/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

 /**
  * The original "Smart Drone" code was created by
  * Jason Nyberg (nyberg@ctron.com).  Enhancements added by Riley Rainey.
  * Further modifications by Umberto Salsi: limits speed to reasonable values;
  * "G" within structural limits as set in the model definition; avoid to
  * too low altitudes (but still the drone may crash on the ground :->);
  * smoother maneuvering.
  * 
  * @file
  */

#ifndef _drone_h
#define _drone_h

#include "pm.h"

#ifdef drone_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

typedef enum {drone_DOG_FIGHT_MODE, drone_HUNTING_MODE} drone_Mode;

/**
 * Set how the drone is generated: 1500 ft behind you
 * (DRONE_DOG_FIGHT_MODE) or randomly up to 50 NM far away in any
 * direction from you (DRONE_HUNTING_MODE).
 */
EXTERN void drone_set_mode(drone_Mode drone_mode);

/**
 * Set drone aggressiveness as % of the max vertical load factor.
 * For example, the value 0.7 means the drones will maneuver with a maximum
 * vertical load not greater than the 70% of maxLoadZPositive/Negative
 * (see the inventory file). The default is 0.5.
 */
EXTERN void drone_set_aggressiveness(double a);

/**
 * Creates e new drone opponent for practicing ACM.
 */
EXTERN void drone_new(craft * p);

/**
 * Attach the drone data structure to an existing craft. Do nothing
 * if it is already a drone. Release with drone_release_commands().
 */
EXTERN void drone_take_commands(craft *c);

/**
 * Remove drone data structure from craft.
 */
EXTERN void drone_release_commands(craft *c);

/**
 * Remove current opponent.
 */
EXTERN void drone_reset_opponent(craft *c);

/**
 * This alarm function is invoked periodically (once per second) to look
 * for hostile aircraft in the proximity of this DIS entity -- the entity is
 * owned by another application at this point, we may ask to take control
 * of it, if a hostile aircraft comes within range.
 * @param p1 Craft.
 * @param p2 Viewer.
 */
EXTERN void drone_endGameDistanceCheck(void * p1, void *p2);

#undef EXTERN
#endif
