// Copyright (c) 1997, 2003 by Jim Lynch.
// Copyright (c) 2010,2026 by Philipp Schafft.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this software; see the file COPYING.  If not, write to
//    the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//    Boston, MA 02110-1301, USA.

#include "util.h"
#include <ctype.h>

void readline(std::istream &in, std::string &it)
{
    getline(in, it);
}

bool IsTrue(const char theChar) {
    switch(tolower(theChar)) {
        case 'y': /* yes */
        case 's': /* sure */
        case 'j': /* ja */
            return true;
            break;
    }

    return false;
}

void ChopTrailingWhiteSpace(std::string &it)
{
    int n = it.size();

    while (isspace((char)it[--n]));

    it = it.substr(0, n + 1);
}

void ChopQuestionMark(std::string &it)
{
    ChopTrailingWhiteSpace(it);

    while(*(it.end() - 1) == '?')
    {
        it = it.substr(0, it.size() - 1);
        ChopTrailingWhiteSpace(it);
    }
}
