#ifndef ATL_sGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,160,320,640,800,960,1120,1200,1280
 * N : 25,160,320,640,800,960,1120,1200,1280
 * NB : 2,8,12,16,32,36,64,64,80
 */
#define ATL_sGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 92) (nb_) = 2; \
   else if ((n_) < 240) (nb_) = 8; \
   else if ((n_) < 480) (nb_) = 12; \
   else if ((n_) < 720) (nb_) = 16; \
   else if ((n_) < 880) (nb_) = 32; \
   else if ((n_) < 1040) (nb_) = 36; \
   else if ((n_) < 1240) (nb_) = 64; \
   else (nb_) = 80; \
}


#endif    /* end ifndef ATL_sGetNB_geqrf */
