/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.cff;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public enum FieldSize {
    BYTE(1, Byte.class, new char[]{'1', 'B', 'b'}, 16),
    SHORT(2, Short.class, new char[]{'2', 'S', 's'}, 32),
    MEDIUM(4, Integer.class, new char[]{'4', 'M', 'm', 'I', 'i'}, 64),
    LONG(8, Long.class, new char[]{'8', 'L', 'l'}, 96),
    DATA(0, null, new char[]{'0', 'D', 'd'}, 112);

    private int byteCount;
    private Class<? extends Number> nativeType;
    private char[] letters;
    private byte bitPattern;

    private FieldSize(int bc, Class<? extends Number> nt, char[] letters, byte bitPattern) {
        this.byteCount = bc;
        this.nativeType = nt;
        this.letters = letters;
        this.bitPattern = bitPattern;
    }

    public static FieldSize forChar(char letter) {
        FieldSize[] fieldSizeArray = FieldSize.values();
        int n = fieldSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldSize fs = fieldSizeArray[n2];
            char[] cArray = fs.letters;
            int n3 = fs.letters.length;
            int n4 = 0;
            while (n4 < n3) {
                char ch = cArray[n4];
                if (ch == letter) {
                    return fs;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static FieldSize forBitPattern(byte bitPattern) {
        FieldSize[] fieldSizeArray = FieldSize.values();
        int n = fieldSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldSize fs = fieldSizeArray[n2];
            if ((fs.bitPattern >>> 4 & 7) == (bitPattern >>> 4 & 7)) {
                return fs;
            }
            ++n2;
        }
        return null;
    }

    public int byteCount() {
        return this.byteCount;
    }

    public int bitCount() {
        return this.byteCount * 8;
    }

    public Class<? extends Number> nativeType() {
        return this.nativeType;
    }

    public char[] allCharRepresentations() {
        return this.letters;
    }

    public char canonicalCharRepresentation() {
        return this.letters[0];
    }

    public byte bitPatternRepresentation() {
        return this.bitPattern;
    }

    public Number readBE(DataInput in) throws IOException {
        switch (this) {
            case BYTE: {
                return in.readByte();
            }
            case SHORT: {
                return in.readShort();
            }
            case MEDIUM: {
                return in.readInt();
            }
            case LONG: {
                return in.readLong();
            }
        }
        return null;
    }

    public void writeBE(DataOutput out, Number n) throws IOException {
        switch (this) {
            case BYTE: {
                out.writeByte(n.byteValue());
                break;
            }
            case SHORT: {
                out.writeShort(n.shortValue());
                break;
            }
            case MEDIUM: {
                out.writeInt(n.intValue());
                break;
            }
            case LONG: {
                out.writeLong(n.longValue());
            }
        }
    }

    public Number readLE(DataInput in) throws IOException {
        switch (this) {
            case BYTE: {
                return in.readByte();
            }
            case SHORT: {
                return Short.reverseBytes(in.readShort());
            }
            case MEDIUM: {
                return Integer.reverseBytes(in.readInt());
            }
            case LONG: {
                return Long.reverseBytes(in.readLong());
            }
        }
        return null;
    }

    public void writeLE(DataOutput out, Number n) throws IOException {
        switch (this) {
            case BYTE: {
                out.writeByte(n.byteValue());
                break;
            }
            case SHORT: {
                out.writeShort(Short.reverseBytes(n.shortValue()));
                break;
            }
            case MEDIUM: {
                out.writeInt(Integer.reverseBytes(n.intValue()));
                break;
            }
            case LONG: {
                out.writeLong(Long.reverseBytes(n.longValue()));
            }
        }
    }
}

