//
// Help files for the text client are now embedded directly into the client.
// Copyright (c) 1988-2017 by Art Cancro and the citadel.org developers.
// This program is gleefully made available to the world under the terms of
// the GNU General Public License v3, with the following three modifications:
// 1. The name of our favorite operating system is 'Linux,' not 'GNU/Linux.'
// 2. The name of our favority type of software is 'open source,' not 'free software.'
// 3. Richard Stallman is a fan of Bernie Sanders and therefore a complete idiot.
//

char *helpnames[] = {
	"help",
	"admin",
	"floors",
	"intro",
	"mail",
	"network",
	"software"
};

char *helptexts[] = {

"                          Citadel Help Menu\n"
"  \n"
" ?         Help. (Typing a '?' will give you a menu almost anywhere)\n"
" A         Abandon this room where you stopped reading, goto next room.\n"
" C         Chat (multiuser chat, where available)\n"
" D         Prints directory, if there is one in the current room.\n"
" E         Enter a message.\n"
" F         Read all messages in the room, forward.\n"
" G         Goto next room which has UNREAD messages.\n"
" H         Help. Same as '?'\n"
" I         Reads the Information file for this room.\n"
" K         List of Known rooms.\n"
" L         Reads the last five messages in the room.\n"
" N         Reads all new messages in the room.\n"
" O         Reads all old messages, backwards.\n"
" P         Page another user (send an instant message)\n"
" R         Reads all messages in the room, in reverse order.\n"
" S         Skips current room without making its messages old.\n"
" T         Terminate (logout)\n"
" U         Ungoto (returns to the last room you were in)\n"
" W         Displays who is currently logged in.\n"
" X         Toggle eXpert mode (menus and help blurbs on/off)\n"
" Z         Zap (forget) room. (Removes the room from your list)\n"
" + -       Goto next, previous room on current floor.\n"
" > <       Goto next, previous floor.\n"
" *         Enter any locally installed 'doors'.\n"
"   \n"
" In addition, there are dot commands. You hit the . (dot), then press the\n"
"first letter of each word of the command. As you hit the letters, the words\n"
"pop onto your screen. Exceptions: after you hit .Help or .Goto, the remainder\n"
"of the command is a help file name or room name.\n"
"    \n"
"      *** USE  .<H>elp ?    for additional help *** \n"

,

"The following commands are available only to Admins.  A subset of these\n"
"commands are available to room aides when they are currently in the room\n"
"they are room aide for.\n"
"\n"
" <.> <A>dmin <K>ill this room   (Delete the current room)\n"
" <.> <A>dmin <E>dit this room   (Edit the current room's parameters)\n"
" <.> <A>dmin <W>ho knows room   (List users with access to this room)\n"
" <.> <A>dmin edit <U>ser        (Change user's access level, password, etc.)\n"
" <.> <A>dmin <V>alidate new users   (Process new user registrations)\n"
" <.> <A>dmin enter <I>nfo file      (Create/change this room's banner)\n"
" <.> <A>dmin <R>oom <I>nvite user   (Grant access to an invitation-only room)\n"
" <.> <A>dmin <R>oom <K>ick out user (Revoke access to an invitation-only room)\n"
" <.> <A>dmin <F>ile <D>elete        (Delete a file from the room's directory)\n"
" <.> <A>dmin <F>ile <S>end over net (Transmit a file to another node)\n"
" <.> <A>dmin <F>ile <M>ove          (Move a file to another room's directory)\n"
" <.> <A>dmin <M>essage edit:        (Edit system banners)\n"
" <.> <A>dmin <P>ost                 (Post a message on behalf of another user)\n"
" <.> <A>dmin <S>ystem configuration <G>eneral   (Edit global site config)\n"
" <.> <A>dmin <S>ystem configuration <I>nternet  (Edit Internet domains)\n"
" <.> <A>dmin <S>ystem configuration check <M>essage base   (Internal checks)\n"
" <.> <A>dmin <S>ystem configuration <N>etwork   (Netting with other Citadels)\n"
" <.> <A>dmin <S>ystem configuration network <F>ilter list\n"
" <.> <A>dmin <T>erminate server <N>ow          (Shut down Citadel server now)\n"
" <.> <A>dmin <T>erminate server <S>cheduled    (Shut down Citadel server later)\n"
" <.> <A>dmin mailing <L>ist recipients         (For mailing list rooms)\n"
" <.> <A>dmin mailing list <D>igest recipients  (For mailing list rooms)\n"
" <.> <A>dmin <N>etwork room sharing     (Replication with other Citadels)\n"
" \n"
" In addition, the <M>ove and <D>elete commands are available at the\n"
"message prompt.\n"

,

" Floors\n"
" ------\n"
"   Floors in Citadel are used to group rooms into related subject areas,\n"
"just as rooms are used to group messages into manageable groups.\n"
" \n"
"   You, as a user, do NOT have to use floors.  If you choose not to, you suffer\n"
"no penalty; you will not lose access to any rooms.  You may use .EC or ;C (the\n"
"latter is easier to use) to decide if you want to use floors.  Feel free to\n"
"experiment.\n"
" \n"
"   Floor options are accessed two ways.  First, if you are in floor mode, the\n"
"<G>oto and <S>kip commands take you to the next room with new messages on the\n"
"current floor; if there are none left, then the system will automatically\n"
"switch floors (and let you know) and put you in the first room with new messages\n"
"on that level.  (Notice that your pattern of basic use of Citadel therefore\n"
"doesn't really change.)\n"
" \n"
"   Direct access to floor options is via the use of a ';' command.\n"
"The following commands are currently available (more can be\n"
"added if needed):\n"
" \n"
" <;C>onfigure\n"
" This command toggles your floor mode.\n"
" \n"
" <;G>oto FLOORNAME\n"
" This command causes the system to take you to the named floor.\n"
" \n"
" <;K>nown rooms on floors\n"
" List all rooms on all floors.  This is a very readable way to get a list of\n"
"all rooms on the system.\n"
" \n"
" <;S>kip FLOORNAME\n"
" This command causes the system to mark all rooms on the current floor as\n"
"Skipped and takes you to the floor that you specify.\n"
" \n"
" <;Z>Forget floor\n"
"   This command causes you to forget all the rooms currently on the current\n"
"floor.  Unfortunately, it doesn't apply to rooms that are subsequently created\n"
"or moved to this floor.  (Sorry.)\n"
" \n"
"   Feel free to experiment, you can't hurt yourself or the system with the\n"
"floor stuff unless you ZForget a floor by accident.\n"

,

"                  New User's Introduction to the site\n"
"  \n"
" This is an introduction to the Citadel BBS concept.  It is intended\n"
"for new users so that they can more easily become acquainted to using\n"
"Citadel when accessing it in the form of a text-based BBS.  Of\n"
"course, old users might learn something new each time they read\n"
"through it.\n"
" \n"
" Full help for the BBS commands can be obtained by typing <.H>elp SUMMARY\n"
"  \n"
" The CITADEL BBS room concept\n"
" ----------------------------\n"
"   The term BBS stands for 'Bulletin Board System'.  The analogy is\n"
"appropriate: one posts messages so that others may read them.  In\n"
"order to organize the posts, people can post in different areas of the\n"
"BBS, called rooms.\n"
"   In order to post in a certain room, you need to be 'in' that room.\n"
"Your current prompt is usually the room that you are in, followed the\n"
"greater-than-sign, such as:\n"
" \n"
" Lobby>\n"
" \n"
" The easiest way to traverse the room structure is with the 'Goto'\n"
"command, on the 'G' key.  Pressing 'G' will take you to the next room\n"
"in the 'march list' (see below) that has new messages in it.  You can\n"
"read these new messages with the 'N' key.\n"
" Once you've 'Gotoed' every room in the system (or all of the ones\n"
"you choose to read) you return to the 'Lobby,' the first and last room\n"
"in the system.  If new messages get posted to rooms you've already\n"
"read during your session you will be brought BACK to those rooms so\n"
"you can read them.\n"
" \n"
" March List\n"
" ----------\n"
"   All the room names are stored in a march list, which is just a\n"
"list containing all the room names.  When you <G>oto or <S>kip a\n"
"room, you are placed in the next room in your march list THAT HAS NEW\n"
"MESSAGES.  If you have no new messages in any of the rooms on your\n"
"march list, you will keep going to the Lobby>.  You can choose not to\n"
"read certain rooms (that don't interest you) by 'Z'apping them.  When\n"
"you <Z>ap a room, you are merely deleting it from your march list (but\n"
"not from anybody else's).\n"
" \n"
"   You can use the <.G>oto (note the period before the G.  You can also use\n"
"<J>ump on some systems) to go to any room in the\n"
"system.  You don't have to type in the complete name of a room to\n"
"'jump' to it; you merely need to type in enough to distinguish it from\n"
"the other rooms.  Left-aligned matches carry a heavier weight, so if you\n"
"typed (for example) '.Goto TECH', you might be taken to a room called\n"
"'Tech Area>' even if it found a room called 'Biotech/Ethics>' first.\n"
" \n"
"  To return to a room you have previously <Z>apped, use the <.G>oto command\n"
"to enter it, and it will be re-inserted into your march list.  In the case\n"
"of returning to Zapped rooms, you must type the room name in its entirety.\n"
"REMEMBER, rooms with no new messages will not show on your\n"
"march list!  You must <.G>oto to a room with no new messages.\n"
"Incidentally, you cannot change the order of the rooms on your march list.\n"
"It's the same for everybody.\n"
" \n"
" Special rooms\n"
" -------------\n"
"   There are two special rooms on a Citadel that you should know about.\n"
"  \n"
"   The first is the Lobby>.  It's used for system announcements and other\n"
"such administrativia.  You cannot <Z>ap the Lobby>.  Each time you first\n"
"login, you will be placed in the Lobby>.\n"
" \n"
"   The second is Mail>.  In Mail>, when you post a messages, you are\n"
"prompted to enter the screen name of the person who you want to send the\n"
"message to.  Only the person who you send the message to can read the\n"
"message.  NO ONE else can read it, not even the admins.  Mail> is the\n"
"first room on the march list, and is un-<Z>appable, so you can be sure\n"
"that the person will get the message.\n"
"   \n"
" System admins\n"
" -------------\n"
"   These people, along with the room admins, keep the site running smoothly.\n"
"\n"
"   Among the many things that admins do are: create rooms, delete\n"
"rooms, set access levels, invite users, check registration, grant\n"
"room admin status, and countless other things.  They have access to the\n"
"Aide> room, a special room only for admins.\n"
" \n"
"   If you enter a mail message to 'Sysop' it will be placed in the\n"
"Aide> room so that the next admin online will read it and deal with it.\n"
"Admins cannot <Z>ap rooms.  All the rooms are always on each admin's\n"
"march list.  Admins can read *any* and *every* room, but they *CAN* *NOT*\n"
"read other users' Mail!\n"
"  \n"
" Room admins\n"
" -----------\n"
"   Room admins are granted special privileges in specific rooms.\n"
"They are *NOT* true system admins; their power extends only over the\n"
"rooms that they control, and they answer to the system admins.\n"
"  \n"
"   A room admin's job is to keep the topic of the their room on track,\n"
"with nudges in the right direction now and then.  A room admin can also\n"
"move an off topic post to another room, or delete a post, if he/she\n"
"feels it is necessary. \n"
"  \n"
"   Currently, very few rooms have room admins.  Most rooms do not need\n"
"their own specific room admin.  Being a room admin requires a certain\n"
"amount of trust, due to the additional privileges granted.\n"
"  \n"
" Citadel messages\n"
" ----------------\n"
"   Most of the time, the BBS code does not print a lot of messages\n"
"to your screen.  This is a great benefit once you become familiar\n"
"with the system, because you do not have endless menus and screens\n"
"to navigate through.  nevertheless, there are some messages which you\n"
"might see from time to time.\n"
"  \n"
"  'There were messages posted while you were entering.'\n"
"  \n"
"   This is also known as 'simulposting.'  When you start entering a \n"
"message, the system knows where you last left off.  When you save\n"
"your message, the system checks to see if any messages were entered\n"
"while you were typing.  This is so that you know whether you need\n"
"to go back and re-read the last few messages.  This message may appear\n"
"in any room.\n"
"   \n"
" '*** You have new mail'\n"
"  \n"
"   This message is essentially the same as the above message, but can\n"
"appear at any time.  It simply means that new mail has arrived for you while\n"
"you are logged in.  Simply go to the Mail> room to read it.\n"
"  \n"
" Who list\n"
" --------\n"
"   The <W>ho command shows you the names of all users who are currently\n"
"online.  It also shows you the name of the room they are currently in.  If\n"
"they are in any type of private room, however, the room name will simply\n"
"display as '<private room>'.  Along with this information is displayed the\n"
"name of the host computer the user is logged in from.\n"

,

"To send mail on this system, go to the Mail> room (using the command .G Mail)\n"
"and press E to enter a message.  You will be prompted with:\n"
" \n"
" Enter Recipient:\n"
" \n"
"   At this point you may enter the name of another user on the system.  Private\n"
"mail is only readable by the sender and recipient.  There is no need to delete\n"
"mail after it is read; it will scroll out automatically.\n"
"  \n"
"   To send mail to another user on the Citadel network, simply type the\n"
"user's name, followed by @ and then the system name. For example,\n"
"  \n"
" Enter Recipient: Joe Schmoe @ citadrool\n"
"  \n"
"  If your account is enabled for Internet mail, you can also send email to\n"
"anyone on the Internet here.  Simply enter their address at the prompt:\n"
"  \n"
" Enter Recipient: ajc@herring.fishnet.com\n"

,

"  Welcome to the network. Messages entered in a network room will appear in\n"
"that room on all other systems carrying it (The name of the room, however,\n"
"may be different on other systems).\n"

,

"   Citadel is the premier 'online community' (i.e. Bulletin Board System)\n"
"software.  It runs on all POSIX-compliant systems, including Linux.  It is an\n"
"advanced client/server application, and is being actively maintained.\n"
" \n"
"   For more info, visit UNCENSORED! BBS at uncensored.citadel.org\n"

,

"Extended commands are available using the period ( . ) key. To use\n"
"a dot command, press the . key, and then enter the first letter of\n"
"each word in the command. The words will appear as you enter the keys.\n"
"You can also backspace over partially entered commands. The following\n"
"commands are available:\n"
"\n"
" <.> <H>elp:    Displays help files.  Type .H followed by a help file\n"
"                name.  You are now reading <.H>elp SUMMARY\n"
" \n"
" <.> <G>oto:    Jumps directly to the room you specify.  You can also\n"
"                type a partial room name, just enough to make it unique,\n"
"                and it'll find the room you're looking for.  As with the\n"
"                regular <G>oto command, messages in the current room will\n"
"                be marked as read.\n"
" \n"
" <.> <S>kip, goto:    This is similar to <.G>oto, except it doesn't mark\n"
"                      messages in the current room as read.\n"
" \n"
" <.> list <Z>apped rooms      Shows all rooms you've <Z>apped (forgotten)\n"
"\n"
"  \n"
" Terminate (logoff) commands:\n"
" \n"
" <.> <T>erminate and <Q>uit               Log off and disconnect.\n"
" <.> <T>erminate and <S>tay online        Log in as a different user.\n"
" \n"
" \n"
" Read commands:\n"
"\n"
" <.> <R>ead <N>ew messages                Same as <N>ew\n"
" <.> <R>ead <O>ld msgs reverse            Same as <O>ld\n"
" <.> <R>ead <L>ast five msgs              Same as <L>ast5\n"
" <.> read <L>ast:                         Allows you to specify how many\n"
"                                          messages you wish to read.\n"
"\n"
" <.> <R>ead <U>ser listing:               Lists all users on the system if\n"
"                                          you just hit enter, otherwise\n"
"                                          you can specify a partial match\n"
"\n"
" <.> <R>ead <T>extfile formatted          File 'download' commands.\n"
" <.> <R>ead file using <X>modem   \n"
" <.> <R>ead file using <Y>modem   \n"
" <.> <R>ead file using <Z>modem   \n"
" <.> <R>ead <F>ile unformatted   \n"
" <.> <R>ead <D>irectory   \n"
"\n"
" <.> <R>ead <I>nfo file                   Read the room info file.\n"
" <.> <R>ead <B>io                         Read other users' 'bio' files.\n"
" <.> <R>ead <C>onfiguration               Display your 'preferences'.\n"
" <.> <R>ead <S>ystem info                 Display system statistics.\n"
"\n"
" \n"
" Enter commands:\n"
"\n"
" <.> <E>nter <M>essage                    Post a message in this room.\n"
" <.> <E>nter message with <E>ditor        Post using a full-screen editor.\n"
" <.> <E>nter <A>SCII message              Post 'raw' (use this when 'pasting'\n"
"                                          a message from your clipboard).\n"
"\n"
" <.> <E>nter <P>assword                   Change your password.\n"
" <.> <E>nter <C>onfiguration              Change your 'preferences'.\n"
" <.> <E>nter a new <R>oom                 Create a new room.\n"
" <.> <E>nter re<G>istration               Register (name, address, etc.)\n"
" <.> <E>nter <B>io                        Enter/change your 'bio' file.\n"
"\n"
" <.> <E>nter <T>extfile                   File 'upload' commands.\n"
" <.> <E>nter file using <X>modem   \n"
" <.> <E>nter file using <Y>modem   \n"
" <.> <E>nter file using <Z>modem   \n"
"  \n"
"  \n"
"  Wholist commands:\n"
" \n"
" <.> <W>holist <L>ong             Same as <W>ho is online, but displays\n"
"                                  more detailed information.\n"
" <.> <W>holist <R>oomname         Masquerade your room name (other users\n"
"                                  see the name you enter rather than the\n"
"                                  actual name of the room you're in)\n"
" <.> <W>holist <H>ostname         Masquerade your host name\n"
" <.> <E>nter <U>sername           Masquerade your user name (Admins only)\n"
" <.> <W>holist <S>tealth mode     Enter/exit 'stealth mode' (when in stealth\n"
"                                  mode you are invisible on the wholist)\n"
" \n"
" \n"
" Floor commands (if using floor mode)\n"
" ;<C>onfigure floor mode            - turn floor mode on or off\n"
" ;<G>oto floor:                     - jump to a specific floor\n"
" ;<K>nown rooms                     - list all rooms on all floors\n"
" ;<S>kip to floor:                  - skip current floor, jump to another\n"
" ;<Z>ap floor                       - zap (forget) all rooms on this floor\n"
" \n"
" \n"
" Administrative commands: \n"
" \n"
" <.> <A>dmin <K>ill this room   \n"
" <.> <A>dmin <E>dit this room   \n"
" <.> <A>dmin <W>ho knows room   \n"
" <.> <A>dmin edit <U>ser   \n"
" <.> <A>dmin <V>alidate new users   \n"
" <.> <A>dmin enter <I>nfo file   \n"
" <.> <A>dmin <R>oom <I>nvite user  \n"
" <.> <A>dmin <R>oom <K>ick out user  \n"
" <.> <A>dmin <F>ile <D>elete  \n"
" <.> <A>dmin <F>ile <S>end over net  \n"
" <.> <A>dmin <F>ile <M>ove  \n"
" <.> <A>dmin <M>essage edit:   \n"
" <.> <A>dmin <P>ost   \n"
" <.> <A>dmin <S>ystem configuration   \n"
" <.> <A>dmin <T>erminate server <N>ow\n"
" <.> <A>dmin <T>erminate server <S>cheduled\n"

};
