//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armlabservices

import "time"

// AutoShutdownProfile - Profile for how to handle shutting down virtual machines.
type AutoShutdownProfile struct {
	// The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
	DisconnectDelay *string `json:"disconnectDelay,omitempty"`

	// The amount of time a VM will idle before it is shutdown if this behavior is enabled.
	IdleDelay *string `json:"idleDelay,omitempty"`

	// The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
	NoConnectDelay *string `json:"noConnectDelay,omitempty"`

	// Whether shutdown on disconnect is enabled
	ShutdownOnDisconnect *EnableState `json:"shutdownOnDisconnect,omitempty"`

	// Whether a VM will get shutdown when it has idled for a period of time.
	ShutdownOnIdle *ShutdownOnIdleMode `json:"shutdownOnIdle,omitempty"`

	// Whether a VM will get shutdown when it hasn't been connected to after a period of time.
	ShutdownWhenNotConnected *EnableState `json:"shutdownWhenNotConnected,omitempty"`
}

// ConnectionProfile - Connection profile for how users connect to lab virtual machines.
type ConnectionProfile struct {
	// The enabled access level for Client Access over RDP.
	ClientRdpAccess *ConnectionType `json:"clientRdpAccess,omitempty"`

	// The enabled access level for Client Access over SSH.
	ClientSSHAccess *ConnectionType `json:"clientSshAccess,omitempty"`

	// The enabled access level for Web Access over RDP.
	WebRdpAccess *ConnectionType `json:"webRdpAccess,omitempty"`

	// The enabled access level for Web Access over SSH.
	WebSSHAccess *ConnectionType `json:"webSshAccess,omitempty"`
}

// Credentials for a user on a lab VM.
type Credentials struct {
	// REQUIRED; The username to use when signing in to lab VMs.
	Username *string `json:"username,omitempty"`

	// The password for the user. This is required for the TemplateVM createOption.
	Password *string `json:"password,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// Image - Lab services virtual machine image
type Image struct {
	// REQUIRED; Image resource properties
	Properties *ImageProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the image.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImageProperties - Properties of an image resource.
type ImageProperties struct {
	// The available regions of the image in the shared gallery.
	AvailableRegions []*string `json:"availableRegions,omitempty"`

	// Is the image enabled
	EnabledState *EnableState `json:"enabledState,omitempty"`

	// READ-ONLY; The image author.
	Author *string `json:"author,omitempty" azure:"ro"`

	// READ-ONLY; A description of the image.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The image display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; URL of the image icon.
	IconURL *string `json:"iconUrl,omitempty" azure:"ro"`

	// READ-ONLY; The OS State of the image.
	OSState *OsState `json:"osState,omitempty" azure:"ro"`

	// READ-ONLY; The OS Type of the image.
	OSType *OsType `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; The ID of an offer associated with the image.
	Offer *string `json:"offer,omitempty" azure:"ro"`

	// READ-ONLY; The ID of marketplace plan associated with the image (optional).
	Plan *string `json:"plan,omitempty" azure:"ro"`

	// READ-ONLY; Current provisioning state of the image.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the publisher of the image.
	Publisher *string `json:"publisher,omitempty" azure:"ro"`

	// READ-ONLY; The image SKU.
	SKU *string `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; The ID for the image in the shared gallery.
	SharedGalleryID *string `json:"sharedGalleryId,omitempty" azure:"ro"`

	// READ-ONLY; The status of image terms of use (enabled = accepted, disabled = not accepted).
	TermsStatus *EnableState `json:"termsStatus,omitempty" azure:"ro"`

	// READ-ONLY; The image version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ImageReference - Image reference information. Used in the virtual machine profile.
type ImageReference struct {
	// Image resource ID
	ID *string `json:"id,omitempty"`

	// The image offer if applicable.
	Offer *string `json:"offer,omitempty"`

	// The image publisher
	Publisher *string `json:"publisher,omitempty"`

	// The image SKU
	SKU *string `json:"sku,omitempty"`

	// The image version specified on creation.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; The actual version of the image after use.
	ExactVersion *string `json:"exactVersion,omitempty" azure:"ro"`
}

// ImageUpdate - Lab services virtual machine image for updates.
type ImageUpdate struct {
	// Image resource properties
	Properties *ImageUpdateProperties `json:"properties,omitempty"`
}

// ImageUpdateProperties - Properties of an image resource update
type ImageUpdateProperties struct {
	// Is the image enabled
	EnabledState *EnableState `json:"enabledState,omitempty"`
}

// ImagesClientCreateOrUpdateOptions contains the optional parameters for the ImagesClient.CreateOrUpdate method.
type ImagesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ImagesClientGetOptions contains the optional parameters for the ImagesClient.Get method.
type ImagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ImagesClientListByLabPlanOptions contains the optional parameters for the ImagesClient.ListByLabPlan method.
type ImagesClientListByLabPlanOptions struct {
	// The filter to apply to the operation.
	Filter *string
}

// ImagesClientUpdateOptions contains the optional parameters for the ImagesClient.Update method.
type ImagesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// InviteBody - Body for a user invite request
type InviteBody struct {
	// Custom text for the invite email.
	Text *string `json:"text,omitempty"`
}

// Lab - The lab resource.
type Lab struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Lab resource properties
	Properties *LabProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the lab.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LabNetworkProfile - Profile for how to handle networking for Labs.
type LabNetworkProfile struct {
	// The external load balancer resource id
	LoadBalancerID *string `json:"loadBalancerId,omitempty"`

	// The external public IP resource id
	PublicIPID *string `json:"publicIpId,omitempty"`

	// The external subnet resource id
	SubnetID *string `json:"subnetId,omitempty"`
}

// LabPlan - Lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they can provide
// a set of default configurations that will apply at the time of creating a lab, but these
// defaults can still be overwritten.
type LabPlan struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Lab plan resource properties
	Properties *LabPlanProperties `json:"properties,omitempty"`

	// Managed Identity Information
	Identity *Identity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the lab plan.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LabPlanNetworkProfile - Profile for how to handle networking for Lab Plans.
type LabPlanNetworkProfile struct {
	// The external subnet resource id
	SubnetID *string `json:"subnetId,omitempty"`
}

// LabPlanProperties - Lab plan resource properties
type LabPlanProperties struct {
	// The allowed regions for the lab creator to use when creating labs using this lab plan.
	AllowedRegions []*string `json:"allowedRegions,omitempty"`

	// The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
	DefaultAutoShutdownProfile *AutoShutdownProfile `json:"defaultAutoShutdownProfile,omitempty"`

	// The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
	DefaultConnectionProfile *ConnectionProfile `json:"defaultConnectionProfile,omitempty"`

	// The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there
	// are existing labs associated with this lab plan.
	DefaultNetworkProfile *LabPlanNetworkProfile `json:"defaultNetworkProfile,omitempty"`

	// Base Url of the lms instance this lab plan can link lab rosters against.
	LinkedLmsInstance *string `json:"linkedLmsInstance,omitempty"`

	// Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it
	// will be persisted in this gallery. Shared images from the gallery can be made
	// available to use when creating new labs.
	SharedGalleryID *string `json:"sharedGalleryId,omitempty"`

	// Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and
	// virtual machine users for all labs in the lab plan.
	SupportInfo *SupportInfo `json:"supportInfo,omitempty"`

	// READ-ONLY; Current provisioning state of the lab plan.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// LabPlanUpdate - Contains lab configuration and default settings. This variant is used for PATCH.
type LabPlanUpdate struct {
	// Managed Identity Information
	Identity *Identity `json:"identity,omitempty"`

	// Lab plan resource update properties
	Properties *LabPlanUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags []*string `json:"tags,omitempty"`
}

// LabPlanUpdateProperties - Lab plan resource properties for updates
type LabPlanUpdateProperties struct {
	// The allowed regions for the lab creator to use when creating labs using this lab plan.
	AllowedRegions []*string `json:"allowedRegions,omitempty"`

	// The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
	DefaultAutoShutdownProfile *AutoShutdownProfile `json:"defaultAutoShutdownProfile,omitempty"`

	// The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
	DefaultConnectionProfile *ConnectionProfile `json:"defaultConnectionProfile,omitempty"`

	// The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there
	// are existing labs associated with this lab plan.
	DefaultNetworkProfile *LabPlanNetworkProfile `json:"defaultNetworkProfile,omitempty"`

	// Base Url of the lms instance this lab plan can link lab rosters against.
	LinkedLmsInstance *string `json:"linkedLmsInstance,omitempty"`

	// Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it
	// will be persisted in this gallery. Shared images from the gallery can be made
	// available to use when creating new labs.
	SharedGalleryID *string `json:"sharedGalleryId,omitempty"`

	// Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and
	// virtual machine users for all labs in the lab plan.
	SupportInfo *SupportInfo `json:"supportInfo,omitempty"`
}

// LabPlansClientBeginCreateOrUpdateOptions contains the optional parameters for the LabPlansClient.BeginCreateOrUpdate method.
type LabPlansClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabPlansClientBeginDeleteOptions contains the optional parameters for the LabPlansClient.BeginDelete method.
type LabPlansClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabPlansClientBeginSaveImageOptions contains the optional parameters for the LabPlansClient.BeginSaveImage method.
type LabPlansClientBeginSaveImageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabPlansClientBeginUpdateOptions contains the optional parameters for the LabPlansClient.BeginUpdate method.
type LabPlansClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabPlansClientGetOptions contains the optional parameters for the LabPlansClient.Get method.
type LabPlansClientGetOptions struct {
	// placeholder for future optional parameters
}

// LabPlansClientListByResourceGroupOptions contains the optional parameters for the LabPlansClient.ListByResourceGroup method.
type LabPlansClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// LabPlansClientListBySubscriptionOptions contains the optional parameters for the LabPlansClient.ListBySubscription method.
type LabPlansClientListBySubscriptionOptions struct {
	// The filter to apply to the operation.
	Filter *string
}

// LabProperties - Properties of a lab resource.
type LabProperties struct {
	// The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting
	// idle.
	AutoShutdownProfile *AutoShutdownProfile `json:"autoShutdownProfile,omitempty"`

	// The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports
	// are open.
	ConnectionProfile *ConnectionProfile `json:"connectionProfile,omitempty"`

	// The description of the lab.
	Description *string `json:"description,omitempty"`

	// The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating
	// a lab via labs.azure.com. Setting a labPlanId on an existing lab provides
	// organization..
	LabPlanID *string `json:"labPlanId,omitempty"`

	// The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been
	// created.
	NetworkProfile *LabNetworkProfile `json:"networkProfile,omitempty"`

	// The lab user list management profile.
	RosterProfile *RosterProfile `json:"rosterProfile,omitempty"`

	// The lab security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// The title of the lab.
	Title *string `json:"title,omitempty"`

	// The profile used for creating lab virtual machines.
	VirtualMachineProfile *VirtualMachineProfile `json:"virtualMachineProfile,omitempty"`

	// READ-ONLY; Current provisioning state of the lab.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The lab state.
	State *LabState `json:"state,omitempty" azure:"ro"`
}

// LabUpdate - The lab resource for updates.
type LabUpdate struct {
	// Lab resource properties
	Properties *LabUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags []*string `json:"tags,omitempty"`
}

// LabUpdateProperties - Properties of a lab resource used for updates.
type LabUpdateProperties struct {
	// The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting
	// idle.
	AutoShutdownProfile *AutoShutdownProfile `json:"autoShutdownProfile,omitempty"`

	// The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports
	// are open.
	ConnectionProfile *ConnectionProfile `json:"connectionProfile,omitempty"`

	// The description of the lab.
	Description *string `json:"description,omitempty"`

	// The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating
	// a lab via labs.azure.com. Setting a labPlanId on an existing lab provides
	// organization..
	LabPlanID *string `json:"labPlanId,omitempty"`

	// The lab user list management profile.
	RosterProfile *RosterProfile `json:"rosterProfile,omitempty"`

	// The lab security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// The title of the lab.
	Title *string `json:"title,omitempty"`

	// The profile used for creating lab virtual machines.
	VirtualMachineProfile *VirtualMachineProfile `json:"virtualMachineProfile,omitempty"`
}

// LabsClientBeginCreateOrUpdateOptions contains the optional parameters for the LabsClient.BeginCreateOrUpdate method.
type LabsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginDeleteOptions contains the optional parameters for the LabsClient.BeginDelete method.
type LabsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginPublishOptions contains the optional parameters for the LabsClient.BeginPublish method.
type LabsClientBeginPublishOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginSyncGroupOptions contains the optional parameters for the LabsClient.BeginSyncGroup method.
type LabsClientBeginSyncGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginUpdateOptions contains the optional parameters for the LabsClient.BeginUpdate method.
type LabsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientGetOptions contains the optional parameters for the LabsClient.Get method.
type LabsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LabsClientListByResourceGroupOptions contains the optional parameters for the LabsClient.ListByResourceGroup method.
type LabsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// LabsClientListBySubscriptionOptions contains the optional parameters for the LabsClient.ListBySubscription method.
type LabsClientListBySubscriptionOptions struct {
	// The filter to apply to the operation.
	Filter *string
}

// ListUsagesResult - List of Core Usages.
type ListUsagesResult struct {
	// The array page of Usages.
	Value []*Usage `json:"value,omitempty"`

	// READ-ONLY; The link to get the next page of Usage result.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationResult - A long running operation result
type OperationResult struct {
	// REQUIRED; The operation status
	Status *OperationStatus `json:"status,omitempty"`

	// End time
	EndTime *time.Time `json:"endTime,omitempty"`

	// The error for a failure if the operation failed.
	Error *ErrorDetail `json:"error,omitempty"`

	// Percent completion
	PercentComplete *float32 `json:"percentComplete,omitempty"`

	// Start time
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationResultsClientGetOptions contains the optional parameters for the OperationResultsClient.Get method.
type OperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PagedImages - Paged list of Lab services virtual machine images.
type PagedImages struct {
	// READ-ONLY; The link to get the next page of image results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The array page of virtual machine images.
	Value []*Image `json:"value,omitempty" azure:"ro"`
}

// PagedLabPlans - Paged list of lab plans.
type PagedLabPlans struct {
	// READ-ONLY; The link to get the next page of lab plan results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The array page of lab plans.
	Value []*LabPlan `json:"value,omitempty" azure:"ro"`
}

// PagedLabs - Paged list of labs.
type PagedLabs struct {
	// READ-ONLY; The link to get the next page of image results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The array page of lab results.
	Value []*Lab `json:"value,omitempty" azure:"ro"`
}

// PagedSKUInfos - Paged list of lab services skus.
type PagedSKUInfos struct {
	// READ-ONLY; The link to get the next page of sku results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The array page of sku results.
	Value []*SKUInfo `json:"value,omitempty" azure:"ro"`
}

// PagedSchedules - Paged list of schedules.
type PagedSchedules struct {
	// READ-ONLY; The link to get the next page of schedule results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The array page of schedule results.
	Value []*Schedule `json:"value,omitempty" azure:"ro"`
}

// PagedUsers - Paged list of users.
type PagedUsers struct {
	// READ-ONLY; The link to get the next page of image results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The array page of user results.
	Value []*User `json:"value,omitempty" azure:"ro"`
}

// PagedVirtualMachines - Paged list of lab services virtual machines.
type PagedVirtualMachines struct {
	// READ-ONLY; The link to get the next page of virtual machine results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The array page of virtual machine results.
	Value []*VirtualMachine `json:"value,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecurrencePattern - Recurrence pattern of a lab schedule.
type RecurrencePattern struct {
	// REQUIRED; When the recurrence will expire. This date is inclusive.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// REQUIRED; The frequency of the recurrence.
	Frequency *RecurrenceFrequency `json:"frequency,omitempty"`

	// The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days.
	// When no interval is supplied, an interval of 1 is used.
	Interval *int32 `json:"interval,omitempty"`

	// The week days the schedule runs. Used for when the Frequency is set to Weekly.
	WeekDays []*WeekDay `json:"weekDays,omitempty"`
}

// ResetPasswordBody - Body of a reset password request.
type ResetPasswordBody struct {
	// REQUIRED; The password
	Password *string `json:"password,omitempty"`

	// REQUIRED; The user whose password is being reset
	Username *string `json:"username,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RosterProfile - The lab user list management profile.
type RosterProfile struct {
	// The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
	ActiveDirectoryGroupID *string `json:"activeDirectoryGroupId,omitempty"`

	// The base URI identifying the lms instance.
	LmsInstance *string `json:"lmsInstance,omitempty"`

	// The unique id of the azure lab services tool in the lms.
	LtiClientID *string `json:"ltiClientId,omitempty"`

	// The unique context identifier for the lab in the lms.
	LtiContextID *string `json:"ltiContextId,omitempty"`

	// The uri of the names and roles service endpoint on the lms for the class attached to this lab.
	LtiRosterEndpoint *string `json:"ltiRosterEndpoint,omitempty"`
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SKUCapabilities - The array of capabilities of a lab services SKU.
type SKUCapabilities struct {
	// READ-ONLY; The name of the capability for a SKU.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The value of the capability for a SKU.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// SKUCapacity - The scale out/in options of the SKU.
type SKUCapacity struct {
	// READ-ONLY; The default capacity for this resource.
	Default *int64 `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; The highest permitted capacity for this resource.
	Maximum *int64 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The lowest permitted capacity for this resource.
	Minimum *int64 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The localized name of the resource.
	ScaleType *ScaleType `json:"scaleType,omitempty" azure:"ro"`
}

// SKUCost - The array of costs of a lab services SKU.
type SKUCost struct {
	// READ-ONLY; The extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty" azure:"ro"`

	// READ-ONLY; The meter id.
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; The quantity of units charged.
	Quantity *float32 `json:"quantity,omitempty" azure:"ro"`
}

// SKUInfo - Azure Lab Services resource SKUs
type SKUInfo struct {
	// The scale out/in options of the SKU.
	Capacity *SKUCapacity `json:"capacity,omitempty"`

	// READ-ONLY; The capabilities of the SKU.
	Capabilities []*SKUCapabilities `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Metadata for retrieving price info of a lab services SKUs.
	Costs []*SKUCost `json:"costs,omitempty" azure:"ro"`

	// READ-ONLY; The family of the SKU.
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; List of locations that are available for a size.
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The name of the SKU.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The lab services resource type.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; Restrictions of a lab services SKUs.
	Restrictions []*SKURestrictions `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY; The SKU size.
	Size *string `json:"size,omitempty" azure:"ro"`

	// READ-ONLY; The tier of the SKU.
	Tier *LabServicesSKUTier `json:"tier,omitempty" azure:"ro"`
}

// SKURestrictions - The restriction details.
type SKURestrictions struct {
	// READ-ONLY; The reason for the restriction.
	ReasonCode *RestrictionReasonCode `json:"reasonCode,omitempty" azure:"ro"`

	// READ-ONLY; The type of restriction.
	Type *RestrictionType `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The values of the restriction.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.List method.
type SKUsClientListOptions struct {
	// The filter to apply to the operation.
	Filter *string
}

// SaveImageBody - Body for the save image POST
type SaveImageBody struct {
	// The ID of the lab virtual machine you want to save an image from.
	LabVirtualMachineID *string `json:"labVirtualMachineId,omitempty"`

	// The name for the image we create.
	Name *string `json:"name,omitempty"`
}

// Schedule for automatically turning virtual machines in a lab on and off at specified times.
type Schedule struct {
	// REQUIRED; Schedule resource properties
	Properties *ScheduleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the schedule.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScheduleProperties - Schedule resource properties
type ScheduleProperties struct {
	// Notes for this schedule.
	Notes *string `json:"notes,omitempty"`

	// The recurrence pattern of the scheduled actions.
	RecurrencePattern *RecurrencePattern `json:"recurrencePattern,omitempty"`

	// When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
	StartAt *time.Time `json:"startAt,omitempty"`

	// When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
	StopAt *time.Time `json:"stopAt,omitempty"`

	// The IANA timezone id for the schedule.
	TimeZoneID *string `json:"timeZoneId,omitempty"`

	// READ-ONLY; Current provisioning state of the schedule.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ScheduleUpdate - Schedule for automatically turning virtual machines in a lab on and off at specified times. Used for updates.
type ScheduleUpdate struct {
	// Schedule resource properties
	Properties *ScheduleUpdateProperties `json:"properties,omitempty"`
}

// ScheduleUpdateProperties - Schedule resource properties used for updates.
type ScheduleUpdateProperties struct {
	// Notes for this schedule.
	Notes *string `json:"notes,omitempty"`

	// The recurrence pattern of the scheduled actions.
	RecurrencePattern *RecurrencePattern `json:"recurrencePattern,omitempty"`

	// When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
	StartAt *time.Time `json:"startAt,omitempty"`

	// When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
	StopAt *time.Time `json:"stopAt,omitempty"`

	// The IANA timezone id for the schedule.
	TimeZoneID *string `json:"timeZoneId,omitempty"`
}

// SchedulesClientBeginDeleteOptions contains the optional parameters for the SchedulesClient.BeginDelete method.
type SchedulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SchedulesClientCreateOrUpdateOptions contains the optional parameters for the SchedulesClient.CreateOrUpdate method.
type SchedulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SchedulesClientGetOptions contains the optional parameters for the SchedulesClient.Get method.
type SchedulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SchedulesClientListByLabOptions contains the optional parameters for the SchedulesClient.ListByLab method.
type SchedulesClientListByLabOptions struct {
	// The filter to apply to the operation.
	Filter *string
}

// SchedulesClientUpdateOptions contains the optional parameters for the SchedulesClient.Update method.
type SchedulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SecurityProfile - The lab security profile.
type SecurityProfile struct {
	// Whether any user or only specified users can register to a lab.
	OpenAccess *EnableState `json:"openAccess,omitempty"`

	// READ-ONLY; The registration code for the lab.
	RegistrationCode *string `json:"registrationCode,omitempty" azure:"ro"`
}

// SupportInfo - Support contact information and instructions.
type SupportInfo struct {
	// Support contact email address.
	Email *string `json:"email,omitempty"`

	// Support instructions.
	Instructions *string `json:"instructions,omitempty"`

	// Support contact phone number.
	Phone *string `json:"phone,omitempty"`

	// Support web address.
	URL *string `json:"url,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TrackedResourceUpdate - Base tracked resource type for all PATCH updates.
type TrackedResourceUpdate struct {
	// Resource tags.
	Tags []*string `json:"tags,omitempty"`
}

// Usage - The core usage details.
type Usage struct {
	// The current usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// The fully qualified arm resource id.
	ID *string `json:"id,omitempty"`

	// The limit integer.
	Limit *int64 `json:"limit,omitempty"`

	// The name.
	Name *UsageName `json:"name,omitempty"`

	// The unit details.
	Unit *UsageUnit `json:"unit,omitempty"`
}

// UsageName - The Usage Names.
type UsageName struct {
	// The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The instances of the resource.
	SKUInstances []*string `json:"skuInstances,omitempty"`

	// The name of the resource.
	Value *string `json:"value,omitempty"`
}

// UsagesClientListByLocationOptions contains the optional parameters for the UsagesClient.ListByLocation method.
type UsagesClientListByLocationOptions struct {
	// The filter to apply to the operation.
	Filter *string
}

// User of a lab that can register for and use virtual machines within the lab.
type User struct {
	// REQUIRED; User resource properties
	Properties *UserProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the user resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserProperties - User resource properties
type UserProperties struct {
	// REQUIRED; Email address of the user.
	Email *string `json:"email,omitempty"`

	// The amount of usage quota time the user gets in addition to the lab usage quota.
	AdditionalUsageQuota *string `json:"additionalUsageQuota,omitempty"`

	// READ-ONLY; Display name of the user, for example user's full name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Date and time when the invitation message was sent to the user.
	InvitationSent *time.Time `json:"invitationSent,omitempty" azure:"ro"`

	// READ-ONLY; State of the invitation message for the user.
	InvitationState *InvitationState `json:"invitationState,omitempty" azure:"ro"`

	// READ-ONLY; Current provisioning state of the user resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; State of the user's registration within the lab.
	RegistrationState *RegistrationState `json:"registrationState,omitempty" azure:"ro"`

	// READ-ONLY; How long the user has used their virtual machines in this lab.
	TotalUsage *string `json:"totalUsage,omitempty" azure:"ro"`
}

// UserUpdate - User of a lab that can register for and use virtual machines within the lab. Used for updates.
type UserUpdate struct {
	// User resource properties
	Properties *UserUpdateProperties `json:"properties,omitempty"`
}

// UserUpdateProperties - User resource properties used for updates.
type UserUpdateProperties struct {
	// The amount of usage quota time the user gets in addition to the lab usage quota.
	AdditionalUsageQuota *string `json:"additionalUsageQuota,omitempty"`
}

// UsersClientBeginCreateOrUpdateOptions contains the optional parameters for the UsersClient.BeginCreateOrUpdate method.
type UsersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientBeginDeleteOptions contains the optional parameters for the UsersClient.BeginDelete method.
type UsersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientBeginInviteOptions contains the optional parameters for the UsersClient.BeginInvite method.
type UsersClientBeginInviteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientBeginUpdateOptions contains the optional parameters for the UsersClient.BeginUpdate method.
type UsersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientGetOptions contains the optional parameters for the UsersClient.Get method.
type UsersClientGetOptions struct {
	// placeholder for future optional parameters
}

// UsersClientListByLabOptions contains the optional parameters for the UsersClient.ListByLab method.
type UsersClientListByLabOptions struct {
	// The filter to apply to the operation.
	Filter *string
}

// VirtualMachine - A lab virtual machine resource.
type VirtualMachine struct {
	// REQUIRED; Virtual machine resource properties
	Properties *VirtualMachineProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System data of the Lab virtual machine.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineAdditionalCapabilities - The additional capabilities for a lab VM.
type VirtualMachineAdditionalCapabilities struct {
	// Flag to pre-install dedicated GPU drivers.
	InstallGpuDrivers *EnableState `json:"installGpuDrivers,omitempty"`
}

// VirtualMachineConnectionProfile - The connection information for the virtual machine
type VirtualMachineConnectionProfile struct {
	// READ-ONLY; The username used to log on to the virtual machine as admin.
	AdminUsername *string `json:"adminUsername,omitempty" azure:"ro"`

	// READ-ONLY; The username used to log on to the virtual machine as non-admin, if one exists.
	NonAdminUsername *string `json:"nonAdminUsername,omitempty" azure:"ro"`

	// READ-ONLY; The private IP address of the virtual machine.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; Port and host name separated by semicolon for connecting via RDP protocol to the virtual machine.
	RdpAuthority *string `json:"rdpAuthority,omitempty" azure:"ro"`

	// READ-ONLY; URL for connecting via RDP protocol to the virtual machine in browser.
	RdpInBrowserURL *string `json:"rdpInBrowserUrl,omitempty" azure:"ro"`

	// READ-ONLY; Port and host name separated by semicolon for connecting via SSH protocol to the virtual machine.
	SSHAuthority *string `json:"sshAuthority,omitempty" azure:"ro"`

	// READ-ONLY; URL for connecting via SSH protocol to the virtual machine in browser.
	SSHInBrowserURL *string `json:"sshInBrowserUrl,omitempty" azure:"ro"`
}

// VirtualMachineProfile - The base virtual machine configuration for a lab.
type VirtualMachineProfile struct {
	// REQUIRED; Credentials for the admin user on the VM.
	AdminUser *Credentials `json:"adminUser,omitempty"`

	// REQUIRED; Indicates what lab virtual machines are created from.
	CreateOption *CreateOption `json:"createOption,omitempty"`

	// REQUIRED; The image configuration for lab virtual machines.
	ImageReference *ImageReference `json:"imageReference,omitempty"`

	// REQUIRED; The SKU for the lab. Defines the type of virtual machines used in the lab.
	SKU *SKU `json:"sku,omitempty"`

	// REQUIRED; The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
	UsageQuota *string `json:"usageQuota,omitempty"`

	// Additional VM capabilities.
	AdditionalCapabilities *VirtualMachineAdditionalCapabilities `json:"additionalCapabilities,omitempty"`

	// Credentials for the non-admin user on the VM, if one exists.
	NonAdminUser *Credentials `json:"nonAdminUser,omitempty"`

	// Enabling this option will use the same password for all user VMs.
	UseSharedPassword *EnableState `json:"useSharedPassword,omitempty"`

	// READ-ONLY; The OS type of the image
	OSType *OsType `json:"osType,omitempty" azure:"ro"`
}

// VirtualMachineProperties - Virtual machine resource properties
type VirtualMachineProperties struct {
	// READ-ONLY; The lab user ID (not the PUID!) of who claimed the virtual machine.
	ClaimedByUserID *string `json:"claimedByUserId,omitempty" azure:"ro"`

	// READ-ONLY; Profile for information about connecting to the virtual machine.
	ConnectionProfile *VirtualMachineConnectionProfile `json:"connectionProfile,omitempty" azure:"ro"`

	// READ-ONLY; Current provisioning state of the virtual machine.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The current state of the virtual machine
	State *VirtualMachineState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The type of this VM resource
	VMType *VirtualMachineType `json:"vmType,omitempty" azure:"ro"`
}

// VirtualMachinesClientBeginRedeployOptions contains the optional parameters for the VirtualMachinesClient.BeginRedeploy
// method.
type VirtualMachinesClientBeginRedeployOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginReimageOptions contains the optional parameters for the VirtualMachinesClient.BeginReimage method.
type VirtualMachinesClientBeginReimageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginResetPasswordOptions contains the optional parameters for the VirtualMachinesClient.BeginResetPassword
// method.
type VirtualMachinesClientBeginResetPasswordOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStartOptions contains the optional parameters for the VirtualMachinesClient.BeginStart method.
type VirtualMachinesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStopOptions contains the optional parameters for the VirtualMachinesClient.BeginStop method.
type VirtualMachinesClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientGetOptions contains the optional parameters for the VirtualMachinesClient.Get method.
type VirtualMachinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListByLabOptions contains the optional parameters for the VirtualMachinesClient.ListByLab method.
type VirtualMachinesClientListByLabOptions struct {
	// The filter to apply to the operation.
	Filter *string
}
