// Code generated by smithy-go-codegen DO NOT EDIT.

package backupstorage

import (
	"bytes"
	"context"
	"fmt"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpDeleteObject struct {
}

func (*awsRestjson1_serializeOpDeleteObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs/{BackupJobId}/object/{ObjectName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteObjectInput(v *DeleteObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupJobId == nil || len(*v.BackupJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupJobId must not be empty")}
	}
	if v.BackupJobId != nil {
		if err := encoder.SetURI("BackupJobId").String(*v.BackupJobId); err != nil {
			return err
		}
	}

	if v.ObjectName == nil || len(*v.ObjectName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ObjectName must not be empty")}
	}
	if v.ObjectName != nil {
		if err := encoder.SetURI("ObjectName").String(*v.ObjectName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetChunk struct {
}

func (*awsRestjson1_serializeOpGetChunk) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChunk) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChunkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/restore-jobs/{StorageJobId}/chunk/{ChunkToken}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChunkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChunkInput(v *GetChunkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChunkToken == nil || len(*v.ChunkToken) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChunkToken must not be empty")}
	}
	if v.ChunkToken != nil {
		if err := encoder.SetURI("ChunkToken").String(*v.ChunkToken); err != nil {
			return err
		}
	}

	if v.StorageJobId == nil || len(*v.StorageJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StorageJobId must not be empty")}
	}
	if v.StorageJobId != nil {
		if err := encoder.SetURI("StorageJobId").String(*v.StorageJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetObjectMetadata struct {
}

func (*awsRestjson1_serializeOpGetObjectMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetObjectMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/restore-jobs/{StorageJobId}/object/{ObjectToken}/metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetObjectMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetObjectMetadataInput(v *GetObjectMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ObjectToken == nil || len(*v.ObjectToken) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ObjectToken must not be empty")}
	}
	if v.ObjectToken != nil {
		if err := encoder.SetURI("ObjectToken").String(*v.ObjectToken); err != nil {
			return err
		}
	}

	if v.StorageJobId == nil || len(*v.StorageJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StorageJobId must not be empty")}
	}
	if v.StorageJobId != nil {
		if err := encoder.SetURI("StorageJobId").String(*v.StorageJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListChunks struct {
}

func (*awsRestjson1_serializeOpListChunks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChunks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChunksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/restore-jobs/{StorageJobId}/chunks/{ObjectToken}/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChunksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChunksInput(v *ListChunksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.ObjectToken == nil || len(*v.ObjectToken) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ObjectToken must not be empty")}
	}
	if v.ObjectToken != nil {
		if err := encoder.SetURI("ObjectToken").String(*v.ObjectToken); err != nil {
			return err
		}
	}

	if v.StorageJobId == nil || len(*v.StorageJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StorageJobId must not be empty")}
	}
	if v.StorageJobId != nil {
		if err := encoder.SetURI("StorageJobId").String(*v.StorageJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListObjects struct {
}

func (*awsRestjson1_serializeOpListObjects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListObjects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/restore-jobs/{StorageJobId}/objects/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListObjectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListObjectsInput(v *ListObjectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreatedAfter != nil {
		encoder.SetQuery("created-after").String(smithytime.FormatDateTime(*v.CreatedAfter))
	}

	if v.CreatedBefore != nil {
		encoder.SetQuery("created-before").String(smithytime.FormatDateTime(*v.CreatedBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.StartingObjectName != nil {
		encoder.SetQuery("starting-object-name").String(*v.StartingObjectName)
	}

	if v.StartingObjectPrefix != nil {
		encoder.SetQuery("starting-object-prefix").String(*v.StartingObjectPrefix)
	}

	if v.StorageJobId == nil || len(*v.StorageJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StorageJobId must not be empty")}
	}
	if v.StorageJobId != nil {
		if err := encoder.SetURI("StorageJobId").String(*v.StorageJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpNotifyObjectComplete struct {
}

func (*awsRestjson1_serializeOpNotifyObjectComplete) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpNotifyObjectComplete) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NotifyObjectCompleteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs/{BackupJobId}/object/{UploadId}/complete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsNotifyObjectCompleteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.MetadataBlob != nil {
		payload := input.MetadataBlob
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsNotifyObjectCompleteInput(v *NotifyObjectCompleteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupJobId == nil || len(*v.BackupJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupJobId must not be empty")}
	}
	if v.BackupJobId != nil {
		if err := encoder.SetURI("BackupJobId").String(*v.BackupJobId); err != nil {
			return err
		}
	}

	if v.MetadataBlobChecksum != nil {
		encoder.SetQuery("metadata-checksum").String(*v.MetadataBlobChecksum)
	}

	if len(v.MetadataBlobChecksumAlgorithm) > 0 {
		encoder.SetQuery("metadata-checksum-algorithm").String(string(v.MetadataBlobChecksumAlgorithm))
	}

	if v.MetadataBlobLength != 0 {
		encoder.SetQuery("metadata-blob-length").Long(v.MetadataBlobLength)
	}

	if v.MetadataString != nil {
		encoder.SetQuery("metadata-string").String(*v.MetadataString)
	}

	if v.ObjectChecksum != nil {
		encoder.SetQuery("checksum").String(*v.ObjectChecksum)
	}

	if len(v.ObjectChecksumAlgorithm) > 0 {
		encoder.SetQuery("checksum-algorithm").String(string(v.ObjectChecksumAlgorithm))
	}

	if v.UploadId == nil || len(*v.UploadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UploadId must not be empty")}
	}
	if v.UploadId != nil {
		if err := encoder.SetURI("UploadId").String(*v.UploadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutChunk struct {
}

func (*awsRestjson1_serializeOpPutChunk) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutChunk) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutChunkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs/{BackupJobId}/chunk/{UploadId}/{ChunkIndex}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutChunkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Data != nil {
		payload := input.Data
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutChunkInput(v *PutChunkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupJobId == nil || len(*v.BackupJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupJobId must not be empty")}
	}
	if v.BackupJobId != nil {
		if err := encoder.SetURI("BackupJobId").String(*v.BackupJobId); err != nil {
			return err
		}
	}

	if v.Checksum != nil {
		encoder.SetQuery("checksum").String(*v.Checksum)
	}

	if len(v.ChecksumAlgorithm) > 0 {
		encoder.SetQuery("checksum-algorithm").String(string(v.ChecksumAlgorithm))
	}

	if v.ChunkIndex == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChunkIndex must not be empty")}
	}
	if v.ChunkIndex != nil {
		if err := encoder.SetURI("ChunkIndex").Long(*v.ChunkIndex); err != nil {
			return err
		}
	}

	{
		encoder.SetQuery("length").Long(v.Length)
	}

	if v.UploadId == nil || len(*v.UploadId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UploadId must not be empty")}
	}
	if v.UploadId != nil {
		if err := encoder.SetURI("UploadId").String(*v.UploadId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutObject struct {
}

func (*awsRestjson1_serializeOpPutObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs/{BackupJobId}/object/{ObjectName}/put-object")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.InlineChunk != nil {
		payload := input.InlineChunk
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutObjectInput(v *PutObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupJobId == nil || len(*v.BackupJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupJobId must not be empty")}
	}
	if v.BackupJobId != nil {
		if err := encoder.SetURI("BackupJobId").String(*v.BackupJobId); err != nil {
			return err
		}
	}

	if v.InlineChunkChecksum != nil {
		encoder.SetQuery("checksum").String(*v.InlineChunkChecksum)
	}

	if v.InlineChunkChecksumAlgorithm != nil {
		encoder.SetQuery("checksum-algorithm").String(*v.InlineChunkChecksumAlgorithm)
	}

	if v.InlineChunkLength != 0 {
		encoder.SetQuery("length").Long(v.InlineChunkLength)
	}

	if v.MetadataString != nil {
		encoder.SetQuery("metadata-string").String(*v.MetadataString)
	}

	if v.ObjectChecksum != nil {
		encoder.SetQuery("object-checksum").String(*v.ObjectChecksum)
	}

	if len(v.ObjectChecksumAlgorithm) > 0 {
		encoder.SetQuery("object-checksum-algorithm").String(string(v.ObjectChecksumAlgorithm))
	}

	if v.ObjectName == nil || len(*v.ObjectName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ObjectName must not be empty")}
	}
	if v.ObjectName != nil {
		if err := encoder.SetURI("ObjectName").String(*v.ObjectName); err != nil {
			return err
		}
	}

	if v.ThrowOnDuplicate {
		encoder.SetQuery("throwOnDuplicate").Boolean(v.ThrowOnDuplicate)
	}

	return nil
}

type awsRestjson1_serializeOpStartObject struct {
}

func (*awsRestjson1_serializeOpStartObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs/{BackupJobId}/object/{ObjectName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartObjectInput(v *StartObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupJobId == nil || len(*v.BackupJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupJobId must not be empty")}
	}
	if v.BackupJobId != nil {
		if err := encoder.SetURI("BackupJobId").String(*v.BackupJobId); err != nil {
			return err
		}
	}

	if v.ObjectName == nil || len(*v.ObjectName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ObjectName must not be empty")}
	}
	if v.ObjectName != nil {
		if err := encoder.SetURI("ObjectName").String(*v.ObjectName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartObjectInput(v *StartObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThrowOnDuplicate {
		ok := object.Key("ThrowOnDuplicate")
		ok.Boolean(v.ThrowOnDuplicate)
	}

	return nil
}
