// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/api/serviceusage/v1beta1/serviceusage.proto

package serviceusage

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum for service identity state.
type GetServiceIdentityResponse_IdentityState int32

const (
	// Default service identity state. This value is used if the state is
	// omitted.
	GetServiceIdentityResponse_IDENTITY_STATE_UNSPECIFIED GetServiceIdentityResponse_IdentityState = 0
	// Service identity has been created and can be used.
	GetServiceIdentityResponse_ACTIVE GetServiceIdentityResponse_IdentityState = 1
)

// Enum value maps for GetServiceIdentityResponse_IdentityState.
var (
	GetServiceIdentityResponse_IdentityState_name = map[int32]string{
		0: "IDENTITY_STATE_UNSPECIFIED",
		1: "ACTIVE",
	}
	GetServiceIdentityResponse_IdentityState_value = map[string]int32{
		"IDENTITY_STATE_UNSPECIFIED": 0,
		"ACTIVE":                     1,
	}
)

func (x GetServiceIdentityResponse_IdentityState) Enum() *GetServiceIdentityResponse_IdentityState {
	p := new(GetServiceIdentityResponse_IdentityState)
	*p = x
	return p
}

func (x GetServiceIdentityResponse_IdentityState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetServiceIdentityResponse_IdentityState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_enumTypes[0].Descriptor()
}

func (GetServiceIdentityResponse_IdentityState) Type() protoreflect.EnumType {
	return &file_google_api_serviceusage_v1beta1_serviceusage_proto_enumTypes[0]
}

func (x GetServiceIdentityResponse_IdentityState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetServiceIdentityResponse_IdentityState.Descriptor instead.
func (GetServiceIdentityResponse_IdentityState) EnumDescriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{34, 0}
}

// Request message for the `EnableService` method.
type EnableServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the consumer and service to enable the service on.
	//
	// The `EnableService` and `DisableService` methods currently only support
	// projects.
	//
	// Enabling a service requires that the service is public or is shared with
	// the user enabling the service.
	//
	// An example name would be:
	// `projects/123/services/serviceusage.googleapis.com`
	// where `123` is the project number (not project ID).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EnableServiceRequest) Reset() {
	*x = EnableServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableServiceRequest) ProtoMessage() {}

func (x *EnableServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableServiceRequest.ProtoReflect.Descriptor instead.
func (*EnableServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{0}
}

func (x *EnableServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `DisableService` method.
type DisableServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the consumer and service to disable the service on.
	//
	// The enable and disable methods currently only support projects.
	//
	// An example name would be:
	// `projects/123/services/serviceusage.googleapis.com`
	// where `123` is the project number (not project ID).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DisableServiceRequest) Reset() {
	*x = DisableServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableServiceRequest) ProtoMessage() {}

func (x *DisableServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableServiceRequest.ProtoReflect.Descriptor instead.
func (*DisableServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{1}
}

func (x *DisableServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `GetService` method.
type GetServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the consumer and service to get the `ConsumerState` for.
	//
	// An example name would be:
	// `projects/123/services/serviceusage.googleapis.com`
	// where `123` is the project number (not project ID).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServiceRequest) Reset() {
	*x = GetServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceRequest) ProtoMessage() {}

func (x *GetServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceRequest.ProtoReflect.Descriptor instead.
func (*GetServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{2}
}

func (x *GetServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `ListServices` method.
type ListServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent to search for services on.
	//
	// An example name would be:
	// `projects/123`
	// where `123` is the project number (not project ID).
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested size of the next page of data.
	// Requested page size cannot exceed 200.
	//  If not set, the default page size is 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token identifying which result to start with, which is returned by a
	// previous list call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Only list services that conform to the given filter.
	// The allowed filter strings are `state:ENABLED` and `state:DISABLED`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListServicesRequest) Reset() {
	*x = ListServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicesRequest) ProtoMessage() {}

func (x *ListServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicesRequest.ProtoReflect.Descriptor instead.
func (*ListServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{3}
}

func (x *ListServicesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServicesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServicesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListServicesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for the `ListServices` method.
type ListServicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The available services for the requested project.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// Token that can be passed to `ListServices` to resume a paginated
	// query.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListServicesResponse) Reset() {
	*x = ListServicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicesResponse) ProtoMessage() {}

func (x *ListServicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicesResponse.ProtoReflect.Descriptor instead.
func (*ListServicesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{4}
}

func (x *ListServicesResponse) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *ListServicesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the `BatchEnableServices` method.
type BatchEnableServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent to enable services on.
	//
	// An example name would be:
	// `projects/123`
	// where `123` is the project number (not project ID).
	//
	// The `BatchEnableServices` method currently only supports projects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The identifiers of the services to enable on the project.
	//
	// A valid identifier would be:
	// serviceusage.googleapis.com
	//
	// Enabling services requires that each service is public or is shared with
	// the user enabling the service.
	//
	// Two or more services must be specified. To enable a single service,
	// use the `EnableService` method instead.
	//
	// A single request can enable a maximum of 20 services at a time. If more
	// than 20 services are specified, the request will fail, and no state changes
	// will occur.
	ServiceIds []string `protobuf:"bytes,2,rep,name=service_ids,json=serviceIds,proto3" json:"service_ids,omitempty"`
}

func (x *BatchEnableServicesRequest) Reset() {
	*x = BatchEnableServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchEnableServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchEnableServicesRequest) ProtoMessage() {}

func (x *BatchEnableServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchEnableServicesRequest.ProtoReflect.Descriptor instead.
func (*BatchEnableServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{5}
}

func (x *BatchEnableServicesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchEnableServicesRequest) GetServiceIds() []string {
	if x != nil {
		return x.ServiceIds
	}
	return nil
}

// Request message for ListConsumerQuotaMetrics
type ListConsumerQuotaMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent of the quotas resource.
	//
	// Some example names would be:
	// `projects/123/services/serviceconsumermanagement.googleapis.com`
	// `folders/345/services/serviceconsumermanagement.googleapis.com`
	// `organizations/456/services/serviceconsumermanagement.googleapis.com`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested size of the next page of data.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specifies the level of detail for quota information in the response.
	View QuotaView `protobuf:"varint,4,opt,name=view,proto3,enum=google.api.serviceusage.v1beta1.QuotaView" json:"view,omitempty"`
}

func (x *ListConsumerQuotaMetricsRequest) Reset() {
	*x = ListConsumerQuotaMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConsumerQuotaMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConsumerQuotaMetricsRequest) ProtoMessage() {}

func (x *ListConsumerQuotaMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConsumerQuotaMetricsRequest.ProtoReflect.Descriptor instead.
func (*ListConsumerQuotaMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{6}
}

func (x *ListConsumerQuotaMetricsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConsumerQuotaMetricsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConsumerQuotaMetricsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConsumerQuotaMetricsRequest) GetView() QuotaView {
	if x != nil {
		return x.View
	}
	return QuotaView_QUOTA_VIEW_UNSPECIFIED
}

// Response message for ListConsumerQuotaMetrics
type ListConsumerQuotaMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Quota settings for the consumer, organized by quota metric.
	Metrics []*ConsumerQuotaMetric `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConsumerQuotaMetricsResponse) Reset() {
	*x = ListConsumerQuotaMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConsumerQuotaMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConsumerQuotaMetricsResponse) ProtoMessage() {}

func (x *ListConsumerQuotaMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConsumerQuotaMetricsResponse.ProtoReflect.Descriptor instead.
func (*ListConsumerQuotaMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{7}
}

func (x *ListConsumerQuotaMetricsResponse) GetMetrics() []*ConsumerQuotaMetric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *ListConsumerQuotaMetricsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetConsumerQuotaMetric
type GetConsumerQuotaMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the quota limit.
	//
	// An example name would be:
	// `projects/123/services/serviceusage.googleapis.com/quotas/metrics/serviceusage.googleapis.com%2Fmutate_requests`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the level of detail for quota information in the response.
	View QuotaView `protobuf:"varint,2,opt,name=view,proto3,enum=google.api.serviceusage.v1beta1.QuotaView" json:"view,omitempty"`
}

func (x *GetConsumerQuotaMetricRequest) Reset() {
	*x = GetConsumerQuotaMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConsumerQuotaMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConsumerQuotaMetricRequest) ProtoMessage() {}

func (x *GetConsumerQuotaMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConsumerQuotaMetricRequest.ProtoReflect.Descriptor instead.
func (*GetConsumerQuotaMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{8}
}

func (x *GetConsumerQuotaMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetConsumerQuotaMetricRequest) GetView() QuotaView {
	if x != nil {
		return x.View
	}
	return QuotaView_QUOTA_VIEW_UNSPECIFIED
}

// Request message for GetConsumerQuotaLimit
type GetConsumerQuotaLimitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the quota limit.
	//
	// Use the quota limit resource name returned by previous
	// ListConsumerQuotaMetrics and GetConsumerQuotaMetric API calls.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the level of detail for quota information in the response.
	View QuotaView `protobuf:"varint,2,opt,name=view,proto3,enum=google.api.serviceusage.v1beta1.QuotaView" json:"view,omitempty"`
}

func (x *GetConsumerQuotaLimitRequest) Reset() {
	*x = GetConsumerQuotaLimitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConsumerQuotaLimitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConsumerQuotaLimitRequest) ProtoMessage() {}

func (x *GetConsumerQuotaLimitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConsumerQuotaLimitRequest.ProtoReflect.Descriptor instead.
func (*GetConsumerQuotaLimitRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{9}
}

func (x *GetConsumerQuotaLimitRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetConsumerQuotaLimitRequest) GetView() QuotaView {
	if x != nil {
		return x.View
	}
	return QuotaView_QUOTA_VIEW_UNSPECIFIED
}

// Request message for CreateAdminOverride.
type CreateAdminOverrideRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent quota limit, returned by a
	// ListConsumerQuotaMetrics or GetConsumerQuotaMetric call.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The admin override to create.
	Override *QuotaOverride `protobuf:"bytes,2,opt,name=override,proto3" json:"override,omitempty"`
	// Whether to force the creation of the quota override.
	// Setting the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// The list of quota safety checks to ignore before the override mutation.
	// Unlike 'force' field that ignores all the quota safety checks, the
	// 'force_only' field ignores only the specified checks; other checks are
	// still enforced. The 'force' and 'force_only' fields cannot both be set.
	ForceOnly []QuotaSafetyCheck `protobuf:"varint,4,rep,packed,name=force_only,json=forceOnly,proto3,enum=google.api.serviceusage.v1beta1.QuotaSafetyCheck" json:"force_only,omitempty"`
}

func (x *CreateAdminOverrideRequest) Reset() {
	*x = CreateAdminOverrideRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAdminOverrideRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAdminOverrideRequest) ProtoMessage() {}

func (x *CreateAdminOverrideRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAdminOverrideRequest.ProtoReflect.Descriptor instead.
func (*CreateAdminOverrideRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{10}
}

func (x *CreateAdminOverrideRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAdminOverrideRequest) GetOverride() *QuotaOverride {
	if x != nil {
		return x.Override
	}
	return nil
}

func (x *CreateAdminOverrideRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *CreateAdminOverrideRequest) GetForceOnly() []QuotaSafetyCheck {
	if x != nil {
		return x.ForceOnly
	}
	return nil
}

// Request message for UpdateAdminOverride.
type UpdateAdminOverrideRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the override to update.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The new override.
	// Only the override_value is updated; all other fields are ignored.
	Override *QuotaOverride `protobuf:"bytes,2,opt,name=override,proto3" json:"override,omitempty"`
	// Whether to force the update of the quota override.
	// Setting the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// Update only the specified fields of the override.
	// If unset, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The list of quota safety checks to ignore before the override mutation.
	// Unlike 'force' field that ignores all the quota safety checks, the
	// 'force_only' field ignores only the specified checks; other checks are
	// still enforced. The 'force' and 'force_only' fields cannot both be set.
	ForceOnly []QuotaSafetyCheck `protobuf:"varint,5,rep,packed,name=force_only,json=forceOnly,proto3,enum=google.api.serviceusage.v1beta1.QuotaSafetyCheck" json:"force_only,omitempty"`
}

func (x *UpdateAdminOverrideRequest) Reset() {
	*x = UpdateAdminOverrideRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAdminOverrideRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAdminOverrideRequest) ProtoMessage() {}

func (x *UpdateAdminOverrideRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAdminOverrideRequest.ProtoReflect.Descriptor instead.
func (*UpdateAdminOverrideRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateAdminOverrideRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateAdminOverrideRequest) GetOverride() *QuotaOverride {
	if x != nil {
		return x.Override
	}
	return nil
}

func (x *UpdateAdminOverrideRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *UpdateAdminOverrideRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAdminOverrideRequest) GetForceOnly() []QuotaSafetyCheck {
	if x != nil {
		return x.ForceOnly
	}
	return nil
}

// Request message for DeleteAdminOverride.
type DeleteAdminOverrideRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the override to delete.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Whether to force the deletion of the quota override.
	// Setting the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	// The list of quota safety checks to ignore before the override mutation.
	// Unlike 'force' field that ignores all the quota safety checks, the
	// 'force_only' field ignores only the specified checks; other checks are
	// still enforced. The 'force' and 'force_only' fields cannot both be set.
	ForceOnly []QuotaSafetyCheck `protobuf:"varint,3,rep,packed,name=force_only,json=forceOnly,proto3,enum=google.api.serviceusage.v1beta1.QuotaSafetyCheck" json:"force_only,omitempty"`
}

func (x *DeleteAdminOverrideRequest) Reset() {
	*x = DeleteAdminOverrideRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAdminOverrideRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAdminOverrideRequest) ProtoMessage() {}

func (x *DeleteAdminOverrideRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAdminOverrideRequest.ProtoReflect.Descriptor instead.
func (*DeleteAdminOverrideRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteAdminOverrideRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAdminOverrideRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeleteAdminOverrideRequest) GetForceOnly() []QuotaSafetyCheck {
	if x != nil {
		return x.ForceOnly
	}
	return nil
}

// Request message for ListAdminOverrides
type ListAdminOverridesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent quota limit, returned by a
	// ListConsumerQuotaMetrics or GetConsumerQuotaMetric call.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested size of the next page of data.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAdminOverridesRequest) Reset() {
	*x = ListAdminOverridesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdminOverridesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdminOverridesRequest) ProtoMessage() {}

func (x *ListAdminOverridesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdminOverridesRequest.ProtoReflect.Descriptor instead.
func (*ListAdminOverridesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{13}
}

func (x *ListAdminOverridesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAdminOverridesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAdminOverridesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAdminOverrides.
type ListAdminOverridesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Admin overrides on this limit.
	Overrides []*QuotaOverride `protobuf:"bytes,1,rep,name=overrides,proto3" json:"overrides,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAdminOverridesResponse) Reset() {
	*x = ListAdminOverridesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdminOverridesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdminOverridesResponse) ProtoMessage() {}

func (x *ListAdminOverridesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdminOverridesResponse.ProtoReflect.Descriptor instead.
func (*ListAdminOverridesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{14}
}

func (x *ListAdminOverridesResponse) GetOverrides() []*QuotaOverride {
	if x != nil {
		return x.Overrides
	}
	return nil
}

func (x *ListAdminOverridesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Response message for BatchCreateAdminOverrides
type BatchCreateAdminOverridesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overrides that were created.
	Overrides []*QuotaOverride `protobuf:"bytes,1,rep,name=overrides,proto3" json:"overrides,omitempty"`
}

func (x *BatchCreateAdminOverridesResponse) Reset() {
	*x = BatchCreateAdminOverridesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateAdminOverridesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateAdminOverridesResponse) ProtoMessage() {}

func (x *BatchCreateAdminOverridesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateAdminOverridesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateAdminOverridesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{15}
}

func (x *BatchCreateAdminOverridesResponse) GetOverrides() []*QuotaOverride {
	if x != nil {
		return x.Overrides
	}
	return nil
}

// Request message for ImportAdminOverrides
type ImportAdminOverridesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the consumer.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Source of import data
	//
	// Types that are assignable to Source:
	//	*ImportAdminOverridesRequest_InlineSource
	Source isImportAdminOverridesRequest_Source `protobuf_oneof:"source"`
	// Whether to force the creation of the quota overrides.
	// Setting the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// The list of quota safety checks to ignore before the override mutation.
	// Unlike 'force' field that ignores all the quota safety checks, the
	// 'force_only' field ignores only the specified checks; other checks are
	// still enforced. The 'force' and 'force_only' fields cannot both be set.
	ForceOnly []QuotaSafetyCheck `protobuf:"varint,4,rep,packed,name=force_only,json=forceOnly,proto3,enum=google.api.serviceusage.v1beta1.QuotaSafetyCheck" json:"force_only,omitempty"`
}

func (x *ImportAdminOverridesRequest) Reset() {
	*x = ImportAdminOverridesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAdminOverridesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAdminOverridesRequest) ProtoMessage() {}

func (x *ImportAdminOverridesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAdminOverridesRequest.ProtoReflect.Descriptor instead.
func (*ImportAdminOverridesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{16}
}

func (x *ImportAdminOverridesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportAdminOverridesRequest) GetSource() isImportAdminOverridesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportAdminOverridesRequest) GetInlineSource() *OverrideInlineSource {
	if x, ok := x.GetSource().(*ImportAdminOverridesRequest_InlineSource); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportAdminOverridesRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *ImportAdminOverridesRequest) GetForceOnly() []QuotaSafetyCheck {
	if x != nil {
		return x.ForceOnly
	}
	return nil
}

type isImportAdminOverridesRequest_Source interface {
	isImportAdminOverridesRequest_Source()
}

type ImportAdminOverridesRequest_InlineSource struct {
	// The import data is specified in the request message itself
	InlineSource *OverrideInlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

func (*ImportAdminOverridesRequest_InlineSource) isImportAdminOverridesRequest_Source() {}

// Response message for ImportAdminOverrides
type ImportAdminOverridesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overrides that were created from the imported data.
	Overrides []*QuotaOverride `protobuf:"bytes,1,rep,name=overrides,proto3" json:"overrides,omitempty"`
}

func (x *ImportAdminOverridesResponse) Reset() {
	*x = ImportAdminOverridesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAdminOverridesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAdminOverridesResponse) ProtoMessage() {}

func (x *ImportAdminOverridesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAdminOverridesResponse.ProtoReflect.Descriptor instead.
func (*ImportAdminOverridesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{17}
}

func (x *ImportAdminOverridesResponse) GetOverrides() []*QuotaOverride {
	if x != nil {
		return x.Overrides
	}
	return nil
}

// Metadata message that provides information such as progress,
// partial failures, and similar information on each GetOperation call
// of LRO returned by ImportAdminOverrides.
type ImportAdminOverridesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportAdminOverridesMetadata) Reset() {
	*x = ImportAdminOverridesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAdminOverridesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAdminOverridesMetadata) ProtoMessage() {}

func (x *ImportAdminOverridesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAdminOverridesMetadata.ProtoReflect.Descriptor instead.
func (*ImportAdminOverridesMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{18}
}

// Request message for CreateConsumerOverride.
type CreateConsumerOverrideRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent quota limit, returned by a
	// ListConsumerQuotaMetrics or GetConsumerQuotaMetric call.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The override to create.
	Override *QuotaOverride `protobuf:"bytes,2,opt,name=override,proto3" json:"override,omitempty"`
	// Whether to force the creation of the quota override.
	// Setting the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// The list of quota safety checks to ignore before the override mutation.
	// Unlike 'force' field that ignores all the quota safety checks, the
	// 'force_only' field ignores only the specified checks; other checks are
	// still enforced. The 'force' and 'force_only' fields cannot both be set.
	ForceOnly []QuotaSafetyCheck `protobuf:"varint,4,rep,packed,name=force_only,json=forceOnly,proto3,enum=google.api.serviceusage.v1beta1.QuotaSafetyCheck" json:"force_only,omitempty"`
}

func (x *CreateConsumerOverrideRequest) Reset() {
	*x = CreateConsumerOverrideRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConsumerOverrideRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConsumerOverrideRequest) ProtoMessage() {}

func (x *CreateConsumerOverrideRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConsumerOverrideRequest.ProtoReflect.Descriptor instead.
func (*CreateConsumerOverrideRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{19}
}

func (x *CreateConsumerOverrideRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConsumerOverrideRequest) GetOverride() *QuotaOverride {
	if x != nil {
		return x.Override
	}
	return nil
}

func (x *CreateConsumerOverrideRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *CreateConsumerOverrideRequest) GetForceOnly() []QuotaSafetyCheck {
	if x != nil {
		return x.ForceOnly
	}
	return nil
}

// Request message for UpdateConsumerOverride.
type UpdateConsumerOverrideRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the override to update.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The new override.
	// Only the override_value is updated; all other fields are ignored.
	Override *QuotaOverride `protobuf:"bytes,2,opt,name=override,proto3" json:"override,omitempty"`
	// Whether to force the update of the quota override.
	// Setting the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// Update only the specified fields of the override.
	// If unset, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The list of quota safety checks to ignore before the override mutation.
	// Unlike 'force' field that ignores all the quota safety checks, the
	// 'force_only' field ignores only the specified checks; other checks are
	// still enforced. The 'force' and 'force_only' fields cannot both be set.
	ForceOnly []QuotaSafetyCheck `protobuf:"varint,5,rep,packed,name=force_only,json=forceOnly,proto3,enum=google.api.serviceusage.v1beta1.QuotaSafetyCheck" json:"force_only,omitempty"`
}

func (x *UpdateConsumerOverrideRequest) Reset() {
	*x = UpdateConsumerOverrideRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConsumerOverrideRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConsumerOverrideRequest) ProtoMessage() {}

func (x *UpdateConsumerOverrideRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConsumerOverrideRequest.ProtoReflect.Descriptor instead.
func (*UpdateConsumerOverrideRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateConsumerOverrideRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateConsumerOverrideRequest) GetOverride() *QuotaOverride {
	if x != nil {
		return x.Override
	}
	return nil
}

func (x *UpdateConsumerOverrideRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *UpdateConsumerOverrideRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConsumerOverrideRequest) GetForceOnly() []QuotaSafetyCheck {
	if x != nil {
		return x.ForceOnly
	}
	return nil
}

// Request message for DeleteConsumerOverride.
type DeleteConsumerOverrideRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the override to delete.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Whether to force the deletion of the quota override.
	// Setting the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	// The list of quota safety checks to ignore before the override mutation.
	// Unlike 'force' field that ignores all the quota safety checks, the
	// 'force_only' field ignores only the specified checks; other checks are
	// still enforced. The 'force' and 'force_only' fields cannot both be set.
	ForceOnly []QuotaSafetyCheck `protobuf:"varint,3,rep,packed,name=force_only,json=forceOnly,proto3,enum=google.api.serviceusage.v1beta1.QuotaSafetyCheck" json:"force_only,omitempty"`
}

func (x *DeleteConsumerOverrideRequest) Reset() {
	*x = DeleteConsumerOverrideRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConsumerOverrideRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConsumerOverrideRequest) ProtoMessage() {}

func (x *DeleteConsumerOverrideRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConsumerOverrideRequest.ProtoReflect.Descriptor instead.
func (*DeleteConsumerOverrideRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteConsumerOverrideRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConsumerOverrideRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeleteConsumerOverrideRequest) GetForceOnly() []QuotaSafetyCheck {
	if x != nil {
		return x.ForceOnly
	}
	return nil
}

// Request message for ListConsumerOverrides
type ListConsumerOverridesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent quota limit, returned by a
	// ListConsumerQuotaMetrics or GetConsumerQuotaMetric call.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested size of the next page of data.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConsumerOverridesRequest) Reset() {
	*x = ListConsumerOverridesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConsumerOverridesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConsumerOverridesRequest) ProtoMessage() {}

func (x *ListConsumerOverridesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConsumerOverridesRequest.ProtoReflect.Descriptor instead.
func (*ListConsumerOverridesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{22}
}

func (x *ListConsumerOverridesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConsumerOverridesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConsumerOverridesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListConsumerOverrides.
type ListConsumerOverridesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Consumer overrides on this limit.
	Overrides []*QuotaOverride `protobuf:"bytes,1,rep,name=overrides,proto3" json:"overrides,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConsumerOverridesResponse) Reset() {
	*x = ListConsumerOverridesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConsumerOverridesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConsumerOverridesResponse) ProtoMessage() {}

func (x *ListConsumerOverridesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConsumerOverridesResponse.ProtoReflect.Descriptor instead.
func (*ListConsumerOverridesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{23}
}

func (x *ListConsumerOverridesResponse) GetOverrides() []*QuotaOverride {
	if x != nil {
		return x.Overrides
	}
	return nil
}

func (x *ListConsumerOverridesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Response message for BatchCreateConsumerOverrides
type BatchCreateConsumerOverridesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overrides that were created.
	Overrides []*QuotaOverride `protobuf:"bytes,1,rep,name=overrides,proto3" json:"overrides,omitempty"`
}

func (x *BatchCreateConsumerOverridesResponse) Reset() {
	*x = BatchCreateConsumerOverridesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateConsumerOverridesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateConsumerOverridesResponse) ProtoMessage() {}

func (x *BatchCreateConsumerOverridesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateConsumerOverridesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateConsumerOverridesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{24}
}

func (x *BatchCreateConsumerOverridesResponse) GetOverrides() []*QuotaOverride {
	if x != nil {
		return x.Overrides
	}
	return nil
}

// Request message for ImportConsumerOverrides
type ImportConsumerOverridesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the consumer.
	//
	// An example name would be:
	// `projects/123/services/compute.googleapis.com`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Source of import data
	//
	// Types that are assignable to Source:
	//	*ImportConsumerOverridesRequest_InlineSource
	Source isImportConsumerOverridesRequest_Source `protobuf_oneof:"source"`
	// Whether to force the creation of the quota overrides.
	// Setting the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// The list of quota safety checks to ignore before the override mutation.
	// Unlike 'force' field that ignores all the quota safety checks, the
	// 'force_only' field ignores only the specified checks; other checks are
	// still enforced. The 'force' and 'force_only' fields cannot both be set.
	ForceOnly []QuotaSafetyCheck `protobuf:"varint,4,rep,packed,name=force_only,json=forceOnly,proto3,enum=google.api.serviceusage.v1beta1.QuotaSafetyCheck" json:"force_only,omitempty"`
}

func (x *ImportConsumerOverridesRequest) Reset() {
	*x = ImportConsumerOverridesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportConsumerOverridesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportConsumerOverridesRequest) ProtoMessage() {}

func (x *ImportConsumerOverridesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportConsumerOverridesRequest.ProtoReflect.Descriptor instead.
func (*ImportConsumerOverridesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{25}
}

func (x *ImportConsumerOverridesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportConsumerOverridesRequest) GetSource() isImportConsumerOverridesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportConsumerOverridesRequest) GetInlineSource() *OverrideInlineSource {
	if x, ok := x.GetSource().(*ImportConsumerOverridesRequest_InlineSource); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportConsumerOverridesRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *ImportConsumerOverridesRequest) GetForceOnly() []QuotaSafetyCheck {
	if x != nil {
		return x.ForceOnly
	}
	return nil
}

type isImportConsumerOverridesRequest_Source interface {
	isImportConsumerOverridesRequest_Source()
}

type ImportConsumerOverridesRequest_InlineSource struct {
	// The import data is specified in the request message itself
	InlineSource *OverrideInlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

func (*ImportConsumerOverridesRequest_InlineSource) isImportConsumerOverridesRequest_Source() {}

// Response message for ImportConsumerOverrides
type ImportConsumerOverridesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overrides that were created from the imported data.
	Overrides []*QuotaOverride `protobuf:"bytes,1,rep,name=overrides,proto3" json:"overrides,omitempty"`
}

func (x *ImportConsumerOverridesResponse) Reset() {
	*x = ImportConsumerOverridesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportConsumerOverridesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportConsumerOverridesResponse) ProtoMessage() {}

func (x *ImportConsumerOverridesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportConsumerOverridesResponse.ProtoReflect.Descriptor instead.
func (*ImportConsumerOverridesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{26}
}

func (x *ImportConsumerOverridesResponse) GetOverrides() []*QuotaOverride {
	if x != nil {
		return x.Overrides
	}
	return nil
}

// Metadata message that provides information such as progress,
// partial failures, and similar information on each GetOperation call
// of LRO returned by ImportConsumerOverrides.
type ImportConsumerOverridesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportConsumerOverridesMetadata) Reset() {
	*x = ImportConsumerOverridesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportConsumerOverridesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportConsumerOverridesMetadata) ProtoMessage() {}

func (x *ImportConsumerOverridesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportConsumerOverridesMetadata.ProtoReflect.Descriptor instead.
func (*ImportConsumerOverridesMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{27}
}

// Response message for ImportAdminQuotaPolicies
type ImportAdminQuotaPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The policies that were created from the imported data.
	Policies []*AdminQuotaPolicy `protobuf:"bytes,1,rep,name=policies,proto3" json:"policies,omitempty"`
}

func (x *ImportAdminQuotaPoliciesResponse) Reset() {
	*x = ImportAdminQuotaPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAdminQuotaPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAdminQuotaPoliciesResponse) ProtoMessage() {}

func (x *ImportAdminQuotaPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAdminQuotaPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ImportAdminQuotaPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{28}
}

func (x *ImportAdminQuotaPoliciesResponse) GetPolicies() []*AdminQuotaPolicy {
	if x != nil {
		return x.Policies
	}
	return nil
}

// Metadata message that provides information such as progress,
// partial failures, and similar information on each GetOperation call
// of LRO returned by ImportAdminQuotaPolicies.
type ImportAdminQuotaPoliciesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportAdminQuotaPoliciesMetadata) Reset() {
	*x = ImportAdminQuotaPoliciesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAdminQuotaPoliciesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAdminQuotaPoliciesMetadata) ProtoMessage() {}

func (x *ImportAdminQuotaPoliciesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAdminQuotaPoliciesMetadata.ProtoReflect.Descriptor instead.
func (*ImportAdminQuotaPoliciesMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{29}
}

// Metadata message that provides information such as progress,
// partial failures, and similar information on each GetOperation call
// of LRO returned by CreateAdminQuotaPolicy.
type CreateAdminQuotaPolicyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateAdminQuotaPolicyMetadata) Reset() {
	*x = CreateAdminQuotaPolicyMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAdminQuotaPolicyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAdminQuotaPolicyMetadata) ProtoMessage() {}

func (x *CreateAdminQuotaPolicyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAdminQuotaPolicyMetadata.ProtoReflect.Descriptor instead.
func (*CreateAdminQuotaPolicyMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{30}
}

// Metadata message that provides information such as progress,
// partial failures, and similar information on each GetOperation call
// of LRO returned by UpdateAdminQuotaPolicy.
type UpdateAdminQuotaPolicyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateAdminQuotaPolicyMetadata) Reset() {
	*x = UpdateAdminQuotaPolicyMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAdminQuotaPolicyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAdminQuotaPolicyMetadata) ProtoMessage() {}

func (x *UpdateAdminQuotaPolicyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAdminQuotaPolicyMetadata.ProtoReflect.Descriptor instead.
func (*UpdateAdminQuotaPolicyMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{31}
}

// Metadata message that provides information such as progress,
// partial failures, and similar information on each GetOperation call
// of LRO returned by DeleteAdminQuotaPolicy.
type DeleteAdminQuotaPolicyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteAdminQuotaPolicyMetadata) Reset() {
	*x = DeleteAdminQuotaPolicyMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAdminQuotaPolicyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAdminQuotaPolicyMetadata) ProtoMessage() {}

func (x *DeleteAdminQuotaPolicyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAdminQuotaPolicyMetadata.ProtoReflect.Descriptor instead.
func (*DeleteAdminQuotaPolicyMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{32}
}

// Request message for generating service identity.
type GenerateServiceIdentityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the consumer and service to generate an identity for.
	//
	// The `GenerateServiceIdentity` methods currently only support projects.
	//
	// An example name would be:
	// `projects/123/services/example.googleapis.com` where `123` is the
	// project number.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *GenerateServiceIdentityRequest) Reset() {
	*x = GenerateServiceIdentityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateServiceIdentityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateServiceIdentityRequest) ProtoMessage() {}

func (x *GenerateServiceIdentityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateServiceIdentityRequest.ProtoReflect.Descriptor instead.
func (*GenerateServiceIdentityRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{33}
}

func (x *GenerateServiceIdentityRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for getting service identity.
type GetServiceIdentityResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Service identity that service producer can use to access consumer
	// resources. If exists is true, it contains email and unique_id. If exists is
	// false, it contains pre-constructed email and empty unique_id.
	Identity *ServiceIdentity `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	// Service identity state.
	State GetServiceIdentityResponse_IdentityState `protobuf:"varint,2,opt,name=state,proto3,enum=google.api.serviceusage.v1beta1.GetServiceIdentityResponse_IdentityState" json:"state,omitempty"`
}

func (x *GetServiceIdentityResponse) Reset() {
	*x = GetServiceIdentityResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServiceIdentityResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceIdentityResponse) ProtoMessage() {}

func (x *GetServiceIdentityResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceIdentityResponse.ProtoReflect.Descriptor instead.
func (*GetServiceIdentityResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{34}
}

func (x *GetServiceIdentityResponse) GetIdentity() *ServiceIdentity {
	if x != nil {
		return x.Identity
	}
	return nil
}

func (x *GetServiceIdentityResponse) GetState() GetServiceIdentityResponse_IdentityState {
	if x != nil {
		return x.State
	}
	return GetServiceIdentityResponse_IDENTITY_STATE_UNSPECIFIED
}

// Metadata for the `GetServiceIdentity` method.
type GetServiceIdentityMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetServiceIdentityMetadata) Reset() {
	*x = GetServiceIdentityMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServiceIdentityMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceIdentityMetadata) ProtoMessage() {}

func (x *GetServiceIdentityMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceIdentityMetadata.ProtoReflect.Descriptor instead.
func (*GetServiceIdentityMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP(), []int{35}
}

var File_google_api_serviceusage_v1beta1_serviceusage_proto protoreflect.FileDescriptor

var file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2a, 0x0a, 0x14, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x2b, 0x0a, 0x15, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x27,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x81, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x84, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x55, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x22, 0xb5, 0x01, 0x0a, 0x1f, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x22, 0x9a, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x73,
	0x0a, 0x1d, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x22, 0x72, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xe8, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a,
	0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x12, 0x50, 0x0a, 0x0a, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0xa1, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x50, 0x0a, 0x0a, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x09, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x98, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12,
	0x50, 0x0a, 0x0a, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x4f, 0x6e, 0x6c,
	0x79, 0x22, 0x6f, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x92, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x71, 0x0a, 0x21, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x09,
	0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52,
	0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x22, 0x85, 0x02, 0x0a, 0x1b, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x5c, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x09, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x6c, 0x0a, 0x1c, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x6d, 0x69,
	0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73,
	0x22, 0x1e, 0x0a, 0x1c, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0xeb, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x6f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x08, 0x6f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xa4,
	0x02, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x50, 0x0a, 0x0a, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x9b, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x12, 0x50, 0x0a, 0x0a, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0x72, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x95, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x09, 0x6f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x6f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x74, 0x0a, 0x24, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x73, 0x22, 0x88, 0x02, 0x0a, 0x1e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x5c, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x09, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0x6f, 0x0a, 0x1f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x22, 0x21, 0x0a, 0x1f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x71, 0x0a, 0x20, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x08, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x22, 0x22, 0x0a, 0x20, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x20, 0x0a, 0x1e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x20, 0x0a,
	0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0x20, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x38, 0x0a, 0x1e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x88, 0x02, 0x0a, 0x1a,
	0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x08, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x5f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x3b, 0x0a, 0x0d, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x49, 0x44,
	0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x22, 0x1c, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x32, 0xfc, 0x23, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0xc7, 0x01, 0x0a, 0x0d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x60, 0x88,
	0x02, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x3a,
	0x01, 0x2a, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xca, 0x01, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x61, 0x88, 0x02, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2b, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x01, 0x2a, 0xca,
	0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x95, 0x01, 0x0a,
	0x0a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0x29, 0x88, 0x02, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa6, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x29, 0x88, 0x02, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0xd8, 0x01,
	0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x65, 0x88, 0x02, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x22, 0x2a, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xde, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0xcd, 0x01, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x15, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12,
	0x3e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xfa, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x86, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x22, 0x4f, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x3a, 0x08, 0x6f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xfa, 0x01, 0x0a,
	0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x86, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x32, 0x4f, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf8, 0x01, 0x0a, 0x13, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x2a, 0x4f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0xe6, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x12, 0x4f, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x8a, 0x02,
	0x0a, 0x14, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x22, 0x4a, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x3c, 0x0a, 0x1c,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x83, 0x02, 0x0a, 0x16, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x22, 0x52, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x3a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0xca, 0x41, 0x22, 0x0a, 0x0d,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x83, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x5e, 0x32, 0x52, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x81, 0x02, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x87, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x2a, 0x52, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xca, 0x41, 0x2a,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf2, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x12, 0x52, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x72, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12,
	0x99, 0x02, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9d, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x52, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x42, 0x0a, 0x1f, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe6, 0x01, 0x0a, 0x17,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x22,
	0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0xca, 0x41, 0x28, 0x0a, 0x0f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x1a, 0xbc, 0x01, 0xca, 0x41, 0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x9a, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x42, 0xf0, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x11, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x4b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0xaa, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x69, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x69, 0x5c, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x69, 0x3a,
	0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescOnce sync.Once
	file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescData = file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDesc
)

func file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescGZIP() []byte {
	file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescOnce.Do(func() {
		file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescData)
	})
	return file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDescData
}

var file_google_api_serviceusage_v1beta1_serviceusage_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes = make([]protoimpl.MessageInfo, 36)
var file_google_api_serviceusage_v1beta1_serviceusage_proto_goTypes = []interface{}{
	(GetServiceIdentityResponse_IdentityState)(0), // 0: google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState
	(*EnableServiceRequest)(nil),                  // 1: google.api.serviceusage.v1beta1.EnableServiceRequest
	(*DisableServiceRequest)(nil),                 // 2: google.api.serviceusage.v1beta1.DisableServiceRequest
	(*GetServiceRequest)(nil),                     // 3: google.api.serviceusage.v1beta1.GetServiceRequest
	(*ListServicesRequest)(nil),                   // 4: google.api.serviceusage.v1beta1.ListServicesRequest
	(*ListServicesResponse)(nil),                  // 5: google.api.serviceusage.v1beta1.ListServicesResponse
	(*BatchEnableServicesRequest)(nil),            // 6: google.api.serviceusage.v1beta1.BatchEnableServicesRequest
	(*ListConsumerQuotaMetricsRequest)(nil),       // 7: google.api.serviceusage.v1beta1.ListConsumerQuotaMetricsRequest
	(*ListConsumerQuotaMetricsResponse)(nil),      // 8: google.api.serviceusage.v1beta1.ListConsumerQuotaMetricsResponse
	(*GetConsumerQuotaMetricRequest)(nil),         // 9: google.api.serviceusage.v1beta1.GetConsumerQuotaMetricRequest
	(*GetConsumerQuotaLimitRequest)(nil),          // 10: google.api.serviceusage.v1beta1.GetConsumerQuotaLimitRequest
	(*CreateAdminOverrideRequest)(nil),            // 11: google.api.serviceusage.v1beta1.CreateAdminOverrideRequest
	(*UpdateAdminOverrideRequest)(nil),            // 12: google.api.serviceusage.v1beta1.UpdateAdminOverrideRequest
	(*DeleteAdminOverrideRequest)(nil),            // 13: google.api.serviceusage.v1beta1.DeleteAdminOverrideRequest
	(*ListAdminOverridesRequest)(nil),             // 14: google.api.serviceusage.v1beta1.ListAdminOverridesRequest
	(*ListAdminOverridesResponse)(nil),            // 15: google.api.serviceusage.v1beta1.ListAdminOverridesResponse
	(*BatchCreateAdminOverridesResponse)(nil),     // 16: google.api.serviceusage.v1beta1.BatchCreateAdminOverridesResponse
	(*ImportAdminOverridesRequest)(nil),           // 17: google.api.serviceusage.v1beta1.ImportAdminOverridesRequest
	(*ImportAdminOverridesResponse)(nil),          // 18: google.api.serviceusage.v1beta1.ImportAdminOverridesResponse
	(*ImportAdminOverridesMetadata)(nil),          // 19: google.api.serviceusage.v1beta1.ImportAdminOverridesMetadata
	(*CreateConsumerOverrideRequest)(nil),         // 20: google.api.serviceusage.v1beta1.CreateConsumerOverrideRequest
	(*UpdateConsumerOverrideRequest)(nil),         // 21: google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest
	(*DeleteConsumerOverrideRequest)(nil),         // 22: google.api.serviceusage.v1beta1.DeleteConsumerOverrideRequest
	(*ListConsumerOverridesRequest)(nil),          // 23: google.api.serviceusage.v1beta1.ListConsumerOverridesRequest
	(*ListConsumerOverridesResponse)(nil),         // 24: google.api.serviceusage.v1beta1.ListConsumerOverridesResponse
	(*BatchCreateConsumerOverridesResponse)(nil),  // 25: google.api.serviceusage.v1beta1.BatchCreateConsumerOverridesResponse
	(*ImportConsumerOverridesRequest)(nil),        // 26: google.api.serviceusage.v1beta1.ImportConsumerOverridesRequest
	(*ImportConsumerOverridesResponse)(nil),       // 27: google.api.serviceusage.v1beta1.ImportConsumerOverridesResponse
	(*ImportConsumerOverridesMetadata)(nil),       // 28: google.api.serviceusage.v1beta1.ImportConsumerOverridesMetadata
	(*ImportAdminQuotaPoliciesResponse)(nil),      // 29: google.api.serviceusage.v1beta1.ImportAdminQuotaPoliciesResponse
	(*ImportAdminQuotaPoliciesMetadata)(nil),      // 30: google.api.serviceusage.v1beta1.ImportAdminQuotaPoliciesMetadata
	(*CreateAdminQuotaPolicyMetadata)(nil),        // 31: google.api.serviceusage.v1beta1.CreateAdminQuotaPolicyMetadata
	(*UpdateAdminQuotaPolicyMetadata)(nil),        // 32: google.api.serviceusage.v1beta1.UpdateAdminQuotaPolicyMetadata
	(*DeleteAdminQuotaPolicyMetadata)(nil),        // 33: google.api.serviceusage.v1beta1.DeleteAdminQuotaPolicyMetadata
	(*GenerateServiceIdentityRequest)(nil),        // 34: google.api.serviceusage.v1beta1.GenerateServiceIdentityRequest
	(*GetServiceIdentityResponse)(nil),            // 35: google.api.serviceusage.v1beta1.GetServiceIdentityResponse
	(*GetServiceIdentityMetadata)(nil),            // 36: google.api.serviceusage.v1beta1.GetServiceIdentityMetadata
	(*Service)(nil),                               // 37: google.api.serviceusage.v1beta1.Service
	(QuotaView)(0),                                // 38: google.api.serviceusage.v1beta1.QuotaView
	(*ConsumerQuotaMetric)(nil),                   // 39: google.api.serviceusage.v1beta1.ConsumerQuotaMetric
	(*QuotaOverride)(nil),                         // 40: google.api.serviceusage.v1beta1.QuotaOverride
	(QuotaSafetyCheck)(0),                         // 41: google.api.serviceusage.v1beta1.QuotaSafetyCheck
	(*fieldmaskpb.FieldMask)(nil),                 // 42: google.protobuf.FieldMask
	(*OverrideInlineSource)(nil),                  // 43: google.api.serviceusage.v1beta1.OverrideInlineSource
	(*AdminQuotaPolicy)(nil),                      // 44: google.api.serviceusage.v1beta1.AdminQuotaPolicy
	(*ServiceIdentity)(nil),                       // 45: google.api.serviceusage.v1beta1.ServiceIdentity
	(*longrunning.Operation)(nil),                 // 46: google.longrunning.Operation
	(*ConsumerQuotaLimit)(nil),                    // 47: google.api.serviceusage.v1beta1.ConsumerQuotaLimit
}
var file_google_api_serviceusage_v1beta1_serviceusage_proto_depIdxs = []int32{
	37, // 0: google.api.serviceusage.v1beta1.ListServicesResponse.services:type_name -> google.api.serviceusage.v1beta1.Service
	38, // 1: google.api.serviceusage.v1beta1.ListConsumerQuotaMetricsRequest.view:type_name -> google.api.serviceusage.v1beta1.QuotaView
	39, // 2: google.api.serviceusage.v1beta1.ListConsumerQuotaMetricsResponse.metrics:type_name -> google.api.serviceusage.v1beta1.ConsumerQuotaMetric
	38, // 3: google.api.serviceusage.v1beta1.GetConsumerQuotaMetricRequest.view:type_name -> google.api.serviceusage.v1beta1.QuotaView
	38, // 4: google.api.serviceusage.v1beta1.GetConsumerQuotaLimitRequest.view:type_name -> google.api.serviceusage.v1beta1.QuotaView
	40, // 5: google.api.serviceusage.v1beta1.CreateAdminOverrideRequest.override:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	41, // 6: google.api.serviceusage.v1beta1.CreateAdminOverrideRequest.force_only:type_name -> google.api.serviceusage.v1beta1.QuotaSafetyCheck
	40, // 7: google.api.serviceusage.v1beta1.UpdateAdminOverrideRequest.override:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	42, // 8: google.api.serviceusage.v1beta1.UpdateAdminOverrideRequest.update_mask:type_name -> google.protobuf.FieldMask
	41, // 9: google.api.serviceusage.v1beta1.UpdateAdminOverrideRequest.force_only:type_name -> google.api.serviceusage.v1beta1.QuotaSafetyCheck
	41, // 10: google.api.serviceusage.v1beta1.DeleteAdminOverrideRequest.force_only:type_name -> google.api.serviceusage.v1beta1.QuotaSafetyCheck
	40, // 11: google.api.serviceusage.v1beta1.ListAdminOverridesResponse.overrides:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	40, // 12: google.api.serviceusage.v1beta1.BatchCreateAdminOverridesResponse.overrides:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	43, // 13: google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.inline_source:type_name -> google.api.serviceusage.v1beta1.OverrideInlineSource
	41, // 14: google.api.serviceusage.v1beta1.ImportAdminOverridesRequest.force_only:type_name -> google.api.serviceusage.v1beta1.QuotaSafetyCheck
	40, // 15: google.api.serviceusage.v1beta1.ImportAdminOverridesResponse.overrides:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	40, // 16: google.api.serviceusage.v1beta1.CreateConsumerOverrideRequest.override:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	41, // 17: google.api.serviceusage.v1beta1.CreateConsumerOverrideRequest.force_only:type_name -> google.api.serviceusage.v1beta1.QuotaSafetyCheck
	40, // 18: google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.override:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	42, // 19: google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.update_mask:type_name -> google.protobuf.FieldMask
	41, // 20: google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.force_only:type_name -> google.api.serviceusage.v1beta1.QuotaSafetyCheck
	41, // 21: google.api.serviceusage.v1beta1.DeleteConsumerOverrideRequest.force_only:type_name -> google.api.serviceusage.v1beta1.QuotaSafetyCheck
	40, // 22: google.api.serviceusage.v1beta1.ListConsumerOverridesResponse.overrides:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	40, // 23: google.api.serviceusage.v1beta1.BatchCreateConsumerOverridesResponse.overrides:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	43, // 24: google.api.serviceusage.v1beta1.ImportConsumerOverridesRequest.inline_source:type_name -> google.api.serviceusage.v1beta1.OverrideInlineSource
	41, // 25: google.api.serviceusage.v1beta1.ImportConsumerOverridesRequest.force_only:type_name -> google.api.serviceusage.v1beta1.QuotaSafetyCheck
	40, // 26: google.api.serviceusage.v1beta1.ImportConsumerOverridesResponse.overrides:type_name -> google.api.serviceusage.v1beta1.QuotaOverride
	44, // 27: google.api.serviceusage.v1beta1.ImportAdminQuotaPoliciesResponse.policies:type_name -> google.api.serviceusage.v1beta1.AdminQuotaPolicy
	45, // 28: google.api.serviceusage.v1beta1.GetServiceIdentityResponse.identity:type_name -> google.api.serviceusage.v1beta1.ServiceIdentity
	0,  // 29: google.api.serviceusage.v1beta1.GetServiceIdentityResponse.state:type_name -> google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState
	1,  // 30: google.api.serviceusage.v1beta1.ServiceUsage.EnableService:input_type -> google.api.serviceusage.v1beta1.EnableServiceRequest
	2,  // 31: google.api.serviceusage.v1beta1.ServiceUsage.DisableService:input_type -> google.api.serviceusage.v1beta1.DisableServiceRequest
	3,  // 32: google.api.serviceusage.v1beta1.ServiceUsage.GetService:input_type -> google.api.serviceusage.v1beta1.GetServiceRequest
	4,  // 33: google.api.serviceusage.v1beta1.ServiceUsage.ListServices:input_type -> google.api.serviceusage.v1beta1.ListServicesRequest
	6,  // 34: google.api.serviceusage.v1beta1.ServiceUsage.BatchEnableServices:input_type -> google.api.serviceusage.v1beta1.BatchEnableServicesRequest
	7,  // 35: google.api.serviceusage.v1beta1.ServiceUsage.ListConsumerQuotaMetrics:input_type -> google.api.serviceusage.v1beta1.ListConsumerQuotaMetricsRequest
	9,  // 36: google.api.serviceusage.v1beta1.ServiceUsage.GetConsumerQuotaMetric:input_type -> google.api.serviceusage.v1beta1.GetConsumerQuotaMetricRequest
	10, // 37: google.api.serviceusage.v1beta1.ServiceUsage.GetConsumerQuotaLimit:input_type -> google.api.serviceusage.v1beta1.GetConsumerQuotaLimitRequest
	11, // 38: google.api.serviceusage.v1beta1.ServiceUsage.CreateAdminOverride:input_type -> google.api.serviceusage.v1beta1.CreateAdminOverrideRequest
	12, // 39: google.api.serviceusage.v1beta1.ServiceUsage.UpdateAdminOverride:input_type -> google.api.serviceusage.v1beta1.UpdateAdminOverrideRequest
	13, // 40: google.api.serviceusage.v1beta1.ServiceUsage.DeleteAdminOverride:input_type -> google.api.serviceusage.v1beta1.DeleteAdminOverrideRequest
	14, // 41: google.api.serviceusage.v1beta1.ServiceUsage.ListAdminOverrides:input_type -> google.api.serviceusage.v1beta1.ListAdminOverridesRequest
	17, // 42: google.api.serviceusage.v1beta1.ServiceUsage.ImportAdminOverrides:input_type -> google.api.serviceusage.v1beta1.ImportAdminOverridesRequest
	20, // 43: google.api.serviceusage.v1beta1.ServiceUsage.CreateConsumerOverride:input_type -> google.api.serviceusage.v1beta1.CreateConsumerOverrideRequest
	21, // 44: google.api.serviceusage.v1beta1.ServiceUsage.UpdateConsumerOverride:input_type -> google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest
	22, // 45: google.api.serviceusage.v1beta1.ServiceUsage.DeleteConsumerOverride:input_type -> google.api.serviceusage.v1beta1.DeleteConsumerOverrideRequest
	23, // 46: google.api.serviceusage.v1beta1.ServiceUsage.ListConsumerOverrides:input_type -> google.api.serviceusage.v1beta1.ListConsumerOverridesRequest
	26, // 47: google.api.serviceusage.v1beta1.ServiceUsage.ImportConsumerOverrides:input_type -> google.api.serviceusage.v1beta1.ImportConsumerOverridesRequest
	34, // 48: google.api.serviceusage.v1beta1.ServiceUsage.GenerateServiceIdentity:input_type -> google.api.serviceusage.v1beta1.GenerateServiceIdentityRequest
	46, // 49: google.api.serviceusage.v1beta1.ServiceUsage.EnableService:output_type -> google.longrunning.Operation
	46, // 50: google.api.serviceusage.v1beta1.ServiceUsage.DisableService:output_type -> google.longrunning.Operation
	37, // 51: google.api.serviceusage.v1beta1.ServiceUsage.GetService:output_type -> google.api.serviceusage.v1beta1.Service
	5,  // 52: google.api.serviceusage.v1beta1.ServiceUsage.ListServices:output_type -> google.api.serviceusage.v1beta1.ListServicesResponse
	46, // 53: google.api.serviceusage.v1beta1.ServiceUsage.BatchEnableServices:output_type -> google.longrunning.Operation
	8,  // 54: google.api.serviceusage.v1beta1.ServiceUsage.ListConsumerQuotaMetrics:output_type -> google.api.serviceusage.v1beta1.ListConsumerQuotaMetricsResponse
	39, // 55: google.api.serviceusage.v1beta1.ServiceUsage.GetConsumerQuotaMetric:output_type -> google.api.serviceusage.v1beta1.ConsumerQuotaMetric
	47, // 56: google.api.serviceusage.v1beta1.ServiceUsage.GetConsumerQuotaLimit:output_type -> google.api.serviceusage.v1beta1.ConsumerQuotaLimit
	46, // 57: google.api.serviceusage.v1beta1.ServiceUsage.CreateAdminOverride:output_type -> google.longrunning.Operation
	46, // 58: google.api.serviceusage.v1beta1.ServiceUsage.UpdateAdminOverride:output_type -> google.longrunning.Operation
	46, // 59: google.api.serviceusage.v1beta1.ServiceUsage.DeleteAdminOverride:output_type -> google.longrunning.Operation
	15, // 60: google.api.serviceusage.v1beta1.ServiceUsage.ListAdminOverrides:output_type -> google.api.serviceusage.v1beta1.ListAdminOverridesResponse
	46, // 61: google.api.serviceusage.v1beta1.ServiceUsage.ImportAdminOverrides:output_type -> google.longrunning.Operation
	46, // 62: google.api.serviceusage.v1beta1.ServiceUsage.CreateConsumerOverride:output_type -> google.longrunning.Operation
	46, // 63: google.api.serviceusage.v1beta1.ServiceUsage.UpdateConsumerOverride:output_type -> google.longrunning.Operation
	46, // 64: google.api.serviceusage.v1beta1.ServiceUsage.DeleteConsumerOverride:output_type -> google.longrunning.Operation
	24, // 65: google.api.serviceusage.v1beta1.ServiceUsage.ListConsumerOverrides:output_type -> google.api.serviceusage.v1beta1.ListConsumerOverridesResponse
	46, // 66: google.api.serviceusage.v1beta1.ServiceUsage.ImportConsumerOverrides:output_type -> google.longrunning.Operation
	46, // 67: google.api.serviceusage.v1beta1.ServiceUsage.GenerateServiceIdentity:output_type -> google.longrunning.Operation
	49, // [49:68] is the sub-list for method output_type
	30, // [30:49] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_api_serviceusage_v1beta1_serviceusage_proto_init() }
func file_google_api_serviceusage_v1beta1_serviceusage_proto_init() {
	if File_google_api_serviceusage_v1beta1_serviceusage_proto != nil {
		return
	}
	file_google_api_serviceusage_v1beta1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchEnableServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConsumerQuotaMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConsumerQuotaMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConsumerQuotaMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConsumerQuotaLimitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAdminOverrideRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAdminOverrideRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAdminOverrideRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdminOverridesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdminOverridesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateAdminOverridesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAdminOverridesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAdminOverridesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAdminOverridesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConsumerOverrideRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConsumerOverrideRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConsumerOverrideRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConsumerOverridesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConsumerOverridesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateConsumerOverridesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportConsumerOverridesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportConsumerOverridesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportConsumerOverridesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAdminQuotaPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAdminQuotaPoliciesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAdminQuotaPolicyMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAdminQuotaPolicyMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAdminQuotaPolicyMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateServiceIdentityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServiceIdentityResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServiceIdentityMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*ImportAdminOverridesRequest_InlineSource)(nil),
	}
	file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*ImportConsumerOverridesRequest_InlineSource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   36,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_api_serviceusage_v1beta1_serviceusage_proto_goTypes,
		DependencyIndexes: file_google_api_serviceusage_v1beta1_serviceusage_proto_depIdxs,
		EnumInfos:         file_google_api_serviceusage_v1beta1_serviceusage_proto_enumTypes,
		MessageInfos:      file_google_api_serviceusage_v1beta1_serviceusage_proto_msgTypes,
	}.Build()
	File_google_api_serviceusage_v1beta1_serviceusage_proto = out.File
	file_google_api_serviceusage_v1beta1_serviceusage_proto_rawDesc = nil
	file_google_api_serviceusage_v1beta1_serviceusage_proto_goTypes = nil
	file_google_api_serviceusage_v1beta1_serviceusage_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ServiceUsageClient is the client API for ServiceUsage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceUsageClient interface {
	// Deprecated: Do not use.
	// Enables a service so that it can be used with a project.
	//
	// Operation response type: `google.protobuf.Empty`
	EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deprecated: Do not use.
	// Disables a service so that it can no longer be used with a project.
	// This prevents unintended usage that may cause unexpected billing
	// charges or security leaks.
	//
	// It is not valid to call the disable method on a service that is not
	// currently enabled. Callers will receive a `FAILED_PRECONDITION` status if
	// the target service is not currently enabled.
	//
	// Operation response type: `google.protobuf.Empty`
	DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deprecated: Do not use.
	// Returns the service configuration and enabled state for a given service.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Deprecated: Do not use.
	// Lists all services available to the specified project, and the current
	// state of those services with respect to the project. The list includes
	// all public services, all services for which the calling user has the
	// `servicemanagement.services.bind` permission, and all services that have
	// already been enabled on the project. The list can be filtered to
	// only include services in a specific state, for example to only include
	// services enabled on the project.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Deprecated: Do not use.
	// Enables multiple services on a project. The operation is atomic: if
	// enabling any service fails, then the entire batch fails, and no state
	// changes occur.
	//
	// Operation response type: `google.protobuf.Empty`
	BatchEnableServices(ctx context.Context, in *BatchEnableServicesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Retrieves a summary of all quota information visible to the service
	// consumer, organized by service metric. Each metric includes information
	// about all of its defined limits. Each limit includes the limit
	// configuration (quota unit, preciseness, default value), the current
	// effective limit value, and all of the overrides applied to the limit.
	ListConsumerQuotaMetrics(ctx context.Context, in *ListConsumerQuotaMetricsRequest, opts ...grpc.CallOption) (*ListConsumerQuotaMetricsResponse, error)
	// Retrieves a summary of quota information for a specific quota metric
	GetConsumerQuotaMetric(ctx context.Context, in *GetConsumerQuotaMetricRequest, opts ...grpc.CallOption) (*ConsumerQuotaMetric, error)
	// Retrieves a summary of quota information for a specific quota limit.
	GetConsumerQuotaLimit(ctx context.Context, in *GetConsumerQuotaLimitRequest, opts ...grpc.CallOption) (*ConsumerQuotaLimit, error)
	// Creates an admin override.
	// An admin override is applied by an administrator of a parent folder or
	// parent organization of the consumer receiving the override. An admin
	// override is intended to limit the amount of quota the consumer can use out
	// of the total quota pool allocated to all children of the folder or
	// organization.
	CreateAdminOverride(ctx context.Context, in *CreateAdminOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an admin override.
	UpdateAdminOverride(ctx context.Context, in *UpdateAdminOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes an admin override.
	DeleteAdminOverride(ctx context.Context, in *DeleteAdminOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists all admin overrides on this limit.
	ListAdminOverrides(ctx context.Context, in *ListAdminOverridesRequest, opts ...grpc.CallOption) (*ListAdminOverridesResponse, error)
	// Creates or updates multiple admin overrides atomically, all on the
	// same consumer, but on many different metrics or limits.
	// The name field in the quota override message should not be set.
	ImportAdminOverrides(ctx context.Context, in *ImportAdminOverridesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a consumer override.
	// A consumer override is applied to the consumer on its own authority to
	// limit its own quota usage. Consumer overrides cannot be used to grant more
	// quota than would be allowed by admin overrides, producer overrides, or the
	// default limit of the service.
	CreateConsumerOverride(ctx context.Context, in *CreateConsumerOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a consumer override.
	UpdateConsumerOverride(ctx context.Context, in *UpdateConsumerOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a consumer override.
	DeleteConsumerOverride(ctx context.Context, in *DeleteConsumerOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists all consumer overrides on this limit.
	ListConsumerOverrides(ctx context.Context, in *ListConsumerOverridesRequest, opts ...grpc.CallOption) (*ListConsumerOverridesResponse, error)
	// Creates or updates multiple consumer overrides atomically, all on the
	// same consumer, but on many different metrics or limits.
	// The name field in the quota override message should not be set.
	ImportConsumerOverrides(ctx context.Context, in *ImportConsumerOverridesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Generates service identity for service.
	GenerateServiceIdentity(ctx context.Context, in *GenerateServiceIdentityRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type serviceUsageClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceUsageClient(cc grpc.ClientConnInterface) ServiceUsageClient {
	return &serviceUsageClient{cc}
}

// Deprecated: Do not use.
func (c *serviceUsageClient) EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/EnableService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *serviceUsageClient) DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/DisableService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *serviceUsageClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/GetService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *serviceUsageClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/ListServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *serviceUsageClient) BatchEnableServices(ctx context.Context, in *BatchEnableServicesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/BatchEnableServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) ListConsumerQuotaMetrics(ctx context.Context, in *ListConsumerQuotaMetricsRequest, opts ...grpc.CallOption) (*ListConsumerQuotaMetricsResponse, error) {
	out := new(ListConsumerQuotaMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/ListConsumerQuotaMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) GetConsumerQuotaMetric(ctx context.Context, in *GetConsumerQuotaMetricRequest, opts ...grpc.CallOption) (*ConsumerQuotaMetric, error) {
	out := new(ConsumerQuotaMetric)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/GetConsumerQuotaMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) GetConsumerQuotaLimit(ctx context.Context, in *GetConsumerQuotaLimitRequest, opts ...grpc.CallOption) (*ConsumerQuotaLimit, error) {
	out := new(ConsumerQuotaLimit)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/GetConsumerQuotaLimit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) CreateAdminOverride(ctx context.Context, in *CreateAdminOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/CreateAdminOverride", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) UpdateAdminOverride(ctx context.Context, in *UpdateAdminOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/UpdateAdminOverride", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) DeleteAdminOverride(ctx context.Context, in *DeleteAdminOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/DeleteAdminOverride", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) ListAdminOverrides(ctx context.Context, in *ListAdminOverridesRequest, opts ...grpc.CallOption) (*ListAdminOverridesResponse, error) {
	out := new(ListAdminOverridesResponse)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/ListAdminOverrides", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) ImportAdminOverrides(ctx context.Context, in *ImportAdminOverridesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/ImportAdminOverrides", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) CreateConsumerOverride(ctx context.Context, in *CreateConsumerOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/CreateConsumerOverride", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) UpdateConsumerOverride(ctx context.Context, in *UpdateConsumerOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/UpdateConsumerOverride", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) DeleteConsumerOverride(ctx context.Context, in *DeleteConsumerOverrideRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/DeleteConsumerOverride", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) ListConsumerOverrides(ctx context.Context, in *ListConsumerOverridesRequest, opts ...grpc.CallOption) (*ListConsumerOverridesResponse, error) {
	out := new(ListConsumerOverridesResponse)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/ListConsumerOverrides", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) ImportConsumerOverrides(ctx context.Context, in *ImportConsumerOverridesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/ImportConsumerOverrides", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) GenerateServiceIdentity(ctx context.Context, in *GenerateServiceIdentityRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1beta1.ServiceUsage/GenerateServiceIdentity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceUsageServer is the server API for ServiceUsage service.
type ServiceUsageServer interface {
	// Deprecated: Do not use.
	// Enables a service so that it can be used with a project.
	//
	// Operation response type: `google.protobuf.Empty`
	EnableService(context.Context, *EnableServiceRequest) (*longrunning.Operation, error)
	// Deprecated: Do not use.
	// Disables a service so that it can no longer be used with a project.
	// This prevents unintended usage that may cause unexpected billing
	// charges or security leaks.
	//
	// It is not valid to call the disable method on a service that is not
	// currently enabled. Callers will receive a `FAILED_PRECONDITION` status if
	// the target service is not currently enabled.
	//
	// Operation response type: `google.protobuf.Empty`
	DisableService(context.Context, *DisableServiceRequest) (*longrunning.Operation, error)
	// Deprecated: Do not use.
	// Returns the service configuration and enabled state for a given service.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// Deprecated: Do not use.
	// Lists all services available to the specified project, and the current
	// state of those services with respect to the project. The list includes
	// all public services, all services for which the calling user has the
	// `servicemanagement.services.bind` permission, and all services that have
	// already been enabled on the project. The list can be filtered to
	// only include services in a specific state, for example to only include
	// services enabled on the project.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Deprecated: Do not use.
	// Enables multiple services on a project. The operation is atomic: if
	// enabling any service fails, then the entire batch fails, and no state
	// changes occur.
	//
	// Operation response type: `google.protobuf.Empty`
	BatchEnableServices(context.Context, *BatchEnableServicesRequest) (*longrunning.Operation, error)
	// Retrieves a summary of all quota information visible to the service
	// consumer, organized by service metric. Each metric includes information
	// about all of its defined limits. Each limit includes the limit
	// configuration (quota unit, preciseness, default value), the current
	// effective limit value, and all of the overrides applied to the limit.
	ListConsumerQuotaMetrics(context.Context, *ListConsumerQuotaMetricsRequest) (*ListConsumerQuotaMetricsResponse, error)
	// Retrieves a summary of quota information for a specific quota metric
	GetConsumerQuotaMetric(context.Context, *GetConsumerQuotaMetricRequest) (*ConsumerQuotaMetric, error)
	// Retrieves a summary of quota information for a specific quota limit.
	GetConsumerQuotaLimit(context.Context, *GetConsumerQuotaLimitRequest) (*ConsumerQuotaLimit, error)
	// Creates an admin override.
	// An admin override is applied by an administrator of a parent folder or
	// parent organization of the consumer receiving the override. An admin
	// override is intended to limit the amount of quota the consumer can use out
	// of the total quota pool allocated to all children of the folder or
	// organization.
	CreateAdminOverride(context.Context, *CreateAdminOverrideRequest) (*longrunning.Operation, error)
	// Updates an admin override.
	UpdateAdminOverride(context.Context, *UpdateAdminOverrideRequest) (*longrunning.Operation, error)
	// Deletes an admin override.
	DeleteAdminOverride(context.Context, *DeleteAdminOverrideRequest) (*longrunning.Operation, error)
	// Lists all admin overrides on this limit.
	ListAdminOverrides(context.Context, *ListAdminOverridesRequest) (*ListAdminOverridesResponse, error)
	// Creates or updates multiple admin overrides atomically, all on the
	// same consumer, but on many different metrics or limits.
	// The name field in the quota override message should not be set.
	ImportAdminOverrides(context.Context, *ImportAdminOverridesRequest) (*longrunning.Operation, error)
	// Creates a consumer override.
	// A consumer override is applied to the consumer on its own authority to
	// limit its own quota usage. Consumer overrides cannot be used to grant more
	// quota than would be allowed by admin overrides, producer overrides, or the
	// default limit of the service.
	CreateConsumerOverride(context.Context, *CreateConsumerOverrideRequest) (*longrunning.Operation, error)
	// Updates a consumer override.
	UpdateConsumerOverride(context.Context, *UpdateConsumerOverrideRequest) (*longrunning.Operation, error)
	// Deletes a consumer override.
	DeleteConsumerOverride(context.Context, *DeleteConsumerOverrideRequest) (*longrunning.Operation, error)
	// Lists all consumer overrides on this limit.
	ListConsumerOverrides(context.Context, *ListConsumerOverridesRequest) (*ListConsumerOverridesResponse, error)
	// Creates or updates multiple consumer overrides atomically, all on the
	// same consumer, but on many different metrics or limits.
	// The name field in the quota override message should not be set.
	ImportConsumerOverrides(context.Context, *ImportConsumerOverridesRequest) (*longrunning.Operation, error)
	// Generates service identity for service.
	GenerateServiceIdentity(context.Context, *GenerateServiceIdentityRequest) (*longrunning.Operation, error)
}

// UnimplementedServiceUsageServer can be embedded to have forward compatible implementations.
type UnimplementedServiceUsageServer struct {
}

func (*UnimplementedServiceUsageServer) EnableService(context.Context, *EnableServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableService not implemented")
}
func (*UnimplementedServiceUsageServer) DisableService(context.Context, *DisableServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableService not implemented")
}
func (*UnimplementedServiceUsageServer) GetService(context.Context, *GetServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}
func (*UnimplementedServiceUsageServer) ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (*UnimplementedServiceUsageServer) BatchEnableServices(context.Context, *BatchEnableServicesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchEnableServices not implemented")
}
func (*UnimplementedServiceUsageServer) ListConsumerQuotaMetrics(context.Context, *ListConsumerQuotaMetricsRequest) (*ListConsumerQuotaMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConsumerQuotaMetrics not implemented")
}
func (*UnimplementedServiceUsageServer) GetConsumerQuotaMetric(context.Context, *GetConsumerQuotaMetricRequest) (*ConsumerQuotaMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConsumerQuotaMetric not implemented")
}
func (*UnimplementedServiceUsageServer) GetConsumerQuotaLimit(context.Context, *GetConsumerQuotaLimitRequest) (*ConsumerQuotaLimit, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConsumerQuotaLimit not implemented")
}
func (*UnimplementedServiceUsageServer) CreateAdminOverride(context.Context, *CreateAdminOverrideRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAdminOverride not implemented")
}
func (*UnimplementedServiceUsageServer) UpdateAdminOverride(context.Context, *UpdateAdminOverrideRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAdminOverride not implemented")
}
func (*UnimplementedServiceUsageServer) DeleteAdminOverride(context.Context, *DeleteAdminOverrideRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAdminOverride not implemented")
}
func (*UnimplementedServiceUsageServer) ListAdminOverrides(context.Context, *ListAdminOverridesRequest) (*ListAdminOverridesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdminOverrides not implemented")
}
func (*UnimplementedServiceUsageServer) ImportAdminOverrides(context.Context, *ImportAdminOverridesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAdminOverrides not implemented")
}
func (*UnimplementedServiceUsageServer) CreateConsumerOverride(context.Context, *CreateConsumerOverrideRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConsumerOverride not implemented")
}
func (*UnimplementedServiceUsageServer) UpdateConsumerOverride(context.Context, *UpdateConsumerOverrideRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConsumerOverride not implemented")
}
func (*UnimplementedServiceUsageServer) DeleteConsumerOverride(context.Context, *DeleteConsumerOverrideRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConsumerOverride not implemented")
}
func (*UnimplementedServiceUsageServer) ListConsumerOverrides(context.Context, *ListConsumerOverridesRequest) (*ListConsumerOverridesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConsumerOverrides not implemented")
}
func (*UnimplementedServiceUsageServer) ImportConsumerOverrides(context.Context, *ImportConsumerOverridesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportConsumerOverrides not implemented")
}
func (*UnimplementedServiceUsageServer) GenerateServiceIdentity(context.Context, *GenerateServiceIdentityRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateServiceIdentity not implemented")
}

func RegisterServiceUsageServer(s *grpc.Server, srv ServiceUsageServer) {
	s.RegisterService(&_ServiceUsage_serviceDesc, srv)
}

func _ServiceUsage_EnableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).EnableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/EnableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).EnableService(ctx, req.(*EnableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_DisableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).DisableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/DisableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).DisableService(ctx, req.(*DisableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_BatchEnableServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchEnableServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).BatchEnableServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/BatchEnableServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).BatchEnableServices(ctx, req.(*BatchEnableServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_ListConsumerQuotaMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConsumerQuotaMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).ListConsumerQuotaMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/ListConsumerQuotaMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).ListConsumerQuotaMetrics(ctx, req.(*ListConsumerQuotaMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_GetConsumerQuotaMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConsumerQuotaMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).GetConsumerQuotaMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/GetConsumerQuotaMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).GetConsumerQuotaMetric(ctx, req.(*GetConsumerQuotaMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_GetConsumerQuotaLimit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConsumerQuotaLimitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).GetConsumerQuotaLimit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/GetConsumerQuotaLimit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).GetConsumerQuotaLimit(ctx, req.(*GetConsumerQuotaLimitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_CreateAdminOverride_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAdminOverrideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).CreateAdminOverride(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/CreateAdminOverride",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).CreateAdminOverride(ctx, req.(*CreateAdminOverrideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_UpdateAdminOverride_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAdminOverrideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).UpdateAdminOverride(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/UpdateAdminOverride",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).UpdateAdminOverride(ctx, req.(*UpdateAdminOverrideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_DeleteAdminOverride_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAdminOverrideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).DeleteAdminOverride(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/DeleteAdminOverride",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).DeleteAdminOverride(ctx, req.(*DeleteAdminOverrideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_ListAdminOverrides_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAdminOverridesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).ListAdminOverrides(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/ListAdminOverrides",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).ListAdminOverrides(ctx, req.(*ListAdminOverridesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_ImportAdminOverrides_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAdminOverridesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).ImportAdminOverrides(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/ImportAdminOverrides",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).ImportAdminOverrides(ctx, req.(*ImportAdminOverridesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_CreateConsumerOverride_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConsumerOverrideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).CreateConsumerOverride(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/CreateConsumerOverride",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).CreateConsumerOverride(ctx, req.(*CreateConsumerOverrideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_UpdateConsumerOverride_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConsumerOverrideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).UpdateConsumerOverride(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/UpdateConsumerOverride",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).UpdateConsumerOverride(ctx, req.(*UpdateConsumerOverrideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_DeleteConsumerOverride_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConsumerOverrideRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).DeleteConsumerOverride(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/DeleteConsumerOverride",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).DeleteConsumerOverride(ctx, req.(*DeleteConsumerOverrideRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_ListConsumerOverrides_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConsumerOverridesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).ListConsumerOverrides(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/ListConsumerOverrides",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).ListConsumerOverrides(ctx, req.(*ListConsumerOverridesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_ImportConsumerOverrides_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportConsumerOverridesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).ImportConsumerOverrides(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/ImportConsumerOverrides",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).ImportConsumerOverrides(ctx, req.(*ImportConsumerOverridesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_GenerateServiceIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateServiceIdentityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).GenerateServiceIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1beta1.ServiceUsage/GenerateServiceIdentity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).GenerateServiceIdentity(ctx, req.(*GenerateServiceIdentityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceUsage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.serviceusage.v1beta1.ServiceUsage",
	HandlerType: (*ServiceUsageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "EnableService",
			Handler:    _ServiceUsage_EnableService_Handler,
		},
		{
			MethodName: "DisableService",
			Handler:    _ServiceUsage_DisableService_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _ServiceUsage_GetService_Handler,
		},
		{
			MethodName: "ListServices",
			Handler:    _ServiceUsage_ListServices_Handler,
		},
		{
			MethodName: "BatchEnableServices",
			Handler:    _ServiceUsage_BatchEnableServices_Handler,
		},
		{
			MethodName: "ListConsumerQuotaMetrics",
			Handler:    _ServiceUsage_ListConsumerQuotaMetrics_Handler,
		},
		{
			MethodName: "GetConsumerQuotaMetric",
			Handler:    _ServiceUsage_GetConsumerQuotaMetric_Handler,
		},
		{
			MethodName: "GetConsumerQuotaLimit",
			Handler:    _ServiceUsage_GetConsumerQuotaLimit_Handler,
		},
		{
			MethodName: "CreateAdminOverride",
			Handler:    _ServiceUsage_CreateAdminOverride_Handler,
		},
		{
			MethodName: "UpdateAdminOverride",
			Handler:    _ServiceUsage_UpdateAdminOverride_Handler,
		},
		{
			MethodName: "DeleteAdminOverride",
			Handler:    _ServiceUsage_DeleteAdminOverride_Handler,
		},
		{
			MethodName: "ListAdminOverrides",
			Handler:    _ServiceUsage_ListAdminOverrides_Handler,
		},
		{
			MethodName: "ImportAdminOverrides",
			Handler:    _ServiceUsage_ImportAdminOverrides_Handler,
		},
		{
			MethodName: "CreateConsumerOverride",
			Handler:    _ServiceUsage_CreateConsumerOverride_Handler,
		},
		{
			MethodName: "UpdateConsumerOverride",
			Handler:    _ServiceUsage_UpdateConsumerOverride_Handler,
		},
		{
			MethodName: "DeleteConsumerOverride",
			Handler:    _ServiceUsage_DeleteConsumerOverride_Handler,
		},
		{
			MethodName: "ListConsumerOverrides",
			Handler:    _ServiceUsage_ListConsumerOverrides_Handler,
		},
		{
			MethodName: "ImportConsumerOverrides",
			Handler:    _ServiceUsage_ImportConsumerOverrides_Handler,
		},
		{
			MethodName: "GenerateServiceIdentity",
			Handler:    _ServiceUsage_GenerateServiceIdentity_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/serviceusage/v1beta1/serviceusage.proto",
}
