// Code generated by smithy-go-codegen DO NOT EDIT.

package mturk

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/mturk/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The ListQualificationTypes operation returns a list of Qualification types,
// filtered by an optional search term.
func (c *Client) ListQualificationTypes(ctx context.Context, params *ListQualificationTypesInput, optFns ...func(*Options)) (*ListQualificationTypesOutput, error) {
	if params == nil {
		params = &ListQualificationTypesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListQualificationTypes", params, optFns, c.addOperationListQualificationTypesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListQualificationTypesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListQualificationTypesInput struct {

	// Specifies that only Qualification types that a user can request through the
	// Amazon Mechanical Turk web site, such as by taking a Qualification test, are
	// returned as results of the search. Some Qualification types, such as those
	// assigned automatically by the system, cannot be requested directly by users. If
	// false, all Qualification types, including those managed by the system, are
	// considered. Valid values are True | False.
	//
	// This member is required.
	MustBeRequestable *bool

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// Specifies that only Qualification types that the Requester created are
	// returned. If false, the operation returns all Qualification types.
	MustBeOwnedByCaller *bool

	// If the previous response was incomplete (because there is more data to
	// retrieve), Amazon Mechanical Turk returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of results.
	NextToken *string

	// A text query against all of the searchable attributes of Qualification types.
	Query *string

	noSmithyDocumentSerde
}

type ListQualificationTypesOutput struct {

	// If the previous response was incomplete (because there is more data to
	// retrieve), Amazon Mechanical Turk returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of results.
	NextToken *string

	// The number of Qualification types on this page in the filtered results list,
	// equivalent to the number of types this operation returns.
	NumResults *int32

	// The list of QualificationType elements returned by the query.
	QualificationTypes []types.QualificationType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListQualificationTypesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListQualificationTypes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListQualificationTypes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListQualificationTypes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListQualificationTypesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListQualificationTypes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListQualificationTypesAPIClient is a client that implements the
// ListQualificationTypes operation.
type ListQualificationTypesAPIClient interface {
	ListQualificationTypes(context.Context, *ListQualificationTypesInput, ...func(*Options)) (*ListQualificationTypesOutput, error)
}

var _ ListQualificationTypesAPIClient = (*Client)(nil)

// ListQualificationTypesPaginatorOptions is the paginator options for
// ListQualificationTypes
type ListQualificationTypesPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListQualificationTypesPaginator is a paginator for ListQualificationTypes
type ListQualificationTypesPaginator struct {
	options   ListQualificationTypesPaginatorOptions
	client    ListQualificationTypesAPIClient
	params    *ListQualificationTypesInput
	nextToken *string
	firstPage bool
}

// NewListQualificationTypesPaginator returns a new ListQualificationTypesPaginator
func NewListQualificationTypesPaginator(client ListQualificationTypesAPIClient, params *ListQualificationTypesInput, optFns ...func(*ListQualificationTypesPaginatorOptions)) *ListQualificationTypesPaginator {
	if params == nil {
		params = &ListQualificationTypesInput{}
	}

	options := ListQualificationTypesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListQualificationTypesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListQualificationTypesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListQualificationTypes page.
func (p *ListQualificationTypesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListQualificationTypesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListQualificationTypes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListQualificationTypes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListQualificationTypes",
	}
}
