// Package storagetables implements the Azure ARM Storagetables service API version 2019-02-02.
//
//
package storagetables

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultVersion is the default value for version
	DefaultVersion = "2019-02-02"
)

// BaseClient is the base client for Storagetables.
type BaseClient struct {
	autorest.Client
	URL     string
	Version string
}

// New creates an instance of the BaseClient client.
func New(URL string) BaseClient {
	return NewWithoutDefaults(URL, DefaultVersion)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(URL string, version string) BaseClient {
	return BaseClient{
		Client:  autorest.NewClientWithUserAgent(UserAgent()),
		URL:     URL,
		Version: version,
	}
}
