      program     he5_gd_readdimscaleF_32

      implicit    none

      include     'hdfeos5.inc'

      integer     status
      integer     i, j, jj
      integer     he5_gdopen
      integer     he5_gdattach
      integer     he5_gdwrfld
      integer     he5_gdwrattr
      integer     he5_gdwrgattr
      integer     he5_ehwrglatt
      integer     he5_gdwrlattr 
      integer     he5_gddetach
      integer     he5_gdclose
      integer     HE5_GDdscaleattrinfo, HE5_GDreaddscaleattr
      integer     HE5_GDgetdimscale, HE5_GDinqdscaleattrs
      integer     ntype
      integer     gdfid,gdid1
      real*4      datbuf_f(1) 
      integer*4   start(2), stride(2), count(2)
      integer*4   datbuf_i(3)
      real*8      veg1(120),veg2(200), temp1(100),temp2(100)
      real*4      geospecf(4)
      character*10    attr4
      character*100   attr5
      integer*4   nbands
      integer     bands(3)
      integer*4   datbuf_i2(2) 
      
      integer         attr_int(25)
      real*4          attr_flt(25)
      real*8          attr_dbl(25)
      character       attr_char(25)
      integer         dimsize
      integer         bufsize, nattr 
      integer     FAIL
      parameter   (FAIL=-1)
      character*100     attrlist
      character*100     strbufsize
      character*15      attrname(10)
      integer         numtype

!  /*
!   * Open the HDF grid file, "Grid.h5".
!   */

      gdfid = HE5_GDopen("grid.he5", HE5F_ACC_RDWR)
 
!  /*
!   * If the grid file cannot be found, HE5_GDopen will return -1 for the file
!   * handle (gdfid).  We there check that this is not the case before
!   * proceeding with the other routines.
!   * 
!   * The HE5_GDattach routine returns the handle to the existing grid "Grid1",
!   * GDid.  If the grid is not found, HE5_GDattach returns -1 for the handle.
!   */ 

      if (gdfid .ne. FAIL) then
     
         GDid1 = HE5_GDattach(gdfid, "UTMGrid")

!      /* the field Pollution has Time,YDim,XDim dimensions. 
!	 xdim = 120
!	 ydim = 200
!	 Time dim is set to 10
!      */

         if (GDid1 .eq. FAIL) then
            
            write(*,*) 'Error: Cannot attach to grid UTMGrid'
            status = HE5_GDclose(gdfid)
            stop
         endif

         bufsize = HE5_GDgetdimscale(GDid1, "Pollution", "XDim", 
     1        dimsize, numtype, veg1)
         if (bufsize .eq. -1) then
	
            write(*,*) 'Error:Cannot get Dimension Scale size for XDim',
     1           ' dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
            
         else
            
            write(*,*) 'bufsize = ',bufsize
            write(*,*) 'dimsize = ',dimsize
            write(*,*) 'numtype = ',numtype
            
            write(*,*) 'First 10 values are:'
            do i = 1,10
               write(*,*) 'DimscaleValue[',i,'] = ',veg1(i)
            enddo
         endif
         
         nattr = HE5_GDinqdscaleattrs(GDid1, "XDim", attrlist, 
     1        strbufsize)
         if ( nattr .lt. 0 ) then
            
            write(*,*) 'Error: Cannot get Dimension Scale attribute',
     1           ' list for XDim'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         write(*,*) ' '
         write(*,*) 'Dimension scale for XDim Attribute:'

         attrname(1) = 'label'
         attrname(2) = 'unit'
         attrname(3) = 'format'
         attrname(4) = 'MissingValue'
         attrname(5) = 'IntValues'
         do j = 1,5
            attr_char = ''
            count(1)= 0
            count(2)= 0

            status = HE5_GDdscaleattrinfo(GDid1,"XDim", attrname(j), 
     1        ntype, count)
                              
            if( ntype .eq. 0) then
               status = HE5_GDreaddscaleattr(GDid1,"XDim", attrname(j), 
     1              attr_int)
            endif

            if( ntype .eq. 10) then
               status = HE5_GDreaddscaleattr(GDid1,"XDim", attrname(j), 
     1              attr_flt)
            endif
            
            if( ntype .eq. 11) then
               status = HE5_GDreaddscaleattr(GDid1,"XDim", attrname(j), 
     1              attr_dbl)
            endif
            
            if( ntype .eq. 57) then
               status = HE5_GDreaddscaleattr(GDid1,"XDim", attrname(j), 
     1              attr_char)
            endif

            write(*,*) ' '
            write(*,*) 'Status returned by HE5_GDreaddscaleattr() :', 
     1           status
            write(*,*) 'Attribute Name: ',attrname(j)
            write(*,*) 'Number of attribute elements: ', count(1), 
     1           '  ', count(2)

            write(*,*) 'Data type of attribute: ', ntype
            
            if( ntype .eq. 0) then
               do jj = 1,count(1)
                  write(*,*) 'Attrvalue[',jj,']: ', attr_int(jj)
               enddo
            endif
            
            if( ntype .eq. 10) then
               do jj = 1,count(1)
                  write(*,*) 'Attrvalue[',jj,']: ',attr_flt(jj)
               enddo
            endif

            if( ntype .eq. 11) then
               do jj = 1,count(1)
                  write(*,*) 'Attrvalue[',jj,']: ',attr_dbl(jj)
               enddo
            endif

            if( ntype .eq. 57) then
               write(*,*) 'Attrvalue: ', attr_char
            endif
         enddo
      endif

      status = HE5_GDdetach(GDid1)
      
      status = HE5_GDclose(gdfid)
      
      stop
      end

