/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcActorSelect.h"
#include "ifcpp/IFC4/include/IfcDate.h"
#include "ifcpp/IFC4/include/IfcDateTime.h"
#include "ifcpp/IFC4/include/IfcDocumentConfidentialityEnum.h"
#include "ifcpp/IFC4/include/IfcDocumentInformation.h"
#include "ifcpp/IFC4/include/IfcDocumentInformationRelationship.h"
#include "ifcpp/IFC4/include/IfcDocumentReference.h"
#include "ifcpp/IFC4/include/IfcDocumentStatusEnum.h"
#include "ifcpp/IFC4/include/IfcIdentifier.h"
#include "ifcpp/IFC4/include/IfcLabel.h"
#include "ifcpp/IFC4/include/IfcRelAssociatesDocument.h"
#include "ifcpp/IFC4/include/IfcText.h"
#include "ifcpp/IFC4/include/IfcURIReference.h"

// ENTITY IfcDocumentInformation 
IfcDocumentInformation::IfcDocumentInformation( int id ) { m_entity_id = id; }
IfcDocumentInformation::~IfcDocumentInformation() {}
shared_ptr<BuildingObject> IfcDocumentInformation::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcDocumentInformation> copy_self( new IfcDocumentInformation() );
	if( m_Identification ) { copy_self->m_Identification = dynamic_pointer_cast<IfcIdentifier>( m_Identification->getDeepCopy(options) ); }
	if( m_Name ) { copy_self->m_Name = dynamic_pointer_cast<IfcLabel>( m_Name->getDeepCopy(options) ); }
	if( m_Description ) { copy_self->m_Description = dynamic_pointer_cast<IfcText>( m_Description->getDeepCopy(options) ); }
	if( m_Location ) { copy_self->m_Location = dynamic_pointer_cast<IfcURIReference>( m_Location->getDeepCopy(options) ); }
	if( m_Purpose ) { copy_self->m_Purpose = dynamic_pointer_cast<IfcText>( m_Purpose->getDeepCopy(options) ); }
	if( m_IntendedUse ) { copy_self->m_IntendedUse = dynamic_pointer_cast<IfcText>( m_IntendedUse->getDeepCopy(options) ); }
	if( m_Scope ) { copy_self->m_Scope = dynamic_pointer_cast<IfcText>( m_Scope->getDeepCopy(options) ); }
	if( m_Revision ) { copy_self->m_Revision = dynamic_pointer_cast<IfcLabel>( m_Revision->getDeepCopy(options) ); }
	if( m_DocumentOwner ) { copy_self->m_DocumentOwner = dynamic_pointer_cast<IfcActorSelect>( m_DocumentOwner->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_Editors.size(); ++ii )
	{
		auto item_ii = m_Editors[ii];
		if( item_ii )
		{
			copy_self->m_Editors.emplace_back( dynamic_pointer_cast<IfcActorSelect>(item_ii->getDeepCopy(options) ) );
		}
	}
	if( m_CreationTime ) { copy_self->m_CreationTime = dynamic_pointer_cast<IfcDateTime>( m_CreationTime->getDeepCopy(options) ); }
	if( m_LastRevisionTime ) { copy_self->m_LastRevisionTime = dynamic_pointer_cast<IfcDateTime>( m_LastRevisionTime->getDeepCopy(options) ); }
	if( m_ElectronicFormat ) { copy_self->m_ElectronicFormat = dynamic_pointer_cast<IfcIdentifier>( m_ElectronicFormat->getDeepCopy(options) ); }
	if( m_ValidFrom ) { copy_self->m_ValidFrom = dynamic_pointer_cast<IfcDate>( m_ValidFrom->getDeepCopy(options) ); }
	if( m_ValidUntil ) { copy_self->m_ValidUntil = dynamic_pointer_cast<IfcDate>( m_ValidUntil->getDeepCopy(options) ); }
	if( m_Confidentiality ) { copy_self->m_Confidentiality = dynamic_pointer_cast<IfcDocumentConfidentialityEnum>( m_Confidentiality->getDeepCopy(options) ); }
	if( m_Status ) { copy_self->m_Status = dynamic_pointer_cast<IfcDocumentStatusEnum>( m_Status->getDeepCopy(options) ); }
	return copy_self;
}
void IfcDocumentInformation::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCDOCUMENTINFORMATION" << "(";
	if( m_Identification ) { m_Identification->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Name ) { m_Name->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Description ) { m_Description->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Location ) { m_Location->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Purpose ) { m_Purpose->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_IntendedUse ) { m_IntendedUse->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Scope ) { m_Scope->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Revision ) { m_Revision->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_DocumentOwner ) { m_DocumentOwner->getStepParameter( stream, true ); } else { stream << "$" ; }
	stream << ",";
	stream << "(";
	for( size_t ii = 0; ii < m_Editors.size(); ++ii )
	{
		if( ii > 0 )
		{
			stream << ",";
		}
		const shared_ptr<IfcActorSelect>& type_object = m_Editors[ii];
		if( type_object )
		{
			type_object->getStepParameter( stream, true );
		}
		else
		{
			stream << "$";
		}
	}
	stream << ")";
	stream << ",";
	if( m_CreationTime ) { m_CreationTime->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_LastRevisionTime ) { m_LastRevisionTime->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_ElectronicFormat ) { m_ElectronicFormat->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_ValidFrom ) { m_ValidFrom->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_ValidUntil ) { m_ValidUntil->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Confidentiality ) { m_Confidentiality->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Status ) { m_Status->getStepParameter( stream ); } else { stream << "$"; }
	stream << ");";
}
void IfcDocumentInformation::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcDocumentInformation::toString() const { return L"IfcDocumentInformation"; }
void IfcDocumentInformation::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 17 ){ std::stringstream err; err << "Wrong parameter count for entity IfcDocumentInformation, expecting 17, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	m_Identification = IfcIdentifier::createObjectFromSTEP( args[0], map );
	m_Name = IfcLabel::createObjectFromSTEP( args[1], map );
	m_Description = IfcText::createObjectFromSTEP( args[2], map );
	m_Location = IfcURIReference::createObjectFromSTEP( args[3], map );
	m_Purpose = IfcText::createObjectFromSTEP( args[4], map );
	m_IntendedUse = IfcText::createObjectFromSTEP( args[5], map );
	m_Scope = IfcText::createObjectFromSTEP( args[6], map );
	m_Revision = IfcLabel::createObjectFromSTEP( args[7], map );
	m_DocumentOwner = IfcActorSelect::createObjectFromSTEP( args[8], map );
	readSelectList( args[9], m_Editors, map );
	m_CreationTime = IfcDateTime::createObjectFromSTEP( args[10], map );
	m_LastRevisionTime = IfcDateTime::createObjectFromSTEP( args[11], map );
	m_ElectronicFormat = IfcIdentifier::createObjectFromSTEP( args[12], map );
	m_ValidFrom = IfcDate::createObjectFromSTEP( args[13], map );
	m_ValidUntil = IfcDate::createObjectFromSTEP( args[14], map );
	m_Confidentiality = IfcDocumentConfidentialityEnum::createObjectFromSTEP( args[15], map );
	m_Status = IfcDocumentStatusEnum::createObjectFromSTEP( args[16], map );
}
void IfcDocumentInformation::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcExternalInformation::getAttributes( vec_attributes );
	vec_attributes.emplace_back( std::make_pair( "Identification", m_Identification ) );
	vec_attributes.emplace_back( std::make_pair( "Name", m_Name ) );
	vec_attributes.emplace_back( std::make_pair( "Description", m_Description ) );
	vec_attributes.emplace_back( std::make_pair( "Location", m_Location ) );
	vec_attributes.emplace_back( std::make_pair( "Purpose", m_Purpose ) );
	vec_attributes.emplace_back( std::make_pair( "IntendedUse", m_IntendedUse ) );
	vec_attributes.emplace_back( std::make_pair( "Scope", m_Scope ) );
	vec_attributes.emplace_back( std::make_pair( "Revision", m_Revision ) );
	vec_attributes.emplace_back( std::make_pair( "DocumentOwner", m_DocumentOwner ) );
	if( !m_Editors.empty() )
	{
		shared_ptr<AttributeObjectVector> Editors_vec_object( new AttributeObjectVector() );
		std::copy( m_Editors.begin(), m_Editors.end(), std::back_inserter( Editors_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "Editors", Editors_vec_object ) );
	}
	vec_attributes.emplace_back( std::make_pair( "CreationTime", m_CreationTime ) );
	vec_attributes.emplace_back( std::make_pair( "LastRevisionTime", m_LastRevisionTime ) );
	vec_attributes.emplace_back( std::make_pair( "ElectronicFormat", m_ElectronicFormat ) );
	vec_attributes.emplace_back( std::make_pair( "ValidFrom", m_ValidFrom ) );
	vec_attributes.emplace_back( std::make_pair( "ValidUntil", m_ValidUntil ) );
	vec_attributes.emplace_back( std::make_pair( "Confidentiality", m_Confidentiality ) );
	vec_attributes.emplace_back( std::make_pair( "Status", m_Status ) );
}
void IfcDocumentInformation::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcExternalInformation::getAttributesInverse( vec_attributes_inverse );
	if( !m_DocumentInfoForObjects_inverse.empty() )
	{
		shared_ptr<AttributeObjectVector> DocumentInfoForObjects_inverse_vec_obj( new AttributeObjectVector() );
		for( size_t i=0; i<m_DocumentInfoForObjects_inverse.size(); ++i )
		{
			if( !m_DocumentInfoForObjects_inverse[i].expired() )
			{
				DocumentInfoForObjects_inverse_vec_obj->m_vec.emplace_back( shared_ptr<IfcRelAssociatesDocument>( m_DocumentInfoForObjects_inverse[i] ) );
			}
		}
		vec_attributes_inverse.emplace_back( std::make_pair( "DocumentInfoForObjects_inverse", DocumentInfoForObjects_inverse_vec_obj ) );
	}
	if( !m_HasDocumentReferences_inverse.empty() )
	{
		shared_ptr<AttributeObjectVector> HasDocumentReferences_inverse_vec_obj( new AttributeObjectVector() );
		for( size_t i=0; i<m_HasDocumentReferences_inverse.size(); ++i )
		{
			if( !m_HasDocumentReferences_inverse[i].expired() )
			{
				HasDocumentReferences_inverse_vec_obj->m_vec.emplace_back( shared_ptr<IfcDocumentReference>( m_HasDocumentReferences_inverse[i] ) );
			}
		}
		vec_attributes_inverse.emplace_back( std::make_pair( "HasDocumentReferences_inverse", HasDocumentReferences_inverse_vec_obj ) );
	}
	if( !m_IsPointedTo_inverse.empty() )
	{
		shared_ptr<AttributeObjectVector> IsPointedTo_inverse_vec_obj( new AttributeObjectVector() );
		for( size_t i=0; i<m_IsPointedTo_inverse.size(); ++i )
		{
			if( !m_IsPointedTo_inverse[i].expired() )
			{
				IsPointedTo_inverse_vec_obj->m_vec.emplace_back( shared_ptr<IfcDocumentInformationRelationship>( m_IsPointedTo_inverse[i] ) );
			}
		}
		vec_attributes_inverse.emplace_back( std::make_pair( "IsPointedTo_inverse", IsPointedTo_inverse_vec_obj ) );
	}
	if( !m_IsPointer_inverse.empty() )
	{
		shared_ptr<AttributeObjectVector> IsPointer_inverse_vec_obj( new AttributeObjectVector() );
		for( size_t i=0; i<m_IsPointer_inverse.size(); ++i )
		{
			if( !m_IsPointer_inverse[i].expired() )
			{
				IsPointer_inverse_vec_obj->m_vec.emplace_back( shared_ptr<IfcDocumentInformationRelationship>( m_IsPointer_inverse[i] ) );
			}
		}
		vec_attributes_inverse.emplace_back( std::make_pair( "IsPointer_inverse", IsPointer_inverse_vec_obj ) );
	}
}
void IfcDocumentInformation::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcExternalInformation::setInverseCounterparts( ptr_self_entity );
}
void IfcDocumentInformation::unlinkFromInverseCounterparts()
{
	IfcExternalInformation::unlinkFromInverseCounterparts();
}
