#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:vincent.vole@example.com"
SENDER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

mkdir -p "$PREFS/$SENDER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'always' > "$PREFS/$SENDER/event_refreshing"

# Test event request registration in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out1f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the recipient.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   ! grep -q 'METHOD:REPLY' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2f.tmp

   ! grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out2fo.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out2fo.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test acceptance and registration in the outgoing handler.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event8@example.com" 2>> $ERROR \
| tee out3.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$SHOWMAIL" < out3.tmp | grep -q 'METHOD:REPLY' \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out3f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the result to the recipient.

  "$PERSON_SCRIPT" $ARGS < out3.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER" \
>  out4fo.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out4fo.tmp" \
&& echo "Success" \
|| echo "Failed"

# Attempt to add an occurrence to the event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-add-person-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out4f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out4f.tmp" \
&& grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out4f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the recipient.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-add-person-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REFRESH' out5.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out5f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out5f.tmp" \
&& ! grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out5f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out5fo.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out5fo.tmp" \
&& ! grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out5fo.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the refresh message to the organiser.

  "$PERSON_SCRIPT" $ARGS < out5.tmp 2>> $ERROR \
| tee out6r.tmp \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REQUEST' out6.tmp \
&& echo "Success" \
|| echo "Failed"

# Present the request to the recipient.

  "$PERSON_SCRIPT" $ARGS < out6r.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out7.tmp

   ! grep -q 'METHOD:REPLY' out7.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out7f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out7f.tmp" \
&& ! grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out7f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out7fo.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out7fo.tmp" \
&& grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out7fo.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test acceptance and registration in the outgoing handler.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event8@example.com" 2>> $ERROR \
| tee out8.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$SHOWMAIL" < out8.tmp | grep -q 'METHOD:REPLY' \
&& echo "Success" \
|| echo "Failed"

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event8@example.com" "20150109T090000Z" 2>> $ERROR \
| tee out9.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$SHOWMAIL" < out9.tmp | grep -q 'METHOD:REPLY' \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out9f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out9f.tmp" \
&& grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out9f.tmp" \
&& echo "Success" \
|| echo "Failed"
