This module adds and/or deletes entries from IP sets which can be defined
by ipset(8).
.TP
\fB\-\-add\-set\fP \fIsetname\fP \fIflag\fP[\fB,\fP\fIflag\fP...]
add the address(es)/port(s) of the packet to the set
.TP
\fB\-\-del\-set\fP \fIsetname\fP \fIflag\fP[\fB,\fP\fIflag\fP...]
delete the address(es)/port(s) of the packet from the set
.TP
\fB\-\-map\-set\fP \fIsetname\fP \fIflag\fP[\fB,\fP\fIflag\fP...] 
[\-\-map\-mark] [\-\-map\-prio] [\-\-map\-queue]
map packet properties (firewall mark, tc priority, hardware queue)
.IP
where \fIflag\fP(s) are
.BR "src"
and/or
.BR "dst"
specifications and there can be no more than six of them.
.TP
\fB\-\-timeout\fP \fIvalue\fP
when adding an entry, the timeout value to use instead of the default
one from the set definition
.TP
\fB\-\-exist\fP
when adding an entry if it already exists, reset the timeout value
to the specified one or to the default from the set definition
.TP
\fB\-\-map\-set\fP \fIset-name\fP
the set-name should be created with \-\-skbinfo option
\fB\-\-map\-mark\fP
map firewall mark to packet by lookup of value in the set
\fB\-\-map\-prio\fP
map traffic control priority to packet by lookup of value in the set
\fB\-\-map\-queue\fP
map hardware NIC queue to packet by lookup of value in the set
.IP
The
\fB\-\-map\-set\fP
option can be used from the mangle table only. The
\fB\-\-map\-prio\fP
and
\fB\-\-map\-queue\fP
flags can be used in the OUTPUT, FORWARD and POSTROUTING chains.
.PP
Use of \-j SET requires that ipset kernel support is provided, which, for
standard kernels, is the case since Linux 2.6.39.
