
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDir.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QDir>
#include <QFileInfo>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDir

//  Constructor QDir::QDir(const QDir &)


static void _init_ctor_QDir_1681 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return_new<QDir> ();
}

static void _call_ctor_QDir_1681 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDir &arg1 = gsi::arg_reader<const QDir & >() (args, heap);
  ret.write<QDir *> (new QDir (arg1));
}


//  Constructor QDir::QDir(const QString &path)


static void _init_ctor_QDir_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QDir> ();
}

static void _call_ctor_QDir_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QDir *> (new QDir (arg1));
}


//  Constructor QDir::QDir(const QString &path, const QString &nameFilter, QFlags<QDir::SortFlag> sort, QFlags<QDir::Filter> filter)


static void _init_ctor_QDir_8374 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("nameFilter");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sort", true, "QDir::SortFlags(QDir::Name | QDir::IgnoreCase)");
  decl->add_arg<QFlags<QDir::SortFlag> > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QDir::AllEntries");
  decl->add_arg<QFlags<QDir::Filter> > (argspec_3);
  decl->set_return_new<QDir> ();
}

static void _call_ctor_QDir_8374 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QDir::SortFlag> arg3 = args ? gsi::arg_reader<QFlags<QDir::SortFlag> >() (args, heap) : gsi::arg_maker<QFlags<QDir::SortFlag> >() (QDir::SortFlags(QDir::Name | QDir::IgnoreCase), heap);
  QFlags<QDir::Filter> arg4 = args ? gsi::arg_reader<QFlags<QDir::Filter> >() (args, heap) : gsi::arg_maker<QFlags<QDir::Filter> >() (QDir::AllEntries, heap);
  ret.write<QDir *> (new QDir (arg1, arg2, arg3, arg4));
}


// QString QDir::absoluteFilePath(const QString &fileName)


static void _init_f_absoluteFilePath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_absoluteFilePath_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QDir *)cls)->absoluteFilePath (arg1));
}


// QString QDir::absolutePath()


static void _init_f_absolutePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_absolutePath_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDir *)cls)->absolutePath ());
}


// QString QDir::canonicalPath()


static void _init_f_canonicalPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_canonicalPath_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDir *)cls)->canonicalPath ());
}


// bool QDir::cd(const QString &dirName)


static void _init_f_cd_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_cd_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->cd (arg1));
}


// bool QDir::cdUp()


static void _init_f_cdUp_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_cdUp_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDir *)cls)->cdUp ());
}


// unsigned int QDir::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QDir *)cls)->count ());
}


// QString QDir::dirName()


static void _init_f_dirName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_dirName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDir *)cls)->dirName ());
}


// QList<QFileInfo> QDir::entryInfoList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)


static void _init_f_entryInfoList_c4540 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters", true, "QDir::NoFilter");
  decl->add_arg<QFlags<QDir::Filter> > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sort", true, "QDir::NoSort");
  decl->add_arg<QFlags<QDir::SortFlag> > (argspec_1);
  decl->set_return<QList<QFileInfo> > ();
}

static void _call_f_entryInfoList_c4540 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QDir::Filter> arg1 = args ? gsi::arg_reader<QFlags<QDir::Filter> >() (args, heap) : gsi::arg_maker<QFlags<QDir::Filter> >() (QDir::NoFilter, heap);
  QFlags<QDir::SortFlag> arg2 = args ? gsi::arg_reader<QFlags<QDir::SortFlag> >() (args, heap) : gsi::arg_maker<QFlags<QDir::SortFlag> >() (QDir::NoSort, heap);
  ret.write<QList<QFileInfo> > ((QList<QFileInfo>)((QDir *)cls)->entryInfoList (arg1, arg2));
}


// QList<QFileInfo> QDir::entryInfoList(const QStringList &nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)


static void _init_f_entryInfoList_c6869 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameFilters");
  decl->add_arg<const QStringList & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filters", true, "QDir::NoFilter");
  decl->add_arg<QFlags<QDir::Filter> > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sort", true, "QDir::NoSort");
  decl->add_arg<QFlags<QDir::SortFlag> > (argspec_2);
  decl->set_return<QList<QFileInfo> > ();
}

static void _call_f_entryInfoList_c6869 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  QFlags<QDir::Filter> arg2 = args ? gsi::arg_reader<QFlags<QDir::Filter> >() (args, heap) : gsi::arg_maker<QFlags<QDir::Filter> >() (QDir::NoFilter, heap);
  QFlags<QDir::SortFlag> arg3 = args ? gsi::arg_reader<QFlags<QDir::SortFlag> >() (args, heap) : gsi::arg_maker<QFlags<QDir::SortFlag> >() (QDir::NoSort, heap);
  ret.write<QList<QFileInfo> > ((QList<QFileInfo>)((QDir *)cls)->entryInfoList (arg1, arg2, arg3));
}


// QStringList QDir::entryList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)


static void _init_f_entryList_c4540 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters", true, "QDir::NoFilter");
  decl->add_arg<QFlags<QDir::Filter> > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sort", true, "QDir::NoSort");
  decl->add_arg<QFlags<QDir::SortFlag> > (argspec_1);
  decl->set_return<QStringList > ();
}

static void _call_f_entryList_c4540 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QDir::Filter> arg1 = args ? gsi::arg_reader<QFlags<QDir::Filter> >() (args, heap) : gsi::arg_maker<QFlags<QDir::Filter> >() (QDir::NoFilter, heap);
  QFlags<QDir::SortFlag> arg2 = args ? gsi::arg_reader<QFlags<QDir::SortFlag> >() (args, heap) : gsi::arg_maker<QFlags<QDir::SortFlag> >() (QDir::NoSort, heap);
  ret.write<QStringList > ((QStringList)((QDir *)cls)->entryList (arg1, arg2));
}


// QStringList QDir::entryList(const QStringList &nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)


static void _init_f_entryList_c6869 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameFilters");
  decl->add_arg<const QStringList & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filters", true, "QDir::NoFilter");
  decl->add_arg<QFlags<QDir::Filter> > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sort", true, "QDir::NoSort");
  decl->add_arg<QFlags<QDir::SortFlag> > (argspec_2);
  decl->set_return<QStringList > ();
}

static void _call_f_entryList_c6869 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  QFlags<QDir::Filter> arg2 = args ? gsi::arg_reader<QFlags<QDir::Filter> >() (args, heap) : gsi::arg_maker<QFlags<QDir::Filter> >() (QDir::NoFilter, heap);
  QFlags<QDir::SortFlag> arg3 = args ? gsi::arg_reader<QFlags<QDir::SortFlag> >() (args, heap) : gsi::arg_maker<QFlags<QDir::SortFlag> >() (QDir::NoSort, heap);
  ret.write<QStringList > ((QStringList)((QDir *)cls)->entryList (arg1, arg2, arg3));
}


// bool QDir::exists()


static void _init_f_exists_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_exists_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDir *)cls)->exists ());
}


// bool QDir::exists(const QString &name)


static void _init_f_exists_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_exists_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->exists (arg1));
}


// QString QDir::filePath(const QString &fileName)


static void _init_f_filePath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_filePath_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QDir *)cls)->filePath (arg1));
}


// QFlags<QDir::Filter> QDir::filter()


static void _init_f_filter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QDir::Filter> > ();
}

static void _call_f_filter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QDir::Filter> > ((QFlags<QDir::Filter>)((QDir *)cls)->filter ());
}


// bool QDir::isAbsolute()


static void _init_f_isAbsolute_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAbsolute_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDir *)cls)->isAbsolute ());
}


// bool QDir::isReadable()


static void _init_f_isReadable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDir *)cls)->isReadable ());
}


// bool QDir::isRelative()


static void _init_f_isRelative_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRelative_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDir *)cls)->isRelative ());
}


// bool QDir::isRoot()


static void _init_f_isRoot_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRoot_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDir *)cls)->isRoot ());
}


// bool QDir::makeAbsolute()


static void _init_f_makeAbsolute_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_makeAbsolute_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDir *)cls)->makeAbsolute ());
}


// bool QDir::mkdir(const QString &dirName)


static void _init_f_mkdir_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_mkdir_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->mkdir (arg1));
}


// bool QDir::mkpath(const QString &dirPath)


static void _init_f_mkpath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirPath");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_mkpath_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->mkpath (arg1));
}


// QStringList QDir::nameFilters()


static void _init_f_nameFilters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_nameFilters_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QDir *)cls)->nameFilters ());
}


// bool QDir::operator!=(const QDir &dir)


static void _init_f_operator_excl__eq__c1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDir &arg1 = gsi::arg_reader<const QDir & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->operator!= (arg1));
}


// QDir &QDir::operator=(const QDir &)


static void _init_f_operator_eq__1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<QDir & > ();
}

static void _call_f_operator_eq__1681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDir &arg1 = gsi::arg_reader<const QDir & >() (args, heap);
  ret.write<QDir & > ((QDir &)((QDir *)cls)->operator= (arg1));
}


// QDir &QDir::operator=(const QString &path)


static void _init_f_operator_eq__2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDir & > ();
}

static void _call_f_operator_eq__2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QDir & > ((QDir &)((QDir *)cls)->operator= (arg1));
}


// bool QDir::operator==(const QDir &dir)


static void _init_f_operator_eq__eq__c1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDir &arg1 = gsi::arg_reader<const QDir & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->operator== (arg1));
}


// QString QDir::operator[](int)


static void _init_f_operator_index__c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_operator_index__c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QDir *)cls)->operator[] (arg1));
}


// QString QDir::path()


static void _init_f_path_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_path_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDir *)cls)->path ());
}


// void QDir::refresh()


static void _init_f_refresh_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_refresh_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDir *)cls)->refresh ();
}


// QString QDir::relativeFilePath(const QString &fileName)


static void _init_f_relativeFilePath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_relativeFilePath_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QDir *)cls)->relativeFilePath (arg1));
}


// bool QDir::remove(const QString &fileName)


static void _init_f_remove_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_remove_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->remove (arg1));
}


// bool QDir::removeRecursively()


static void _init_f_removeRecursively_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_removeRecursively_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDir *)cls)->removeRecursively ());
}


// bool QDir::rename(const QString &oldName, const QString &newName)


static void _init_f_rename_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_rename_3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->rename (arg1, arg2));
}


// bool QDir::rmdir(const QString &dirName)


static void _init_f_rmdir_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_rmdir_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->rmdir (arg1));
}


// bool QDir::rmpath(const QString &dirPath)


static void _init_f_rmpath_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dirPath");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_rmpath_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDir *)cls)->rmpath (arg1));
}


// void QDir::setFilter(QFlags<QDir::Filter> filter)


static void _init_f_setFilter_2230 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<QFlags<QDir::Filter> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2230 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QDir::Filter> arg1 = gsi::arg_reader<QFlags<QDir::Filter> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDir *)cls)->setFilter (arg1);
}


// void QDir::setNameFilters(const QStringList &nameFilters)


static void _init_f_setNameFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameFilters");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilters_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDir *)cls)->setNameFilters (arg1);
}


// void QDir::setPath(const QString &path)


static void _init_f_setPath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPath_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDir *)cls)->setPath (arg1);
}


// void QDir::setSorting(QFlags<QDir::SortFlag> sort)


static void _init_f_setSorting_2418 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sort");
  decl->add_arg<QFlags<QDir::SortFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSorting_2418 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QDir::SortFlag> arg1 = gsi::arg_reader<QFlags<QDir::SortFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDir *)cls)->setSorting (arg1);
}


// QFlags<QDir::SortFlag> QDir::sorting()


static void _init_f_sorting_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QDir::SortFlag> > ();
}

static void _call_f_sorting_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QDir::SortFlag> > ((QFlags<QDir::SortFlag>)((QDir *)cls)->sorting ());
}


// void QDir::swap(QDir &other)


static void _init_f_swap_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QDir & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDir &arg1 = gsi::arg_reader<QDir & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDir *)cls)->swap (arg1);
}


// static void QDir::addResourceSearchPath(const QString &path)


static void _init_f_addResourceSearchPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addResourceSearchPath_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QDir::addResourceSearchPath (arg1);
}


// static void QDir::addSearchPath(const QString &prefix, const QString &path)


static void _init_f_addSearchPath_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("path");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addSearchPath_3942 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QDir::addSearchPath (arg1, arg2);
}


// static QString QDir::cleanPath(const QString &path)


static void _init_f_cleanPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_cleanPath_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)QDir::cleanPath (arg1));
}


// static QDir QDir::current()


static void _init_f_current_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_current_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDir > ((QDir)QDir::current ());
}


// static QString QDir::currentPath()


static void _init_f_currentPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_currentPath_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QDir::currentPath ());
}


// static QList<QFileInfo> QDir::drives()


static void _init_f_drives_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QFileInfo> > ();
}

static void _call_f_drives_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QFileInfo> > ((QList<QFileInfo>)QDir::drives ());
}


// static QString QDir::fromNativeSeparators(const QString &pathName)


static void _init_f_fromNativeSeparators_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pathName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromNativeSeparators_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)QDir::fromNativeSeparators (arg1));
}


// static QDir QDir::home()


static void _init_f_home_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_home_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDir > ((QDir)QDir::home ());
}


// static QString QDir::homePath()


static void _init_f_homePath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_homePath_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QDir::homePath ());
}


// static bool QDir::isAbsolutePath(const QString &path)


static void _init_f_isAbsolutePath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isAbsolutePath_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)QDir::isAbsolutePath (arg1));
}


// static bool QDir::isRelativePath(const QString &path)


static void _init_f_isRelativePath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isRelativePath_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)QDir::isRelativePath (arg1));
}


// static bool QDir::match(const QStringList &filters, const QString &fileName)


static void _init_f_match_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const QStringList & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_match_4354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)QDir::match (arg1, arg2));
}


// static bool QDir::match(const QString &filter, const QString &fileName)


static void _init_f_match_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_match_3942 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)QDir::match (arg1, arg2));
}


// static QStringList QDir::nameFiltersFromString(const QString &nameFilter)


static void _init_f_nameFiltersFromString_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameFilter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_f_nameFiltersFromString_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QStringList > ((QStringList)QDir::nameFiltersFromString (arg1));
}


// static QDir QDir::root()


static void _init_f_root_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_root_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDir > ((QDir)QDir::root ());
}


// static QString QDir::rootPath()


static void _init_f_rootPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_rootPath_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QDir::rootPath ());
}


// static QStringList QDir::searchPaths(const QString &prefix)


static void _init_f_searchPaths_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_f_searchPaths_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QStringList > ((QStringList)QDir::searchPaths (arg1));
}


// static QChar QDir::separator()


static void _init_f_separator_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_separator_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(QDir::separator ()));
}


// static bool QDir::setCurrent(const QString &path)


static void _init_f_setCurrent_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setCurrent_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)QDir::setCurrent (arg1));
}


// static void QDir::setSearchPaths(const QString &prefix, const QStringList &searchPaths)


static void _init_f_setSearchPaths_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("searchPaths");
  decl->add_arg<const QStringList & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSearchPaths_4354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QDir::setSearchPaths (arg1, arg2);
}


// static QDir QDir::temp()


static void _init_f_temp_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_temp_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDir > ((QDir)QDir::temp ());
}


// static QString QDir::tempPath()


static void _init_f_tempPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_tempPath_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QDir::tempPath ());
}


// static QString QDir::toNativeSeparators(const QString &pathName)


static void _init_f_toNativeSeparators_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pathName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toNativeSeparators_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)QDir::toNativeSeparators (arg1));
}



namespace gsi
{

static gsi::Methods methods_QDir () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDir::QDir(const QDir &)\nThis method creates an object of class QDir.", &_init_ctor_QDir_1681, &_call_ctor_QDir_1681);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDir::QDir(const QString &path)\nThis method creates an object of class QDir.", &_init_ctor_QDir_2025, &_call_ctor_QDir_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDir::QDir(const QString &path, const QString &nameFilter, QFlags<QDir::SortFlag> sort, QFlags<QDir::Filter> filter)\nThis method creates an object of class QDir.", &_init_ctor_QDir_8374, &_call_ctor_QDir_8374);
  methods += new qt_gsi::GenericMethod ("absoluteFilePath", "@brief Method QString QDir::absoluteFilePath(const QString &fileName)\n", true, &_init_f_absoluteFilePath_c2025, &_call_f_absoluteFilePath_c2025);
  methods += new qt_gsi::GenericMethod ("absolutePath", "@brief Method QString QDir::absolutePath()\n", true, &_init_f_absolutePath_c0, &_call_f_absolutePath_c0);
  methods += new qt_gsi::GenericMethod ("canonicalPath", "@brief Method QString QDir::canonicalPath()\n", true, &_init_f_canonicalPath_c0, &_call_f_canonicalPath_c0);
  methods += new qt_gsi::GenericMethod ("cd", "@brief Method bool QDir::cd(const QString &dirName)\n", false, &_init_f_cd_2025, &_call_f_cd_2025);
  methods += new qt_gsi::GenericMethod ("cdUp", "@brief Method bool QDir::cdUp()\n", false, &_init_f_cdUp_0, &_call_f_cdUp_0);
  methods += new qt_gsi::GenericMethod ("count", "@brief Method unsigned int QDir::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod ("dirName", "@brief Method QString QDir::dirName()\n", true, &_init_f_dirName_c0, &_call_f_dirName_c0);
  methods += new qt_gsi::GenericMethod ("entryInfoList", "@brief Method QList<QFileInfo> QDir::entryInfoList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)\n", true, &_init_f_entryInfoList_c4540, &_call_f_entryInfoList_c4540);
  methods += new qt_gsi::GenericMethod ("entryInfoList", "@brief Method QList<QFileInfo> QDir::entryInfoList(const QStringList &nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)\n", true, &_init_f_entryInfoList_c6869, &_call_f_entryInfoList_c6869);
  methods += new qt_gsi::GenericMethod ("entryList", "@brief Method QStringList QDir::entryList(QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)\n", true, &_init_f_entryList_c4540, &_call_f_entryList_c4540);
  methods += new qt_gsi::GenericMethod ("entryList", "@brief Method QStringList QDir::entryList(const QStringList &nameFilters, QFlags<QDir::Filter> filters, QFlags<QDir::SortFlag> sort)\n", true, &_init_f_entryList_c6869, &_call_f_entryList_c6869);
  methods += new qt_gsi::GenericMethod ("exists", "@brief Method bool QDir::exists()\n", true, &_init_f_exists_c0, &_call_f_exists_c0);
  methods += new qt_gsi::GenericMethod ("exists", "@brief Method bool QDir::exists(const QString &name)\n", true, &_init_f_exists_c2025, &_call_f_exists_c2025);
  methods += new qt_gsi::GenericMethod ("filePath", "@brief Method QString QDir::filePath(const QString &fileName)\n", true, &_init_f_filePath_c2025, &_call_f_filePath_c2025);
  methods += new qt_gsi::GenericMethod (":filter", "@brief Method QFlags<QDir::Filter> QDir::filter()\n", true, &_init_f_filter_c0, &_call_f_filter_c0);
  methods += new qt_gsi::GenericMethod ("isAbsolute?", "@brief Method bool QDir::isAbsolute()\n", true, &_init_f_isAbsolute_c0, &_call_f_isAbsolute_c0);
  methods += new qt_gsi::GenericMethod ("isReadable?", "@brief Method bool QDir::isReadable()\n", true, &_init_f_isReadable_c0, &_call_f_isReadable_c0);
  methods += new qt_gsi::GenericMethod ("isRelative?", "@brief Method bool QDir::isRelative()\n", true, &_init_f_isRelative_c0, &_call_f_isRelative_c0);
  methods += new qt_gsi::GenericMethod ("isRoot?", "@brief Method bool QDir::isRoot()\n", true, &_init_f_isRoot_c0, &_call_f_isRoot_c0);
  methods += new qt_gsi::GenericMethod ("makeAbsolute", "@brief Method bool QDir::makeAbsolute()\n", false, &_init_f_makeAbsolute_0, &_call_f_makeAbsolute_0);
  methods += new qt_gsi::GenericMethod ("mkdir", "@brief Method bool QDir::mkdir(const QString &dirName)\n", true, &_init_f_mkdir_c2025, &_call_f_mkdir_c2025);
  methods += new qt_gsi::GenericMethod ("mkpath", "@brief Method bool QDir::mkpath(const QString &dirPath)\n", true, &_init_f_mkpath_c2025, &_call_f_mkpath_c2025);
  methods += new qt_gsi::GenericMethod (":nameFilters", "@brief Method QStringList QDir::nameFilters()\n", true, &_init_f_nameFilters_c0, &_call_f_nameFilters_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QDir::operator!=(const QDir &dir)\n", true, &_init_f_operator_excl__eq__c1681, &_call_f_operator_excl__eq__c1681);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QDir &QDir::operator=(const QDir &)\n", false, &_init_f_operator_eq__1681, &_call_f_operator_eq__1681);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QDir &QDir::operator=(const QString &path)\n", false, &_init_f_operator_eq__2025, &_call_f_operator_eq__2025);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QDir::operator==(const QDir &dir)\n", true, &_init_f_operator_eq__eq__c1681, &_call_f_operator_eq__eq__c1681);
  methods += new qt_gsi::GenericMethod ("[]", "@brief Method QString QDir::operator[](int)\n", true, &_init_f_operator_index__c767, &_call_f_operator_index__c767);
  methods += new qt_gsi::GenericMethod (":path", "@brief Method QString QDir::path()\n", true, &_init_f_path_c0, &_call_f_path_c0);
  methods += new qt_gsi::GenericMethod ("refresh", "@brief Method void QDir::refresh()\n", true, &_init_f_refresh_c0, &_call_f_refresh_c0);
  methods += new qt_gsi::GenericMethod ("relativeFilePath", "@brief Method QString QDir::relativeFilePath(const QString &fileName)\n", true, &_init_f_relativeFilePath_c2025, &_call_f_relativeFilePath_c2025);
  methods += new qt_gsi::GenericMethod ("remove", "@brief Method bool QDir::remove(const QString &fileName)\n", false, &_init_f_remove_2025, &_call_f_remove_2025);
  methods += new qt_gsi::GenericMethod ("removeRecursively", "@brief Method bool QDir::removeRecursively()\n", false, &_init_f_removeRecursively_0, &_call_f_removeRecursively_0);
  methods += new qt_gsi::GenericMethod ("rename", "@brief Method bool QDir::rename(const QString &oldName, const QString &newName)\n", false, &_init_f_rename_3942, &_call_f_rename_3942);
  methods += new qt_gsi::GenericMethod ("rmdir", "@brief Method bool QDir::rmdir(const QString &dirName)\n", true, &_init_f_rmdir_c2025, &_call_f_rmdir_c2025);
  methods += new qt_gsi::GenericMethod ("rmpath", "@brief Method bool QDir::rmpath(const QString &dirPath)\n", true, &_init_f_rmpath_c2025, &_call_f_rmpath_c2025);
  methods += new qt_gsi::GenericMethod ("setFilter|filter=", "@brief Method void QDir::setFilter(QFlags<QDir::Filter> filter)\n", false, &_init_f_setFilter_2230, &_call_f_setFilter_2230);
  methods += new qt_gsi::GenericMethod ("setNameFilters|nameFilters=", "@brief Method void QDir::setNameFilters(const QStringList &nameFilters)\n", false, &_init_f_setNameFilters_2437, &_call_f_setNameFilters_2437);
  methods += new qt_gsi::GenericMethod ("setPath|path=", "@brief Method void QDir::setPath(const QString &path)\n", false, &_init_f_setPath_2025, &_call_f_setPath_2025);
  methods += new qt_gsi::GenericMethod ("setSorting|sorting=", "@brief Method void QDir::setSorting(QFlags<QDir::SortFlag> sort)\n", false, &_init_f_setSorting_2418, &_call_f_setSorting_2418);
  methods += new qt_gsi::GenericMethod (":sorting", "@brief Method QFlags<QDir::SortFlag> QDir::sorting()\n", true, &_init_f_sorting_c0, &_call_f_sorting_c0);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QDir::swap(QDir &other)\n", false, &_init_f_swap_986, &_call_f_swap_986);
  methods += new qt_gsi::GenericStaticMethod ("addResourceSearchPath", "@brief Static method void QDir::addResourceSearchPath(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_addResourceSearchPath_2025, &_call_f_addResourceSearchPath_2025);
  methods += new qt_gsi::GenericStaticMethod ("addSearchPath", "@brief Static method void QDir::addSearchPath(const QString &prefix, const QString &path)\nThis method is static and can be called without an instance.", &_init_f_addSearchPath_3942, &_call_f_addSearchPath_3942);
  methods += new qt_gsi::GenericStaticMethod ("cleanPath", "@brief Static method QString QDir::cleanPath(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_cleanPath_2025, &_call_f_cleanPath_2025);
  methods += new qt_gsi::GenericStaticMethod ("current", "@brief Static method QDir QDir::current()\nThis method is static and can be called without an instance.", &_init_f_current_0, &_call_f_current_0);
  methods += new qt_gsi::GenericStaticMethod ("currentPath", "@brief Static method QString QDir::currentPath()\nThis method is static and can be called without an instance.", &_init_f_currentPath_0, &_call_f_currentPath_0);
  methods += new qt_gsi::GenericStaticMethod ("drives", "@brief Static method QList<QFileInfo> QDir::drives()\nThis method is static and can be called without an instance.", &_init_f_drives_0, &_call_f_drives_0);
  methods += new qt_gsi::GenericStaticMethod ("fromNativeSeparators", "@brief Static method QString QDir::fromNativeSeparators(const QString &pathName)\nThis method is static and can be called without an instance.", &_init_f_fromNativeSeparators_2025, &_call_f_fromNativeSeparators_2025);
  methods += new qt_gsi::GenericStaticMethod ("home", "@brief Static method QDir QDir::home()\nThis method is static and can be called without an instance.", &_init_f_home_0, &_call_f_home_0);
  methods += new qt_gsi::GenericStaticMethod ("homePath", "@brief Static method QString QDir::homePath()\nThis method is static and can be called without an instance.", &_init_f_homePath_0, &_call_f_homePath_0);
  methods += new qt_gsi::GenericStaticMethod ("isAbsolutePath?", "@brief Static method bool QDir::isAbsolutePath(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_isAbsolutePath_2025, &_call_f_isAbsolutePath_2025);
  methods += new qt_gsi::GenericStaticMethod ("isRelativePath?", "@brief Static method bool QDir::isRelativePath(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_isRelativePath_2025, &_call_f_isRelativePath_2025);
  methods += new qt_gsi::GenericStaticMethod ("match", "@brief Static method bool QDir::match(const QStringList &filters, const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_match_4354, &_call_f_match_4354);
  methods += new qt_gsi::GenericStaticMethod ("match", "@brief Static method bool QDir::match(const QString &filter, const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_match_3942, &_call_f_match_3942);
  methods += new qt_gsi::GenericStaticMethod ("nameFiltersFromString", "@brief Static method QStringList QDir::nameFiltersFromString(const QString &nameFilter)\nThis method is static and can be called without an instance.", &_init_f_nameFiltersFromString_2025, &_call_f_nameFiltersFromString_2025);
  methods += new qt_gsi::GenericStaticMethod ("root", "@brief Static method QDir QDir::root()\nThis method is static and can be called without an instance.", &_init_f_root_0, &_call_f_root_0);
  methods += new qt_gsi::GenericStaticMethod ("rootPath", "@brief Static method QString QDir::rootPath()\nThis method is static and can be called without an instance.", &_init_f_rootPath_0, &_call_f_rootPath_0);
  methods += new qt_gsi::GenericStaticMethod ("searchPaths", "@brief Static method QStringList QDir::searchPaths(const QString &prefix)\nThis method is static and can be called without an instance.", &_init_f_searchPaths_2025, &_call_f_searchPaths_2025);
  methods += new qt_gsi::GenericStaticMethod ("separator", "@brief Static method QChar QDir::separator()\nThis method is static and can be called without an instance.", &_init_f_separator_0, &_call_f_separator_0);
  methods += new qt_gsi::GenericStaticMethod ("setCurrent", "@brief Static method bool QDir::setCurrent(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_setCurrent_2025, &_call_f_setCurrent_2025);
  methods += new qt_gsi::GenericStaticMethod ("setSearchPaths", "@brief Static method void QDir::setSearchPaths(const QString &prefix, const QStringList &searchPaths)\nThis method is static and can be called without an instance.", &_init_f_setSearchPaths_4354, &_call_f_setSearchPaths_4354);
  methods += new qt_gsi::GenericStaticMethod ("temp", "@brief Static method QDir QDir::temp()\nThis method is static and can be called without an instance.", &_init_f_temp_0, &_call_f_temp_0);
  methods += new qt_gsi::GenericStaticMethod ("tempPath", "@brief Static method QString QDir::tempPath()\nThis method is static and can be called without an instance.", &_init_f_tempPath_0, &_call_f_tempPath_0);
  methods += new qt_gsi::GenericStaticMethod ("toNativeSeparators", "@brief Static method QString QDir::toNativeSeparators(const QString &pathName)\nThis method is static and can be called without an instance.", &_init_f_toNativeSeparators_2025, &_call_f_toNativeSeparators_2025);
  return methods;
}

gsi::Class<QDir> decl_QDir ("QtCore", "QDir",
  methods_QDir (),
  "@qt\n@brief Binding of QDir");


GSI_QTCORE_PUBLIC gsi::Class<QDir> &qtdecl_QDir () { return decl_QDir; }

}


//  Implementation of the enum wrapper class for QDir::Filter
namespace qt_gsi
{

static gsi::Enum<QDir::Filter> decl_QDir_Filter_Enum ("QtCore", "QDir_Filter",
    gsi::enum_const ("Dirs", QDir::Dirs, "@brief Enum constant QDir::Dirs") +
    gsi::enum_const ("Files", QDir::Files, "@brief Enum constant QDir::Files") +
    gsi::enum_const ("Drives", QDir::Drives, "@brief Enum constant QDir::Drives") +
    gsi::enum_const ("NoSymLinks", QDir::NoSymLinks, "@brief Enum constant QDir::NoSymLinks") +
    gsi::enum_const ("AllEntries", QDir::AllEntries, "@brief Enum constant QDir::AllEntries") +
    gsi::enum_const ("TypeMask", QDir::TypeMask, "@brief Enum constant QDir::TypeMask") +
    gsi::enum_const ("Readable", QDir::Readable, "@brief Enum constant QDir::Readable") +
    gsi::enum_const ("Writable", QDir::Writable, "@brief Enum constant QDir::Writable") +
    gsi::enum_const ("Executable", QDir::Executable, "@brief Enum constant QDir::Executable") +
    gsi::enum_const ("PermissionMask", QDir::PermissionMask, "@brief Enum constant QDir::PermissionMask") +
    gsi::enum_const ("Modified", QDir::Modified, "@brief Enum constant QDir::Modified") +
    gsi::enum_const ("Hidden", QDir::Hidden, "@brief Enum constant QDir::Hidden") +
    gsi::enum_const ("System", QDir::System, "@brief Enum constant QDir::System") +
    gsi::enum_const ("AccessMask", QDir::AccessMask, "@brief Enum constant QDir::AccessMask") +
    gsi::enum_const ("AllDirs", QDir::AllDirs, "@brief Enum constant QDir::AllDirs") +
    gsi::enum_const ("CaseSensitive", QDir::CaseSensitive, "@brief Enum constant QDir::CaseSensitive") +
    gsi::enum_const ("NoDot", QDir::NoDot, "@brief Enum constant QDir::NoDot") +
    gsi::enum_const ("NoDotDot", QDir::NoDotDot, "@brief Enum constant QDir::NoDotDot") +
    gsi::enum_const ("NoDotAndDotDot", QDir::NoDotAndDotDot, "@brief Enum constant QDir::NoDotAndDotDot") +
    gsi::enum_const ("NoFilter", QDir::NoFilter, "@brief Enum constant QDir::NoFilter"),
  "@qt\n@brief This class represents the QDir::Filter enum");

static gsi::QFlagsClass<QDir::Filter > decl_QDir_Filter_Enums ("QtCore", "QDir_QFlags_Filter",
  "@qt\n@brief This class represents the QFlags<QDir::Filter> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDir> inject_QDir_Filter_Enum_in_parent (decl_QDir_Filter_Enum.defs ());
static gsi::ClassExt<QDir> decl_QDir_Filter_Enum_as_child (decl_QDir_Filter_Enum, "Filter");
static gsi::ClassExt<QDir> decl_QDir_Filter_Enums_as_child (decl_QDir_Filter_Enums, "QFlags_Filter");

}


//  Implementation of the enum wrapper class for QDir::SortFlag
namespace qt_gsi
{

static gsi::Enum<QDir::SortFlag> decl_QDir_SortFlag_Enum ("QtCore", "QDir_SortFlag",
    gsi::enum_const ("Name", QDir::Name, "@brief Enum constant QDir::Name") +
    gsi::enum_const ("Time", QDir::Time, "@brief Enum constant QDir::Time") +
    gsi::enum_const ("Size", QDir::Size, "@brief Enum constant QDir::Size") +
    gsi::enum_const ("Unsorted", QDir::Unsorted, "@brief Enum constant QDir::Unsorted") +
    gsi::enum_const ("SortByMask", QDir::SortByMask, "@brief Enum constant QDir::SortByMask") +
    gsi::enum_const ("DirsFirst", QDir::DirsFirst, "@brief Enum constant QDir::DirsFirst") +
    gsi::enum_const ("Reversed", QDir::Reversed, "@brief Enum constant QDir::Reversed") +
    gsi::enum_const ("IgnoreCase", QDir::IgnoreCase, "@brief Enum constant QDir::IgnoreCase") +
    gsi::enum_const ("DirsLast", QDir::DirsLast, "@brief Enum constant QDir::DirsLast") +
    gsi::enum_const ("LocaleAware", QDir::LocaleAware, "@brief Enum constant QDir::LocaleAware") +
    gsi::enum_const ("Type", QDir::Type, "@brief Enum constant QDir::Type") +
    gsi::enum_const ("NoSort", QDir::NoSort, "@brief Enum constant QDir::NoSort"),
  "@qt\n@brief This class represents the QDir::SortFlag enum");

static gsi::QFlagsClass<QDir::SortFlag > decl_QDir_SortFlag_Enums ("QtCore", "QDir_QFlags_SortFlag",
  "@qt\n@brief This class represents the QFlags<QDir::SortFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDir> inject_QDir_SortFlag_Enum_in_parent (decl_QDir_SortFlag_Enum.defs ());
static gsi::ClassExt<QDir> decl_QDir_SortFlag_Enum_as_child (decl_QDir_SortFlag_Enum, "SortFlag");
static gsi::ClassExt<QDir> decl_QDir_SortFlag_Enums_as_child (decl_QDir_SortFlag_Enums, "QFlags_SortFlag");

}

