/***************************************************************************
                          tipsdialog.cpp  -  description
                             -------------------
    begin                : sept 2019
    copyright            : (C) 2019 by Jaime Robles
    email                : jaime@robles.es
 ***************************************************************************/

/*****************************************************************************
 * This file is part of KLog.                                                *
 *                                                                           *
 *    KLog is free software: you can redistribute it and/or modify           *
 *    it under the terms of the GNU General Public License as published by   *
 *    the Free Software Foundation, either version 3 of the License, or      *
 *    (at your option) any later version.                                    *
 *                                                                           *
 *    KLog is distributed in the hope that it will be useful,                *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *    GNU General Public License for more details.                           *
 *                                                                           *
 *    You should have received a copy of the GNU General Public License      *
 *    along with KLog.  If not, see <https://www.gnu.org/licenses/>.         *
 *                                                                           *
 *****************************************************************************/
#include "tipsdialog.h"

#include <QDialogButtonBox>
#include <QGridLayout>
#include <QKeyEvent>
#include <QLabel>
#include <QPushButton>
#include <QDebug>

TipsDialog::TipsDialog(QWidget *parent): QDialog(parent)
{
      //qDebug() << "TipsDialog::TipsDialog" << QT_ENDL;
    logLevel = Info;  //7 Debug /0=emergency or no debug
    logEvent(Q_FUNC_INFO, "Start", Debug);
    tipTextQLabel = new QLabel;
    tipId = 1;
    tipMax = 19;

    setWindowTitle(tr("KLog tips"));
    setWindowFlags(windowFlags() & Qt::WindowContextHelpButtonHint);

    tipTextQLabel->setWordWrap(true);
    tipTextQLabel->setOpenExternalLinks(false);
    tipTextQLabel->setTextInteractionFlags(Qt::TextBrowserInteraction);
    tipTextQLabel->setTextFormat(Qt::RichText);
    setTip(1);

    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Close);
    QPushButton *closeButton = buttonBox->button(QDialogButtonBox::Close);
    QPushButton *nextButton = new QPushButton;
    QPushButton *prevButton = new QPushButton;
    nextButton->setText(tr("Next"));
    prevButton->setText(tr("Previous"));

    buttonBox->addButton(closeButton, QDialogButtonBox::ButtonRole(QDialogButtonBox::RejectRole | QDialogButtonBox::AcceptRole));
    buttonBox->addButton(prevButton, QDialogButtonBox::ButtonRole(QDialogButtonBox::ActionRole));
    buttonBox->addButton(nextButton, QDialogButtonBox::ButtonRole(QDialogButtonBox::ActionRole));

    //connect(buttonBox , &QDialogButtonBox::rejected, this, &QDialog::reject);
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject())) ;
    connect(prevButton, SIGNAL(clicked()), this, SLOT(slotPrevButtonClicked() ) );
    connect(nextButton, SIGNAL(clicked()), this, SLOT(slotNextButtonClicked() ) );
    connect(tipTextQLabel, SIGNAL(linkActivated(QString)), this, SLOT(slotLinkActivated(QString)));

    tip = new QWidget;

    QGridLayout *layout1 = new QGridLayout;
    layout1->addWidget(tipTextQLabel, 0, 1, 4, 4);
    tip->setLayout(layout1);

    QVBoxLayout *layout = new QVBoxLayout(this);
    layout->addWidget(tip);
    layout->addWidget(buttonBox);
    setLayout(layout);
    logEvent(Q_FUNC_INFO, "END", Debug);
}

TipsDialog::~TipsDialog(){}


void TipsDialog::slotPrevButtonClicked()
{
    logEvent(Q_FUNC_INFO, "Start", Debug);

    if (tipId>1)
    {
        tipId--;
    }
    else
    {
        tipId = tipMax;
    }
    setTip(tipId);

    logEvent(Q_FUNC_INFO, "END", Debug);
}

void TipsDialog::slotNextButtonClicked()
{
    logEvent(Q_FUNC_INFO, "Start", Debug);

    if (tipId<tipMax)
    {
        tipId++;
    }
    else
    {
        tipId = 1;
    }
    setTip(tipId);
    logEvent(Q_FUNC_INFO, "END", Debug);
}

void TipsDialog::setLogLevel(const DebugLogLevel _sev)
{
    logEvent(Q_FUNC_INFO, "Start", Debug);
    logLevel = _sev;
    logEvent(Q_FUNC_INFO, "END", Debug);
}

void TipsDialog::setTip(const int _t)
{
    logEvent(Q_FUNC_INFO, "Start", Debug);
    switch (_t) {

    case 1:
        //: Translator: Please make sure that the name of the link is coherent with the menu Tools->Fill in QSO data
        description = tr("<b>Tip #1:</b><br>Do you know...<br>You can use <a href=\"#ToolsFillInQSO\">Tools->Fill in QSO data</a> to automatically read the full log to fill the DXCC, CQ, ITU zones and continent?");
    break;
   case 2:
        //: Translator: Please make sure that the name of the link is coherent with the menu Tools->Fill in DXCC data
      description = tr("<b>Tip #2:</b><br>Do you know...<br>You can find the QSLs that you still need to send with <a href=\"#ToolsSendPendingQSL\">Tools->QSL tools...->Find My-QSLs pending to send</a>.<bR>This tool will list you in the search box all the QSOs with the QSL-Sent marked as <i>Requested</i>.");
    break;
    case 3:
        //: Translator: Please make sure that the name of the link is coherent with the menu Tools->QSL tools...->Find QSO to QSL
        description = tr("<b>Tip #3:</b><br>Do you know...<br>You can use <a href=\"#ToolsFindQSO2QSL\">Tools->QSL tools...->Find QSO to QSL</a> to look for all those QSO that you should send your QSL because you still need to confirm that DXCC and you have still not send your QSL card?");
    break;
    case 4:
        //: Translator: Please make sure that the name of the link is coherent with the menu File->Export Requested QSL to ADIF...
        description = tr("<b>Tip #4:</b><br>Do you know...<br>You can enter a '*' in the search box, in the search window to search for all the QSOs done with one specific station callsign?");
    break;
    case 5:
        description = tr("<b>Tip #5:</b><br>Do you know...<br>You can find the file containing all your log and other information in the logbook.dat "
                         "file and the klogrc file, containing the KLog config file in the KLog folder by opening the"
                         " <a href=\"#FileOpenKLogFolder\">File->KLog folder</a> menu?");
    break;
    case 6:
        //: Translator: Please make sure that the name of the link is coherent with the menu File->KLog folder
        description = tr("<b>Tip #6:</b><br>Do you know...<br>You can upload your QSO marked as queued to LoTW via TQSL with <a href=\"#ToolsUploadLoTW\">Tools->LoTW tools ...->Sends the log to LoTW calling TQSL.</a> ?<br><br>You have to configure TQSL in the preferences to be able to use this functionality.");
    break;
    case 7:
        //: Translator: Please make sure that the name of the link is coherent with the menu QSL tools...->Find My-QSLs pending to send
        description = tr("<b>Tip #7:</b><br>Do you know...<br>You can see the QSO that confirms one specific DXCC entity in one specific band by poiting your mouse over that band in the DXCC widget?");
    break;
    case 8:
        //: Translator: Please make sure that the name of the link is coherent with the menu QSL tools...->Find DX-QSLs pending to receive
        description = tr("<b>Tip #8:</b><br>Do you know...<br>You can find the QSLs that you are still waiting for with <a href=\"#ToolsReceivePendingQSL\">Tools->QSL tools...->Find DX-QSLs pending to receive</a>.<bR>This tool will list you in the search box all the QSOs with the QSL-Sent marked as <i>Sent</i> but you have still not received the QSL card from the DX.");
    break;
    case 9:
        //: Translator: Please make sure that the name of the link is coherent with the menu QSL tools...->Find requested pending to receive
        description = tr("<b>Tip #9:</b><br>Do you know...<br>You can find the QSLs that you are still waiting for with <a href=\"#ToolsReceiveRecPendingQSL\">Tools->QSL tools...->Find requested pending to receive</a>.<bR>This tool will list you in the search box all the QSOs with the QSL-Rec marked as <i>Requested</i> but you have still not received the QSL card from the DX.");
    break;
    case 10:
        description = tr("<b>Tip #10:</b><br>Do you know...<br>You can subscribe to the <a href=https://t.me/klogchat>English KLog Telegram group</a> to discuss about KLog in English?");
    break;
    case 11:
        description = tr("<b>Tip #11:</b><br>Do you know...<br>You can subscribe to the <a href=https://t.me/KLogES>Spanish Telegram group</a> to discuss about KLog in Spanish?");
    break;
    case 12:
        description = tr("<b>Tip #12:</b><br>Do you know...<br>You can subscribe to <a href=https://groups.io/g/klog>KLog mailing list</a> to discuss via email about KLog in English?");
    break;
    case 13:
        description = tr("<b>Tip #13:</b><br>Do you know...<br>You can <a href=https://twitter.com/_ea4k>follow EA4K on twitter</a> to get updates about KLog?");
    break;
    case 14:
        description = tr("<b>Tip #14:</b><br>Do you know...<br>You can write your own <a href=https://www.eham.net/reviews/detail/3118>review in eHam.net about KLog</a> to help other users to decide to use KLog?");
    break;
    case 15:
        description = tr("<b>Tip #15:</b><br>Do you know...<br>You can join the development team by simply <a href=https://www.klog.xyz/contact>Contacting us</a>?");
    break;
    case 16:
        description = tr("<b>Tip #16:</b><br>Do you know...<br>That there are many ways to contribute to KLog and some of them are listed in the <a href=https://www.klog.xyz/contrib>KLog Contribute</a> page?");
    break;
    case 17:
        description = tr("<b>Tip #17:</b><br>Do you know...<br>You can support translating KLog into your language? Please check <a href=https://www.klog.xyz/contrib/translations>KLog Translations</a> page.");
    break;
    case 18:
        description = tr("<b>Tip #18:</b><br>Do you know...<br>You can double-click on an entity name in the DXCC table and all the QSOs with that DXCC Entity will be shown in the search box?");
    break;
    case 19:
        description = tr("<b>Tip #19:</b><br>Do you know...<br>You can right-click on a QSO and select <i>Check in QRZ.com</i> to check that callsign in QRZ.com?");
    break;
    default:
        //description = tr("TIP-Default: Text");
        description = "";
    break;
    }
    //tipTextEdit->setHtml(description);

    tipTextQLabel->setText(description);
    logEvent(Q_FUNC_INFO, "END", Debug);
      //qDebug() << "TipsDialog::setTip: END"  << QT_ENDL;
}

void TipsDialog::slotLinkActivated(const QString &_link)
{
    logEvent(Q_FUNC_INFO, "Start", Debug);

      //qDebug() << "TipsDialog::slotLinkActivated: " << _link << QT_ENDL;
    //Comprobar el enalce y activar el menu correspondiente
    if (_link == "#ToolsFillInQSO")
    {
        emit fillInQSOSignal();
    }
    else if (_link == "#ToolsFindQSO2QSL")
    {
        emit fillInDXCCSignal();
    }
    else if (_link == "#ToolsFillInDXCC")
    {
        emit findQSL2QSOSignal();
    }
    else if (_link == "#FileExportQSLADIFToPrint")
    {
        emit fileExportToPrintSignal();
    }
    else if (_link == "#FileExportLoTWADIF")
    {
        //emit fileExportForLoTWSignal();
    }
    else if (_link == "#FileOpenKLogFolder")
    {
        emit fileOpenKLogFolderSignal();
    }
    else if (_link == "#ToolsSendPendingQSL")
    {
        emit toolSendPendingQSLSignal();
    }
    else if (_link == "#ToolsReceivePendingQSL")
    {
        emit toolRecPendingQSLSignal();
    }
    else if (_link == "#ToolsReceiveRecPendingQSL")
    {
        emit toolRecRecPendingQSLSignal();
    }
    else if (_link == "#ToolsUploadLoTW")
    {
        emit toolsUploadLoTWSignal();
    }
    logEvent(Q_FUNC_INFO, "END", Debug);
}


void TipsDialog::logEvent(const QString &_func, const QString &_msg,  DebugLogLevel _level)
{
    if (logLevel<=_level)
        emit debugLog (_func, _msg, _level);
}
