/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.lip;

import java.util.ArrayList;
import java.util.HashMap;
import org.lisaac.ldt.model.lip.LIPCall;
import org.lisaac.ldt.model.lip.LIPSlotCode;
import org.lisaac.ldt.model.lip.LIPSlotData;
import org.lisaac.ldt.model.lip.LIPString;
import org.lisaac.ldt.model.lip.LIPValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LIP {
    private static final String PROJECT_PATH_SLOT = "project_path";
    private static final String LISAAC_PATH_SLOT = "path";
    private String filename;
    protected ArrayList<String> listParent = new ArrayList();
    protected ArrayList<LIPSlotCode> listMethod = new ArrayList();
    protected HashMap<String, LIPSlotData> listData = new HashMap();

    public LIP(String filename) {
        this.filename = filename;
    }

    public String getFileName() {
        return this.filename;
    }

    public void addParent(String string) {
        this.listParent.add(string);
    }

    public void addMethod(LIPSlotCode m) {
        this.listMethod.add(m);
    }

    public void addData(LIPSlotData data) {
        this.listData.put(data.getName(), data);
    }

    public ArrayList<String> getParentList() {
        return this.listParent;
    }

    public void clearParents() {
        this.listParent = null;
    }

    public LIPSlotCode getMethod(int i) {
        return this.listMethod.get(i);
    }

    public int getMethodCount() {
        return this.listMethod.size();
    }

    public LIPSlotCode getPublicMethod(int index) {
        int count = 0;
        int i = 0;
        while (i < this.getMethodCount()) {
            LIPSlotCode method = this.getMethod(i);
            if (method.isPublic()) {
                if (index == count) {
                    return method;
                }
                ++count;
            }
            ++i;
        }
        return null;
    }

    public int getPublicMethodCount() {
        int count = 0;
        int i = 0;
        while (i < this.getMethodCount()) {
            LIPSlotCode method = this.getMethod(i);
            if (method.isPublic()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void addProjectPath(String projectPath) {
        int i = 0;
        while (i < this.getMethodCount()) {
            LIPSlotCode method = this.getMethod(i);
            if (method.getName().compareTo(PROJECT_PATH_SLOT) == 0) {
                method.addLastCode(new LIPCall(LISAAC_PATH_SLOT, new LIPValue(new LIPString(projectPath))));
                break;
            }
            ++i;
        }
    }
}

