; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -codegenprepare -cgp-optimize-phi-types %s -S | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64--linux-gnu"

define float @convphi1(i32 *%s, i32 *%d, i32 %n) {
; CHECK-LABEL: @convphi1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast i32 [[LS]] to float
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[LD:%.*]] = load i32, i32* [[D:%.*]], align 4
; CHECK-NEXT:    [[LD_BC:%.*]] = bitcast i32 [[LD]] to float
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi float [ [[LS_BC]], [[THEN]] ], [ [[LD_BC]], [[ELSE]] ]
; CHECK-NEXT:    ret float [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  br i1 %cmp15, label %then, label %else

then:
  %ls = load i32, i32* %s, align 4
  br label %end

else:
  %ld = load i32, i32* %d, align 4
  br label %end

end:
  %phi = phi i32 [ %ls, %then ], [ %ld, %else ]
  %b = bitcast i32 %phi to float
  ret float %b
}

define float @convphi2(i32 *%s, i32 *%d, i32 %n) {
; CHECK-LABEL: @convphi2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[END:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast i32 [[LS]] to float
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi float [ [[LS_BC]], [[THEN]] ], [ undef, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret float [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  br i1 %cmp15, label %then, label %end

then:
  %ls = load i32, i32* %s, align 4
  br label %end

end:
  %phi = phi i32 [ %ls, %then ], [ undef, %entry ]
  %b = bitcast i32 %phi to float
  ret float %b
}

define float @convphi3(i32 *%s, i32 *%d, i32 %n, float %f) {
; CHECK-LABEL: @convphi3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    [[FB:%.*]] = bitcast float [[F:%.*]] to i32
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[END:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast i32 [[LS]] to float
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi float [ [[LS_BC]], [[THEN]] ], [ [[F]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret float [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  %fb = bitcast float %f to i32
  br i1 %cmp15, label %then, label %end

then:
  %ls = load i32, i32* %s, align 4
  br label %end

end:
  %phi = phi i32 [ %ls, %then ], [ %fb, %entry ]
  %b = bitcast i32 %phi to float
  ret float %b
}

define void @convphi4(i32 *%s, i32 *%d, i32 %n, float %f) {
; CHECK-LABEL: @convphi4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    [[FB:%.*]] = bitcast float [[F:%.*]] to i32
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[END:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast i32 [[LS]] to float
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi float [ [[LS_BC]], [[THEN]] ], [ [[F]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[BC:%.*]] = bitcast float [[PHI_TC]] to i32
; CHECK-NEXT:    store i32 [[BC]], i32* [[D:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  %fb = bitcast float %f to i32
  br i1 %cmp15, label %then, label %end

then:
  %ls = load i32, i32* %s, align 4
  br label %end

end:
  %phi = phi i32 [ %ls, %then ], [ %fb, %entry ]
  store i32 %phi, i32 *%d
  ret void
}

define i64 @convphi_d2i(double *%s, double *%d, i32 %n) {
; CHECK-LABEL: @convphi_d2i(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load double, double* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast double [[LS]] to i64
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[LD:%.*]] = load double, double* [[D:%.*]], align 4
; CHECK-NEXT:    [[LD_BC:%.*]] = bitcast double [[LD]] to i64
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi i64 [ [[LS_BC]], [[THEN]] ], [ [[LD_BC]], [[ELSE]] ]
; CHECK-NEXT:    ret i64 [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  br i1 %cmp15, label %then, label %else

then:
  %ls = load double, double* %s, align 4
  br label %end

else:
  %ld = load double, double* %d, align 4
  br label %end

end:
  %phi = phi double [ %ls, %then ], [ %ld, %else ]
  %b = bitcast double %phi to i64
  ret i64 %b
}

define i32 @convphi_f2i(float *%s, float *%d, i32 %n) {
; CHECK-LABEL: @convphi_f2i(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load float, float* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast float [[LS]] to i32
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[LD:%.*]] = load float, float* [[D:%.*]], align 4
; CHECK-NEXT:    [[LD_BC:%.*]] = bitcast float [[LD]] to i32
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi i32 [ [[LS_BC]], [[THEN]] ], [ [[LD_BC]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  br i1 %cmp15, label %then, label %else

then:
  %ls = load float, float* %s, align 4
  br label %end

else:
  %ld = load float, float* %d, align 4
  br label %end

end:
  %phi = phi float [ %ls, %then ], [ %ld, %else ]
  %b = bitcast float %phi to i32
  ret i32 %b
}

define i16 @convphi_h2i(half *%s, half *%d, i32 %n) {
; CHECK-LABEL: @convphi_h2i(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load half, half* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast half [[LS]] to i16
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[LD:%.*]] = load half, half* [[D:%.*]], align 4
; CHECK-NEXT:    [[LD_BC:%.*]] = bitcast half [[LD]] to i16
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi i16 [ [[LS_BC]], [[THEN]] ], [ [[LD_BC]], [[ELSE]] ]
; CHECK-NEXT:    ret i16 [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  br i1 %cmp15, label %then, label %else

then:
  %ls = load half, half* %s, align 4
  br label %end

else:
  %ld = load half, half* %d, align 4
  br label %end

end:
  %phi = phi half [ %ls, %then ], [ %ld, %else ]
  %b = bitcast half %phi to i16
  ret i16 %b
}

define i128 @convphi_ld2i(fp128 *%s, fp128 *%d, i32 %n) {
; CHECK-LABEL: @convphi_ld2i(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load fp128, fp128* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast fp128 [[LS]] to i128
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[LD:%.*]] = load fp128, fp128* [[D:%.*]], align 4
; CHECK-NEXT:    [[LD_BC:%.*]] = bitcast fp128 [[LD]] to i128
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi i128 [ [[LS_BC]], [[THEN]] ], [ [[LD_BC]], [[ELSE]] ]
; CHECK-NEXT:    ret i128 [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  br i1 %cmp15, label %then, label %else

then:
  %ls = load fp128, fp128* %s, align 4
  br label %end

else:
  %ld = load fp128, fp128* %d, align 4
  br label %end

end:
  %phi = phi fp128 [ %ls, %then ], [ %ld, %else ]
  %b = bitcast fp128 %phi to i128
  ret i128 %b
}

define <4 x i32> @convphi_4xf2i(<4 x float> *%s, <4 x float> *%d, i32 %n) {
; CHECK-LABEL: @convphi_4xf2i(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load <4 x float>, <4 x float>* [[S:%.*]], align 4
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[LD:%.*]] = load <4 x float>, <4 x float>* [[D:%.*]], align 4
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI:%.*]] = phi <4 x float> [ [[LS]], [[THEN]] ], [ [[LD]], [[ELSE]] ]
; CHECK-NEXT:    [[B:%.*]] = bitcast <4 x float> [[PHI]] to <4 x i32>
; CHECK-NEXT:    ret <4 x i32> [[B]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  br i1 %cmp15, label %then, label %else

then:
  %ls = load <4 x float>, <4 x float>* %s, align 4
  br label %end

else:
  %ld = load <4 x float>, <4 x float>* %d, align 4
  br label %end

end:
  %phi = phi <4 x float> [ %ls, %then ], [ %ld, %else ]
  %b = bitcast <4 x float> %phi to <4 x i32>
  ret <4 x i32> %b
}

define float @convphi_loop(i32 *%s, i32 *%d, i64 %n) {
; CHECK-LABEL: @convphi_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i64 [[N:%.*]], 0
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast i32 [[LS]] to float
; CHECK-NEXT:    br i1 [[CMP15]], label [[LOOP:%.*]], label [[END:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[LPHI_TC:%.*]] = phi float [ [[LS_BC]], [[ENTRY]] ], [ [[LD_BC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[LD:%.*]] = load i32, i32* [[D:%.*]], align 4
; CHECK-NEXT:    [[LD_BC]] = bitcast i32 [[LD]] to float
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[END]], label [[LOOP]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi float [ undef, [[ENTRY]] ], [ [[LPHI_TC]], [[LOOP]] ]
; CHECK-NEXT:    ret float [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i64 %n, 0
  %ls = load i32, i32* %s, align 4
  br i1 %cmp15, label %loop, label %end

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %lphi = phi i32 [ %ls, %entry ], [ %ld, %loop ]
  %ld = load i32, i32* %d, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %end, label %loop

end:
  %phi = phi i32 [ undef, %entry ], [ %lphi, %loop ]
  %b = bitcast i32 %phi to float
  ret float %b
}

define float @convphi_loopdelayed(i32 *%s, i32 *%d, i64 %n) {
; CHECK-LABEL: @convphi_loopdelayed(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i64 [[N:%.*]], 0
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    br i1 [[CMP15]], label [[LOOP:%.*]], label [[END:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[LD:%.*]] = load i32, i32* [[D:%.*]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[END]], label [[LOOP]]
; CHECK:       end:
; CHECK-NEXT:    [[B:%.*]] = bitcast i32 [[LS]] to float
; CHECK-NEXT:    ret float [[B]]
;
entry:
  %cmp15 = icmp sgt i64 %n, 0
  %ls = load i32, i32* %s, align 4
  br i1 %cmp15, label %loop, label %end

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %lphi = phi i32 [ %ls, %entry ], [ %lphi, %loop ]
  %ld = load i32, i32* %d, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %end, label %loop

end:
  %phi = phi i32 [ undef, %entry ], [ %lphi, %loop ]
  %b = bitcast i32 %phi to float
  ret float %b
}

define float @convphi_loopdelayed2(i32 *%s, i32 *%d, i64 %n) {
; CHECK-LABEL: @convphi_loopdelayed2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i64 [[N:%.*]], 0
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast i32 [[LS]] to float
; CHECK-NEXT:    br i1 [[CMP15]], label [[LOOP:%.*]], label [[END:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[LPHI_TC:%.*]] = phi float [ [[LS_BC]], [[ENTRY]] ], [ [[LD_BC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[LPHI2_TC:%.*]] = phi float [ undef, [[ENTRY]] ], [ [[LPHI_TC]], [[LOOP]] ]
; CHECK-NEXT:    [[LD:%.*]] = load i32, i32* [[D:%.*]], align 4
; CHECK-NEXT:    [[LD_BC]] = bitcast i32 [[LD]] to float
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[END]], label [[LOOP]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi float [ undef, [[ENTRY]] ], [ [[LPHI2_TC]], [[LOOP]] ]
; CHECK-NEXT:    ret float [[PHI_TC]]
;
entry:
  %cmp15 = icmp sgt i64 %n, 0
  %ls = load i32, i32* %s, align 4
  br i1 %cmp15, label %loop, label %end

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %lphi = phi i32 [ %ls, %entry ], [ %ld, %loop ]
  %lphi2 = phi i32 [ undef, %entry ], [ %lphi, %loop ]
  %ld = load i32, i32* %d, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %end, label %loop

end:
  %phi = phi i32 [ undef, %entry ], [ %lphi2, %loop ]
  %b = bitcast i32 %phi to float
  ret float %b
}

define float @convphi_loopmore(i32 *%s, i32 *%d, i64 %n) {
; CHECK-LABEL: @convphi_loopmore(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[N:%.*]], 1
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    [[LS_BC:%.*]] = bitcast i32 [[LS]] to float
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[IFEND:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LD:%.*]] = load i32, i32* [[D:%.*]], align 4
; CHECK-NEXT:    [[LD_BC:%.*]] = bitcast i32 [[LD]] to float
; CHECK-NEXT:    br label [[IFEND]]
; CHECK:       ifend:
; CHECK-NEXT:    [[PHI1_TC:%.*]] = phi float [ [[LD_BC]], [[THEN]] ], [ [[LS_BC]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i64 [[N]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[LOOP:%.*]], label [[END:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[IFEND]] ], [ [[IV_NEXT:%.*]], [[LOOPEND:%.*]] ]
; CHECK-NEXT:    [[PHI2_TC:%.*]] = phi float [ [[PHI1_TC]], [[IFEND]] ], [ [[PHI3_TC:%.*]], [[LOOPEND]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i64 [[N]], 1
; CHECK-NEXT:    br i1 [[TMP0]], label [[LOOPTHEN:%.*]], label [[LOOPEND]]
; CHECK:       loopthen:
; CHECK-NEXT:    [[LL:%.*]] = load i32, i32* [[D]], align 4
; CHECK-NEXT:    [[LL_BC:%.*]] = bitcast i32 [[LL]] to float
; CHECK-NEXT:    br label [[LOOPEND]]
; CHECK:       loopend:
; CHECK-NEXT:    [[PHI3_TC]] = phi float [ [[LL_BC]], [[LOOPTHEN]] ], [ [[PHI2_TC]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[END]], label [[LOOP]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI_TC:%.*]] = phi float [ [[PHI1_TC]], [[IFEND]] ], [ [[PHI3_TC]], [[LOOPEND]] ]
; CHECK-NEXT:    ret float [[PHI_TC]]
;
entry:
  %cmp = icmp eq i64 %n, 1
  %ls = load i32, i32* %s, align 4
  br i1 %cmp, label %then, label %ifend

then:
  %ld = load i32, i32* %d, align 4
  br label %ifend

ifend:
  %phi1 = phi i32 [ %ld, %then ], [ %ls, %entry ]
  %cmp15 = icmp sgt i64 %n, 0
  br i1 %cmp15, label %loop, label %end

loop:
  %iv = phi i64 [ 0, %ifend ], [ %iv.next, %loopend ]
  %phi2 = phi i32 [ %phi1, %ifend ], [ %phi3, %loopend ]
  br i1 %cmp, label %loopthen, label %loopend

loopthen:
  %ll = load i32, i32* %d, align 4
  br label %loopend

loopend:
  %phi3 = phi i32 [ %ll, %loopthen ], [ %phi2, %loop ]
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond = icmp eq i64 %iv.next, %n
  br i1 %exitcond, label %end, label %loop

end:
  %phi = phi i32 [ %phi1, %ifend ], [ %phi3, %loopend ]
  %b = bitcast i32 %phi to float
  ret float %b
}




