; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=thumbv7-apple-darwin %s -o - | FileCheck %s

define i8 @scmp_8_8(i8 signext %x, i8 signext %y) nounwind {
; CHECK-LABEL: scmp_8_8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    mov.w r0, #0
; CHECK-NEXT:    mov.w r2, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r0, #1
; CHECK-NEXT:    it gt
; CHECK-NEXT:    movgt r2, #1
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    bx lr
  %1 = call i8 @llvm.scmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @scmp_8_16(i16 signext %x, i16 signext %y) nounwind {
; CHECK-LABEL: scmp_8_16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    mov.w r0, #0
; CHECK-NEXT:    mov.w r2, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r0, #1
; CHECK-NEXT:    it gt
; CHECK-NEXT:    movgt r2, #1
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    bx lr
  %1 = call i8 @llvm.scmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @scmp_8_32(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: scmp_8_32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    mov.w r0, #0
; CHECK-NEXT:    mov.w r2, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r0, #1
; CHECK-NEXT:    it gt
; CHECK-NEXT:    movgt r2, #1
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    bx lr
  %1 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @scmp_8_64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: scmp_8_64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    subs.w r12, r0, r2
; CHECK-NEXT:    mov.w r9, #0
; CHECK-NEXT:    sbcs.w r12, r1, r3
; CHECK-NEXT:    mov.w r12, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt.w r12, #1
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt.w r9, #1
; CHECK-NEXT:    sub.w r0, r9, r12
; CHECK-NEXT:    bx lr
  %1 = call i8 @llvm.scmp(i64 %x, i64 %y)
  ret i8 %1
}

define i8 @scmp_8_128(i128 %x, i128 %y) nounwind {
; CHECK-LABEL: scmp_8_128:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    add.w lr, sp, #16
; CHECK-NEXT:    ldr r4, [sp, #28]
; CHECK-NEXT:    movs r5, #0
; CHECK-NEXT:    ldm.w lr, {r9, r12, lr}
; CHECK-NEXT:    subs.w r6, r0, r9
; CHECK-NEXT:    sbcs.w r6, r1, r12
; CHECK-NEXT:    sbcs.w r6, r2, lr
; CHECK-NEXT:    sbcs.w r6, r3, r4
; CHECK-NEXT:    mov.w r6, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r6, #1
; CHECK-NEXT:    subs.w r0, r9, r0
; CHECK-NEXT:    sbcs.w r0, r12, r1
; CHECK-NEXT:    sbcs.w r0, lr, r2
; CHECK-NEXT:    sbcs.w r0, r4, r3
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r5, #1
; CHECK-NEXT:    subs r0, r5, r6
; CHECK-NEXT:    pop {r4, r5, r6, pc}
  %1 = call i8 @llvm.scmp(i128 %x, i128 %y)
  ret i8 %1
}

define i32 @scmp_32_32(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: scmp_32_32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    mov.w r0, #0
; CHECK-NEXT:    mov.w r2, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r0, #1
; CHECK-NEXT:    it gt
; CHECK-NEXT:    movgt r2, #1
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    bx lr
  %1 = call i32 @llvm.scmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @scmp_32_64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: scmp_32_64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    subs.w r12, r0, r2
; CHECK-NEXT:    mov.w r9, #0
; CHECK-NEXT:    sbcs.w r12, r1, r3
; CHECK-NEXT:    mov.w r12, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt.w r12, #1
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt.w r9, #1
; CHECK-NEXT:    sub.w r0, r9, r12
; CHECK-NEXT:    bx lr
  %1 = call i32 @llvm.scmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @scmp_64_64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: scmp_64_64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    subs.w r12, r0, r2
; CHECK-NEXT:    mov.w r9, #0
; CHECK-NEXT:    sbcs.w r12, r1, r3
; CHECK-NEXT:    mov.w r12, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt.w r12, #1
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt.w r9, #1
; CHECK-NEXT:    sub.w r0, r9, r12
; CHECK-NEXT:    asrs r1, r0, #31
; CHECK-NEXT:    bx lr
  %1 = call i64 @llvm.scmp(i64 %x, i64 %y)
  ret i64 %1
}
