# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_set import PointSet


class PolyData(PointSet):
    r"""
    PolyData - concrete dataset represents vertices, lines, polygons,
    and triangle strips
    
    Superclass: PointSet
    
    PolyData is a data object that is a concrete implementation of
    DataSet. PolyData represents a geometric structure consisting
    of vertices, lines, polygons, and/or triangle strips. Point and cell
    attribute values (e.g., scalars, vectors, etc.) also are represented.
    
    The actual cell types (vtkcell_type.h) supported by PolyData are:
    Vertex, PolyVertex, Line, PolyLine, Triangle, Quad,
    Polygon, and TriangleStrip.
    
    One important feature of PolyData objects is that special
    traversal and data manipulation methods are available to process
    data. These methods are generally more efficient than DataSet
    methods and should be used whenever possible. For example, traversing
    the cells in a dataset we would use get_cell(). To traverse cells with
    PolyData we would retrieve the cell array object representing
    polygons (for example using get_polys()) and then use CellArray's
    init_traversal() and get_next_cell() methods.
    
    @warning
    Because PolyData is implemented with four separate instances of
    CellArray to represent 0D vertices, 1D lines, 2D polygons, and 2D
    triangle strips, it is possible to create PolyData instances that
    consist of a mixture of cell types. Because of the design of the
    class, there are certain limitations on how mixed cell types are
    inserted into the PolyData, and in turn the order in which they
    are processed and rendered. To preserve the consistency of cell ids,
    and to ensure that cells with cell data are rendered properly, users
    must insert mixed cells in the order of vertices (Vertex and
    PolyVertex), lines (Line and PolyLine), polygons
    (Triangle, Quad, Polygon), and triangle strips
    (vtktriangle_strip).
    
    @warning
    Some filters when processing PolyData with mixed cell types may
    process the cells in differing ways. Some will convert one type into
    another (e.g., TriangleStrip into Triangles) or expect a
    certain type (vtkdecimate_pro expects triangles or triangle strips;
    TubeFilter expects lines). Read the documentation for each filter
    carefully to understand how each part of PolyData is processed.
    
    @warning
    Some of the methods specified here function properly only when the
    dataset has been specified as "Editable". They are documented as
    such.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolyData, obj, update, **traits)
    
    def _get_lines(self):
        return wrap_vtk(self._vtk_obj.GetLines())
    def _set_lines(self, arg):
        old_val = self._get_lines()
        my_arg = deref_array([arg], [['vtkCellArray']])
        self._wrap_call(self._vtk_obj.SetLines,
                        my_arg[0])
        self.trait_property_changed('lines', old_val, arg)
    lines = traits.Property(_get_lines, _set_lines, desc=\
        r"""
        Get the cell array defining lines. If there are no lines, an
        empty array will be returned (convenience to simplify traversal).
        """
    )

    def _get_polys(self):
        return wrap_vtk(self._vtk_obj.GetPolys())
    def _set_polys(self, arg):
        old_val = self._get_polys()
        my_arg = deref_array([arg], [['vtkCellArray']])
        self._wrap_call(self._vtk_obj.SetPolys,
                        my_arg[0])
        self.trait_property_changed('polys', old_val, arg)
    polys = traits.Property(_get_polys, _set_polys, desc=\
        r"""
        Get the cell array defining polygons. If there are no polygons,
        an empty array will be returned (convenience to simplify
        traversal).
        """
    )

    def _get_strips(self):
        return wrap_vtk(self._vtk_obj.GetStrips())
    def _set_strips(self, arg):
        old_val = self._get_strips()
        my_arg = deref_array([arg], [['vtkCellArray']])
        self._wrap_call(self._vtk_obj.SetStrips,
                        my_arg[0])
        self.trait_property_changed('strips', old_val, arg)
    strips = traits.Property(_get_strips, _set_strips, desc=\
        r"""
        Get the cell array defining triangle strips. If there are no
        triangle strips, an empty array will be returned (convenience to
        simplify traversal).
        """
    )

    def _get_verts(self):
        return wrap_vtk(self._vtk_obj.GetVerts())
    def _set_verts(self, arg):
        old_val = self._get_verts()
        my_arg = deref_array([arg], [['vtkCellArray']])
        self._wrap_call(self._vtk_obj.SetVerts,
                        my_arg[0])
        self.trait_property_changed('verts', old_val, arg)
    verts = traits.Property(_get_verts, _set_verts, desc=\
        r"""
        Get the cell array defining vertices. If there are no vertices,
        an empty array will be returned (convenience to simplify
        traversal).
        """
    )

    def get_cell_edge_neighbors(self, *args):
        """
        get_cell_edge_neighbors(self, cellId:int, p1:int, p2:int,
            cellIds:IdList) -> None
        C++: void get_cell_edge_neighbors(IdType cellId, IdType p1,
            IdType p2, IdList *cellIds)
        Get the neighbors at an edge. More efficient than the general
        get_cell_neighbors(). Assumes links have been built (with
        build_links()), and looks specifically for edge neighbors.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetCellEdgeNeighbors, *my_args)
        return ret

    def get_cell_id_relative_to_cell_array(self, *args):
        """
        get_cell_id_relative_to_cell_array(self, cellId:int) -> int
        C++: IdType get_cell_id_relative_to_cell_array(IdType cellId)
        Maps the cell at position `cellId` inside the `vtkpoly_data` to
        its location in the corresponding cell array. For instance, if
        cell `cellId` is a line, then this method returns the position of
        this cell in the `Lines` cell array.
        """
        ret = self._wrap_call(self._vtk_obj.GetCellIdRelativeToCellArray, *args)
        return ret

    def get_cells_bounds(self, *args):
        """
        get_cells_bounds(self, bounds:[float, float, float, float, float,
            float]) -> None
        C++: void get_cells_bounds(double bounds[6])
        Get the cells bounds. Internally calls compute_cells_bounds().
        @sa compute_cells_bounds()
        """
        ret = self._wrap_call(self._vtk_obj.GetCellsBounds, *args)
        return ret

    def _get_ghost_level(self):
        return self._vtk_obj.GetGhostLevel()
    ghost_level = traits.Property(_get_ghost_level, desc=\
        r"""
        Get the ghost level.
        """
    )

    def _get_mesh_m_time(self):
        return self._vtk_obj.GetMeshMTime()
    mesh_m_time = traits.Property(_get_mesh_m_time, desc=\
        r"""
        Return the mesh (geometry/topology) modification time. This time
        is different from the usual MTime which also takes into account
        the modification of data arrays. This function can be used to
        track the changes on the mesh separately from the data arrays
        (eg. static mesh over time with transient data).
        """
    )

    def _get_number_of_lines(self):
        return self._vtk_obj.GetNumberOfLines()
    number_of_lines = traits.Property(_get_number_of_lines, desc=\
        r"""
        
        """
    )

    def _get_number_of_pieces(self):
        return self._vtk_obj.GetNumberOfPieces()
    number_of_pieces = traits.Property(_get_number_of_pieces, desc=\
        r"""
        
        """
    )

    def _get_number_of_polys(self):
        return self._vtk_obj.GetNumberOfPolys()
    number_of_polys = traits.Property(_get_number_of_polys, desc=\
        r"""
        
        """
    )

    def _get_number_of_strips(self):
        return self._vtk_obj.GetNumberOfStrips()
    number_of_strips = traits.Property(_get_number_of_strips, desc=\
        r"""
        
        """
    )

    def _get_number_of_verts(self):
        return self._vtk_obj.GetNumberOfVerts()
    number_of_verts = traits.Property(_get_number_of_verts, desc=\
        r"""
        Return the number of primitives of a particular type held.
        """
    )

    def _get_piece(self):
        return self._vtk_obj.GetPiece()
    piece = traits.Property(_get_piece, desc=\
        r"""
        Get the piece and the number of pieces. Similar to extent in 3D.
        """
    )

    def get_scalar_field_critical_index(self, *args):
        """
        get_scalar_field_critical_index(self, pointId:int,
            scalarField:DataArray) -> int
        C++: int get_scalar_field_critical_index(IdType pointId,
            DataArray *scalarField)
        get_scalar_field_critical_index(self, pointId:int, fieldId:int) -> int
        C++: int get_scalar_field_critical_index(IdType pointId,
            int fieldId)
        get_scalar_field_critical_index(self, pointId:int, fieldName:str)
            -> int
        C++: int get_scalar_field_critical_index(IdType pointId,
            const char *fieldName)"""
        my_args = deref_array(args, [('int', 'vtkDataArray'), ('int', 'int'), ('int', 'string')])
        ret = self._wrap_call(self._vtk_obj.GetScalarFieldCriticalIndex, *my_args)
        return ret

    def add_cell_reference(self, *args):
        """
        add_cell_reference(self, cellId:int) -> None
        C++: void add_cell_reference(IdType cellId)
        Add references to cell in cell structure. This means the links
        from the cell's points to the cell are modified. Memory is not
        extended. Use the method resize_cell_list() to resize the link list
        from a point to its using cells. (This operator assumes
        build_links() has been called.) Use this method only when the
        dataset is set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.AddCellReference, *args)
        return ret

    def add_reference_to_cell(self, *args):
        """
        add_reference_to_cell(self, ptId:int, cellId:int) -> None
        C++: void add_reference_to_cell(IdType ptId, IdType cellId)
        Add a reference to a cell in a particular point's link list. (You
        may also consider using add_cell_reference() to add the references
        from all the cell's points to the cell.) This operator does not
        realloc memory; use the operator resize_cell_list() to do this if
        necessary. Use this method only when the dataset is set as
        Editable.
        """
        ret = self._wrap_call(self._vtk_obj.AddReferenceToCell, *args)
        return ret

    def allocate(self, *args):
        """
        allocate(self, numCells:int=1000, extSize:int=1000) -> None
        C++: void allocate(IdType numCells=1000, int extSize=1000)
        allocate(self, inPolyData:PolyData, numCells:int=1000,
            extSize:int=1000) -> None
        C++: void allocate(PolyData *inPolyData,
            IdType numCells=1000, int extSize=1000)
        Method allocates initial storage for vertex, line, polygon, and
        triangle strip arrays. Use this method before the method
        poly_data::insert_next_cell(). (Or, provide vertex, line, polygon,
        and triangle strip cell arrays). extSize is no longer used.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Allocate, *my_args)
        return ret

    def allocate_copy(self, *args):
        """
        allocate_copy(self, pd:PolyData) -> bool
        C++: bool allocate_copy(PolyData *pd)
        Preallocate memory for the internal cell arrays such that they
        are the same size as those in pd.
        
        Existing data is not preserved and the number of cells is set to
        zero.
        
        @return True if allocation succeeds.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AllocateCopy, *my_args)
        return ret

    def allocate_estimate(self, *args):
        """
        allocate_estimate(self, numCells:int, maxCellSize:int) -> bool
        C++: bool allocate_estimate(IdType numCells,
            IdType maxCellSize)
        allocate_estimate(self, numVerts:int, maxVertSize:int,
            numLines:int, maxLineSize:int, numPolys:int, maxPolySize:int,
            numStrips:int, maxStripSize:int) -> bool
        C++: bool allocate_estimate(IdType numVerts,
            IdType maxVertSize, IdType numLines,
            IdType maxLineSize, IdType numPolys,
            IdType maxPolySize, IdType numStrips,
            IdType maxStripSize)
        Preallocate memory for the internal cell arrays. Each of the
        internal cell arrays (verts, lines, polys, and strips) will be
        resized to holdnumCells cells of size maxcell_size.
        
        Existing data is not preserved and the number of cells is set to
        zero.
        
        @return True if allocation succeeds.
        """
        ret = self._wrap_call(self._vtk_obj.AllocateEstimate, *args)
        return ret

    def allocate_exact(self, *args):
        """
        allocate_exact(self, numCells:int, connectivitySize:int) -> bool
        C++: bool allocate_exact(IdType numCells,
            IdType connectivitySize)
        allocate_exact(self, numVerts:int, vertConnSize:int, numLines:int,
            lineConnSize:int, numPolys:int, polyConnSize:int,
            numStrips:int, stripConnSize:int) -> bool
        C++: bool allocate_exact(IdType numVerts,
            IdType vertConnSize, IdType numLines,
            IdType lineConnSize, IdType numPolys,
            IdType polyConnSize, IdType numStrips,
            IdType stripConnSize)
        Preallocate memory for the internal cell arrays. Each of the
        internal cell arrays (verts, lines, polys, and strips) will be
        resized to holdnumCells cells and connectivitySize pointIds.
        
        Existing data is not preserved and the number of cells is set to
        zero.
        
        @return True if allocation succeeds.
        """
        ret = self._wrap_call(self._vtk_obj.AllocateExact, *args)
        return ret

    def allocate_proportional(self, *args):
        """
        allocate_proportional(self, pd:PolyData, ratio:float) -> bool
        C++: bool allocate_proportional(PolyData *pd, double ratio)
        Preallocate memory for the internal cell arrays such that they
        are proportional to those in pd by a factor of ratio (for
        instance,ratio = 2 allocates twice as many cells).
        
        Existing data is not preserved and the number of cells is set to
        zero.
        
        @return True if allocation succeeds.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AllocateProportional, *my_args)
        return ret

    def build_cells(self):
        """
        build_cells(self) -> None
        C++: void build_cells()
        Create data structure that allows random access of cells.
        build_cells is expensive but necessary to make use of the faster
        non-virtual implementations of get_cell/get_cell_points. One may
        check if cells need to be built via need_to_builds before invoking.
        Cells always need to be built/re-built after low level direct
        modifications to verts, lines, polys or strips cell arrays.
        """
        ret = self._vtk_obj.BuildCells()
        return ret
        

    def build_links(self, *args):
        """
        build_links(self, initialSize:int=0) -> None
        C++: void build_links(int initialSize=0)
        Create upward links from points to cells that use each point.
        Enables topologically complex queries. Normally the links array
        is allocated based on the number of points in the PolyData.
        The optional initialSize parameter can be used to allocate a
        larger size initially.
        """
        ret = self._wrap_call(self._vtk_obj.BuildLinks, *args)
        return ret

    def compute_cells_bounds(self):
        """
        compute_cells_bounds(self) -> None
        C++: void compute_cells_bounds()
        Compute the (X, Y, Z)  bounds of the data. Note that the method
        only considers points that are used by cells. This is done for
        usability and historical reasons.
        
        IMPORTANT
        
        Until vtk 9.0.1, PolyData::ComputeBounds() used to ignore
        points that do not belong to any cell. That was not consistent
        with other PointSet subclasses and thus was error prone. See
        this para_view issue
        https://gitlab.kitware.com/paraview/paraview/-/issues/20354 Now
        it defers to PointSet::ComputeBounds() so
        PolyData::GetBounds() may not return the same bounds as
        before. This behavior is probably the one you want when using
        bounds.
        
        The previous behavior is still availble through
        PolyData::ComputeCellsBounds() and
        PolyData::GetCellsBounds(). This is mainly used for rendering
        purpose.
        """
        ret = self._vtk_obj.ComputeCellsBounds()
        return ret
        

    def copy_cells(self, *args):
        """
        copy_cells(self, pd:PolyData, idList:IdList,
            locator:IncrementalPointLocator=...) -> None
        C++: void copy_cells(PolyData *pd, IdList *idList,
            IncrementalPointLocator *locator=nullptr)
        Copy cells listed in idList from pd, including points, point
        data, and cell data.  This method assumes that point and cell
        data have been allocated.  If you pass in a point locator, then
        the points won't be duplicated in the output. This requires the
        use of an incremental point locator.
        """
        my_args = deref_array(args, [('vtkPolyData', 'vtkIdList', 'vtkIncrementalPointLocator')])
        ret = self._wrap_call(self._vtk_obj.CopyCells, *my_args)
        return ret

    def delete_cell(self, *args):
        """
        delete_cell(self, cellId:int) -> None
        C++: void delete_cell(IdType cellId)"""
        ret = self._wrap_call(self._vtk_obj.DeleteCell, *args)
        return ret

    def delete_cells(self):
        """
        delete_cells(self) -> None
        C++: void delete_cells()
        Release data structure that allows random access of the cells.
        This must be done before a 2nd call to build_links(). delete_cells
        implicitly deletes the links as well since they are no longer
        valid.
        """
        ret = self._vtk_obj.DeleteCells()
        return ret
        

    def delete_links(self):
        """
        delete_links(self) -> None
        C++: void delete_links()
        Release the upward links from point to cells that use each point.
        """
        ret = self._vtk_obj.DeleteLinks()
        return ret
        

    def delete_point(self, *args):
        """
        delete_point(self, ptId:int) -> None
        C++: void delete_point(IdType ptId)
        Mark a point/cell as deleted from this PolyData. Use this
        method only when the dataset is set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.DeletePoint, *args)
        return ret

    def insert_next_cell(self, *args):
        """
        insert_next_cell(self, type:int, npts:int, pts:(int, ...)) -> int
        C++: IdType insert_next_cell(int type, int npts,
            const IdType pts[])
        insert_next_cell(self, type:int, pts:IdList) -> int
        C++: IdType insert_next_cell(int type, IdList *pts)
        Insert a cell of type VTK_VERTEX, VTK_POLY_VERTEX, VTK_LINE,
        VTK_POLY_LINE, VTK_TRIANGLE, VTK_QUAD, VTK_POLYGON, or
        VTK_TRIANGLE_STRIP.  Make sure that the poly_data::Allocate()
        function has been called first or that vertex, line, polygon, and
        triangle strip arrays have been supplied. Note: will also insert
        VTK_PIXEL, but converts it to VTK_QUAD.
        """
        my_args = deref_array(args, [('int', 'int', ('int', Ellipsis)), ('int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.InsertNextCell, *my_args)
        return ret

    def insert_next_linked_cell(self, *args):
        """
        insert_next_linked_cell(self, type:int, npts:int, pts:(int, ...))
            -> int
        C++: IdType insert_next_linked_cell(int type, int npts,
            const IdType pts[])
        Add a new cell to the cell data structure (after cell pointers
        have been built). This method adds the cell and then updates the
        links from the points to the cells. (Memory is allocated as
        necessary.) Use this method only when the dataset is set as
        Editable.
        """
        ret = self._wrap_call(self._vtk_obj.InsertNextLinkedCell, *args)
        return ret

    def insert_next_linked_point(self, *args):
        """
        insert_next_linked_point(self, numLinks:int) -> int
        C++: IdType insert_next_linked_point(int numLinks)
        insert_next_linked_point(self, x:[float, float, float], numLinks:int)
             -> int
        C++: IdType insert_next_linked_point(double x[3], int numLinks)
        Add a point to the cell data structure (after cell pointers have
        been built). This method adds the point and then allocates memory
        for the links to the cells.  (To use this method, make sure
        points are available and build_links() has been invoked.) Of the
        two methods below, one inserts a point coordinate and the other
        just makes room for cell links. Use this method only when the
        dataset is set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.InsertNextLinkedPoint, *args)
        return ret

    def is_edge(self, *args):
        """
        is_edge(self, p1:int, p2:int) -> int
        C++: int is_edge(IdType p1, IdType p2)
        Determine whether two points form an edge. If they do, return
        non-zero. By definition poly_vertex and poly_line have no edges
        since 1-dimensional edges are only found on cells 2D and higher.
        Edges are defined as 1-D boundary entities to cells. Make sure
        build_links() has been called first.
        """
        ret = self._wrap_call(self._vtk_obj.IsEdge, *args)
        return ret

    def is_point_used_by_cell(self, *args):
        """
        is_point_used_by_cell(self, ptId:int, cellId:int) -> int
        C++: int is_point_used_by_cell(IdType ptId, IdType cellId)
        Determine whether a point is used by a particular cell. If it is,
        return non-zero. Make sure build_cells() has been called first.
        """
        ret = self._wrap_call(self._vtk_obj.IsPointUsedByCell, *args)
        return ret

    def is_triangle(self, *args):
        """
        is_triangle(self, v1:int, v2:int, v3:int) -> int
        C++: int is_triangle(int v1, int v2, int v3)
        Given three vertices, determine whether it's a triangle. Make
        sure build_links() has been called first.
        """
        ret = self._wrap_call(self._vtk_obj.IsTriangle, *args)
        return ret

    def need_to_build_cells(self):
        """
        need_to_build_cells(self) -> bool
        C++: bool need_to_build_cells()
        Check if build_cells is needed.
        """
        ret = self._vtk_obj.NeedToBuildCells()
        return ret
        

    def remove_cell_reference(self, *args):
        """
        remove_cell_reference(self, cellId:int) -> None
        C++: void remove_cell_reference(IdType cellId)
        Remove all references to cell in cell structure. This means the
        links from the cell's points to the cell are deleted. Memory is
        not reclaimed. Use the method resize_cell_list() to resize the link
        list from a point to its using cells. (This operator assumes
        build_links() has been called.) Use this method only when the
        dataset is set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveCellReference, *args)
        return ret

    def remove_deleted_cells(self):
        """
        remove_deleted_cells(self) -> None
        C++: void remove_deleted_cells()
        The cells marked by calls to delete_cell are stored in the Cell
        Array VTK_EMPTY_CELL, but they still exist in the cell arrays. 
        Calling remove_deleted_cells will traverse the cell arrays and
        remove/compact the cell arrays as well as any cell data thus
        truly removing the cells from the polydata object. Use this
        method only when the dataset is set as Editable.
        """
        ret = self._vtk_obj.RemoveDeletedCells()
        return ret
        

    def remove_ghost_cells(self):
        """
        remove_ghost_cells(self) -> None
        C++: void remove_ghost_cells()
        This method will remove any cell that is marked as ghost (has the
        DataSetAttributes::DUPLICATECELL or the
        DataSetAttributes::HIDDENCELL bit set). It does not remove
        unused points.
        """
        ret = self._vtk_obj.RemoveGhostCells()
        return ret
        

    def remove_reference_to_cell(self, *args):
        """
        remove_reference_to_cell(self, ptId:int, cellId:int) -> None
        C++: void remove_reference_to_cell(IdType ptId, IdType cellId)
        Remove a reference to a cell in a particular point's link list.
        You may also consider using remove_cell_reference() to remove the
        references from all the cell's points to the cell. This operator
        does not reallocate memory; use the operator resize_cell_list() to
        do this if necessary. Use this method only when the dataset is
        set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveReferenceToCell, *args)
        return ret

    def replace_cell(self, *args):
        """
        replace_cell(self, cellId:int, ids:IdList) -> None
        C++: void replace_cell(IdType cellId, IdList *ids)
        replace_cell(self, cellId:int, npts:int, pts:(int, ...)) -> None
        C++: void replace_cell(IdType cellId, int npts,
            const IdType pts[])"""
        my_args = deref_array(args, [('int', 'vtkIdList'), ('int', 'int', ('int', Ellipsis))])
        ret = self._wrap_call(self._vtk_obj.ReplaceCell, *my_args)
        return ret

    def replace_cell_point(self, *args):
        """
        replace_cell_point(self, cellId:int, oldPtId:int, newPtId:int)
            -> None
        C++: void replace_cell_point(IdType cellId, IdType oldPtId,
            IdType newPtId)
        Replace a point in the cell connectivity list with a different
        point. Use this method only when the dataset is set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.ReplaceCellPoint, *args)
        return ret

    def replace_linked_cell(self, *args):
        """
        replace_linked_cell(self, cellId:int, npts:int, pts:(int, ...))
            -> None
        C++: void replace_linked_cell(IdType cellId, int npts,
            const IdType pts[])
        Replace one cell with another in cell structure. This operator
        updates the connectivity list and the point's link list. It does
        not delete references to the old cell in the point's link list.
        Use the operator remove_cell_reference() to delete all references
        from points to (old) cell.  You may also want to consider using
        the operator resize_cell_list() if the link list is changing size.
        Use this method only when the dataset is set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.ReplaceLinkedCell, *args)
        return ret

    def reset(self):
        """
        reset(self) -> None
        C++: void reset()
        Begin inserting data all over again. Memory is not freed but
        otherwise objects are returned to their initial state.
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def resize_cell_list(self, *args):
        """
        resize_cell_list(self, ptId:int, size:int) -> None
        C++: void resize_cell_list(IdType ptId, int size)
        Resize the list of cells using a particular point. (This operator
        assumes that build_links() has been called.) Use this method only
        when the dataset is set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.ResizeCellList, *args)
        return ret

    def reverse_cell(self, *args):
        """
        reverse_cell(self, cellId:int) -> None
        C++: void reverse_cell(IdType cellId)
        Reverse the order of point ids defining the cell. Use this method
        only when the dataset is set as Editable.
        """
        ret = self._wrap_call(self._vtk_obj.ReverseCell, *args)
        return ret

    _updateable_traits_ = \
    (('editable', 'GetEditable'), ('global_release_data_flag',
    'GetGlobalReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'editable', 'global_release_data_flag',
    'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolyData, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['editable', 'global_release_data_flag'], [], []),
            title='Edit PolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

