# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class VectorFieldTopology(PolyDataAlgorithm):
    r"""
    VectorFieldTopology - Extract the topological skeleton as output
    datasets
    
    Superclass: PolyDataAlgorithm
    
    VectorFieldTopology is a filter that extracts the critical points
    and the 1D separatrices (lines) If the data is 3D and the user
    enables compute_surfaces, also the 2D separatrices are computed
    (surfaces)
    
    @par Thanks: Developed by Roxana Bujack and Karen Tsai at Los Alamos
    National Laboratory under LDRD 20190143ER
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVectorFieldTopology, obj, update, **traits)
    
    compute_surfaces = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Specify/see if the separatring surfaces (separatrices in 3D) are
        computed or not
        """
    )

    def _compute_surfaces_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeSurfaces,
                        self.compute_surfaces)

    exclude_boundary = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Specify/see if the boundary cells are treated or not
        """
    )

    def _exclude_boundary_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExcludeBoundary,
                        self.exclude_boundary)

    integration_step_size = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the Initial, minimum, and maximum step size used for line
        integration, expressed in integration_step_unit
        """
    )

    def _integration_step_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntegrationStepSize,
                        self.integration_step_size)

    integration_step_unit = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        Specify a uniform integration step unit for
        minimum_integration_step, initial_integration_step, and
        maximum_integration_step. 1 = LENGTH_UNIT, i.e. all sizes are
        expresed in coordinate scale or cell scale 2 = CELL_LENGTH_UNIT,
        i.e. all sizes are expresed in cell scale
        """
    )

    def _integration_step_unit_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntegrationStepUnit,
                        self.integration_step_unit)

    max_num_steps = traits.Int(100, enter_set=True, auto_set=False, desc=\
        r"""
        Specify/see the maximal number of iterations in this class and in
        StreamTracer
        """
    )

    def _max_num_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxNumSteps,
                        self.max_num_steps)

    offset_away_from_boundary = traits.Float(0.001, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the offset_away_from_boundary to shift seeds for computing
        separating lines/surfaces
        """
    )

    def _offset_away_from_boundary_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOffsetAwayFromBoundary,
                        self.offset_away_from_boundary)

    separatrix_distance = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Specify/see the distance by which the seedpoints of the
        separatrices are placed away from the saddle expressed in
        integration_step_unit
        """
    )

    def _separatrix_distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSeparatrixDistance,
                        self.separatrix_distance)

    use_boundary_switch_points = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Specify/see whether to use boundary switch points/lines points as
        seeds or not
        """
    )

    def _use_boundary_switch_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseBoundarySwitchPoints,
                        self.use_boundary_switch_points)

    use_iterative_seeding = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Specify/see if the simple (fast) or iterative (correct) version
        is called
        """
    )

    def _use_iterative_seeding_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseIterativeSeeding,
                        self.use_iterative_seeding)

    vector_angle_threshold = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the vector_angle_threshold to remove noisy boundary switch
        points/lines When computing boundary switch point, if the vecotrs
        of the two points within a cell are almost parallel, the boundary
        switch point computed is considered as a noise point. Let v0 and
        v1 be the vectors of the two points, and their norm equal to 1.
        The dot product between them Dot(v0,v1) = cos(theta), where theta
        is the angle between v0 and v1. When v0 and v1 are almost
        parallel, abs(Dot(v0,v1)) is close to 1. The range of this
        threshold is [0,1]. For any abs(Dot(v0,v1)) >
        vector_angle_threshold, the boundary switch point computed is a
        noise point.
        """
    )

    def _vector_angle_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVectorAngleThreshold,
                        self.vector_angle_threshold)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_interpolator_type(self, *args):
        """
        set_interpolator_type(self, interpType:int) -> None
        C++: void set_interpolator_type(int interpType)
        Set the type of the velocity field interpolator to determine
        whether InterpolatedVelocityField
        (INTERPOLATOR_WITH_DATASET_POINT_LOCATOR) or
        CellLocatorInterpolatedVelocityField
        (INTERPOLATOR_WITH_CELL_LOCATOR) is employed for locating cells
        during streamline integration.
        """
        ret = self._wrap_call(self._vtk_obj.SetInterpolatorType, *args)
        return ret

    def set_interpolator_type_to_cell_locator(self):
        """
        set_interpolator_type_to_cell_locator(self) -> None
        C++: void set_interpolator_type_to_cell_locator()
        Set the velocity field interpolator type to the one involving a
        cell locator.
        """
        ret = self._vtk_obj.SetInterpolatorTypeToCellLocator()
        return ret
        

    def set_interpolator_type_to_data_set_point_locator(self):
        """
        set_interpolator_type_to_data_set_point_locator(self) -> None
        C++: void set_interpolator_type_to_data_set_point_locator()
        Set the velocity field interpolator type to the one involving a
        dataset point locator.
        """
        ret = self._vtk_obj.SetInterpolatorTypeToDataSetPointLocator()
        return ret
        

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('compute_surfaces', 'GetComputeSurfaces'), ('exclude_boundary',
    'GetExcludeBoundary'), ('integration_step_size',
    'GetIntegrationStepSize'), ('integration_step_unit',
    'GetIntegrationStepUnit'), ('max_num_steps', 'GetMaxNumSteps'),
    ('offset_away_from_boundary', 'GetOffsetAwayFromBoundary'),
    ('separatrix_distance', 'GetSeparatrixDistance'),
    ('use_boundary_switch_points', 'GetUseBoundarySwitchPoints'),
    ('use_iterative_seeding', 'GetUseIterativeSeeding'),
    ('vector_angle_threshold', 'GetVectorAngleThreshold'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'compute_surfaces', 'exclude_boundary',
    'integration_step_size', 'integration_step_unit', 'max_num_steps',
    'offset_away_from_boundary', 'progress_text', 'separatrix_distance',
    'use_boundary_switch_points', 'use_iterative_seeding',
    'vector_angle_threshold'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VectorFieldTopology, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VectorFieldTopology properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['compute_surfaces', 'exclude_boundary',
            'integration_step_size', 'integration_step_unit', 'max_num_steps',
            'offset_away_from_boundary', 'separatrix_distance',
            'use_boundary_switch_points', 'use_iterative_seeding',
            'vector_angle_threshold']),
            title='Edit VectorFieldTopology properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VectorFieldTopology properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

