/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Natural logarithm of `1/2`.
*
* @module @stdlib/constants/float64/ln-half
* @type {number}
*
* @example
* var LN_HALF = require( '@stdlib/constants/float64/ln-half' );
* // returns -0.6931471805599453
*/


// MAIN //

/**
* Natural logarithm of `1/2`.
*
* ```tex
* \ln (1/2)
* ```
*
* @constant
* @type {number}
* @default -0.6931471805599453
*/
var LN_HALF = -0.69314718055994530941723212145817656807550013436025525412;


// EXPORTS //

module.exports = LN_HALF;
