/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.Site;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.service.PortalService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.SiteService;
import org.chefproject.util.Menu;
import org.chefproject.util.Reference;
import org.chefproject.util.StringUtil;

public class IFrameAction
extends VelocityPortletPaneledAction {
    private static final String SOURCE = "source";
    private static final String HEIGHT = "height";
    private static final String SPECIAL = "special";
    private static final String TITLE = "title";
    private static final String UPDATE = "update";

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        PortletConfig config = portlet.getPortletConfig();
        if (state.getAttribute(SOURCE) == null) {
            String special = StringUtil.trimToNull(config.getInitParameter(SPECIAL));
            if (special == null) {
                if ("true".equals(config.getInitParameter("site"))) {
                    special = "site";
                } else if ("true".equals(config.getInitParameter("workspace"))) {
                    special = "workspace";
                } else if ("true".equals(config.getInitParameter("worksite"))) {
                    special = "worksite";
                }
            }
            if (special == null) {
                special = "";
            }
            state.setAttribute(SPECIAL, (Object)special);
            String url = StringUtil.trimToNull(config.getInitParameter(SOURCE));
            if (url == null) {
                url = StringUtil.trimToNull(config.getInitParameter("url"));
            }
            state.setAttribute("source-config", (Object)url);
            url = this.sourceUrl(special, url, rundata);
            state.setAttribute(SOURCE, (Object)url);
        }
        if (state.getAttribute(HEIGHT) == null) {
            state.setAttribute(HEIGHT, (Object)config.getInitParameter(HEIGHT));
        }
        if (state.getAttribute(TITLE) == null) {
            PortletInstance instance = PersistenceManager.getInstance((Portlet)portlet, (RunData)rundata);
            Entry entry = instance.getEntry();
            state.setAttribute(TITLE, (Object)entry.getTitle());
        }
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        if ("options".equals(state.getAttribute("mode"))) {
            return this.buildOptionsPanelContext(portlet, context, rundata, state);
        }
        context.put(SOURCE, state.getAttribute(SOURCE));
        context.put(HEIGHT, state.getAttribute(HEIGHT));
        context.put("action", state.getAttribute("action"));
        Menu bar = new Menu((Portlet)portlet, rundata, "IFrameAction");
        this.addOptionsMenu(bar, (JetspeedRunData)rundata);
        if (bar.getItems().hasNext()) {
            context.put("menu", bar);
        }
        return (String)this.getContext(rundata).get("template");
    }

    public String buildOptionsPanelContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        context.put(SOURCE, state.getAttribute("source-config"));
        context.put(HEIGHT, state.getAttribute(HEIGHT));
        context.put(TITLE, state.getAttribute(TITLE));
        context.put(SPECIAL, state.getAttribute(SPECIAL));
        context.put("action", "IFrameAction");
        context.put("doUpdate", "eventSubmit_doConfigure_update");
        context.put("doCancel", "eventSubmit_doCancel");
        String template = (String)this.getContext(data).get("template");
        return template + "-customize";
    }

    public void doConfigure_update(RunData data, Context context) {
        String title;
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        String special = data.getParameters().getString(SPECIAL);
        if (!special.equals(state.getAttribute(SPECIAL))) {
            state.setAttribute(SPECIAL, (Object)special);
        }
        String source = "";
        if (((String)state.getAttribute(SPECIAL)).length() == 0) {
            source = data.getParameters().getString(SOURCE);
            if ((source = source.trim()).length() > 0 && !source.startsWith("/") && source.indexOf("://") == -1) {
                source = "http://" + source;
            }
        }
        state.setAttribute("source-config", (Object)source);
        source = this.sourceUrl(special, source, (JetspeedRunData)data);
        state.setAttribute(SOURCE, (Object)source);
        String height = data.getParameters().getString(HEIGHT);
        if (!height.equals(state.getAttribute(HEIGHT))) {
            state.setAttribute(HEIGHT, (Object)height);
        }
        if (!(title = data.getParameters().getString(TITLE)).equals(state.getAttribute(TITLE))) {
            state.setAttribute(TITLE, (Object)title);
        }
        ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
        tool.getPropertiesEdit().addProperty(HEIGHT, (String)state.getAttribute(HEIGHT));
        tool.getPropertiesEdit().addProperty(SPECIAL, (String)state.getAttribute(SPECIAL));
        tool.getPropertiesEdit().addProperty(SOURCE, (String)state.getAttribute("source-config"));
        tool.setTitle((String)state.getAttribute(TITLE));
        this.saveOptions();
        state.removeAttribute("mode");
    }

    public void doCancel(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        this.cancelOptions();
        state.removeAttribute("mode");
    }

    private String convertReferenceUrl(String url) {
        Reference ref = new Reference(url);
        if (ref.getType() == null) {
            return url;
        }
        return ref.getUrl();
    }

    private String sourceUrl(String special, String url, JetspeedRunData rundata) {
        if (url == null || url.trim().length() == 0) {
            if ("site".equals(special)) {
                url = ServerConfigurationService.getString("site.intro.url", "");
            } else if ("workspace".equals(special)) {
                url = ServerConfigurationService.getString("site.user.url", "");
            } else if ("worksite".equals(special)) {
                String siteId = PortalService.getCurrentSiteId();
                try {
                    Site s = SiteService.getSite(siteId);
                    url = StringUtil.trimToNull(s.getInfoUrl());
                    if (url == null) {
                        url = s.getUrl();
                    }
                }
                catch (Exception any) {
                    // empty catch block
                }
            }
        }
        if (url != null) {
            url = url.trim();
            url = this.convertReferenceUrl(url);
        }
        return url;
    }

    protected boolean requireResetToolLink() {
        return false;
    }

    static {
        SOURCE = SOURCE;
        HEIGHT = HEIGHT;
        SPECIAL = SPECIAL;
        TITLE = TITLE;
        UPDATE = UPDATE;
    }
}

