#ifndef _KALLOC_H_
#define _KALLOC_H_

#include <stddef.h> /* for size_t */

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
    size_t capacity, available, n_blocks, n_cores, largest;
} km_stat_t;

void* kmalloc(void* km, size_t size);
void* krealloc(void* km, void* ptr, size_t size);
void* kcalloc(void* km, size_t count, size_t size);
void kfree(void* km, void* ptr);

void* km_init(void);
void km_destroy(void* km);
void km_stat(const void* _km, km_stat_t* s);

#ifdef __cplusplus
}
#endif

#endif
