/**************************************************************************
 **                                                                      **
 ** Copyright (C) 2011-2026 Lukas Spies                                  **
 ** Contact: https://photoqt.org                                         **
 **                                                                      **
 ** This file is part of PhotoQt.                                        **
 **                                                                      **
 ** PhotoQt is free software: you can redistribute it and/or modify      **
 ** it under the terms of the GNU General Public License as published by **
 ** the Free Software Foundation, either version 2 of the License, or    **
 ** (at your option) any later version.                                  **
 **                                                                      **
 ** PhotoQt is distributed in the hope that it will be useful,           **
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
 ** GNU General Public License for more details.                         **
 **                                                                      **
 ** You should have received a copy of the GNU General Public License    **
 ** along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      **
 **                                                                      **
 **************************************************************************/
#pragma once

#include <QObject>
#include <QDir>
#include <QTimer>

/*************************************************************/
/*************************************************************/
//
// this class is heavily used in both C++ and QML code
// thus there is a WRAPPER for QML available
//
/*************************************************************/
/*************************************************************/

class PQCScriptsFilesPaths : public QObject {

    Q_OBJECT

public:
    static PQCScriptsFilesPaths& get();
    virtual ~PQCScriptsFilesPaths();

    PQCScriptsFilesPaths(PQCScriptsFilesPaths const&)     = delete;
    void operator=(PQCScriptsFilesPaths const&) = delete;

    // path methods
    QString cleanPath(QString path);
    QString cleanPath_windows(QString path);
    QString pathWithNativeSeparators(QString path);
    QString pathFromNativeSeparators(QString path);
    QString toPercentEncoding(QString str);
    QString fromPercentEncoding(QString str);
    QString handleAnimatedImagePathAndEncode(QString path);
    QString getSuffix(QString path);
    QString getSuffixLowerCase(QString path);
    QString getCompleteSuffix(QString path);
    QString getCompleteSuffixLowerCase(QString path);
    QString getBasename(QString fullpath);
    QString getFilename(QString fullpath);
    QString getDir(QString fullpath);
    QString getDirname(const QString fullpath);
    bool    isUrl(QString path);
    bool    areDirsTheSame(QString folder1, QString folder2);

    // folder methods
    bool        isFolder(QString path);
    QStringList getFoldersIn(QString path);
    QString     goUpOneLevel(QString path);
    bool        isExcludeDirFromCaching(QString filename);

    // file methods
    QDateTime getFileModified(QString path);
    QString   getFileType(QString path);
    QString   getFileSizeHumanReadable(QString path);
    double    convertBytesToGB(const qint64 bytes);
    QString   createTooltipFilename(QString fname);
    void      openInDefaultFileManager(QString filename);

    // folder and file methods
    bool doesItExist(QString path);
    bool isOnNetwork(QString filename);

    // get some fixed directories
    QString getHomeDir();
    QString getTempDir();
    QString findDropBoxFolder();
    QString findNextcloudFolder();
    QString findOwnCloudFolder();

    // windows methods
    QString getWindowsDriveLetter(QString path);

    // externally related
    QString     selectFileFromDialog(QString buttonlabel, QString preselectFile, int formatId, bool confirmOverwrite);
    QString     selectFileFromDialog(QString buttonlabel, QString preselectFile, bool confirmOverwrite);
    QString     selectFolderFromDialog(QString buttonlabel, QString preselectFolder);
    void        saveLogToFile(QString txt);
    QString     openFileFromDialog(QString buttonlabel, QString preselectFile, QStringList endings);
    QStringList openFilesFromDialog(QString buttonlabel, QString preselectFile, QStringList endings);
    QString     getExistingDirectory(QString startDir = QDir::homePath());
    void        cleanupTemporaryFiles();
    void        setThumbnailBaseCacheDir(QString dir);

    // navigating between folders
    QString getSiblingFile(const QString currentFile, const int direction, int &remainingIteration, int &remainingLevelUp, int &remainingLevelDown);
    QString _findFirstFileinFolderAndSubFolder(const QString folder, const bool ascendingFolder, int &remainingIteration, int &remainingDescending);
    void _sortList(QStringList &lst, const bool ascending);


private:
    PQCScriptsFilesPaths();

    int animatedImageTemporaryCounter;

    QTimer networkSharesTimer;
    QStringList networkshares;

private Q_SLOTS:
    void detectNetworkShares();

};
