#
# Copyright 2019 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#
# == Define: glance::backend::multistore::rbd
#
# configures the storage backend for glance as a rbd instance
#
# === Parameters:
#
# [*rbd_store_user*]
#   Optional. Default: $facts['os_service_default'].
#
# [*rbd_store_pool*]
#   Optional. Default: $facts['os_service_default'].
#
# [*rbd_store_ceph_conf*]
#   Optional. Default: $facts['os_service_default'].
#
# [*rbd_store_chunk_size*]
#   Optional. Default: $facts['os_service_default'].
#
# [*rbd_thin_provisioning*]
#   Optional. Boolean describing if thin provisioning is enabled or not
#   Defaults to $facts['os_service_default']
#
# [*rados_connect_timeout*]
#   Optional. Timeout value (in seconds) used when connecting to ceph cluster.
#   Default: $facts['os_service_default'].
#
# [*store_description*]
#   (optional) Provides constructive information about the store backend to
#   end users.
#   Defaults to $facts['os_service_default'].
#
# [*weight*]
#   (optional) Define a relative weight for this store over any others that
#   are configured.
#   Defaults to $facts['os_service_default'].
#
# [*manage_packages*]
#   Optional. Whether we should manage the packages.
#   Defaults to true,
#
# [*package_ensure*]
#   Optional. Desired ensure state of packages.
#   accepts latest or specific versions.
#   Defaults to present.
#
define glance::backend::multistore::rbd (
  $rbd_store_user                         = $facts['os_service_default'],
  $rbd_store_ceph_conf                    = $facts['os_service_default'],
  $rbd_store_pool                         = $facts['os_service_default'],
  $rbd_store_chunk_size                   = $facts['os_service_default'],
  $rbd_thin_provisioning                  = $facts['os_service_default'],
  $rados_connect_timeout                  = $facts['os_service_default'],
  $store_description                      = $facts['os_service_default'],
  $weight                                 = $facts['os_service_default'],
  Boolean $manage_packages                = true,
  Stdlib::Ensure::Package $package_ensure = 'present',
) {
  include glance::deps
  include glance::params

  glance_api_config {
    "${name}/rbd_store_ceph_conf":   value => $rbd_store_ceph_conf;
    "${name}/rbd_store_user":        value => $rbd_store_user;
    "${name}/rbd_store_pool":        value => $rbd_store_pool;
    "${name}/rbd_store_chunk_size":  value => $rbd_store_chunk_size;
    "${name}/rbd_thin_provisioning": value => $rbd_thin_provisioning;
    "${name}/rados_connect_timeout": value => $rados_connect_timeout;
    "${name}/store_description":     value => $store_description;
    "${name}/weight":                value => $weight;
  }

  glance_cache_config {
    "${name}/rbd_store_ceph_conf":   value => $rbd_store_ceph_conf;
    "${name}/rbd_store_user":        value => $rbd_store_user;
    "${name}/rbd_store_pool":        value => $rbd_store_pool;
    "${name}/rbd_store_chunk_size":  value => $rbd_store_chunk_size;
    "${name}/rbd_thin_provisioning": value => $rbd_thin_provisioning;
    "${name}/rados_connect_timeout": value => $rados_connect_timeout;
    "${name}/weight":                value => $weight;
  }

  if $manage_packages {
    stdlib::ensure_packages('python-ceph', {
      ensure => $package_ensure,
      name   => $glance::params::pyceph_package_name,
      tag    => ['openstack', 'glance-support-package'],
    })
  }
}
