# Taking Ownership of pypdf

pypdf is currently maintained by stefan6419846. We want to avoid that
pypdf ever goes unmaintained again. This document serves as a guide to avoid
that if I become unavailable, e.g. due to severe health issues.

This currently is just an abstract scenario. I'm fine and I will likely do this
for several more years, but I have seen how projects stand still for many years
because of the maintainer becoming inactive.

## What belongs to pypdf?

The resources needed for maintaining pypdf are:

* PyPI: [pypdf](https://pypi.org/project/pypdf/) and [PyPDF2](https://pypi.org/project/PyPDF2/)
* Github: [pypdf](https://github.com/py-pdf/pypdf) (the repository, not the organization)
* ReadTheDocs: [pypdf](https://readthedocs.org/projects/pypdf/) and [PyPDF2](https://readthedocs.org/projects/pypdf2/)

## When may somebody take ownership?

**No activity in 180 days**: If I don't answer e-mails (see my GitHub profile)
and don't make any commits / merges for half a year, you can consider pypdf "not
maintained".

## Who may take ownership?

Preferably, one of the owners of the GitHub `py-pdf` organization takes care of
that.

As of 27th of August 2023, the following people might be candidates:

* [Lucas-C](https://github.com/Lucas-C): He maintains fpdf2 and is a py-pdf owner
* [pubpub-zz](https://github.com/pubpub-zz): He is one of the most active contributors
  to pypdf
* [Matthew Peveler](https://github.com/MasterOdin): Less active, but he is very
  careful about breaking changes and an experienced software developer.
* [exiledkingcc](https://github.com/exiledkingcc): He has contributed the core
  changes related to encryption.

## How to take ownership?

* PyPI: Follow [PEP 541 – Package Index Name Retention](https://peps.python.org/pep-0541/)
* GitHub: Talk with one of the other py-pdf organization owners
* ReadTheDocs: Follow the [Abandoned projects policy](https://docs.readthedocs.io/en/latest/abandoned-projects.html)
