import OCP.BRepSweep
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TopLoc
import OCP.Sweep
import OCP.TopoDS
import OCP.gp
import OCP.TopAbs
import OCP.BRep
__all__  = [
"BRepSweep_Builder",
"BRepSweep_Iterator",
"BRepSweep_NumLinearRegularSweep",
"BRepSweep_Prism",
"BRepSweep_Revol",
"BRepSweep_Trsf",
"BRepSweep_Tool",
"BRepSweep_Translation",
"BRepSweep_Rotation"
]
class BRepSweep_Builder():
    """
    implements the abstract Builder with the BRep Builder
    """
    @overload
    def Add(self,aShape1 : OCP.TopoDS.TopoDS_Shape,aShape2 : OCP.TopoDS.TopoDS_Shape,Orient : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Adds the Shape 1 in the Shape 2, set to <Orient> orientation.

        Adds the Shape 1 in the Shape 2.
        """
    @overload
    def Add(self,aShape1 : OCP.TopoDS.TopoDS_Shape,aShape2 : OCP.TopoDS.TopoDS_Shape) -> None: ...
    def Builder(self) -> OCP.BRep.BRep_Builder: 
        """
        None

        None
        """
    def MakeCompSolid(self,aCompSolid : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Returns an empty CompSolid.
        """
    def MakeCompound(self,aCompound : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Returns an empty Compound.
        """
    def MakeShell(self,aShell : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Returns an empty Shell.
        """
    def MakeSolid(self,aSolid : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Returns an empty Solid.
        """
    def MakeWire(self,aWire : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Returns an empty Wire.
        """
    def __init__(self,aBuilder : OCP.BRep.BRep_Builder) -> None: ...
    pass
class BRepSweep_Iterator():
    """
    This class provides iteration services required by the Generating Line (TopoDS Shape) of a BRepSweep. This tool is used to iterate on the direct sub-shapes of a Shape.
    """
    def Init(self,aShape : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Reset the Iterator on sub-shapes of <aShape>.
        """
    def More(self) -> bool: 
        """
        Returns True if there is a current sub-shape.

        Returns True if there is a current sub-shape.
        """
    def Next(self) -> None: 
        """
        Moves to the next sub-shape.
        """
    def Orientation(self) -> OCP.TopAbs.TopAbs_Orientation: 
        """
        Returns the orientation of the current sub-shape.

        Returns the orientation of the current sub-shape.
        """
    def Value(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the current sub-shape.

        Returns the current sub-shape.
        """
    def __init__(self) -> None: ...
    pass
class BRepSweep_NumLinearRegularSweep():
    """
    This a generic class is used to build Sweept primitives with a generating "shape" and a directing "line".
    """
    def Closed(self) -> bool: 
        """
        None
        """
    def DirectSolid(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopAbs.TopAbs_Orientation: 
        """
        Returns the Orientation of the shell in the solid generated by the face aGenS with the edge aDirS. It is REVERSED if the surface is swept in the direction of the normal.
        """
    @overload
    def FirstShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by the first Vertex of myDirWire and myGenShape.

        Returns the resulting Shape indexed by the first Vertex of myDirWire and aGenS.
        """
    @overload
    def FirstShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    def GDDShapeIsToAdd(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape,aSubDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aNewSubShape (addressed by aGenS and aSubDirS) must be added in aNewShape (addressed by aGenS and aDirS).
        """
    def GGDShapeIsToAdd(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aSubGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aNewSubShape (addressed by aSubGenS and aDirS) must be added in aNewShape (addressed by aGenS and aDirS).
        """
    def GenIsUsed(self,theS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the shape, generated from theS is used in result shape
        """
    def HasShape(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aDirS and aGenS addresses a resulting Shape. In some specific cases the shape can be geometrically inexsistant, then this function returns false.
        """
    def IsInvariant(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if aGenS cannot be transformed.
        """
    def IsUsed(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the initial shape aGenS is used in result shape
        """
    @overload
    def LastShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by the last Vertex of myDirWire and myGenShape.

        Returns the resulting Shape indexed by the last Vertex of myDirWire and aGenS.
        """
    @overload
    def LastShape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def MakeEmptyDirectingEdge(self,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the edge addressed by [aGenV,aDirE], with its geometric part, but without subcomponents.
        """
    def MakeEmptyFace(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the face addressed by [aGenS,aDirS], with its geometric part, but without subcomponents. The couple aGenS, aDirS can be a "generating face and a directing vertex" or "a generating edge and a directing edge".
        """
    def MakeEmptyGeneratingEdge(self,aGenE : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the edge addressed by [aGenE,aDirV], with its geometric part, but without subcomponents.
        """
    def MakeEmptyVertex(self,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the vertex addressed by [aGenV,aDirV], with its geometric part, but without subcomponents.
        """
    def SeparatedWires(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aSubGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        In some particular cases the topology of a generated face must be composed of independent closed wires, in this case this function returns true.
        """
    def SetContinuity(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Called to propagate the continuity of every vertex between two edges of the generating wire aGenS on the generated edge and faces.
        """
    def SetDirectingPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenE, aDirE and aGenV.
        """
    def SetDirectingParameter(self,aNewEdge : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameter of the new vertex on the new edge. The new edge and new vertex where generated from aGenV aDirE, and aDirV.
        """
    def SetGeneratingPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,aDirV : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenE, aDirE and aDirV.
        """
    def SetGeneratingParameter(self,aNewEdge : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameter of the new vertex on the new edge. The new edge and new vertex where generated from aGenE, aGenV and aDirV .
        """
    def SetPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenF : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenF, aGenE and aDirV.
        """
    def SetParameters(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenF : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameters of the new vertex on the new face. The new face and new vertex where generated from aGenF, aGenV and aDirV .
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by aDirS and aGenS.

        Returns the resulting Shape indexed by myDirWire and aGenS.

        Returns the resulting Shape indexed by myDirWire and myGenShape.
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: ...
    @overload
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def SplitShell(self,aNewShape : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        In some particular cases the topology of a generated Shell must be composed of independent closed Shells, in this case this function returns a Compound of independent Shells.
        """
    pass
class BRepSweep_Prism():
    """
    Provides natural constructors to build BRepSweep translated swept Primitives.
    """
    @overload
    def FirstShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the TopoDS Shape of the bottom of the prism.

        Returns the TopoDS Shape of the bottom of the prism. generated with aGenS (subShape of the generating shape).
        """
    @overload
    def FirstShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    def GenIsUsed(self,theS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the shape, generated from theS is used in result shape
        """
    def IsUsed(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the aGenS is used in resulting shape
        """
    @overload
    def LastShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the TopoDS Shape of the top of the prism.

        Returns the TopoDS Shape of the top of the prism. generated with aGenS (subShape of the generating shape).
        """
    @overload
    def LastShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the TopoDS Shape attached to the prism.

        Returns the TopoDS Shape generated with aGenS (subShape of the generating shape).
        """
    @overload
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def Vec(self) -> OCP.gp.gp_Vec: 
        """
        Returns the Vector of the Prism, if it is an infinite prism the Vec is unitar.
        """
    @overload
    def __init__(self,S : OCP.TopoDS.TopoDS_Shape,D : OCP.gp.gp_Dir,Inf : bool=True,Copy : bool=False,Canonize : bool=True) -> None: ...
    @overload
    def __init__(self,S : OCP.TopoDS.TopoDS_Shape,V : OCP.gp.gp_Vec,Copy : bool=False,Canonize : bool=True) -> None: ...
    pass
class BRepSweep_Revol():
    """
    Provides natural constructors to build BRepSweep rotated swept Primitives.
    """
    def Angle(self) -> float: 
        """
        returns the angle.
        """
    def Axe(self) -> OCP.gp.gp_Ax1: 
        """
        returns the axis
        """
    @overload
    def FirstShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the first shape of the revol (coinciding with the generating shape).

        Returns the first shape of the revol (coinciding with the generating shape).
        """
    @overload
    def FirstShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    def IsUsed(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the aGenS is used in resulting Shape
        """
    @overload
    def LastShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the TopoDS Shape of the top of the prism.

        Returns the TopoDS Shape of the top of the prism. generated with aGenS (subShape of the generating shape).
        """
    @overload
    def LastShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    @overload
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the TopoDS Shape attached to the Revol.

        Returns the TopoDS Shape generated with aGenS (subShape of the generating shape).
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    @overload
    def __init__(self,S : OCP.TopoDS.TopoDS_Shape,A : OCP.gp.gp_Ax1,D : float,C : bool=False) -> None: ...
    @overload
    def __init__(self,S : OCP.TopoDS.TopoDS_Shape,A : OCP.gp.gp_Ax1,C : bool=False) -> None: ...
    pass
class BRepSweep_Trsf(BRepSweep_NumLinearRegularSweep):
    """
    This class is inherited from NumLinearRegularSweep to implement the simple swept primitives built moving a Shape with a Trsf. It often is possible to build the constructed subshapes by a simple move of the generating subshapes (shared topology and geometry). So two ways of construction are proposed :
    """
    def Closed(self) -> bool: 
        """
        None
        """
    def DirectSolid(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopAbs.TopAbs_Orientation: 
        """
        Returns the Orientation of the shell in the solid generated by the face aGenS with the edge aDirS. It is REVERSED if the surface is swept in the direction of the normal.
        """
    @overload
    def FirstShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by the first Vertex of myDirWire and myGenShape.

        Returns the resulting Shape indexed by the first Vertex of myDirWire and aGenS.
        """
    @overload
    def FirstShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    def GDDShapeIsToAdd(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape,aSubDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aNewSubShape (addressed by aGenS and aSubDirS) must be added in aNewShape (addressed by aGenS and aDirS).
        """
    def GGDShapeIsToAdd(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aSubGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aNewSubShape (addressed by aSubGenS and aDirS) must be added in aNewShape (addressed by aGenS and aDirS).
        """
    def GenIsUsed(self,theS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the shape, generated from theS is used in result shape
        """
    def HasShape(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aDirS and aGenS addresses a resulting Shape. In some specific cases the shape can be geometrically inexsistant, then this function returns false.
        """
    def Init(self) -> None: 
        """
        ends the construction of the swept primitive calling the virtual geometric functions that can't be called in the initialize.
        """
    def IsInvariant(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the geometry of aGenS is not modified by the trsf of the BRepSweep Trsf.
        """
    def IsUsed(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the initial shape aGenS is used in result shape
        """
    @overload
    def LastShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by the last Vertex of myDirWire and myGenShape.

        Returns the resulting Shape indexed by the last Vertex of myDirWire and aGenS.
        """
    @overload
    def LastShape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def MakeEmptyDirectingEdge(self,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the edge addressed by [aGenV,aDirE], with its geometric part, but without subcomponents.
        """
    def MakeEmptyFace(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the face addressed by [aGenS,aDirS], with its geometric part, but without subcomponents. The couple aGenS, aDirS can be a "generating face and a directing vertex" or "a generating edge and a directing edge".
        """
    def MakeEmptyGeneratingEdge(self,aGenE : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the edge addressed by [aGenE,aDirV], with its geometric part, but without subcomponents.
        """
    def MakeEmptyVertex(self,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the vertex addressed by [aGenV,aDirV], with its geometric part, but without subcomponents.
        """
    def Process(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        function called to analyze the way of construction of the shapes generated by aGenS and aDirV.
        """
    def SeparatedWires(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aSubGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        In some particular cases the topology of a generated face must be composed of independent closed wires, in this case this function returns true.
        """
    def SetContinuity(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Called to propagate the continuity of every vertex between two edges of the generating wire aGenS on the generated edge and faces.
        """
    def SetDirectingPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenE, aDirE and aGenV.
        """
    def SetDirectingParameter(self,aNewEdge : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameter of the new vertex on the new edge. The new edge and new vertex where generated from aGenV aDirE, and aDirV.
        """
    def SetGeneratingPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,aDirV : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenE, aDirE and aDirV.
        """
    def SetGeneratingParameter(self,aNewEdge : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameter of the new vertex on the new edge. The new edge and new vertex where generated from aGenE, aGenV and aDirV .
        """
    def SetPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenF : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenF, aGenE and aDirV.
        """
    def SetParameters(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenF : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameters of the new vertex on the new face. The new face and new vertex where generated from aGenF, aGenV and aDirV .
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by aDirS and aGenS.

        Returns the resulting Shape indexed by myDirWire and aGenS.

        Returns the resulting Shape indexed by myDirWire and myGenShape.
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: ...
    @overload
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def SplitShell(self,aNewShape : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        In some particular cases the topology of a generated Shell must be composed of independent closed Shells, in this case this function returns a Compound of independent Shells.
        """
    pass
class BRepSweep_Tool():
    """
    Provides the indexation and type analysis services required by the TopoDS generating Shape of BRepSweep.
    """
    def Index(self,aShape : OCP.TopoDS.TopoDS_Shape) -> int: 
        """
        Returns the index of <aShape>.
        """
    def NbShapes(self) -> int: 
        """
        Returns the number of subshapes in the shape.
        """
    def Orientation(self,aShape : OCP.TopoDS.TopoDS_Shape) -> OCP.TopAbs.TopAbs_Orientation: 
        """
        Returns the Orientation of <aShape>.
        """
    def SetOrientation(self,aShape : OCP.TopoDS.TopoDS_Shape,Or : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Set the Orientation of <aShape> with Or.
        """
    def Shape(self,anIndex : int) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the Shape at Index anIdex.
        """
    def Type(self,aShape : OCP.TopoDS.TopoDS_Shape) -> OCP.TopAbs.TopAbs_ShapeEnum: 
        """
        Returns the type of <aShape>.
        """
    def __init__(self,aShape : OCP.TopoDS.TopoDS_Shape) -> None: ...
    pass
class BRepSweep_Translation(BRepSweep_Trsf, BRepSweep_NumLinearRegularSweep):
    """
    Provides an algorithm to build object by translation sweep.
    """
    def Closed(self) -> bool: 
        """
        None
        """
    def DirectSolid(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopAbs.TopAbs_Orientation: 
        """
        Returns the Orientation of the shell in the solid generated by the face aGenS with the edge aDirS. It is REVERSED if the surface is swept in the direction of the normal.
        """
    @overload
    def FirstShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by the first Vertex of myDirWire and myGenShape.

        Returns the resulting Shape indexed by the first Vertex of myDirWire and aGenS.
        """
    @overload
    def FirstShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    def GDDShapeIsToAdd(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape,aSubDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aNewSubShape (addressed by aGenS and aSubDirS) must be added in aNewShape (addressed by aGenS and aDirS).
        """
    def GGDShapeIsToAdd(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aSubGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aNewSubShape (addressed by aSubGenS and aDirS) must be added in aNewShape (addressed by aGenS and aDirS).
        """
    def GenIsUsed(self,theS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the shape, generated from theS is used in result shape
        """
    def HasShape(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aDirS and aGenS addresses a resulting Shape. In some specific cases the shape can be geometrically inexsistant, then this function returns false.
        """
    def Init(self) -> None: 
        """
        ends the construction of the swept primitive calling the virtual geometric functions that can't be called in the initialize.
        """
    def IsInvariant(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns always false because here the transformation is a translation.
        """
    def IsUsed(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the initial shape aGenS is used in result shape
        """
    @overload
    def LastShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by the last Vertex of myDirWire and myGenShape.

        Returns the resulting Shape indexed by the last Vertex of myDirWire and aGenS.
        """
    @overload
    def LastShape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def MakeEmptyDirectingEdge(self,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the edge addressed by [aGenV,aDirE], with its geometric part, but without subcomponents.
        """
    def MakeEmptyFace(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the face addressed by [aGenS,aDirS], with its geometric part, but without subcomponents. The couple aGenS, aDirS can be a "generating face and a directing vertex" or "a generating edge and a directing edge".
        """
    def MakeEmptyGeneratingEdge(self,aGenE : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the edge addressed by [aGenE,aDirV], with its geometric part, but without subcomponents.
        """
    def MakeEmptyVertex(self,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the vertex addressed by [aGenV,aDirV], with its geometric part, but without subcomponents.
        """
    def Process(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        function called to analyze the way of construction of the shapes generated by aGenS and aDirV.
        """
    def SeparatedWires(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aSubGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        In some particular cases the topology of a generated face must be composed of independent closed wires, in this case this function returns true. Here it always returns false.
        """
    def SetContinuity(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Called to propagate the continuity of every vertex between two edges of the generating wire aGenS on the generated edge and faces.
        """
    def SetDirectingPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenE, aDirE and aGenV.
        """
    def SetDirectingParameter(self,aNewEdge : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameter of the new vertex on the new edge. The new edge and new vertex where generated from aGenV aDirE, and aDirV.
        """
    def SetGeneratingPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,aDirV : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenE, aDirE and aDirV.
        """
    def SetGeneratingParameter(self,aNewEdge : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameter of the new vertex on the new edge. The new edge and new vertex where generated from aGenE, aGenV and aDirV .
        """
    def SetPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenF : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenF, aGenE and aDirV.
        """
    def SetParameters(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenF : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameters of the new vertex on the new face. The new face and new vertex where generated from aGenF, aGenV and aDirV .
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by aDirS and aGenS.

        Returns the resulting Shape indexed by myDirWire and aGenS.

        Returns the resulting Shape indexed by myDirWire and myGenShape.
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: ...
    @overload
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def SplitShell(self,aNewShape : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        In some particular cases the topology of a generated Shell must be composed of independent closed Shells, in this case this function returns a Compound of independent Shells.
        """
    def Vec(self) -> OCP.gp.gp_Vec: 
        """
        Returns the Vector of the Prism, if it is an infinite prism the Vec is unitar.
        """
    def __init__(self,S : OCP.TopoDS.TopoDS_Shape,N : OCP.Sweep.Sweep_NumShape,L : OCP.TopLoc.TopLoc_Location,V : OCP.gp.gp_Vec,C : bool,Canonize : bool=True) -> None: ...
    pass
class BRepSweep_Rotation(BRepSweep_Trsf, BRepSweep_NumLinearRegularSweep):
    """
    Provides an algorithm to build object by Rotation sweep.
    """
    def Angle(self) -> float: 
        """
        returns the angle.
        """
    def Axe(self) -> OCP.gp.gp_Ax1: 
        """
        returns the axis
        """
    def Closed(self) -> bool: 
        """
        None
        """
    def DirectSolid(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopAbs.TopAbs_Orientation: 
        """
        Returns the Orientation of the shell in the solid generated by the face aGenS with the edge aDirS. It is REVERSED if the surface is swept in the direction of the normal.
        """
    @overload
    def FirstShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by the first Vertex of myDirWire and myGenShape.

        Returns the resulting Shape indexed by the first Vertex of myDirWire and aGenS.
        """
    @overload
    def FirstShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: ...
    def GDDShapeIsToAdd(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape,aSubDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aNewSubShape (addressed by aGenS and aSubDirS) must be added in aNewShape (addressed by aGenS and aDirS).
        """
    def GGDShapeIsToAdd(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aSubGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aNewSubShape (addressed by aSubGenS and aDirS) must be added in aNewShape (addressed by aGenS and aDirS).
        """
    def GenIsUsed(self,theS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the shape, generated from theS is used in result shape
        """
    def HasShape(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        Returns true if aDirS and aGenS addresses a resulting Shape. In some specific cases the shape can be geometrically inexsistant, then this function returns false.
        """
    def Init(self) -> None: 
        """
        ends the construction of the swept primitive calling the virtual geometric functions that can't be called in the initialize.
        """
    def IsInvariant(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true when the geometry of aGenS is not modified by the rotation.
        """
    def IsUsed(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        Returns true if the initial shape aGenS is used in result shape
        """
    @overload
    def LastShape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by the last Vertex of myDirWire and myGenShape.

        Returns the resulting Shape indexed by the last Vertex of myDirWire and aGenS.
        """
    @overload
    def LastShape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def MakeEmptyDirectingEdge(self,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the edge addressed by [aGenV,aDirE], with its geometric part, but without subcomponents.
        """
    def MakeEmptyFace(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the face addressed by [aGenS,aDirS], with its geometric part, but without subcomponents. The couple aGenS, aDirS can be a "generating face and a directing vertex" or "a generating edge and a directing edge".
        """
    def MakeEmptyGeneratingEdge(self,aGenE : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the edge addressed by [aGenE,aDirV], with its geometric part, but without subcomponents.
        """
    def MakeEmptyVertex(self,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Builds the vertex addressed by [aGenV,aDirV], with its geometric part, but without subcomponents.
        """
    def Process(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        function called to analyze the way of construction of the shapes generated by aGenS and aDirV.
        """
    def SeparatedWires(self,aNewShape : OCP.TopoDS.TopoDS_Shape,aNewSubShape : OCP.TopoDS.TopoDS_Shape,aGenS : OCP.TopoDS.TopoDS_Shape,aSubGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> bool: 
        """
        In some particular cases the topology of a generated face must be composed of independent closed wires, in this case this function returns true. The only case in which the function may return true is a planar face in a closed revol.
        """
    def SetContinuity(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Called to propagate the continuity of every vertex between two edges of the generating wire aGenS on the generated edge and faces.
        """
    def SetDirectingPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenE, aDirE and aGenV.
        """
    def SetDirectingParameter(self,aNewEdge : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameter of the new vertex on the new edge. The new edge and new vertex where generated from aGenV aDirE, and aDirV.
        """
    def SetGeneratingPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aDirE : OCP.Sweep.Sweep_NumShape,aDirV : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenE, aDirE and aDirV.
        """
    def SetGeneratingParameter(self,aNewEdge : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameter of the new vertex on the new edge. The new edge and new vertex where generated from aGenE, aGenV and aDirV .
        """
    def SetPCurve(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewEdge : OCP.TopoDS.TopoDS_Shape,aGenF : OCP.TopoDS.TopoDS_Shape,aGenE : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape,orien : OCP.TopAbs.TopAbs_Orientation) -> None: 
        """
        Sets the PCurve for a new edge on a new face. The new edge and the new face were generated using aGenF, aGenE and aDirV.
        """
    def SetParameters(self,aNewFace : OCP.TopoDS.TopoDS_Shape,aNewVertex : OCP.TopoDS.TopoDS_Shape,aGenF : OCP.TopoDS.TopoDS_Shape,aGenV : OCP.TopoDS.TopoDS_Shape,aDirV : OCP.Sweep.Sweep_NumShape) -> None: 
        """
        Sets the parameters of the new vertex on the new face. The new face and new vertex where generated from aGenF, aGenV and aDirV .
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the resulting Shape indexed by aDirS and aGenS.

        Returns the resulting Shape indexed by myDirWire and aGenS.

        Returns the resulting Shape indexed by myDirWire and myGenShape.
        """
    @overload
    def Shape(self,aGenS : OCP.TopoDS.TopoDS_Shape,aDirS : OCP.Sweep.Sweep_NumShape) -> OCP.TopoDS.TopoDS_Shape: ...
    @overload
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: ...
    def SplitShell(self,aNewShape : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Shape: 
        """
        In some particular cases the topology of a generated Shell must be composed of independent closed Shells, in this case this function returns a Compound of independent Shells.
        """
    def __init__(self,S : OCP.TopoDS.TopoDS_Shape,N : OCP.Sweep.Sweep_NumShape,L : OCP.TopLoc.TopLoc_Location,A : OCP.gp.gp_Ax1,D : float,C : bool) -> None: ...
    pass
