# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.fax.v1.fax.fax_media import FaxMediaList


class FaxList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the FaxList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.fax.v1.fax.FaxList
        :rtype: twilio.rest.fax.v1.fax.FaxList
        """
        super(FaxList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Faxes'.format(**self._solution)

    def stream(self, from_=values.unset, to=values.unset,
               date_created_on_or_before=values.unset,
               date_created_after=values.unset, limit=None, page_size=None):
        """
        Streams FaxInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode from_: Retrieve only those faxes sent from this phone number
        :param unicode to: Retrieve only those faxes sent to this phone number
        :param datetime date_created_on_or_before: Retrieve only faxes created on or before this date
        :param datetime date_created_after: Retrieve only faxes created after this date
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.fax.v1.fax.FaxInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(
            from_=from_,
            to=to,
            date_created_on_or_before=date_created_on_or_before,
            date_created_after=date_created_after,
            page_size=limits['page_size'],
        )

        return self._version.stream(page, limits['limit'])

    def list(self, from_=values.unset, to=values.unset,
             date_created_on_or_before=values.unset,
             date_created_after=values.unset, limit=None, page_size=None):
        """
        Lists FaxInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode from_: Retrieve only those faxes sent from this phone number
        :param unicode to: Retrieve only those faxes sent to this phone number
        :param datetime date_created_on_or_before: Retrieve only faxes created on or before this date
        :param datetime date_created_after: Retrieve only faxes created after this date
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.fax.v1.fax.FaxInstance]
        """
        return list(self.stream(
            from_=from_,
            to=to,
            date_created_on_or_before=date_created_on_or_before,
            date_created_after=date_created_after,
            limit=limit,
            page_size=page_size,
        ))

    def page(self, from_=values.unset, to=values.unset,
             date_created_on_or_before=values.unset,
             date_created_after=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of FaxInstance records from the API.
        Request is executed immediately

        :param unicode from_: Retrieve only those faxes sent from this phone number
        :param unicode to: Retrieve only those faxes sent to this phone number
        :param datetime date_created_on_or_before: Retrieve only faxes created on or before this date
        :param datetime date_created_after: Retrieve only faxes created after this date
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxPage
        """
        data = values.of({
            'From': from_,
            'To': to,
            'DateCreatedOnOrBefore': serialize.iso8601_datetime(date_created_on_or_before),
            'DateCreatedAfter': serialize.iso8601_datetime(date_created_after),
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return FaxPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of FaxInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return FaxPage(self._version, response, self._solution)

    def create(self, to, media_url, quality=values.unset,
               status_callback=values.unset, from_=values.unset,
               sip_auth_username=values.unset, sip_auth_password=values.unset,
               store_media=values.unset, ttl=values.unset):
        """
        Create the FaxInstance

        :param unicode to: The phone number to receive the fax
        :param unicode media_url: The URL of the PDF that contains the fax
        :param FaxInstance.Quality quality: The quality of this fax
        :param unicode status_callback: The URL we should call to send status information to your application
        :param unicode from_: The number the fax was sent from
        :param unicode sip_auth_username: The username for SIP authentication
        :param unicode sip_auth_password: The password for SIP authentication
        :param bool store_media: Whether to store a copy of the sent media
        :param unicode ttl: How long in minutes to try to send the fax

        :returns: The created FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxInstance
        """
        data = values.of({
            'To': to,
            'MediaUrl': media_url,
            'Quality': quality,
            'StatusCallback': status_callback,
            'From': from_,
            'SipAuthUsername': sip_auth_username,
            'SipAuthPassword': sip_auth_password,
            'StoreMedia': store_media,
            'Ttl': ttl,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return FaxInstance(self._version, payload, )

    def get(self, sid):
        """
        Constructs a FaxContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.fax.v1.fax.FaxContext
        :rtype: twilio.rest.fax.v1.fax.FaxContext
        """
        return FaxContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a FaxContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.fax.v1.fax.FaxContext
        :rtype: twilio.rest.fax.v1.fax.FaxContext
        """
        return FaxContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Fax.V1.FaxList>'


class FaxPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the FaxPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.fax.v1.fax.FaxPage
        :rtype: twilio.rest.fax.v1.fax.FaxPage
        """
        super(FaxPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of FaxInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.fax.v1.fax.FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxInstance
        """
        return FaxInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Fax.V1.FaxPage>'


class FaxContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, sid):
        """
        Initialize the FaxContext

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.fax.v1.fax.FaxContext
        :rtype: twilio.rest.fax.v1.fax.FaxContext
        """
        super(FaxContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Faxes/{sid}'.format(**self._solution)

        # Dependents
        self._media = None

    def fetch(self):
        """
        Fetch the FaxInstance

        :returns: The fetched FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return FaxInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, status=values.unset):
        """
        Update the FaxInstance

        :param FaxInstance.UpdateStatus status: The new status of the resource

        :returns: The updated FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxInstance
        """
        data = values.of({'Status': status, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return FaxInstance(self._version, payload, sid=self._solution['sid'], )

    def delete(self):
        """
        Deletes the FaxInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    @property
    def media(self):
        """
        Access the media

        :returns: twilio.rest.fax.v1.fax.fax_media.FaxMediaList
        :rtype: twilio.rest.fax.v1.fax.fax_media.FaxMediaList
        """
        if self._media is None:
            self._media = FaxMediaList(self._version, fax_sid=self._solution['sid'], )
        return self._media

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Fax.V1.FaxContext {}>'.format(context)


class FaxInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class Direction(object):
        INBOUND = "inbound"
        OUTBOUND = "outbound"

    class Quality(object):
        STANDARD = "standard"
        FINE = "fine"
        SUPERFINE = "superfine"

    class Status(object):
        QUEUED = "queued"
        PROCESSING = "processing"
        SENDING = "sending"
        DELIVERED = "delivered"
        RECEIVING = "receiving"
        RECEIVED = "received"
        NO_ANSWER = "no-answer"
        BUSY = "busy"
        FAILED = "failed"
        CANCELED = "canceled"

    class UpdateStatus(object):
        CANCELED = "canceled"

    def __init__(self, version, payload, sid=None):
        """
        Initialize the FaxInstance

        :returns: twilio.rest.fax.v1.fax.FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxInstance
        """
        super(FaxInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'from_': payload.get('from'),
            'to': payload.get('to'),
            'quality': payload.get('quality'),
            'media_sid': payload.get('media_sid'),
            'media_url': payload.get('media_url'),
            'num_pages': deserialize.integer(payload.get('num_pages')),
            'duration': deserialize.integer(payload.get('duration')),
            'status': payload.get('status'),
            'direction': payload.get('direction'),
            'api_version': payload.get('api_version'),
            'price': deserialize.decimal(payload.get('price')),
            'price_unit': payload.get('price_unit'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'links': payload.get('links'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: FaxContext for this FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxContext
        """
        if self._context is None:
            self._context = FaxContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def from_(self):
        """
        :returns: The number the fax was sent from
        :rtype: unicode
        """
        return self._properties['from_']

    @property
    def to(self):
        """
        :returns: The phone number that received the fax
        :rtype: unicode
        """
        return self._properties['to']

    @property
    def quality(self):
        """
        :returns: The quality of the fax
        :rtype: FaxInstance.Quality
        """
        return self._properties['quality']

    @property
    def media_sid(self):
        """
        :returns: The SID of the FaxMedia resource that is associated with the Fax
        :rtype: unicode
        """
        return self._properties['media_sid']

    @property
    def media_url(self):
        """
        :returns: The Twilio-hosted URL that can be used to download fax media
        :rtype: unicode
        """
        return self._properties['media_url']

    @property
    def num_pages(self):
        """
        :returns: The number of pages contained in the fax document
        :rtype: unicode
        """
        return self._properties['num_pages']

    @property
    def duration(self):
        """
        :returns: The time it took to transmit the fax
        :rtype: unicode
        """
        return self._properties['duration']

    @property
    def status(self):
        """
        :returns: The status of the fax
        :rtype: FaxInstance.Status
        """
        return self._properties['status']

    @property
    def direction(self):
        """
        :returns: The direction of the fax
        :rtype: FaxInstance.Direction
        """
        return self._properties['direction']

    @property
    def api_version(self):
        """
        :returns: The API version used to transmit the fax
        :rtype: unicode
        """
        return self._properties['api_version']

    @property
    def price(self):
        """
        :returns: The fax transmission price
        :rtype: unicode
        """
        return self._properties['price']

    @property
    def price_unit(self):
        """
        :returns: The ISO 4217 currency used for billing
        :rtype: unicode
        """
        return self._properties['price_unit']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 formatted date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 formatted date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def links(self):
        """
        :returns: The URLs of the fax's related resources
        :rtype: unicode
        """
        return self._properties['links']

    @property
    def url(self):
        """
        :returns: The absolute URL of the fax resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the FaxInstance

        :returns: The fetched FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxInstance
        """
        return self._proxy.fetch()

    def update(self, status=values.unset):
        """
        Update the FaxInstance

        :param FaxInstance.UpdateStatus status: The new status of the resource

        :returns: The updated FaxInstance
        :rtype: twilio.rest.fax.v1.fax.FaxInstance
        """
        return self._proxy.update(status=status, )

    def delete(self):
        """
        Deletes the FaxInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    @property
    def media(self):
        """
        Access the media

        :returns: twilio.rest.fax.v1.fax.fax_media.FaxMediaList
        :rtype: twilio.rest.fax.v1.fax.fax_media.FaxMediaList
        """
        return self._proxy.media

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Fax.V1.FaxInstance {}>'.format(context)
