// ============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Sylvain GENIN
// Copyright (C) 2021 - Samuel GOUGEON
//
//  This file is distributed under the same license as the Scilab package.
// ============================================================================
// <-- NO CHECK REF -->
// <-- CLI SHELL MODE -->

s = %s;

empty = [];

r = 2;
R = [1,2;3,4];
R3(:,:,1) = R;
R3(:,:,2) = R';
c = 1 + 2*%i;
C = [1+2*%i,2+4*%i;3+6*%i,4+8*%i];
C3(:,:,1) = C;
C3(:,:,2) = C';

e = eye();
ec = (5+%i) * eye();

p = 1 + %s - %s**2;
pc = 1 + %s - %s**2 + ( 2 - 3 * %s + 4 * %s**2 ) * %i;
P = [2*p, 2;4*p,-5*p];
PC = [2*pc, 2;4*pc,-5*pc];

SP = sparse([1,2;4,5;3,10],[1,2,3]);
SPC = sparse([1,2;4,5;3,10],[1,2,3]) * ( 1 + 4*%i);
SPB = sparse([1,2;2,1],[%t;%t],[2,2]);
SP1 = sparse([1,1],[10]);
SPC1 = sparse([1,1],[1]) * ( 2 + 6*%i);

i8 = int8(-8);
ui8 = uint8(8);
I8 = int8([-8 2 ; -24 -32]);
UI8 = uint8([8 2 ; 24 32]);

I16 = int16([-16 2 ; -48 -64]);
UI16 = uint16([16 2 ; 48 64]);
i16 = int16(-16);
ui16 = uint16(16);

i32 = int32(-32);
ui32 = uint32(32);
I32 = int32([-32 2 ; -96 -128]);
UI32 = uint32([32 2 ; 96 128]);

str = "string";
STR = ["string1" "string2";"string3" "string4"];

b = %f;
B = [%t %f;%f %t];

assert_checkequal(empty <> empty, %f);
assert_checkequal(empty <> r, %t);
assert_checkequal(empty <> c, %t);
assert_checkequal(empty <> R, %t);
assert_checkequal(empty <> C, %t);
assert_checkequal(empty <> e, %t);
assert_checkequal(empty <> ec, %t);
assert_checkequal(empty <> p, %t);
assert_checkequal(empty <> pc, %t);
assert_checkequal(empty <> P, %t);
assert_checkequal(empty <> PC, %t);
assert_checkequal(empty <> SP, %t);
assert_checkequal(empty <> SPC, %t);
assert_checkequal(empty <> SP1, %t);
assert_checkequal(empty <> SPC1, %t);
assert_checkequal(empty <> i8, %t);
assert_checkequal(empty <> I8, %t);
assert_checkequal(empty <> ui8, %t);
assert_checkequal(empty <> UI8, %t);
assert_checkequal(empty <> i16, %t);
assert_checkequal(empty <> I16, %t);
assert_checkequal(empty <> ui16, %t);
assert_checkequal(empty <> UI16, %t);
assert_checkequal(empty <> i32, %t);
assert_checkequal(empty <> I32, %t);
assert_checkequal(empty <> ui32, %t);
assert_checkequal(empty <> UI32, %t);
assert_checkequal(empty <> str, %t);
assert_checkequal(empty <> STR, %t);
assert_checkequal(empty <> b, %t);
assert_checkequal(empty <> B, %t);
assert_checkequal(empty <> SPB, %t);

assert_checkequal(r <> empty, %t);
assert_checkequal(r <> r, %f);
assert_checkequal(r <> c, %t);
assert_checkequal(r <> R, [%t,%f;%t,%t]);
assert_checkequal(r <> C, [%t,%t;%t,%t]);
assert_checkequal(r <> e, %t);
assert_checkequal(r <> ec, %t);
assert_checkequal(r <> p, %t);
assert_checkequal(r <> pc, %t);
assert_checkequal(r <> P, [%t,%f;%t,%t]);
assert_checkequal(r <> PC, [%t,%f;%t,%t]);
assert_checkequal(r <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(r <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(r <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(r <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(r <> i8, %t);
assert_checkequal(r <> I8, [%t,%f;%t,%t]);
assert_checkequal(r <> ui8, %t);
assert_checkequal(r <> UI8, [%t,%f;%t,%t]);
assert_checkequal(r <> i16, %t);
assert_checkequal(r <> I16, [%t,%f;%t,%t]);
assert_checkequal(r <> ui16, %t);
assert_checkequal(r <> UI16, [%t,%f;%t,%t]);
assert_checkequal(r <> i32, %t);
assert_checkequal(r <> I32, [%t,%f;%t,%t]);
assert_checkequal(r <> ui32, %t);
assert_checkequal(r <> UI32, [%t,%f;%t,%t]);
assert_checkequal(r <> str, %t);
assert_checkequal(r <> STR, %t);
assert_checkequal(r <> b, %t);
assert_checkequal(r <> B, %t);
assert_checkequal(r <> SPB, %t);

assert_checkequal(c <> empty, %t);
assert_checkequal(c <> r, %t);
assert_checkequal(c <> c, %f);
assert_checkequal(c <> R, [%t,%t;%t,%t]);
assert_checkequal(c <> C, [%f,%t;%t,%t]);
assert_checkequal(c <> e, %t);
assert_checkequal(c <> ec, %t);
assert_checkequal(c <> p, %t);
assert_checkequal(c <> pc, %t);
assert_checkequal(c <> P, [%t,%t;%t,%t]);
assert_checkequal(c <> PC, [%t,%t;%t,%t]);
assert_checkequal(c <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(c <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(c <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(c <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(c <> i8, %t);
assert_checkequal(c <> I8, [%t,%t;%t,%t]);
assert_checkequal(c <> ui8, %t);
assert_checkequal(c <> UI8, [%t,%t;%t,%t]);
assert_checkequal(c <> i16, %t);
assert_checkequal(c <> I16, [%t,%t;%t,%t]);
assert_checkequal(c <> ui16, %t);
assert_checkequal(c <> UI16, [%t,%t;%t,%t]);
assert_checkequal(c <> i32, %t);
assert_checkequal(c <> I32, [%t,%t;%t,%t]);
assert_checkequal(c <> ui32, %t);
assert_checkequal(c <> UI32, [%t,%t;%t,%t]);
assert_checkequal(c <> str, %t);
assert_checkequal(c <> STR, %t);
assert_checkequal(c <> b, %t);
assert_checkequal(c <> B, %t);
assert_checkequal(c <> SPB, %t);

assert_checkequal(R <> empty, %t);
assert_checkequal(R <> r, [%t,%f;%t,%t]);
assert_checkequal(R <> c, [%t,%t;%t,%t]);
assert_checkequal(R <> R, [%f,%f;%f,%f]);
assert_checkequal(R <> C, [%t,%t;%t,%t]);
assert_checkequal(R <> e, [%f,%t;%t,%t]);
assert_checkequal(R <> ec, [%t,%t;%t,%t]);
assert_checkequal(R <> p, [%t,%t;%t,%t]);
assert_checkequal(R <> pc, [%t,%t;%t,%t]);
assert_checkequal(R <> P, [%t,%f;%t,%t]);
assert_checkequal(R <> PC, [%t,%f;%t,%t]);
assert_checkequal(R <> SP, %t);
assert_checkequal(R <> SPC, %t);
assert_checkequal(R <> SP1, %t);
assert_checkequal(R <> SPC1, %t);
assert_checkequal(R <> i8, [%t,%t;%t,%t]);
assert_checkequal(R <> I8, [%t,%f;%t,%t]);
assert_checkequal(R <> ui8, [%t,%t;%t,%t]);
assert_checkequal(R <> UI8, [%t,%f;%t,%t]);
assert_checkequal(R <> i16, [%t,%t;%t,%t]);
assert_checkequal(R <> I16, [%t,%f;%t,%t]);
assert_checkequal(R <> ui16, [%t,%t;%t,%t]);
assert_checkequal(R <> UI16, [%t,%f;%t,%t]);
assert_checkequal(R <> i32, [%t,%t;%t,%t]);
assert_checkequal(R <> I32, [%t,%f;%t,%t]);
assert_checkequal(R <> ui32, [%t,%t;%t,%t]);
assert_checkequal(R <> UI32, [%t,%f;%t,%t]);
assert_checkequal(R <> str, %t);
assert_checkequal(R <> STR, %t);
assert_checkequal(R <> b, %t);
assert_checkequal(R <> B, %t);
assert_checkequal(R <> SPB, %t);

assert_checkequal(C <> empty, %t);
assert_checkequal(C <> r, [%t,%t;%t,%t]);
assert_checkequal(C <> c, [%f,%t;%t,%t]);
assert_checkequal(C <> R, [%t,%t;%t,%t]);
assert_checkequal(C <> C, [%f,%f;%f,%f]);
assert_checkequal(C <> e, [%t,%t;%t,%t]);
assert_checkequal(C <> ec, [%t,%t;%t,%t]);
assert_checkequal(C <> p, [%t,%t;%t,%t]);
assert_checkequal(C <> pc, [%t,%t;%t,%t]);
assert_checkequal(C <> P, [%t,%t;%t,%t]);
assert_checkequal(C <> PC, [%t,%t;%t,%t]);
assert_checkequal(C <> SP, %t);
assert_checkequal(C <> SPC, %t);
assert_checkequal(C <> SP1, %t);
assert_checkequal(C <> SPC1, %t);
assert_checkequal(C <> i8, [%t,%t;%t,%t]);
assert_checkequal(C <> I8, [%t,%t;%t,%t]);
assert_checkequal(C <> ui8, [%t,%t;%t,%t]);
assert_checkequal(C <> UI8, [%t,%t;%t,%t]);
assert_checkequal(C <> i16, [%t,%t;%t,%t]);
assert_checkequal(C <> I16, [%t,%t;%t,%t]);
assert_checkequal(C <> ui16, [%t,%t;%t,%t]);
assert_checkequal(C <> UI16, [%t,%t;%t,%t]);
assert_checkequal(C <> i32, [%t,%t;%t,%t]);
assert_checkequal(C <> I32, [%t,%t;%t,%t]);
assert_checkequal(C <> ui32, [%t,%t;%t,%t]);
assert_checkequal(C <> UI32, [%t,%t;%t,%t]);
assert_checkequal(C <> str, %t);
assert_checkequal(C <> STR, %t);
assert_checkequal(C <> b, %t);
assert_checkequal(C <> B, %t);
assert_checkequal(C <> SPB, %t);

assert_checkequal(e <> empty, %t);
assert_checkequal(e <> r, %t);
assert_checkequal(e <> c, %t);
assert_checkequal(e <> R, [%f,%t;%t,%t]);
assert_checkequal(e <> C, [%t,%t;%t,%t]);
assert_checkequal(e <> e, %f);
assert_checkequal(e <> ec, %t);
assert_checkequal(e <> p, %t);
assert_checkequal(e <> pc, %t);
assert_checkequal(e <> P, [%t,%t;%t,%t]);
assert_checkequal(e <> PC, [%t,%t;%t,%t]);
assert_checkequal(e <> SP, %t);
assert_checkequal(e <> SPC, %t);
assert_checkequal(e <> SP1, %t);
assert_checkequal(e <> SPC1, %t);
assert_checkequal(e <> i8, %t);
assert_checkequal(e <> I8, [%t,%t;%t,%t]);
assert_checkequal(e <> ui8, %t);
assert_checkequal(e <> UI8, [%t,%t;%t,%t]);
assert_checkequal(e <> i16, %t);
assert_checkequal(e <> I16, [%t,%t;%t,%t]);
assert_checkequal(e <> ui16, %t);
assert_checkequal(e <> UI16, [%t,%t;%t,%t]);
assert_checkequal(e <> i32, %t);
assert_checkequal(e <> I32, [%t,%t;%t,%t]);
assert_checkequal(e <> ui32, %t);
assert_checkequal(e <> UI32, [%t,%t;%t,%t]);
assert_checkequal(e <> str, %t);
assert_checkequal(e <> STR, %t);
assert_checkequal(e <> b, %t);
assert_checkequal(e <> B, %t);
assert_checkequal(e <> SPB, %t);

assert_checkequal(ec <> empty, %t);
assert_checkequal(ec <> r, %t);
assert_checkequal(ec <> c, %t);
assert_checkequal(ec <> R, [%t,%t;%t,%t]);
assert_checkequal(ec <> C, [%t,%t;%t,%t]);
assert_checkequal(ec <> e, %t);
assert_checkequal(ec <> ec, %f);
assert_checkequal(ec <> p, %t);
assert_checkequal(ec <> pc, %t);
assert_checkequal(ec <> P, [%t,%t;%t,%t]);
assert_checkequal(ec <> PC, [%t,%t;%t,%t]);
assert_checkequal(ec <> SP, %t);
assert_checkequal(ec <> SPC, %t);
assert_checkequal(ec <> SP1, %t);
assert_checkequal(ec <> SPC1, %t);
assert_checkequal(ec <> i8, %t);
assert_checkequal(ec <> I8, [%t,%t;%t,%t]);
assert_checkequal(ec <> ui8, %t);
assert_checkequal(ec <> UI8, [%t,%t;%t,%t]);
assert_checkequal(ec <> i16, %t);
assert_checkequal(ec <> I16, [%t,%t;%t,%t]);
assert_checkequal(ec <> ui16, %t);
assert_checkequal(ec <> UI16, [%t,%t;%t,%t]);
assert_checkequal(ec <> i32, %t);
assert_checkequal(ec <> I32, [%t,%t;%t,%t]);
assert_checkequal(ec <> ui32, %t);
assert_checkequal(ec <> UI32, [%t,%t;%t,%t]);
assert_checkequal(ec <> str, %t);
assert_checkequal(ec <> STR, %t);
assert_checkequal(ec <> b, %t);
assert_checkequal(ec <> B, %t);
assert_checkequal(ec <> SPB, %t);

assert_checkequal(p <> empty, %t);
assert_checkequal(p <> r, %t);
assert_checkequal(p <> c, %t);
assert_checkequal(p <> R, [%t,%t;%t,%t]);
assert_checkequal(p <> C, [%t,%t;%t,%t]);
assert_checkequal(p <> e, %t);
assert_checkequal(p <> ec, %t);
assert_checkequal(p <> p, %f);
assert_checkequal(p <> pc, %t);
assert_checkequal(p <> P, [%t,%t;%t,%t]);
assert_checkequal(p <> PC, [%t,%t;%t,%t]);
assert_checkequal(p <> i8, %t);
assert_checkequal(p <> I8, [%t,%t;%t,%t]);
assert_checkequal(p <> ui8, %t);
assert_checkequal(p <> UI8, [%t,%t;%t,%t]);
assert_checkequal(p <> i16, %t);
assert_checkequal(p <> I16, [%t,%t;%t,%t]);
assert_checkequal(p <> ui16, %t);
assert_checkequal(p <> UI16, [%t,%t;%t,%t]);
assert_checkequal(p <> i32, %t);
assert_checkequal(p <> I32, [%t,%t;%t,%t]);
assert_checkequal(p <> ui32, %t);
assert_checkequal(p <> UI32, [%t,%t;%t,%t]);
assert_checkequal(p <> str, %t);
assert_checkequal(p <> STR, %t);
assert_checkequal(p <> b, %t);
assert_checkequal(p <> B, %t);

assert_checkequal(pc <> empty, %t);
assert_checkequal(pc <> r, %t);
assert_checkequal(pc <> c, %t);
assert_checkequal(pc <> R, [%t,%t;%t,%t]);
assert_checkequal(pc <> C, [%t,%t;%t,%t]);
assert_checkequal(pc <> e, %t);
assert_checkequal(pc <> ec, %t);
assert_checkequal(pc <> p, %t);
assert_checkequal(pc <> pc, %f);
assert_checkequal(pc <> P, [%t,%t;%t,%t]);
assert_checkequal(pc <> PC, [%t,%t;%t,%t]);
assert_checkequal(pc <> i8, %t);
assert_checkequal(pc <> I8, [%t,%t;%t,%t]);
assert_checkequal(pc <> ui8, %t);
assert_checkequal(pc <> UI8, [%t,%t;%t,%t]);
assert_checkequal(pc <> i16, %t);
assert_checkequal(pc <> I16, [%t,%t;%t,%t]);
assert_checkequal(pc <> ui16, %t);
assert_checkequal(pc <> UI16, [%t,%t;%t,%t]);
assert_checkequal(pc <> i32, %t);
assert_checkequal(pc <> I32, [%t,%t;%t,%t]);
assert_checkequal(pc <> ui32, %t);
assert_checkequal(pc <> UI32, [%t,%t;%t,%t]);
assert_checkequal(pc <> str, %t);
assert_checkequal(pc <> STR, %t);
assert_checkequal(pc <> b, %t);
assert_checkequal(pc <> B, %t);

assert_checkequal(P <> empty, %t);
assert_checkequal(P <> r, [%t,%f;%t,%t]);
assert_checkequal(P <> c, [%t,%t;%t,%t]);
assert_checkequal(P <> R, [%t,%f;%t,%t]);
assert_checkequal(P <> C, [%t,%t;%t,%t]);
assert_checkequal(P <> e, [%t,%t;%t,%t]);
assert_checkequal(P <> ec, [%t,%t;%t,%t]);
assert_checkequal(P <> p, [%t,%t;%t,%t]);
assert_checkequal(P <> pc, [%t,%t;%t,%t]);
assert_checkequal(P <> P, [%f,%f;%f,%f]);
assert_checkequal(P <> PC, [%t,%f;%t,%t]);
assert_checkequal(P <> i8, [%t,%t;%t,%t]);
assert_checkequal(P <> I8, [%t,%f;%t,%t]);
assert_checkequal(P <> ui8, [%t,%t;%t,%t]);
assert_checkequal(P <> UI8, [%t,%f;%t,%t]);
assert_checkequal(P <> i16, [%t,%t;%t,%t]);
assert_checkequal(P <> I16, [%t,%f;%t,%t]);
assert_checkequal(P <> ui16, [%t,%t;%t,%t]);
assert_checkequal(P <> UI16, [%t,%f;%t,%t]);
assert_checkequal(P <> i32, [%t,%t;%t,%t]);
assert_checkequal(P <> I32, [%t,%f;%t,%t]);
assert_checkequal(P <> ui32, [%t,%t;%t,%t]);
assert_checkequal(P <> UI32, [%t,%f;%t,%t]);
assert_checkequal(P <> str, %t);
assert_checkequal(P <> STR, %t);
assert_checkequal(P <> b, %t);
assert_checkequal(P <> B, %t);

assert_checkequal(PC <> empty, %t);
assert_checkequal(PC <> r, [%t,%f;%t,%t]);
assert_checkequal(PC <> c, [%t,%t;%t,%t]);
assert_checkequal(PC <> R, [%t,%f;%t,%t]);
assert_checkequal(PC <> C, [%t,%t;%t,%t]);
assert_checkequal(PC <> e, [%t,%t;%t,%t]);
assert_checkequal(PC <> ec, [%t,%t;%t,%t]);
assert_checkequal(PC <> p, [%t,%t;%t,%t]);
assert_checkequal(PC <> pc, [%t,%t;%t,%t]);
assert_checkequal(PC <> P, [%t,%f;%t,%t]);
assert_checkequal(PC <> PC, [%f,%f;%f,%f]);
assert_checkequal(PC <> i8, [%t,%t;%t,%t]);
assert_checkequal(PC <> I8, [%t,%f;%t,%t]);
assert_checkequal(PC <> ui8, [%t,%t;%t,%t]);
assert_checkequal(PC <> UI8, [%t,%f;%t,%t]);
assert_checkequal(PC <> i16, [%t,%t;%t,%t]);
assert_checkequal(PC <> I16, [%t,%f;%t,%t]);
assert_checkequal(PC <> ui16, [%t,%t;%t,%t]);
assert_checkequal(PC <> UI16, [%t,%f;%t,%t]);
assert_checkequal(PC <> i32, [%t,%t;%t,%t]);
assert_checkequal(PC <> I32, [%t,%f;%t,%t]);
assert_checkequal(PC <> ui32, [%t,%t;%t,%t]);
assert_checkequal(PC <> UI32, [%t,%f;%t,%t]);
assert_checkequal(PC <> str, %t);
assert_checkequal(PC <> STR, %t);
assert_checkequal(PC <> b, %t);
assert_checkequal(PC <> B, %t);

assert_checkequal(SP <> empty, %t);
assert_checkequal(SP <> r, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> c, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> R, %t);
assert_checkequal(SP <> C, %t);
assert_checkequal(SP <> e, %t);
assert_checkequal(SP <> ec, %t);
assert_checkequal(SP <> SP, sparse([1,1],[%f],[4,10]));
assert_checkequal(SP <> SPC, sparse([1,2;3,10;4,5],[%t;%t;%t],[4,10]));
assert_checkequal(SP <> SP1, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> SPC1, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> i8, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> I8, %t);
assert_checkequal(SP <> ui8, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> UI8, %t);
assert_checkequal(SP <> i16, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> I16, %t);
assert_checkequal(SP <> ui16, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> UI16, %t);
assert_checkequal(SP <> i32, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> I32, %t);
assert_checkequal(SP <> ui32, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP <> UI32, %t);
assert_checkequal(SP <> str, %t);
assert_checkequal(SP <> STR, %t);
assert_checkequal(SP <> b, %t);
assert_checkequal(SP <> B, %t);
assert_checkequal(SP <> SPB, %t);

assert_checkequal(SPC <> empty, %t);
assert_checkequal(SPC <> r, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> c, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> R, %t);
assert_checkequal(SPC <> C, %t);
assert_checkequal(SPC <> e, %t);
assert_checkequal(SPC <> ec, %t);
assert_checkequal(SPC <> SP, sparse([1,2;3,10;4,5],[%t;%t;%t],[4,10]));
assert_checkequal(SPC <> SPC, sparse([1,1],[%f],[4,10]));
assert_checkequal(SPC <> SP1, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> SPC1, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> i8, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> I8, %t);
assert_checkequal(SPC <> ui8, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> UI8, %t);
assert_checkequal(SPC <> i16, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> I16, %t);
assert_checkequal(SPC <> ui16, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> UI16, %t);
assert_checkequal(SPC <> i32, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> I32, %t);
assert_checkequal(SPC <> ui32, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC <> UI32, %t);
assert_checkequal(SPC <> str, %t);
assert_checkequal(SPC <> STR, %t);
assert_checkequal(SPC <> b, %t);
assert_checkequal(SPC <> B, %t);
assert_checkequal(SPC <> SPB, %t);

assert_checkequal(SP1 <> empty, %t);
assert_checkequal(SP1 <> r, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> c, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> R, %t);
assert_checkequal(SP1 <> C, %t);
assert_checkequal(SP1 <> e, %t);
assert_checkequal(SP1 <> ec, %t);
assert_checkequal(SP1 <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP1 <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SP1 <> SP1, sparse([1,1],[%f],[1,1]));
assert_checkequal(SP1 <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> i8, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> I8, %t);
assert_checkequal(SP1 <> ui8, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> UI8, %t);
assert_checkequal(SP1 <> i16, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> I16, %t);
assert_checkequal(SP1 <> ui16, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> UI16, %t);
assert_checkequal(SP1 <> i32, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> I32, %t);
assert_checkequal(SP1 <> ui32, sparse([1,1],%t,[1,1]));
assert_checkequal(SP1 <> UI32, %t);
assert_checkequal(SP1 <> str, %t);
assert_checkequal(SP1 <> STR, %t);
assert_checkequal(SP1 <> b, %t);
assert_checkequal(SP1 <> B, %t);
assert_checkequal(SP1 <> SPB, %t);

assert_checkequal(SPC1 <> empty, %t);
assert_checkequal(SPC1 <> r, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> c, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> R, %t);
assert_checkequal(SPC1 <> C, %t);
assert_checkequal(SPC1 <> e, %t);
assert_checkequal(SPC1 <> ec, %t);
assert_checkequal(SPC1 <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC1 <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(SPC1 <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> SPC1, sparse([1,1],[%f],[1,1]));
assert_checkequal(SPC1 <> i8, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> I8, %t);
assert_checkequal(SPC1 <> ui8, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> UI8, %t);
assert_checkequal(SPC1 <> i16, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> I16, %t);
assert_checkequal(SPC1 <> ui16, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> UI16, %t);
assert_checkequal(SPC1 <> i32, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> I32, %t);
assert_checkequal(SPC1 <> ui32, sparse([1,1],%t,[1,1]));
assert_checkequal(SPC1 <> UI32, %t);
assert_checkequal(SPC1 <> str, %t);
assert_checkequal(SPC1 <> STR, %t);
assert_checkequal(SPC1 <> b, %t);
assert_checkequal(SPC1 <> B, %t);
assert_checkequal(SPC1 <> SPB, %t);

assert_checkequal(i8 <> empty, %t);
assert_checkequal(i8 <> r, %t);
assert_checkequal(i8 <> c, %t);
assert_checkequal(i8 <> R, [%t,%t;%t,%t]);
assert_checkequal(i8 <> C, [%t,%t;%t,%t]);
assert_checkequal(i8 <> e, %t);
assert_checkequal(i8 <> ec, %t);
assert_checkequal(i8 <> p, %t);
assert_checkequal(i8 <> pc, %t);
assert_checkequal(i8 <> P, [%t,%t;%t,%t]);
assert_checkequal(i8 <> PC, [%t,%t;%t,%t]);
assert_checkequal(i8 <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(i8 <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(i8 <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(i8 <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(i8 <> i8, %f);
assert_checkequal(i8 <> I8, [%f,%t;%t,%t]);
assert_checkequal(i8 <> ui8, %t);
assert_checkequal(i8 <> UI8, [%t,%t;%t,%t]);
assert_checkequal(i8 <> i16, %t);
assert_checkequal(i8 <> I16, [%t,%t;%t,%t]);
assert_checkequal(i8 <> ui16, %t);
assert_checkequal(i8 <> UI16, [%t,%t;%t,%t]);
assert_checkequal(i8 <> i32, %t);
assert_checkequal(i8 <> I32, [%t,%t;%t,%t]);
assert_checkequal(i8 <> ui32, %t);
assert_checkequal(i8 <> UI32, [%t,%t;%t,%t]);
assert_checkequal(i8 <> str, %t);
assert_checkequal(i8 <> STR, %t);
assert_checkequal(i8 <> b, %t);
assert_checkequal(i8 <> B, [%t,%t;%t,%t]);
assert_checkequal(i8 <> SPB, %t);

assert_checkequal(I8 <> empty, %t);
assert_checkequal(I8 <> r, [%t,%f;%t,%t]);
assert_checkequal(I8 <> c, [%t,%t;%t,%t]);
assert_checkequal(I8 <> R, [%t,%f;%t,%t]);
assert_checkequal(I8 <> C, [%t,%t;%t,%t]);
assert_checkequal(I8 <> e, [%t,%t;%t,%t]);
assert_checkequal(I8 <> ec, [%t,%t;%t,%t]);
assert_checkequal(I8 <> p, [%t,%t;%t,%t]);
assert_checkequal(I8 <> pc, [%t,%t;%t,%t]);
assert_checkequal(I8 <> P, [%t,%f;%t,%t]);
assert_checkequal(I8 <> PC, [%t,%f;%t,%t]);
assert_checkequal(I8 <> SP, %t);
assert_checkequal(I8 <> SPC, %t);
assert_checkequal(I8 <> SP1, %t);
assert_checkequal(I8 <> SPC1, %t);
assert_checkequal(I8 <> i8, [%f,%t;%t,%t]);
assert_checkequal(I8 <> I8, [%f,%f;%f,%f]);
assert_checkequal(I8 <> ui8, [%t,%t;%t,%t]);
assert_checkequal(I8 <> UI8, [%t,%f;%t,%t]);
assert_checkequal(I8 <> i16, [%t,%t;%t,%t]);
assert_checkequal(I8 <> I16, [%t,%f;%t,%t]);
assert_checkequal(I8 <> ui16, [%t,%t;%t,%t]);
assert_checkequal(I8 <> UI16, [%t,%f;%t,%t]);
assert_checkequal(I8 <> i32, [%t,%t;%t,%f]);
assert_checkequal(I8 <> I32, [%t,%f;%t,%t]);
assert_checkequal(I8 <> ui32, [%t,%t;%t,%t]);
assert_checkequal(I8 <> UI32, [%t,%f;%t,%t]);
assert_checkequal(I8 <> str, %t);
assert_checkequal(I8 <> STR, %t);
assert_checkequal(I8 <> b, [%t,%t;%t,%t]);
assert_checkequal(I8 <> B, [%t,%t;%t,%t]);
assert_checkequal(I8 <> SPB, %t);

assert_checkequal(ui8 <> empty, %t);
assert_checkequal(ui8 <> r, %t);
assert_checkequal(ui8 <> c, %t);
assert_checkequal(ui8 <> R, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> C, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> e, %t);
assert_checkequal(ui8 <> ec, %t);
assert_checkequal(ui8 <> p, %t);
assert_checkequal(ui8 <> pc, %t);
assert_checkequal(ui8 <> P, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> PC, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(ui8 <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(ui8 <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(ui8 <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(ui8 <> i8, %t);
assert_checkequal(ui8 <> I8, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> ui8, %f);
assert_checkequal(ui8 <> UI8, [%f,%t;%t,%t]);
assert_checkequal(ui8 <> i16, %t);
assert_checkequal(ui8 <> I16, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> ui16, %t);
assert_checkequal(ui8 <> UI16, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> i32, %t);
assert_checkequal(ui8 <> I32, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> ui32, %t);
assert_checkequal(ui8 <> UI32, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> str, %t);
assert_checkequal(ui8 <> STR, %t);
assert_checkequal(ui8 <> b, %t);
assert_checkequal(ui8 <> B, [%t,%t;%t,%t]);
assert_checkequal(ui8 <> SPB, %t);

assert_checkequal(UI8 <> empty, %t);
assert_checkequal(UI8 <> r, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> c, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> R, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> C, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> e, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> ec, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> p, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> pc, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> P, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> PC, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> SP, %t);
assert_checkequal(UI8 <> SPC, %t);
assert_checkequal(UI8 <> SP1, %t);
assert_checkequal(UI8 <> SPC1, %t);
assert_checkequal(UI8 <> i8, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> I8, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> ui8, [%f,%t;%t,%t]);
assert_checkequal(UI8 <> UI8, [%f,%f;%f,%f]);
assert_checkequal(UI8 <> i16, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> I16, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> ui16, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> UI16, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> i32, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> I32, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> ui32, [%t,%t;%t,%f]);
assert_checkequal(UI8 <> UI32, [%t,%f;%t,%t]);
assert_checkequal(UI8 <> str, %t);
assert_checkequal(UI8 <> STR, %t);
assert_checkequal(UI8 <> b, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> B, [%t,%t;%t,%t]);
assert_checkequal(UI8 <> SPB, %t);

assert_checkequal(i16 <> empty, %t);
assert_checkequal(i16 <> r, %t);
assert_checkequal(i16 <> c, %t);
assert_checkequal(i16 <> R, [%t,%t;%t,%t]);
assert_checkequal(i16 <> C, [%t,%t;%t,%t]);
assert_checkequal(i16 <> e, %t);
assert_checkequal(i16 <> ec, %t);
assert_checkequal(i16 <> p, %t);
assert_checkequal(i16 <> pc, %t);
assert_checkequal(i16 <> P, [%t,%t;%t,%t]);
assert_checkequal(i16 <> PC, [%t,%t;%t,%t]);
assert_checkequal(i16 <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(i16 <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(i16 <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(i16 <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(i16 <> i8, %t);
assert_checkequal(i16 <> I8, [%t,%t;%t,%t]);
assert_checkequal(i16 <> ui8, %t);
assert_checkequal(i16 <> UI8, [%t,%t;%t,%t]);
assert_checkequal(i16 <> i16, %f);
assert_checkequal(i16 <> I16, [%f,%t;%t,%t]);
assert_checkequal(i16 <> ui16, %t);
assert_checkequal(i16 <> UI16, [%t,%t;%t,%t]);
assert_checkequal(i16 <> i32, %t);
assert_checkequal(i16 <> I32, [%t,%t;%t,%t]);
assert_checkequal(i16 <> ui32, %t);
assert_checkequal(i16 <> UI32, [%t,%t;%t,%t]);
assert_checkequal(i16 <> str, %t);
assert_checkequal(i16 <> STR, %t);
assert_checkequal(i16 <> b, %t);
assert_checkequal(i16 <> B, [%t,%t;%t,%t]);
assert_checkequal(i16 <> SPB, %t);

assert_checkequal(I16 <> empty, %t);
assert_checkequal(I16 <> r, [%t,%f;%t,%t]);
assert_checkequal(I16 <> c, [%t,%t;%t,%t]);
assert_checkequal(I16 <> R, [%t,%f;%t,%t]);
assert_checkequal(I16 <> C, [%t,%t;%t,%t]);
assert_checkequal(I16 <> e, [%t,%t;%t,%t]);
assert_checkequal(I16 <> ec, [%t,%t;%t,%t]);
assert_checkequal(I16 <> p, [%t,%t;%t,%t]);
assert_checkequal(I16 <> pc, [%t,%t;%t,%t]);
assert_checkequal(I16 <> P, [%t,%f;%t,%t]);
assert_checkequal(I16 <> PC, [%t,%f;%t,%t]);
assert_checkequal(I16 <> SP, %t);
assert_checkequal(I16 <> SPC, %t);
assert_checkequal(I16 <> SP1, %t);
assert_checkequal(I16 <> SPC1, %t);
assert_checkequal(I16 <> i8, [%t,%t;%t,%t]);
assert_checkequal(I16 <> I8, [%t,%f;%t,%t]);
assert_checkequal(I16 <> ui8, [%t,%t;%t,%t]);
assert_checkequal(I16 <> UI8, [%t,%f;%t,%t]);
assert_checkequal(I16 <> i16, [%f,%t;%t,%t]);
assert_checkequal(I16 <> I16, [%f,%f;%f,%f]);
assert_checkequal(I16 <> ui16, [%t,%t;%t,%t]);
assert_checkequal(I16 <> UI16, [%t,%f;%t,%t]);
assert_checkequal(I16 <> i32, [%t,%t;%t,%t]);
assert_checkequal(I16 <> I32, [%t,%f;%t,%t]);
assert_checkequal(I16 <> ui32, [%t,%t;%t,%t]);
assert_checkequal(I16 <> UI32, [%t,%f;%t,%t]);
assert_checkequal(I16 <> str, %t);
assert_checkequal(I16 <> STR, %t);
assert_checkequal(I16 <> b, [%t,%t;%t,%t]);
assert_checkequal(I16 <> B, [%t,%t;%t,%t]);
assert_checkequal(I16 <> SPB, %t);

assert_checkequal(ui16 <> empty, %t);
assert_checkequal(ui16 <> r, %t);
assert_checkequal(ui16 <> c, %t);
assert_checkequal(ui16 <> R, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> C, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> e, %t);
assert_checkequal(ui16 <> ec, %t);
assert_checkequal(ui16 <> p, %t);
assert_checkequal(ui16 <> pc, %t);
assert_checkequal(ui16 <> P, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> PC, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(ui16 <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(ui16 <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(ui16 <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(ui16 <> i8, %t);
assert_checkequal(ui16 <> I8, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> ui8, %t);
assert_checkequal(ui16 <> UI8, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> i16, %t);
assert_checkequal(ui16 <> I16, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> ui16, %f);
assert_checkequal(ui16 <> UI16, [%f,%t;%t,%t]);
assert_checkequal(ui16 <> i32, %t);
assert_checkequal(ui16 <> I32, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> ui32, %t);
assert_checkequal(ui16 <> UI32, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> str, %t);
assert_checkequal(ui16 <> STR, %t);
assert_checkequal(ui16 <> b, %t);
assert_checkequal(ui16 <> B, [%t,%t;%t,%t]);
assert_checkequal(ui16 <> SPB, %t);

assert_checkequal(UI16 <> empty, %t);
assert_checkequal(UI16 <> r, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> c, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> R, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> C, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> e, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> ec, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> p, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> pc, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> P, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> PC, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> SP, %t);
assert_checkequal(UI16 <> SPC, %t);
assert_checkequal(UI16 <> SP1, %t);
assert_checkequal(UI16 <> SPC1, %t);
assert_checkequal(UI16 <> i8, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> I8, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> ui8, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> UI8, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> i16, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> I16, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> ui16, [%f,%t;%t,%t]);
assert_checkequal(UI16 <> UI16, [%f,%f;%f,%f]);
assert_checkequal(UI16 <> i32, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> I32, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> ui32, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> UI32, [%t,%f;%t,%t]);
assert_checkequal(UI16 <> str, %t);
assert_checkequal(UI16 <> STR, %t);
assert_checkequal(UI16 <> b, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> B, [%t,%t;%t,%t]);
assert_checkequal(UI16 <> SPB, %t);

assert_checkequal(i32 <> empty, %t);
assert_checkequal(i32 <> r, %t);
assert_checkequal(i32 <> c, %t);
assert_checkequal(i32 <> R, [%t,%t;%t,%t]);
assert_checkequal(i32 <> C, [%t,%t;%t,%t]);
assert_checkequal(i32 <> e, %t);
assert_checkequal(i32 <> ec, %t);
assert_checkequal(i32 <> p, %t);
assert_checkequal(i32 <> pc, %t);
assert_checkequal(i32 <> P, [%t,%t;%t,%t]);
assert_checkequal(i32 <> PC, [%t,%t;%t,%t]);
assert_checkequal(i32 <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(i32 <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(i32 <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(i32 <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(i32 <> i8, %t);
assert_checkequal(i32 <> I8, [%t,%t;%t,%f]);
assert_checkequal(i32 <> ui8, %t);
assert_checkequal(i32 <> UI8, [%t,%t;%t,%t]);
assert_checkequal(i32 <> i16, %t);
assert_checkequal(i32 <> I16, [%t,%t;%t,%t]);
assert_checkequal(i32 <> ui16, %t);
assert_checkequal(i32 <> UI16, [%t,%t;%t,%t]);
assert_checkequal(i32 <> i32, %f);
assert_checkequal(i32 <> I32, [%f,%t;%t,%t]);
assert_checkequal(i32 <> ui32, %t);
assert_checkequal(i32 <> UI32, [%t,%t;%t,%t]);
assert_checkequal(i32 <> str, %t);
assert_checkequal(i32 <> STR, %t);
assert_checkequal(i32 <> b, %t);
assert_checkequal(i32 <> B, [%t,%t;%t,%t]);
assert_checkequal(i32 <> SPB, %t);

assert_checkequal(I32 <> empty, %t);
assert_checkequal(I32 <> r, [%t,%f;%t,%t]);
assert_checkequal(I32 <> c, [%t,%t;%t,%t]);
assert_checkequal(I32 <> R, [%t,%f;%t,%t]);
assert_checkequal(I32 <> C, [%t,%t;%t,%t]);
assert_checkequal(I32 <> e, [%t,%t;%t,%t]);
assert_checkequal(I32 <> ec, [%t,%t;%t,%t]);
assert_checkequal(I32 <> p, [%t,%t;%t,%t]);
assert_checkequal(I32 <> pc, [%t,%t;%t,%t]);
assert_checkequal(I32 <> P, [%t,%f;%t,%t]);
assert_checkequal(I32 <> PC, [%t,%f;%t,%t]);
assert_checkequal(I32 <> SP, %t);
assert_checkequal(I32 <> SPC, %t);
assert_checkequal(I32 <> SP1, %t);
assert_checkequal(I32 <> SPC1, %t);
assert_checkequal(I32 <> i8, [%t,%t;%t,%t]);
assert_checkequal(I32 <> I8, [%t,%f;%t,%t]);
assert_checkequal(I32 <> ui8, [%t,%t;%t,%t]);
assert_checkequal(I32 <> UI8, [%t,%f;%t,%t]);
assert_checkequal(I32 <> i16, [%t,%t;%t,%t]);
assert_checkequal(I32 <> I16, [%t,%f;%t,%t]);
assert_checkequal(I32 <> ui16, [%t,%t;%t,%t]);
assert_checkequal(I32 <> UI16, [%t,%f;%t,%t]);
assert_checkequal(I32 <> i32, [%f,%t;%t,%t]);
assert_checkequal(I32 <> I32, [%f,%f;%f,%f]);
assert_checkequal(I32 <> ui32, [%t,%t;%t,%t]);
assert_checkequal(I32 <> UI32, [%t,%f;%t,%t]);
assert_checkequal(I32 <> str, %t);
assert_checkequal(I32 <> STR, %t);
assert_checkequal(I32 <> b, [%t,%t;%t,%t]);
assert_checkequal(I32 <> B, [%t,%t;%t,%t]);
assert_checkequal(I32 <> SPB, %t);

assert_checkequal(ui32 <> empty, %t);
assert_checkequal(ui32 <> r, %t);
assert_checkequal(ui32 <> c, %t);
assert_checkequal(ui32 <> R, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> C, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> e, %t);
assert_checkequal(ui32 <> ec, %t);
assert_checkequal(ui32 <> p, %t);
assert_checkequal(ui32 <> pc, %t);
assert_checkequal(ui32 <> P, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> PC, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> SP, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(ui32 <> SPC, sparse([1,1;1,2;1,3;1,4;1,5;1,6;1,7;1,8;1,9;1,10;2,1;2,2;2,3;2,4;2,5;2,6;2,7;2,8;2,9;2,10;3,1;3,2;3,3;3,4;3,5;3,6;3,7;3,8;3,9;3,10;4,1;4,2;4,3;4,4;4,5;4,6;4,7;4,8;4,9;4,10],[%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t;%t],[4,10]));
assert_checkequal(ui32 <> SP1, sparse([1,1],%t,[1,1]));
assert_checkequal(ui32 <> SPC1, sparse([1,1],%t,[1,1]));
assert_checkequal(ui32 <> i8, %t);
assert_checkequal(ui32 <> I8, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> ui8, %t);
assert_checkequal(ui32 <> UI8, [%t,%t;%t,%f]);
assert_checkequal(ui32 <> i16, %t);
assert_checkequal(ui32 <> I16, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> ui16, %t);
assert_checkequal(ui32 <> UI16, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> i32, %t);
assert_checkequal(ui32 <> I32, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> ui32, %f);
assert_checkequal(ui32 <> UI32, [%f,%t;%t,%t]);
assert_checkequal(ui32 <> str, %t);
assert_checkequal(ui32 <> STR, %t);
assert_checkequal(ui32 <> b, %t);
assert_checkequal(ui32 <> B, [%t,%t;%t,%t]);
assert_checkequal(ui32 <> SPB, %t);

assert_checkequal(UI32 <> empty, %t);
assert_checkequal(UI32 <> r, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> c, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> R, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> C, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> e, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> ec, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> p, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> pc, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> P, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> PC, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> SP, %t);
assert_checkequal(UI32 <> SPC, %t);
assert_checkequal(UI32 <> SP1, %t);
assert_checkequal(UI32 <> SPC1, %t);
assert_checkequal(UI32 <> i8, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> I8, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> ui8, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> UI8, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> i16, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> I16, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> ui16, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> UI16, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> i32, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> I32, [%t,%f;%t,%t]);
assert_checkequal(UI32 <> ui32, [%f,%t;%t,%t]);
assert_checkequal(UI32 <> UI32, [%f,%f;%f,%f]);
assert_checkequal(UI32 <> str, %t);
assert_checkequal(UI32 <> STR, %t);
assert_checkequal(UI32 <> b, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> B, [%t,%t;%t,%t]);
assert_checkequal(UI32 <> SPB, %t);

assert_checkequal(str <> empty, %t);
assert_checkequal(str <> r, %t);
assert_checkequal(str <> c, %t);
assert_checkequal(str <> R, %t);
assert_checkequal(str <> C, %t);
assert_checkequal(str <> e, %t);
assert_checkequal(str <> ec, %t);
assert_checkequal(str <> p, %t);
assert_checkequal(str <> pc, %t);
assert_checkequal(str <> P, %t);
assert_checkequal(str <> PC, %t);
assert_checkequal(str <> SP, %t);
assert_checkequal(str <> SPC, %t);
assert_checkequal(str <> SP1, %t);
assert_checkequal(str <> SPC1, %t);
assert_checkequal(str <> i8, %t);
assert_checkequal(str <> I8, %t);
assert_checkequal(str <> ui8, %t);
assert_checkequal(str <> UI8, %t);
assert_checkequal(str <> i16, %t);
assert_checkequal(str <> I16, %t);
assert_checkequal(str <> ui16, %t);
assert_checkequal(str <> UI16, %t);
assert_checkequal(str <> i32, %t);
assert_checkequal(str <> I32, %t);
assert_checkequal(str <> ui32, %t);
assert_checkequal(str <> UI32, %t);
assert_checkequal(str <> str, %f);
assert_checkequal(str <> STR, [%t,%t;%t,%t]);
assert_checkequal(str <> b, %t);
assert_checkequal(str <> B, %t);
assert_checkequal(str <> SPB, %t);

assert_checkequal(STR <> empty, %t);
assert_checkequal(STR <> r, %t);
assert_checkequal(STR <> c, %t);
assert_checkequal(STR <> R, %t);
assert_checkequal(STR <> C, %t);
assert_checkequal(STR <> e, %t);
assert_checkequal(STR <> ec, %t);
assert_checkequal(STR <> p, %t);
assert_checkequal(STR <> pc, %t);
assert_checkequal(STR <> P, %t);
assert_checkequal(STR <> PC, %t);
assert_checkequal(STR <> SP, %t);
assert_checkequal(STR <> SPC, %t);
assert_checkequal(STR <> SP1, %t);
assert_checkequal(STR <> SPC1, %t);
assert_checkequal(STR <> i8, %t);
assert_checkequal(STR <> I8, %t);
assert_checkequal(STR <> ui8, %t);
assert_checkequal(STR <> UI8, %t);
assert_checkequal(STR <> i16, %t);
assert_checkequal(STR <> I16, %t);
assert_checkequal(STR <> ui16, %t);
assert_checkequal(STR <> UI16, %t);
assert_checkequal(STR <> i32, %t);
assert_checkequal(STR <> I32, %t);
assert_checkequal(STR <> ui32, %t);
assert_checkequal(STR <> UI32, %t);
assert_checkequal(STR <> str, [%t,%t;%t,%t]);
assert_checkequal(STR <> STR, [%f,%f;%f,%f]);
assert_checkequal(STR <> b, %t);
assert_checkequal(STR <> B, %t);
assert_checkequal(STR <> SPB, %t);

assert_checkequal(b <> empty, %t);
assert_checkequal(b <> r, %t);
assert_checkequal(b <> c, %t);
assert_checkequal(b <> R, %t);
assert_checkequal(b <> C, %t);
assert_checkequal(b <> e, %t);
assert_checkequal(b <> ec, %t);
assert_checkequal(b <> p, %t);
assert_checkequal(b <> pc, %t);
assert_checkequal(b <> P, %t);
assert_checkequal(b <> PC, %t);
assert_checkequal(b <> SP, %t);
assert_checkequal(b <> SPC, %t);
assert_checkequal(b <> SP1, %t);
assert_checkequal(b <> SPC1, %t);
assert_checkequal(b <> i8, %t);
assert_checkequal(b <> I8, [%t,%t;%t,%t]);
assert_checkequal(b <> ui8, %t);
assert_checkequal(b <> UI8, [%t,%t;%t,%t]);
assert_checkequal(b <> i16, %t);
assert_checkequal(b <> I16, [%t,%t;%t,%t]);
assert_checkequal(b <> ui16, %t);
assert_checkequal(b <> UI16, [%t,%t;%t,%t]);
assert_checkequal(b <> i32, %t);
assert_checkequal(b <> I32, [%t,%t;%t,%t]);
assert_checkequal(b <> ui32, %t);
assert_checkequal(b <> UI32, [%t,%t;%t,%t]);
assert_checkequal(b <> str, %t);
assert_checkequal(b <> STR, %t);
assert_checkequal(b <> b, %f);
assert_checkequal(b <> B, [%t,%f;%f,%t]);
assert_checkequal(b <> SPB, sparse([1,2;2,1],[%t;%t],[2,2]));

assert_checkequal(B <> empty, %t);
assert_checkequal(B <> r, %t);
assert_checkequal(B <> c, %t);
assert_checkequal(B <> R, %t);
assert_checkequal(B <> C, %t);
assert_checkequal(B <> e, %t);
assert_checkequal(B <> ec, %t);
assert_checkequal(B <> p, %t);
assert_checkequal(B <> pc, %t);
assert_checkequal(B <> P, %t);
assert_checkequal(B <> PC, %t);
assert_checkequal(B <> SP, %t);
assert_checkequal(B <> SPC, %t);
assert_checkequal(B <> SP1, %t);
assert_checkequal(B <> SPC1, %t);
assert_checkequal(B <> i8, [%t,%t;%t,%t]);
assert_checkequal(B <> I8, [%t,%t;%t,%t]);
assert_checkequal(B <> ui8, [%t,%t;%t,%t]);
assert_checkequal(B <> UI8, [%t,%t;%t,%t]);
assert_checkequal(B <> i16, [%t,%t;%t,%t]);
assert_checkequal(B <> I16, [%t,%t;%t,%t]);
assert_checkequal(B <> ui16, [%t,%t;%t,%t]);
assert_checkequal(B <> UI16, [%t,%t;%t,%t]);
assert_checkequal(B <> i32, [%t,%t;%t,%t]);
assert_checkequal(B <> I32, [%t,%t;%t,%t]);
assert_checkequal(B <> ui32, [%t,%t;%t,%t]);
assert_checkequal(B <> UI32, [%t,%t;%t,%t]);
assert_checkequal(B <> str, %t);
assert_checkequal(B <> STR, %t);
assert_checkequal(B <> b, [%t,%f;%f,%t]);
assert_checkequal(B <> B, [%f,%f;%f,%f]);
assert_checkequal(B <> SPB, sparse([1,1;1,2;2,1;2,2],[%t;%t;%t;%t],[2,2]));

assert_checkequal(SPB <> empty, %t);
assert_checkequal(SPB <> r, %t);
assert_checkequal(SPB <> c, %t);
assert_checkequal(SPB <> R, %t);
assert_checkequal(SPB <> C, %t);
assert_checkequal(SPB <> e, %t);
assert_checkequal(SPB <> ec, %t);
assert_checkequal(SPB <> SP, %t);
assert_checkequal(SPB <> SPC, %t);
assert_checkequal(SPB <> SP1, %t);
assert_checkequal(SPB <> SPC1, %t);
assert_checkequal(SPB <> i8, %t);
assert_checkequal(SPB <> I8, %t);
assert_checkequal(SPB <> ui8, %t);
assert_checkequal(SPB <> UI8, %t);
assert_checkequal(SPB <> i16, %t);
assert_checkequal(SPB <> I16, %t);
assert_checkequal(SPB <> ui16, %t);
assert_checkequal(SPB <> UI16, %t);
assert_checkequal(SPB <> i32, %t);
assert_checkequal(SPB <> I32, %t);
assert_checkequal(SPB <> ui32, %t);
assert_checkequal(SPB <> UI32, %t);
assert_checkequal(SPB <> str, %t);
assert_checkequal(SPB <> STR, %t);
assert_checkequal(SPB <> b, sparse([1,2;2,1],[%t;%t],[2,2]));
assert_checkequal(SPB <> B, sparse([1,1;1,2;2,1;2,2],[%t;%t;%t;%t],[2,2]));
assert_checkequal(SPB <> SPB, sparse([1,1],[%f],[2,2]));

assert_checkequal(["a" "b"] <> ["a" "b" "c"],%t);
assert_checkequal(["a" "b"] <> ["a" ; "b"],%t);
assert_checkequal(["a" "b" "c"] <> ["a" "b"],%t);
assert_checkequal(["a" "b"; "a" "b"] <> ["a" "b"],%t);

//struct
test_st=struct("double",1,"string","test","int8",int8(2),"struct",struct("valeur",0));
test_st2=struct("double",1,"string","test","int16",int8(2),"struct",1);
test_st4=struct("double",1,"string","test","int8",int8(4),"struct",struct("valeur",0));
test_st8=struct("double",8,"string","test","int8",int8(8),"struct",struct("valeur",0));

assert_checkequal(test_st <> test_st, %f);
assert_checkequal(test_st <> test_st2, %t);
assert_checkequal([test_st4 test_st8] <> [test_st test_st], [%t,%t]);
assert_checkequal([test_st, test_st4;test_st4,test_st8] <> [test_st, test_st; test_st,test_st], [%f,%t;%t,%t]);
assert_checkequal(test_st <> [], %t);

//polynom
res = horner(1/(1-%s),1/(1-%s));

assert_checkequal(res <> (1-%s)/-%s, %f);
assert_checkequal(res <> (1-%s)/1, %t);
assert_checkequal(res <> 1/-%s, %t);

// <> with a type==0 object (void or listdelete)
// --------------------------------------------
L = list(,2);
assert_checkfalse(L(1) <> L(1));
assert_checkfalse(null() <> null());
assert_checktrue(L(1) <> null());
assert_checktrue(null() <> L(1));
//
lss = syslin('c',[0,1;0,0],[1;1],[1,1]);
ptr = lufact(sparse(rand(5,5)));
x = 1:10; h5File = TMPDIR + "/x.sod"; save(h5File,"x"); h5 = h5open(h5File);
program = macr2tree(%0_o_0);
xml = xmlReadStr("<root><a rib=""bar""><b>Hello</b></a></root>");
L2 = list(1, [], %z, %f, sparse(5), sparse(%t), int8(2), "abc", sin, sind, ..
    list(3), list(), {1,%t}, {}, struct("a",3), 1/%z, 1:$, lss, ptr, ..
    h5, program, xml);
for object = L2
    assert_checktrue(object <> L(1));
    assert_checktrue(object <> null());
    assert_checktrue(L(1) <> object);
    assert_checktrue(null() <> object);
end
h5close(h5);
ludel(ptr);
xmlDelete(xml);
mdelete(h5File);

//macro
deff("[x]=myplus(y,z)","x=y+z");

deff("[x]=mymacro(y,z)",["a=3*y+1"; "x=a*z+y"]);

assert_checkequal(myplus <> myplus,%f);
assert_checkequal(myplus <> mymacro,%t);
assert_checkequal(myplus <> [],%t);
assert_checkequal(myplus <> 2,%t);

//function
assert_checkequal(acosd <> acosd, %f);
assert_checkequal(acosd <> [], %t);
assert_checkequal(acosd <> 2, %t);

// libraries
assert_checktrue(iolib <> corelib);
