/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestSeedWidget2.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
//
// This example tests the vtkSeedWidget

// First include the required header files for the VTK classes we are using.
#include "vtkActor.h"
#include "vtkAxisActor2D.h"
#include "vtkCommand.h"
#include "vtkCoordinate.h"
#include "vtkHandleWidget.h"
#include "vtkImageActor.h"
#include "vtkImageMapper3D.h"
#include "vtkImageMapToColors.h"
#include "vtkLookupTable.h"
#include "vtkMath.h"
#include "vtkPointHandleRepresentation2D.h"
#include "vtkPolyDataMapper.h"
#include "vtkProperty2D.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkSeedRepresentation.h"
#include "vtkSeedWidget.h"
#include "vtkSmartPointer.h"
#include "vtkSphereSource.h"
#include "vtkTesting.h"
#include "vtkTestUtilities.h"
#include "vtkVolume16Reader.h"

const char TestSeedWidget2Log[] =
"# StreamVersion 1\n"
"EnterEvent 292 47 0 0 0 0 0\n"
"MouseMoveEvent 292 47 0 0 0 0 0\n"
"MouseMoveEvent 282 57 0 0 0 0 0\n"
"MouseMoveEvent 272 68 0 0 0 0 0\n"
"MouseMoveEvent 264 79 0 0 0 0 0\n"
"MouseMoveEvent 256 90 0 0 0 0 0\n"
"MouseMoveEvent 247 103 0 0 0 0 0\n"
"MouseMoveEvent 238 114 0 0 0 0 0\n"
"MouseMoveEvent 231 123 0 0 0 0 0\n"
"MouseMoveEvent 226 132 0 0 0 0 0\n"
"MouseMoveEvent 219 141 0 0 0 0 0\n"
"MouseMoveEvent 216 148 0 0 0 0 0\n"
"MouseMoveEvent 212 155 0 0 0 0 0\n"
"MouseMoveEvent 208 161 0 0 0 0 0\n"
"MouseMoveEvent 205 166 0 0 0 0 0\n"
"MouseMoveEvent 202 169 0 0 0 0 0\n"
"MouseMoveEvent 201 172 0 0 0 0 0\n"
"MouseMoveEvent 200 173 0 0 0 0 0\n"
"MouseMoveEvent 199 174 0 0 0 0 0\n"
"MouseMoveEvent 198 174 0 0 0 0 0\n"
"MouseMoveEvent 197 174 0 0 0 0 0\n"
"MouseMoveEvent 196 174 0 0 0 0 0\n"
"MouseMoveEvent 195 174 0 0 0 0 0\n"
"MouseMoveEvent 193 172 0 0 0 0 0\n"
"MouseMoveEvent 192 171 0 0 0 0 0\n"
"MouseMoveEvent 192 170 0 0 0 0 0\n"
"MouseMoveEvent 192 168 0 0 0 0 0\n"
"MouseMoveEvent 191 166 0 0 0 0 0\n"
"MouseMoveEvent 190 164 0 0 0 0 0\n"
"MouseMoveEvent 189 162 0 0 0 0 0\n"
"MouseMoveEvent 188 161 0 0 0 0 0\n"
"MouseMoveEvent 187 160 0 0 0 0 0\n"
"MouseMoveEvent 186 158 0 0 0 0 0\n"
"MouseMoveEvent 185 157 0 0 0 0 0\n"
"MouseMoveEvent 184 156 0 0 0 0 0\n"
"MouseMoveEvent 183 154 0 0 0 0 0\n"
"MouseMoveEvent 182 152 0 0 0 0 0\n"
"MouseMoveEvent 181 151 0 0 0 0 0\n"
"MouseMoveEvent 180 150 0 0 0 0 0\n"
"MouseMoveEvent 179 149 0 0 0 0 0\n"
"MouseMoveEvent 178 148 0 0 0 0 0\n"
"MouseMoveEvent 176 148 0 0 0 0 0\n"
"MouseMoveEvent 174 147 0 0 0 0 0\n"
"MouseMoveEvent 172 146 0 0 0 0 0\n"
"MouseMoveEvent 168 144 0 0 0 0 0\n"
"MouseMoveEvent 165 144 0 0 0 0 0\n"
"MouseMoveEvent 161 144 0 0 0 0 0\n"
"MouseMoveEvent 158 144 0 0 0 0 0\n"
"MouseMoveEvent 153 144 0 0 0 0 0\n"
"MouseMoveEvent 149 144 0 0 0 0 0\n"
"MouseMoveEvent 143 144 0 0 0 0 0\n"
"MouseMoveEvent 138 144 0 0 0 0 0\n"
"MouseMoveEvent 132 144 0 0 0 0 0\n"
"MouseMoveEvent 126 147 0 0 0 0 0\n"
"MouseMoveEvent 120 149 0 0 0 0 0\n"
"MouseMoveEvent 113 151 0 0 0 0 0\n"
"MouseMoveEvent 107 153 0 0 0 0 0\n"
"MouseMoveEvent 101 155 0 0 0 0 0\n"
"MouseMoveEvent 95 157 0 0 0 0 0\n"
"MouseMoveEvent 90 160 0 0 0 0 0\n"
"MouseMoveEvent 84 162 0 0 0 0 0\n"
"MouseMoveEvent 82 163 0 0 0 0 0\n"
"MouseMoveEvent 80 164 0 0 0 0 0\n"
"MouseMoveEvent 79 164 0 0 0 0 0\n"
"MouseMoveEvent 83 166 0 0 0 0 0\n"
"MouseMoveEvent 82 166 0 0 0 0 0\n"
"MouseMoveEvent 81 166 0 0 0 0 0\n"
"MouseMoveEvent 82 167 0 0 0 0 0\n"
"MouseMoveEvent 83 167 0 0 0 0 0\n"
"MouseMoveEvent 84 167 0 0 0 0 0\n"
"MouseMoveEvent 85 167 0 0 0 0 0\n"
"MouseMoveEvent 87 167 0 0 0 0 0\n"
"MouseMoveEvent 89 167 0 0 0 0 0\n"
"MouseMoveEvent 91 166 0 0 0 0 0\n"
"MouseMoveEvent 93 163 0 0 0 0 0\n"
"MouseMoveEvent 94 162 0 0 0 0 0\n"
"MouseMoveEvent 95 158 0 0 0 0 0\n"
"MouseMoveEvent 97 154 0 0 0 0 0\n"
"MouseMoveEvent 99 150 0 0 0 0 0\n"
"MouseMoveEvent 100 148 0 0 0 0 0\n"
"MouseMoveEvent 102 143 0 0 0 0 0\n"
"MouseMoveEvent 103 141 0 0 0 0 0\n"
"MouseMoveEvent 104 137 0 0 0 0 0\n"
"MouseMoveEvent 105 135 0 0 0 0 0\n"
"MouseMoveEvent 105 133 0 0 0 0 0\n"
"MouseMoveEvent 105 131 0 0 0 0 0\n"
"MouseMoveEvent 105 129 0 0 0 0 0\n"
"MouseMoveEvent 105 127 0 0 0 0 0\n"
"MouseMoveEvent 105 125 0 0 0 0 0\n"
"MouseMoveEvent 105 124 0 0 0 0 0\n"
"MouseMoveEvent 105 122 0 0 0 0 0\n"
"MouseMoveEvent 104 121 0 0 0 0 0\n"
"MouseMoveEvent 103 121 0 0 0 0 0\n"
"MouseMoveEvent 101 124 0 0 0 0 0\n"
"MouseMoveEvent 100 128 0 0 0 0 0\n"
"MouseMoveEvent 98 132 0 0 0 0 0\n"
"MouseMoveEvent 97 138 0 0 0 0 0\n"
"MouseMoveEvent 95 143 0 0 0 0 0\n"
"MouseMoveEvent 94 148 0 0 0 0 0\n"
"MouseMoveEvent 92 153 0 0 0 0 0\n"
"MouseMoveEvent 91 158 0 0 0 0 0\n"
"MouseMoveEvent 89 162 0 0 0 0 0\n"
"MouseMoveEvent 88 165 0 0 0 0 0\n"
"MouseMoveEvent 87 167 0 0 0 0 0\n"
"MouseMoveEvent 86 169 0 0 0 0 0\n"
"MouseMoveEvent 86 170 0 0 0 0 0\n"
"MouseMoveEvent 85 171 0 0 0 0 0\n"
"MouseMoveEvent 84 173 0 0 0 0 0\n"
"MouseMoveEvent 83 175 0 0 0 0 0\n"
"MouseMoveEvent 81 178 0 0 0 0 0\n"
"MouseMoveEvent 80 180 0 0 0 0 0\n"
"MouseMoveEvent 79 181 0 0 0 0 0\n"
"MouseMoveEvent 78 182 0 0 0 0 0\n"
"MouseMoveEvent 78 183 0 0 0 0 0\n"
"MouseMoveEvent 77 184 0 0 0 0 0\n"
"MouseMoveEvent 76 186 0 0 0 0 0\n"
"MouseMoveEvent 75 187 0 0 0 0 0\n"
"MouseMoveEvent 74 188 0 0 0 0 0\n"
"MouseMoveEvent 73 189 0 0 0 0 0\n"
"MouseMoveEvent 71 191 0 0 0 0 0\n"
"MouseMoveEvent 70 192 0 0 0 0 0\n"
"MouseMoveEvent 70 193 0 0 0 0 0\n"
"MouseMoveEvent 69 194 0 0 0 0 0\n"
"MouseMoveEvent 68 195 0 0 0 0 0\n"
"MouseMoveEvent 67 197 0 0 0 0 0\n"
"MouseMoveEvent 67 199 0 0 0 0 0\n"
"MouseMoveEvent 65 202 0 0 0 0 0\n"
"MouseMoveEvent 65 203 0 0 0 0 0\n"
"MouseMoveEvent 65 204 0 0 0 0 0\n"
"MouseMoveEvent 65 205 0 0 0 0 0\n"
"MouseMoveEvent 64 207 0 0 0 0 0\n"
"MouseMoveEvent 64 208 0 0 0 0 0\n"
"MouseMoveEvent 64 209 0 0 0 0 0\n"
"MouseMoveEvent 64 210 0 0 0 0 0\n"
"MouseMoveEvent 64 211 0 0 0 0 0\n"
"LeftButtonPressEvent 64 211 0 0 0 0 0\n"
"RenderEvent 64 211 0 0 0 0 0\n"
"LeftButtonReleaseEvent 64 211 0 0 0 0 0\n"
"MouseMoveEvent 66 211 0 0 0 0 0\n"
"RenderEvent 66 211 0 0 0 0 0\n"
"MouseMoveEvent 67 211 0 0 0 0 0\n"
"RenderEvent 67 211 0 0 0 0 0\n"
"MouseMoveEvent 72 209 0 0 0 0 0\n"
"RenderEvent 72 209 0 0 0 0 0\n"
"MouseMoveEvent 76 208 0 0 0 0 0\n"
"RenderEvent 76 208 0 0 0 0 0\n"
"MouseMoveEvent 89 206 0 0 0 0 0\n"
"RenderEvent 89 206 0 0 0 0 0\n"
"MouseMoveEvent 106 201 0 0 0 0 0\n"
"RenderEvent 106 201 0 0 0 0 0\n"
"MouseMoveEvent 136 192 0 0 0 0 0\n"
"RenderEvent 136 192 0 0 0 0 0\n"
"MouseMoveEvent 158 187 0 0 0 0 0\n"
"RenderEvent 158 187 0 0 0 0 0\n"
"MouseMoveEvent 178 181 0 0 0 0 0\n"
"RenderEvent 178 181 0 0 0 0 0\n"
"MouseMoveEvent 196 176 0 0 0 0 0\n"
"RenderEvent 196 176 0 0 0 0 0\n"
"MouseMoveEvent 212 172 0 0 0 0 0\n"
"RenderEvent 212 172 0 0 0 0 0\n"
"MouseMoveEvent 225 168 0 0 0 0 0\n"
"RenderEvent 225 168 0 0 0 0 0\n"
"MouseMoveEvent 232 166 0 0 0 0 0\n"
"RenderEvent 232 166 0 0 0 0 0\n"
"MouseMoveEvent 235 165 0 0 0 0 0\n"
"RenderEvent 235 165 0 0 0 0 0\n"
"MouseMoveEvent 236 165 0 0 0 0 0\n"
"RenderEvent 236 165 0 0 0 0 0\n"
"MouseMoveEvent 237 165 0 0 0 0 0\n"
"RenderEvent 237 165 0 0 0 0 0\n"
"MouseMoveEvent 238 165 0 0 0 0 0\n"
"RenderEvent 238 165 0 0 0 0 0\n"
"MouseMoveEvent 239 166 0 0 0 0 0\n"
"RenderEvent 239 166 0 0 0 0 0\n"
"MouseMoveEvent 243 167 0 0 0 0 0\n"
"RenderEvent 243 167 0 0 0 0 0\n"
"MouseMoveEvent 248 168 0 0 0 0 0\n"
"RenderEvent 248 168 0 0 0 0 0\n"
"MouseMoveEvent 251 170 0 0 0 0 0\n"
"RenderEvent 251 170 0 0 0 0 0\n"
"MouseMoveEvent 253 170 0 0 0 0 0\n"
"RenderEvent 253 170 0 0 0 0 0\n"
"MouseMoveEvent 255 171 0 0 0 0 0\n"
"RenderEvent 255 171 0 0 0 0 0\n"
"MouseMoveEvent 256 172 0 0 0 0 0\n"
"RenderEvent 256 172 0 0 0 0 0\n"
"MouseMoveEvent 256 173 0 0 0 0 0\n"
"RenderEvent 256 173 0 0 0 0 0\n"
"MouseMoveEvent 257 179 0 0 0 0 0\n"
"RenderEvent 257 179 0 0 0 0 0\n"
"MouseMoveEvent 256 189 0 0 0 0 0\n"
"RenderEvent 256 189 0 0 0 0 0\n"
"MouseMoveEvent 252 198 0 0 0 0 0\n"
"RenderEvent 252 198 0 0 0 0 0\n"
"MouseMoveEvent 251 201 0 0 0 0 0\n"
"RenderEvent 251 201 0 0 0 0 0\n"
"MouseMoveEvent 251 202 0 0 0 0 0\n"
"RenderEvent 251 202 0 0 0 0 0\n"
"MouseMoveEvent 249 204 0 0 0 0 0\n"
"RenderEvent 249 204 0 0 0 0 0\n"
"MouseMoveEvent 248 205 0 0 0 0 0\n"
"RenderEvent 248 205 0 0 0 0 0\n"
"MouseMoveEvent 247 206 0 0 0 0 0\n"
"RenderEvent 247 206 0 0 0 0 0\n"
"MouseMoveEvent 247 207 0 0 0 0 0\n"
"RenderEvent 247 207 0 0 0 0 0\n"
"MouseMoveEvent 247 208 0 0 0 0 0\n"
"RenderEvent 247 208 0 0 0 0 0\n"
"MouseMoveEvent 247 209 0 0 0 0 0\n"
"RenderEvent 247 209 0 0 0 0 0\n"
"MouseMoveEvent 247 210 0 0 0 0 0\n"
"RenderEvent 247 210 0 0 0 0 0\n"
"MouseMoveEvent 246 212 0 0 0 0 0\n"
"RenderEvent 246 212 0 0 0 0 0\n"
"MouseMoveEvent 246 213 0 0 0 0 0\n"
"RenderEvent 246 213 0 0 0 0 0\n"
"MouseMoveEvent 245 214 0 0 0 0 0\n"
"RenderEvent 245 214 0 0 0 0 0\n"
"MouseMoveEvent 243 218 0 0 0 0 0\n"
"RenderEvent 243 218 0 0 0 0 0\n"
"MouseMoveEvent 242 219 0 0 0 0 0\n"
"RenderEvent 242 219 0 0 0 0 0\n"
"LeftButtonPressEvent 242 219 0 0 0 0 0\n"
"RenderEvent 242 219 0 0 0 0 0\n"
"LeftButtonReleaseEvent 242 219 0 0 0 0 0\n"
"MouseMoveEvent 241 220 0 0 0 0 0\n"
"RenderEvent 241 220 0 0 0 0 0\n"
"MouseMoveEvent 239 218 0 0 0 0 0\n"
"RenderEvent 239 218 0 0 0 0 0\n"
"MouseMoveEvent 238 217 0 0 0 0 0\n"
"RenderEvent 238 217 0 0 0 0 0\n"
"MouseMoveEvent 236 215 0 0 0 0 0\n"
"RenderEvent 236 215 0 0 0 0 0\n"
"MouseMoveEvent 235 212 0 0 0 0 0\n"
"RenderEvent 235 212 0 0 0 0 0\n"
"MouseMoveEvent 233 208 0 0 0 0 0\n"
"RenderEvent 233 208 0 0 0 0 0\n"
"MouseMoveEvent 231 205 0 0 0 0 0\n"
"RenderEvent 231 205 0 0 0 0 0\n"
"MouseMoveEvent 226 194 0 0 0 0 0\n"
"RenderEvent 226 194 0 0 0 0 0\n"
"MouseMoveEvent 222 188 0 0 0 0 0\n"
"RenderEvent 222 188 0 0 0 0 0\n"
"MouseMoveEvent 220 182 0 0 0 0 0\n"
"RenderEvent 220 182 0 0 0 0 0\n"
"MouseMoveEvent 218 177 0 0 0 0 0\n"
"RenderEvent 218 177 0 0 0 0 0\n"
"MouseMoveEvent 217 175 0 0 0 0 0\n"
"RenderEvent 217 175 0 0 0 0 0\n"
"MouseMoveEvent 216 173 0 0 0 0 0\n"
"RenderEvent 216 173 0 0 0 0 0\n"
"MouseMoveEvent 216 171 0 0 0 0 0\n"
"RenderEvent 216 171 0 0 0 0 0\n"
"MouseMoveEvent 215 170 0 0 0 0 0\n"
"RenderEvent 215 170 0 0 0 0 0\n"
"MouseMoveEvent 215 169 0 0 0 0 0\n"
"RenderEvent 215 169 0 0 0 0 0\n"
"MouseMoveEvent 215 167 0 0 0 0 0\n"
"RenderEvent 215 167 0 0 0 0 0\n"
"MouseMoveEvent 214 164 0 0 0 0 0\n"
"RenderEvent 214 164 0 0 0 0 0\n"
"MouseMoveEvent 214 161 0 0 0 0 0\n"
"RenderEvent 214 161 0 0 0 0 0\n"
"MouseMoveEvent 214 158 0 0 0 0 0\n"
"RenderEvent 214 158 0 0 0 0 0\n"
"MouseMoveEvent 214 156 0 0 0 0 0\n"
"RenderEvent 214 156 0 0 0 0 0\n"
"MouseMoveEvent 214 154 0 0 0 0 0\n"
"RenderEvent 214 154 0 0 0 0 0\n"
"MouseMoveEvent 214 153 0 0 0 0 0\n"
"RenderEvent 214 153 0 0 0 0 0\n"
"MouseMoveEvent 215 152 0 0 0 0 0\n"
"RenderEvent 215 152 0 0 0 0 0\n"
"MouseMoveEvent 215 151 0 0 0 0 0\n"
"RenderEvent 215 151 0 0 0 0 0\n"
"MouseMoveEvent 216 149 0 0 0 0 0\n"
"RenderEvent 216 149 0 0 0 0 0\n"
"MouseMoveEvent 216 145 0 0 0 0 0\n"
"RenderEvent 216 145 0 0 0 0 0\n"
"MouseMoveEvent 216 142 0 0 0 0 0\n"
"RenderEvent 216 142 0 0 0 0 0\n"
"MouseMoveEvent 217 139 0 0 0 0 0\n"
"RenderEvent 217 139 0 0 0 0 0\n"
"MouseMoveEvent 217 137 0 0 0 0 0\n"
"RenderEvent 217 137 0 0 0 0 0\n"
"MouseMoveEvent 217 135 0 0 0 0 0\n"
"RenderEvent 217 135 0 0 0 0 0\n"
"MouseMoveEvent 217 134 0 0 0 0 0\n"
"RenderEvent 217 134 0 0 0 0 0\n"
"LeftButtonPressEvent 217 134 0 0 0 0 0\n"
"RenderEvent 217 134 0 0 0 0 0\n"
"LeftButtonReleaseEvent 217 134 0 0 0 0 0\n"
"MouseMoveEvent 217 132 0 0 0 0 0\n"
"RenderEvent 217 132 0 0 0 0 0\n"
"MouseMoveEvent 217 130 0 0 0 0 0\n"
"RenderEvent 217 130 0 0 0 0 0\n"
"MouseMoveEvent 217 128 0 0 0 0 0\n"
"RenderEvent 217 128 0 0 0 0 0\n"
"MouseMoveEvent 217 124 0 0 0 0 0\n"
"RenderEvent 217 124 0 0 0 0 0\n"
"MouseMoveEvent 217 120 0 0 0 0 0\n"
"RenderEvent 217 120 0 0 0 0 0\n"
"MouseMoveEvent 217 110 0 0 0 0 0\n"
"RenderEvent 217 110 0 0 0 0 0\n"
"MouseMoveEvent 217 101 0 0 0 0 0\n"
"RenderEvent 217 101 0 0 0 0 0\n"
"MouseMoveEvent 217 91 0 0 0 0 0\n"
"RenderEvent 217 91 0 0 0 0 0\n"
"MouseMoveEvent 214 85 0 0 0 0 0\n"
"RenderEvent 214 85 0 0 0 0 0\n"
"MouseMoveEvent 213 80 0 0 0 0 0\n"
"RenderEvent 213 80 0 0 0 0 0\n"
"MouseMoveEvent 211 76 0 0 0 0 0\n"
"RenderEvent 211 76 0 0 0 0 0\n"
"MouseMoveEvent 210 74 0 0 0 0 0\n"
"RenderEvent 210 74 0 0 0 0 0\n"
"MouseMoveEvent 210 73 0 0 0 0 0\n"
"RenderEvent 210 73 0 0 0 0 0\n"
"MouseMoveEvent 209 72 0 0 0 0 0\n"
"RenderEvent 209 72 0 0 0 0 0\n"
"MouseMoveEvent 208 72 0 0 0 0 0\n"
"RenderEvent 208 72 0 0 0 0 0\n"
"MouseMoveEvent 207 73 0 0 0 0 0\n"
"RenderEvent 207 73 0 0 0 0 0\n"
"MouseMoveEvent 206 73 0 0 0 0 0\n"
"RenderEvent 206 73 0 0 0 0 0\n"
"MouseMoveEvent 205 74 0 0 0 0 0\n"
"RenderEvent 205 74 0 0 0 0 0\n"
"MouseMoveEvent 204 75 0 0 0 0 0\n"
"RenderEvent 204 75 0 0 0 0 0\n"
"MouseMoveEvent 203 76 0 0 0 0 0\n"
"RenderEvent 203 76 0 0 0 0 0\n"
"MouseMoveEvent 202 77 0 0 0 0 0\n"
"RenderEvent 202 77 0 0 0 0 0\n"
"MouseMoveEvent 201 78 0 0 0 0 0\n"
"RenderEvent 201 78 0 0 0 0 0\n"
"MouseMoveEvent 200 79 0 0 0 0 0\n"
"RenderEvent 200 79 0 0 0 0 0\n"
"MouseMoveEvent 199 80 0 0 0 0 0\n"
"RenderEvent 199 80 0 0 0 0 0\n"
"MouseMoveEvent 198 81 0 0 0 0 0\n"
"RenderEvent 198 81 0 0 0 0 0\n"
"MouseMoveEvent 197 82 0 0 0 0 0\n"
"RenderEvent 197 82 0 0 0 0 0\n"
"MouseMoveEvent 196 82 0 0 0 0 0\n"
"RenderEvent 196 82 0 0 0 0 0\n"
"MouseMoveEvent 195 82 0 0 0 0 0\n"
"RenderEvent 195 82 0 0 0 0 0\n"
"MouseMoveEvent 194 82 0 0 0 0 0\n"
"RenderEvent 194 82 0 0 0 0 0\n"
"MouseMoveEvent 193 82 0 0 0 0 0\n"
"RenderEvent 193 82 0 0 0 0 0\n"
"MouseMoveEvent 192 82 0 0 0 0 0\n"
"RenderEvent 192 82 0 0 0 0 0\n"
"LeftButtonPressEvent 192 82 0 0 0 0 0\n"
"RenderEvent 192 82 0 0 0 0 0\n"
"LeftButtonReleaseEvent 192 82 0 0 0 0 0\n"
"MouseMoveEvent 191 82 0 0 0 0 0\n"
"RenderEvent 191 82 0 0 0 0 0\n"
"MouseMoveEvent 190 82 0 0 0 0 0\n"
"RenderEvent 190 82 0 0 0 0 0\n"
"MouseMoveEvent 188 81 0 0 0 0 0\n"
"RenderEvent 188 81 0 0 0 0 0\n"
"MouseMoveEvent 187 80 0 0 0 0 0\n"
"RenderEvent 187 80 0 0 0 0 0\n"
"MouseMoveEvent 185 79 0 0 0 0 0\n"
"RenderEvent 185 79 0 0 0 0 0\n"
"MouseMoveEvent 182 78 0 0 0 0 0\n"
"RenderEvent 182 78 0 0 0 0 0\n"
"MouseMoveEvent 175 75 0 0 0 0 0\n"
"RenderEvent 175 75 0 0 0 0 0\n"
"MouseMoveEvent 166 73 0 0 0 0 0\n"
"RenderEvent 166 73 0 0 0 0 0\n"
"MouseMoveEvent 154 73 0 0 0 0 0\n"
"RenderEvent 154 73 0 0 0 0 0\n"
"MouseMoveEvent 143 73 0 0 0 0 0\n"
"RenderEvent 143 73 0 0 0 0 0\n"
"MouseMoveEvent 132 73 0 0 0 0 0\n"
"RenderEvent 132 73 0 0 0 0 0\n"
"MouseMoveEvent 122 73 0 0 0 0 0\n"
"RenderEvent 122 73 0 0 0 0 0\n"
"MouseMoveEvent 114 74 0 0 0 0 0\n"
"RenderEvent 114 74 0 0 0 0 0\n"
"MouseMoveEvent 108 75 0 0 0 0 0\n"
"RenderEvent 108 75 0 0 0 0 0\n"
"MouseMoveEvent 103 76 0 0 0 0 0\n"
"RenderEvent 103 76 0 0 0 0 0\n"
"MouseMoveEvent 101 76 0 0 0 0 0\n"
"RenderEvent 101 76 0 0 0 0 0\n"
"MouseMoveEvent 100 77 0 0 0 0 0\n"
"RenderEvent 100 77 0 0 0 0 0\n"
"MouseMoveEvent 97 78 0 0 0 0 0\n"
"RenderEvent 97 78 0 0 0 0 0\n"
"MouseMoveEvent 95 79 0 0 0 0 0\n"
"RenderEvent 95 79 0 0 0 0 0\n"
"MouseMoveEvent 90 81 0 0 0 0 0\n"
"RenderEvent 90 81 0 0 0 0 0\n"
"MouseMoveEvent 87 83 0 0 0 0 0\n"
"RenderEvent 87 83 0 0 0 0 0\n"
"MouseMoveEvent 83 85 0 0 0 0 0\n"
"RenderEvent 83 85 0 0 0 0 0\n"
"MouseMoveEvent 82 86 0 0 0 0 0\n"
"RenderEvent 82 86 0 0 0 0 0\n"
"MouseMoveEvent 81 87 0 0 0 0 0\n"
"RenderEvent 81 87 0 0 0 0 0\n"
"MouseMoveEvent 81 88 0 0 0 0 0\n"
"RenderEvent 81 88 0 0 0 0 0\n"
"MouseMoveEvent 81 89 0 0 0 0 0\n"
"RenderEvent 81 89 0 0 0 0 0\n"
"MouseMoveEvent 81 90 0 0 0 0 0\n"
"RenderEvent 81 90 0 0 0 0 0\n"
"MouseMoveEvent 82 91 0 0 0 0 0\n"
"RenderEvent 82 91 0 0 0 0 0\n"
"MouseMoveEvent 83 92 0 0 0 0 0\n"
"RenderEvent 83 92 0 0 0 0 0\n"
"MouseMoveEvent 83 93 0 0 0 0 0\n"
"RenderEvent 83 93 0 0 0 0 0\n"
"MouseMoveEvent 84 94 0 0 0 0 0\n"
"RenderEvent 84 94 0 0 0 0 0\n"
"MouseMoveEvent 84 95 0 0 0 0 0\n"
"RenderEvent 84 95 0 0 0 0 0\n"
"MouseMoveEvent 85 97 0 0 0 0 0\n"
"RenderEvent 85 97 0 0 0 0 0\n"
"MouseMoveEvent 86 98 0 0 0 0 0\n"
"RenderEvent 86 98 0 0 0 0 0\n"
"MouseMoveEvent 87 99 0 0 0 0 0\n"
"RenderEvent 87 99 0 0 0 0 0\n"
"MouseMoveEvent 88 99 0 0 0 0 0\n"
"RenderEvent 88 99 0 0 0 0 0\n"
"MouseMoveEvent 89 98 0 0 0 0 0\n"
"RenderEvent 89 98 0 0 0 0 0\n"
"MouseMoveEvent 90 98 0 0 0 0 0\n"
"RenderEvent 90 98 0 0 0 0 0\n"
"MouseMoveEvent 91 99 0 0 0 0 0\n"
"RenderEvent 91 99 0 0 0 0 0\n"
"MouseMoveEvent 92 100 0 0 0 0 0\n"
"RenderEvent 92 100 0 0 0 0 0\n"
"MouseMoveEvent 92 102 0 0 0 0 0\n"
"RenderEvent 92 102 0 0 0 0 0\n"
"MouseMoveEvent 92 103 0 0 0 0 0\n"
"RenderEvent 92 103 0 0 0 0 0\n"
"LeftButtonPressEvent 92 103 0 0 0 0 0\n"
"RenderEvent 92 103 0 0 0 0 0\n"
"LeftButtonReleaseEvent 92 103 0 0 0 0 0\n"
"MouseMoveEvent 92 105 0 0 0 0 0\n"
"RenderEvent 92 105 0 0 0 0 0\n"
"MouseMoveEvent 92 107 0 0 0 0 0\n"
"RenderEvent 92 107 0 0 0 0 0\n"
"MouseMoveEvent 92 110 0 0 0 0 0\n"
"RenderEvent 92 110 0 0 0 0 0\n"
"MouseMoveEvent 92 114 0 0 0 0 0\n"
"RenderEvent 92 114 0 0 0 0 0\n"
"MouseMoveEvent 92 127 0 0 0 0 0\n"
"RenderEvent 92 127 0 0 0 0 0\n"
"MouseMoveEvent 91 140 0 0 0 0 0\n"
"RenderEvent 91 140 0 0 0 0 0\n"
"MouseMoveEvent 89 153 0 0 0 0 0\n"
"RenderEvent 89 153 0 0 0 0 0\n"
"MouseMoveEvent 87 164 0 0 0 0 0\n"
"RenderEvent 87 164 0 0 0 0 0\n"
"MouseMoveEvent 86 172 0 0 0 0 0\n"
"RenderEvent 86 172 0 0 0 0 0\n"
"MouseMoveEvent 85 178 0 0 0 0 0\n"
"RenderEvent 85 178 0 0 0 0 0\n"
"MouseMoveEvent 83 187 0 0 0 0 0\n"
"RenderEvent 83 187 0 0 0 0 0\n"
"MouseMoveEvent 82 191 0 0 0 0 0\n"
"RenderEvent 82 191 0 0 0 0 0\n"
"MouseMoveEvent 81 195 0 0 0 0 0\n"
"RenderEvent 81 195 0 0 0 0 0\n"
"MouseMoveEvent 78 201 0 0 0 0 0\n"
"RenderEvent 78 201 0 0 0 0 0\n"
"MouseMoveEvent 76 206 0 0 0 0 0\n"
"RenderEvent 76 206 0 0 0 0 0\n"
"MouseMoveEvent 73 211 0 0 0 0 0\n"
"RenderEvent 73 211 0 0 0 0 0\n"
"MouseMoveEvent 73 212 0 0 0 0 0\n"
"RenderEvent 73 212 0 0 0 0 0\n"
"MouseMoveEvent 73 213 0 0 0 0 0\n"
"RenderEvent 73 213 0 0 0 0 0\n"
"MouseMoveEvent 72 214 0 0 0 0 0\n"
"RenderEvent 72 214 0 0 0 0 0\n"
"MouseMoveEvent 71 214 0 0 0 0 0\n"
"RenderEvent 71 214 0 0 0 0 0\n"
"MouseMoveEvent 70 214 0 0 0 0 0\n"
"RenderEvent 70 214 0 0 0 0 0\n"
"MouseMoveEvent 69 214 0 0 0 0 0\n"
"RenderEvent 69 214 0 0 0 0 0\n"
"MouseMoveEvent 68 213 0 0 0 0 0\n"
"RenderEvent 68 213 0 0 0 0 0\n"
"MouseMoveEvent 67 212 0 0 0 0 0\n"
"RenderEvent 67 212 0 0 0 0 0\n"
"MouseMoveEvent 67 211 0 0 0 0 0\n"
"RenderEvent 67 211 0 0 0 0 0\n"
"MouseMoveEvent 66 210 0 0 0 0 0\n"
"RenderEvent 66 210 0 0 0 0 0\n"
"LeftButtonPressEvent 66 210 0 0 0 0 0\n"
"RenderEvent 66 210 0 0 0 0 0\n"
"MouseMoveEvent 66 208 0 0 0 0 0\n"
"RenderEvent 66 208 0 0 0 0 0\n"
"MouseMoveEvent 66 206 0 0 0 0 0\n"
"RenderEvent 66 206 0 0 0 0 0\n"
"MouseMoveEvent 66 203 0 0 0 0 0\n"
"RenderEvent 66 203 0 0 0 0 0\n"
"MouseMoveEvent 66 202 0 0 0 0 0\n"
"RenderEvent 66 202 0 0 0 0 0\n"
"MouseMoveEvent 68 198 0 0 0 0 0\n"
"RenderEvent 68 198 0 0 0 0 0\n"
"MouseMoveEvent 70 192 0 0 0 0 0\n"
"RenderEvent 70 192 0 0 0 0 0\n"
"MouseMoveEvent 74 185 0 0 0 0 0\n"
"RenderEvent 74 185 0 0 0 0 0\n"
"MouseMoveEvent 78 178 0 0 0 0 0\n"
"RenderEvent 78 178 0 0 0 0 0\n"
"MouseMoveEvent 81 173 0 0 0 0 0\n"
"RenderEvent 81 173 0 0 0 0 0\n"
"MouseMoveEvent 83 170 0 0 0 0 0\n"
"RenderEvent 83 170 0 0 0 0 0\n"
"MouseMoveEvent 84 169 0 0 0 0 0\n"
"RenderEvent 84 169 0 0 0 0 0\n"
"MouseMoveEvent 85 167 0 0 0 0 0\n"
"RenderEvent 85 167 0 0 0 0 0\n"
"MouseMoveEvent 86 166 0 0 0 0 0\n"
"RenderEvent 86 166 0 0 0 0 0\n"
"MouseMoveEvent 88 162 0 0 0 0 0\n"
"RenderEvent 88 162 0 0 0 0 0\n"
"MouseMoveEvent 89 161 0 0 0 0 0\n"
"RenderEvent 89 161 0 0 0 0 0\n"
"MouseMoveEvent 89 160 0 0 0 0 0\n"
"RenderEvent 89 160 0 0 0 0 0\n"
"MouseMoveEvent 89 159 0 0 0 0 0\n"
"RenderEvent 89 159 0 0 0 0 0\n"
"MouseMoveEvent 89 158 0 0 0 0 0\n"
"RenderEvent 89 158 0 0 0 0 0\n"
"MouseMoveEvent 89 157 0 0 0 0 0\n"
"RenderEvent 89 157 0 0 0 0 0\n"
"MouseMoveEvent 89 156 0 0 0 0 0\n"
"RenderEvent 89 156 0 0 0 0 0\n"
"MouseMoveEvent 89 155 0 0 0 0 0\n"
"RenderEvent 89 155 0 0 0 0 0\n"
"MouseMoveEvent 90 154 0 0 0 0 0\n"
"RenderEvent 90 154 0 0 0 0 0\n"
"MouseMoveEvent 92 155 0 0 0 0 0\n"
"RenderEvent 92 155 0 0 0 0 0\n"
"MouseMoveEvent 92 156 0 0 0 0 0\n"
"RenderEvent 92 156 0 0 0 0 0\n"
"LeftButtonReleaseEvent 92 156 0 0 0 0 0\n"
"RenderEvent 92 156 0 0 0 0 0\n"
"MouseMoveEvent 94 158 0 0 0 0 0\n"
"RenderEvent 94 158 0 0 0 0 0\n"
"MouseMoveEvent 95 159 0 0 0 0 0\n"
"RenderEvent 95 159 0 0 0 0 0\n"
"MouseMoveEvent 97 159 0 0 0 0 0\n"
"RenderEvent 97 159 0 0 0 0 0\n"
"MouseMoveEvent 99 159 0 0 0 0 0\n"
"RenderEvent 99 159 0 0 0 0 0\n"
"MouseMoveEvent 100 160 0 0 0 0 0\n"
"RenderEvent 100 160 0 0 0 0 0\n"
"MouseMoveEvent 111 161 0 0 0 0 0\n"
"RenderEvent 111 161 0 0 0 0 0\n"
"MouseMoveEvent 119 161 0 0 0 0 0\n"
"RenderEvent 119 161 0 0 0 0 0\n"
"MouseMoveEvent 128 161 0 0 0 0 0\n"
"RenderEvent 128 161 0 0 0 0 0\n"
"MouseMoveEvent 138 163 0 0 0 0 0\n"
"RenderEvent 138 163 0 0 0 0 0\n"
"MouseMoveEvent 148 164 0 0 0 0 0\n"
"RenderEvent 148 164 0 0 0 0 0\n"
"MouseMoveEvent 155 165 0 0 0 0 0\n"
"RenderEvent 155 165 0 0 0 0 0\n"
"MouseMoveEvent 161 166 0 0 0 0 0\n"
"RenderEvent 161 166 0 0 0 0 0\n"
"MouseMoveEvent 167 168 0 0 0 0 0\n"
"RenderEvent 167 168 0 0 0 0 0\n"
"MouseMoveEvent 171 170 0 0 0 0 0\n"
"RenderEvent 171 170 0 0 0 0 0\n"
"MouseMoveEvent 174 171 0 0 0 0 0\n"
"RenderEvent 174 171 0 0 0 0 0\n"
"MouseMoveEvent 176 173 0 0 0 0 0\n"
"RenderEvent 176 173 0 0 0 0 0\n"
"MouseMoveEvent 179 176 0 0 0 0 0\n"
"RenderEvent 179 176 0 0 0 0 0\n"
"MouseMoveEvent 185 184 0 0 0 0 0\n"
"RenderEvent 185 184 0 0 0 0 0\n"
"MouseMoveEvent 189 190 0 0 0 0 0\n"
"RenderEvent 189 190 0 0 0 0 0\n"
"MouseMoveEvent 191 192 0 0 0 0 0\n"
"RenderEvent 191 192 0 0 0 0 0\n"
"MouseMoveEvent 192 193 0 0 0 0 0\n"
"RenderEvent 192 193 0 0 0 0 0\n"
"MouseMoveEvent 194 194 0 0 0 0 0\n"
"RenderEvent 194 194 0 0 0 0 0\n"
"MouseMoveEvent 195 195 0 0 0 0 0\n"
"RenderEvent 195 195 0 0 0 0 0\n"
"MouseMoveEvent 196 196 0 0 0 0 0\n"
"RenderEvent 196 196 0 0 0 0 0\n"
"MouseMoveEvent 197 197 0 0 0 0 0\n"
"RenderEvent 197 197 0 0 0 0 0\n"
"MouseMoveEvent 198 199 0 0 0 0 0\n"
"RenderEvent 198 199 0 0 0 0 0\n"
"MouseMoveEvent 199 200 0 0 0 0 0\n"
"RenderEvent 199 200 0 0 0 0 0\n"
"MouseMoveEvent 200 201 0 0 0 0 0\n"
"RenderEvent 200 201 0 0 0 0 0\n"
"MouseMoveEvent 201 202 0 0 0 0 0\n"
"RenderEvent 201 202 0 0 0 0 0\n"
"MouseMoveEvent 202 203 0 0 0 0 0\n"
"RenderEvent 202 203 0 0 0 0 0\n"
"MouseMoveEvent 206 206 0 0 0 0 0\n"
"RenderEvent 206 206 0 0 0 0 0\n"
"MouseMoveEvent 210 208 0 0 0 0 0\n"
"RenderEvent 210 208 0 0 0 0 0\n"
"MouseMoveEvent 214 210 0 0 0 0 0\n"
"RenderEvent 214 210 0 0 0 0 0\n"
"MouseMoveEvent 217 211 0 0 0 0 0\n"
"RenderEvent 217 211 0 0 0 0 0\n"
"MouseMoveEvent 220 212 0 0 0 0 0\n"
"RenderEvent 220 212 0 0 0 0 0\n"
"MouseMoveEvent 222 213 0 0 0 0 0\n"
"RenderEvent 222 213 0 0 0 0 0\n"
"MouseMoveEvent 226 215 0 0 0 0 0\n"
"RenderEvent 226 215 0 0 0 0 0\n"
"MouseMoveEvent 228 217 0 0 0 0 0\n"
"RenderEvent 228 217 0 0 0 0 0\n"
"MouseMoveEvent 229 218 0 0 0 0 0\n"
"RenderEvent 229 218 0 0 0 0 0\n"
"MouseMoveEvent 231 219 0 0 0 0 0\n"
"RenderEvent 231 219 0 0 0 0 0\n"
"MouseMoveEvent 233 221 0 0 0 0 0\n"
"RenderEvent 233 221 0 0 0 0 0\n"
"MouseMoveEvent 234 222 0 0 0 0 0\n"
"RenderEvent 234 222 0 0 0 0 0\n"
"MouseMoveEvent 236 223 0 0 0 0 0\n"
"RenderEvent 236 223 0 0 0 0 0\n"
"MouseMoveEvent 237 222 0 0 0 0 0\n"
"RenderEvent 237 222 0 0 0 0 0\n"
"MouseMoveEvent 238 221 0 0 0 0 0\n"
"RenderEvent 238 221 0 0 0 0 0\n"
"MouseMoveEvent 239 221 0 0 0 0 0\n"
"RenderEvent 239 221 0 0 0 0 0\n"
"MouseMoveEvent 240 221 0 0 0 0 0\n"
"RenderEvent 240 221 0 0 0 0 0\n"
"LeftButtonPressEvent 240 221 0 0 0 0 0\n"
"RenderEvent 240 221 0 0 0 0 0\n"
"MouseMoveEvent 238 221 0 0 0 0 0\n"
"RenderEvent 238 221 0 0 0 0 0\n"
"MouseMoveEvent 235 221 0 0 0 0 0\n"
"RenderEvent 235 221 0 0 0 0 0\n"
"MouseMoveEvent 233 220 0 0 0 0 0\n"
"RenderEvent 233 220 0 0 0 0 0\n"
"MouseMoveEvent 231 220 0 0 0 0 0\n"
"RenderEvent 231 220 0 0 0 0 0\n"
"MouseMoveEvent 229 219 0 0 0 0 0\n"
"RenderEvent 229 219 0 0 0 0 0\n"
"MouseMoveEvent 223 218 0 0 0 0 0\n"
"RenderEvent 223 218 0 0 0 0 0\n"
"MouseMoveEvent 214 216 0 0 0 0 0\n"
"RenderEvent 214 216 0 0 0 0 0\n"
"MouseMoveEvent 207 216 0 0 0 0 0\n"
"RenderEvent 207 216 0 0 0 0 0\n"
"MouseMoveEvent 195 214 0 0 0 0 0\n"
"RenderEvent 195 214 0 0 0 0 0\n"
"MouseMoveEvent 181 212 0 0 0 0 0\n"
"RenderEvent 181 212 0 0 0 0 0\n"
"MouseMoveEvent 166 212 0 0 0 0 0\n"
"RenderEvent 166 212 0 0 0 0 0\n"
"MouseMoveEvent 148 212 0 0 0 0 0\n"
"RenderEvent 148 212 0 0 0 0 0\n"
"MouseMoveEvent 130 212 0 0 0 0 0\n"
"RenderEvent 130 212 0 0 0 0 0\n"
"MouseMoveEvent 115 212 0 0 0 0 0\n"
"RenderEvent 115 212 0 0 0 0 0\n"
"MouseMoveEvent 102 212 0 0 0 0 0\n"
"RenderEvent 102 212 0 0 0 0 0\n"
"MouseMoveEvent 92 212 0 0 0 0 0\n"
"RenderEvent 92 212 0 0 0 0 0\n"
"MouseMoveEvent 86 212 0 0 0 0 0\n"
"RenderEvent 86 212 0 0 0 0 0\n"
"MouseMoveEvent 84 212 0 0 0 0 0\n"
"RenderEvent 84 212 0 0 0 0 0\n"
"MouseMoveEvent 82 212 0 0 0 0 0\n"
"RenderEvent 82 212 0 0 0 0 0\n"
"MouseMoveEvent 81 212 0 0 0 0 0\n"
"RenderEvent 81 212 0 0 0 0 0\n"
"MouseMoveEvent 80 212 0 0 0 0 0\n"
"RenderEvent 80 212 0 0 0 0 0\n"
"MouseMoveEvent 77 212 0 0 0 0 0\n"
"RenderEvent 77 212 0 0 0 0 0\n"
"MouseMoveEvent 74 213 0 0 0 0 0\n"
"RenderEvent 74 213 0 0 0 0 0\n"
"MouseMoveEvent 71 214 0 0 0 0 0\n"
"RenderEvent 71 214 0 0 0 0 0\n"
"MouseMoveEvent 67 214 0 0 0 0 0\n"
"RenderEvent 67 214 0 0 0 0 0\n"
"MouseMoveEvent 63 215 0 0 0 0 0\n"
"RenderEvent 63 215 0 0 0 0 0\n"
"MouseMoveEvent 62 216 0 0 0 0 0\n"
"RenderEvent 62 216 0 0 0 0 0\n"
"MouseMoveEvent 61 216 0 0 0 0 0\n"
"RenderEvent 61 216 0 0 0 0 0\n"
"MouseMoveEvent 60 216 0 0 0 0 0\n"
"RenderEvent 60 216 0 0 0 0 0\n"
"LeftButtonReleaseEvent 60 216 0 0 0 0 0\n"
"RenderEvent 60 216 0 0 0 0 0\n"
"MouseMoveEvent 62 213 0 0 0 0 0\n"
"RenderEvent 62 213 0 0 0 0 0\n"
"MouseMoveEvent 64 211 0 0 0 0 0\n"
"RenderEvent 64 211 0 0 0 0 0\n"
"MouseMoveEvent 66 209 0 0 0 0 0\n"
"RenderEvent 66 209 0 0 0 0 0\n"
"MouseMoveEvent 72 202 0 0 0 0 0\n"
"RenderEvent 72 202 0 0 0 0 0\n"
"MouseMoveEvent 79 192 0 0 0 0 0\n"
"RenderEvent 79 192 0 0 0 0 0\n"
"MouseMoveEvent 90 177 0 0 0 0 0\n"
"RenderEvent 90 177 0 0 0 0 0\n"
"MouseMoveEvent 105 160 0 0 0 0 0\n"
"RenderEvent 105 160 0 0 0 0 0\n"
"MouseMoveEvent 122 142 0 0 0 0 0\n"
"RenderEvent 122 142 0 0 0 0 0\n"
"MouseMoveEvent 139 127 0 0 0 0 0\n"
"RenderEvent 139 127 0 0 0 0 0\n"
"MouseMoveEvent 153 116 0 0 0 0 0\n"
"RenderEvent 153 116 0 0 0 0 0\n"
"MouseMoveEvent 172 102 0 0 0 0 0\n"
"RenderEvent 172 102 0 0 0 0 0\n"
"MouseMoveEvent 181 95 0 0 0 0 0\n"
"RenderEvent 181 95 0 0 0 0 0\n"
"MouseMoveEvent 188 87 0 0 0 0 0\n"
"RenderEvent 188 87 0 0 0 0 0\n"
"MouseMoveEvent 191 82 0 0 0 0 0\n"
"RenderEvent 191 82 0 0 0 0 0\n"
"MouseMoveEvent 194 76 0 0 0 0 0\n"
"RenderEvent 194 76 0 0 0 0 0\n"
"MouseMoveEvent 195 72 0 0 0 0 0\n"
"RenderEvent 195 72 0 0 0 0 0\n"
"MouseMoveEvent 195 69 0 0 0 0 0\n"
"RenderEvent 195 69 0 0 0 0 0\n"
"MouseMoveEvent 195 67 0 0 0 0 0\n"
"RenderEvent 195 67 0 0 0 0 0\n"
"MouseMoveEvent 195 66 0 0 0 0 0\n"
"RenderEvent 195 66 0 0 0 0 0\n"
"MouseMoveEvent 195 65 0 0 0 0 0\n"
"RenderEvent 195 65 0 0 0 0 0\n"
"MouseMoveEvent 195 64 0 0 0 0 0\n"
"RenderEvent 195 64 0 0 0 0 0\n"
"MouseMoveEvent 194 63 0 0 0 0 0\n"
"RenderEvent 194 63 0 0 0 0 0\n"
"MouseMoveEvent 193 63 0 0 0 0 0\n"
"RenderEvent 193 63 0 0 0 0 0\n"
"MouseMoveEvent 192 63 0 0 0 0 0\n"
"RenderEvent 192 63 0 0 0 0 0\n"
"MouseMoveEvent 191 63 0 0 0 0 0\n"
"RenderEvent 191 63 0 0 0 0 0\n"
"MouseMoveEvent 190 64 0 0 0 0 0\n"
"RenderEvent 190 64 0 0 0 0 0\n"
"MouseMoveEvent 188 66 0 0 0 0 0\n"
"RenderEvent 188 66 0 0 0 0 0\n"
"MouseMoveEvent 188 68 0 0 0 0 0\n"
"RenderEvent 188 68 0 0 0 0 0\n"
"MouseMoveEvent 188 71 0 0 0 0 0\n"
"RenderEvent 188 71 0 0 0 0 0\n"
"MouseMoveEvent 188 73 0 0 0 0 0\n"
"RenderEvent 188 73 0 0 0 0 0\n"
"MouseMoveEvent 188 76 0 0 0 0 0\n"
"RenderEvent 188 76 0 0 0 0 0\n"
"MouseMoveEvent 188 80 0 0 0 0 0\n"
"RenderEvent 188 80 0 0 0 0 0\n"
"MouseMoveEvent 188 81 0 0 0 0 0\n"
"RenderEvent 188 81 0 0 0 0 0\n"
"MouseMoveEvent 188 82 0 0 0 0 0\n"
"RenderEvent 188 82 0 0 0 0 0\n"
"LeftButtonPressEvent 188 82 0 0 0 0 0\n"
"RenderEvent 188 82 0 0 0 0 0\n"
"MouseMoveEvent 188 83 0 0 0 0 0\n"
"RenderEvent 188 83 0 0 0 0 0\n"
"MouseMoveEvent 188 84 0 0 0 0 0\n"
"RenderEvent 188 84 0 0 0 0 0\n"
"MouseMoveEvent 188 86 0 0 0 0 0\n"
"RenderEvent 188 86 0 0 0 0 0\n"
"MouseMoveEvent 190 89 0 0 0 0 0\n"
"RenderEvent 190 89 0 0 0 0 0\n"
"MouseMoveEvent 191 91 0 0 0 0 0\n"
"RenderEvent 191 91 0 0 0 0 0\n"
"MouseMoveEvent 193 94 0 0 0 0 0\n"
"RenderEvent 193 94 0 0 0 0 0\n"
"MouseMoveEvent 194 98 0 0 0 0 0\n"
"RenderEvent 194 98 0 0 0 0 0\n"
"MouseMoveEvent 194 103 0 0 0 0 0\n"
"RenderEvent 194 103 0 0 0 0 0\n"
"MouseMoveEvent 194 110 0 0 0 0 0\n"
"RenderEvent 194 110 0 0 0 0 0\n"
"MouseMoveEvent 194 122 0 0 0 0 0\n"
"RenderEvent 194 122 0 0 0 0 0\n"
"MouseMoveEvent 193 127 0 0 0 0 0\n"
"RenderEvent 193 127 0 0 0 0 0\n"
"MouseMoveEvent 192 132 0 0 0 0 0\n"
"RenderEvent 192 132 0 0 0 0 0\n"
"MouseMoveEvent 190 136 0 0 0 0 0\n"
"RenderEvent 190 136 0 0 0 0 0\n"
"MouseMoveEvent 189 140 0 0 0 0 0\n"
"RenderEvent 189 140 0 0 0 0 0\n"
"MouseMoveEvent 187 144 0 0 0 0 0\n"
"RenderEvent 187 144 0 0 0 0 0\n"
"MouseMoveEvent 185 149 0 0 0 0 0\n"
"RenderEvent 185 149 0 0 0 0 0\n"
"MouseMoveEvent 182 155 0 0 0 0 0\n"
"RenderEvent 182 155 0 0 0 0 0\n"
"MouseMoveEvent 180 160 0 0 0 0 0\n"
"RenderEvent 180 160 0 0 0 0 0\n"
"MouseMoveEvent 178 163 0 0 0 0 0\n"
"RenderEvent 178 163 0 0 0 0 0\n"
"MouseMoveEvent 176 167 0 0 0 0 0\n"
"RenderEvent 176 167 0 0 0 0 0\n"
"MouseMoveEvent 174 171 0 0 0 0 0\n"
"RenderEvent 174 171 0 0 0 0 0\n"
"MouseMoveEvent 173 173 0 0 0 0 0\n"
"RenderEvent 173 173 0 0 0 0 0\n"
"MouseMoveEvent 172 174 0 0 0 0 0\n"
"RenderEvent 172 174 0 0 0 0 0\n"
"MouseMoveEvent 172 175 0 0 0 0 0\n"
"RenderEvent 172 175 0 0 0 0 0\n"
"MouseMoveEvent 171 176 0 0 0 0 0\n"
"RenderEvent 171 176 0 0 0 0 0\n"
"MouseMoveEvent 171 177 0 0 0 0 0\n"
"RenderEvent 171 177 0 0 0 0 0\n"
"MouseMoveEvent 171 178 0 0 0 0 0\n"
"RenderEvent 171 178 0 0 0 0 0\n"
"MouseMoveEvent 170 179 0 0 0 0 0\n"
"RenderEvent 170 179 0 0 0 0 0\n"
"MouseMoveEvent 170 180 0 0 0 0 0\n"
"RenderEvent 170 180 0 0 0 0 0\n"
"MouseMoveEvent 169 182 0 0 0 0 0\n"
"RenderEvent 169 182 0 0 0 0 0\n"
"MouseMoveEvent 169 183 0 0 0 0 0\n"
"RenderEvent 169 183 0 0 0 0 0\n"
"MouseMoveEvent 169 184 0 0 0 0 0\n"
"RenderEvent 169 184 0 0 0 0 0\n"
"MouseMoveEvent 168 185 0 0 0 0 0\n"
"RenderEvent 168 185 0 0 0 0 0\n"
"MouseMoveEvent 168 186 0 0 0 0 0\n"
"RenderEvent 168 186 0 0 0 0 0\n"
"MouseMoveEvent 168 187 0 0 0 0 0\n"
"RenderEvent 168 187 0 0 0 0 0\n"
"MouseMoveEvent 167 188 0 0 0 0 0\n"
"RenderEvent 167 188 0 0 0 0 0\n"
"MouseMoveEvent 167 189 0 0 0 0 0\n"
"RenderEvent 167 189 0 0 0 0 0\n"
"MouseMoveEvent 167 190 0 0 0 0 0\n"
"RenderEvent 167 190 0 0 0 0 0\n"
"MouseMoveEvent 166 191 0 0 0 0 0\n"
"RenderEvent 166 191 0 0 0 0 0\n"
"MouseMoveEvent 166 192 0 0 0 0 0\n"
"RenderEvent 166 192 0 0 0 0 0\n"
"MouseMoveEvent 165 193 0 0 0 0 0\n"
"RenderEvent 165 193 0 0 0 0 0\n"
"MouseMoveEvent 165 194 0 0 0 0 0\n"
"RenderEvent 165 194 0 0 0 0 0\n"
"MouseMoveEvent 164 195 0 0 0 0 0\n"
"RenderEvent 164 195 0 0 0 0 0\n"
"MouseMoveEvent 164 196 0 0 0 0 0\n"
"RenderEvent 164 196 0 0 0 0 0\n"
"MouseMoveEvent 164 197 0 0 0 0 0\n"
"RenderEvent 164 197 0 0 0 0 0\n"
"LeftButtonReleaseEvent 164 197 0 0 0 0 0\n"
"RenderEvent 164 197 0 0 0 0 0\n"
"MouseMoveEvent 164 195 0 0 0 0 0\n"
"RenderEvent 164 195 0 0 0 0 0\n"
"MouseMoveEvent 164 193 0 0 0 0 0\n"
"RenderEvent 164 193 0 0 0 0 0\n"
"MouseMoveEvent 165 189 0 0 0 0 0\n"
"RenderEvent 165 189 0 0 0 0 0\n"
"MouseMoveEvent 168 180 0 0 0 0 0\n"
"RenderEvent 168 180 0 0 0 0 0\n"
"MouseMoveEvent 171 168 0 0 0 0 0\n"
"RenderEvent 171 168 0 0 0 0 0\n"
"MouseMoveEvent 172 156 0 0 0 0 0\n"
"RenderEvent 172 156 0 0 0 0 0\n"
"MouseMoveEvent 174 146 0 0 0 0 0\n"
"RenderEvent 174 146 0 0 0 0 0\n"
"MouseMoveEvent 174 136 0 0 0 0 0\n"
"RenderEvent 174 136 0 0 0 0 0\n"
"MouseMoveEvent 174 126 0 0 0 0 0\n"
"RenderEvent 174 126 0 0 0 0 0\n"
"MouseMoveEvent 174 115 0 0 0 0 0\n"
"RenderEvent 174 115 0 0 0 0 0\n"
"MouseMoveEvent 173 107 0 0 0 0 0\n"
"RenderEvent 173 107 0 0 0 0 0\n"
"MouseMoveEvent 170 100 0 0 0 0 0\n"
"RenderEvent 170 100 0 0 0 0 0\n"
"MouseMoveEvent 167 92 0 0 0 0 0\n"
"RenderEvent 167 92 0 0 0 0 0\n"
"MouseMoveEvent 164 88 0 0 0 0 0\n"
"RenderEvent 164 88 0 0 0 0 0\n"
"MouseMoveEvent 160 84 0 0 0 0 0\n"
"RenderEvent 160 84 0 0 0 0 0\n"
"MouseMoveEvent 153 81 0 0 0 0 0\n"
"RenderEvent 153 81 0 0 0 0 0\n"
"MouseMoveEvent 145 79 0 0 0 0 0\n"
"RenderEvent 145 79 0 0 0 0 0\n"
"MouseMoveEvent 136 77 0 0 0 0 0\n"
"RenderEvent 136 77 0 0 0 0 0\n"
"MouseMoveEvent 127 76 0 0 0 0 0\n"
"RenderEvent 127 76 0 0 0 0 0\n"
"MouseMoveEvent 116 75 0 0 0 0 0\n"
"RenderEvent 116 75 0 0 0 0 0\n"
"MouseMoveEvent 109 74 0 0 0 0 0\n"
"RenderEvent 109 74 0 0 0 0 0\n"
"MouseMoveEvent 102 74 0 0 0 0 0\n"
"RenderEvent 102 74 0 0 0 0 0\n"
"MouseMoveEvent 97 74 0 0 0 0 0\n"
"RenderEvent 97 74 0 0 0 0 0\n"
"MouseMoveEvent 93 74 0 0 0 0 0\n"
"RenderEvent 93 74 0 0 0 0 0\n"
"MouseMoveEvent 91 74 0 0 0 0 0\n"
"RenderEvent 91 74 0 0 0 0 0\n"
"MouseMoveEvent 90 74 0 0 0 0 0\n"
"RenderEvent 90 74 0 0 0 0 0\n"
"MouseMoveEvent 88 74 0 0 0 0 0\n"
"RenderEvent 88 74 0 0 0 0 0\n"
"MouseMoveEvent 85 74 0 0 0 0 0\n"
"RenderEvent 85 74 0 0 0 0 0\n"
"MouseMoveEvent 83 74 0 0 0 0 0\n"
"RenderEvent 83 74 0 0 0 0 0\n"
"MouseMoveEvent 80 74 0 0 0 0 0\n"
"RenderEvent 80 74 0 0 0 0 0\n"
"MouseMoveEvent 77 74 0 0 0 0 0\n"
"RenderEvent 77 74 0 0 0 0 0\n"
"MouseMoveEvent 75 74 0 0 0 0 0\n"
"RenderEvent 75 74 0 0 0 0 0\n"
"MouseMoveEvent 72 75 0 0 0 0 0\n"
"RenderEvent 72 75 0 0 0 0 0\n"
"MouseMoveEvent 69 75 0 0 0 0 0\n"
"RenderEvent 69 75 0 0 0 0 0\n"
"MouseMoveEvent 67 76 0 0 0 0 0\n"
"RenderEvent 67 76 0 0 0 0 0\n"
"MouseMoveEvent 66 76 0 0 0 0 0\n"
"RenderEvent 66 76 0 0 0 0 0\n"
"MouseMoveEvent 64 77 0 0 0 0 0\n"
"RenderEvent 64 77 0 0 0 0 0\n"
"MouseMoveEvent 64 78 0 0 0 0 0\n"
"RenderEvent 64 78 0 0 0 0 0\n"
"MouseMoveEvent 64 80 0 0 0 0 0\n"
"RenderEvent 64 80 0 0 0 0 0\n"
"MouseMoveEvent 64 81 0 0 0 0 0\n"
"RenderEvent 64 81 0 0 0 0 0\n"
"MouseMoveEvent 66 84 0 0 0 0 0\n"
"RenderEvent 66 84 0 0 0 0 0\n"
"MouseMoveEvent 68 86 0 0 0 0 0\n"
"RenderEvent 68 86 0 0 0 0 0\n"
"MouseMoveEvent 71 89 0 0 0 0 0\n"
"RenderEvent 71 89 0 0 0 0 0\n"
"MouseMoveEvent 74 92 0 0 0 0 0\n"
"RenderEvent 74 92 0 0 0 0 0\n"
"MouseMoveEvent 77 95 0 0 0 0 0\n"
"RenderEvent 77 95 0 0 0 0 0\n"
"MouseMoveEvent 79 97 0 0 0 0 0\n"
"RenderEvent 79 97 0 0 0 0 0\n"
"MouseMoveEvent 81 101 0 0 0 0 0\n"
"RenderEvent 81 101 0 0 0 0 0\n"
"MouseMoveEvent 82 103 0 0 0 0 0\n"
"RenderEvent 82 103 0 0 0 0 0\n"
"MouseMoveEvent 83 104 0 0 0 0 0\n"
"RenderEvent 83 104 0 0 0 0 0\n"
"MouseMoveEvent 84 105 0 0 0 0 0\n"
"RenderEvent 84 105 0 0 0 0 0\n"
"MouseMoveEvent 84 106 0 0 0 0 0\n"
"RenderEvent 84 106 0 0 0 0 0\n"
"MouseMoveEvent 85 107 0 0 0 0 0\n"
"RenderEvent 85 107 0 0 0 0 0\n"
"MouseMoveEvent 86 109 0 0 0 0 0\n"
"RenderEvent 86 109 0 0 0 0 0\n"
"MouseMoveEvent 86 110 0 0 0 0 0\n"
"RenderEvent 86 110 0 0 0 0 0\n"
"MouseMoveEvent 87 111 0 0 0 0 0\n"
"RenderEvent 87 111 0 0 0 0 0\n"
"MouseMoveEvent 88 112 0 0 0 0 0\n"
"RenderEvent 88 112 0 0 0 0 0\n"
"MouseMoveEvent 89 112 0 0 0 0 0\n"
"RenderEvent 89 112 0 0 0 0 0\n"
"MouseMoveEvent 90 112 0 0 0 0 0\n"
"RenderEvent 90 112 0 0 0 0 0\n"
"MouseMoveEvent 91 112 0 0 0 0 0\n"
"RenderEvent 91 112 0 0 0 0 0\n"
"MouseMoveEvent 92 111 0 0 0 0 0\n"
"RenderEvent 92 111 0 0 0 0 0\n"
"MouseMoveEvent 91 110 0 0 0 0 0\n"
"RenderEvent 91 110 0 0 0 0 0\n"
"MouseMoveEvent 91 109 0 0 0 0 0\n"
"RenderEvent 91 109 0 0 0 0 0\n"
"MouseMoveEvent 91 108 0 0 0 0 0\n"
"RenderEvent 91 108 0 0 0 0 0\n"
"MouseMoveEvent 92 107 0 0 0 0 0\n"
"RenderEvent 92 107 0 0 0 0 0\n"
"LeftButtonPressEvent 92 107 0 0 0 0 0\n"
"RenderEvent 92 107 0 0 0 0 0\n"
"MouseMoveEvent 93 106 0 0 0 0 0\n"
"RenderEvent 93 106 0 0 0 0 0\n"
"MouseMoveEvent 94 106 0 0 0 0 0\n"
"RenderEvent 94 106 0 0 0 0 0\n"
"MouseMoveEvent 97 106 0 0 0 0 0\n"
"RenderEvent 97 106 0 0 0 0 0\n"
"MouseMoveEvent 101 105 0 0 0 0 0\n"
"RenderEvent 101 105 0 0 0 0 0\n"
"MouseMoveEvent 108 104 0 0 0 0 0\n"
"RenderEvent 108 104 0 0 0 0 0\n"
"MouseMoveEvent 118 103 0 0 0 0 0\n"
"RenderEvent 118 103 0 0 0 0 0\n"
"MouseMoveEvent 133 100 0 0 0 0 0\n"
"RenderEvent 133 100 0 0 0 0 0\n"
"MouseMoveEvent 142 97 0 0 0 0 0\n"
"RenderEvent 142 97 0 0 0 0 0\n"
"MouseMoveEvent 149 96 0 0 0 0 0\n"
"RenderEvent 149 96 0 0 0 0 0\n"
"MouseMoveEvent 156 95 0 0 0 0 0\n"
"RenderEvent 156 95 0 0 0 0 0\n"
"MouseMoveEvent 162 94 0 0 0 0 0\n"
"RenderEvent 162 94 0 0 0 0 0\n"
"MouseMoveEvent 169 93 0 0 0 0 0\n"
"RenderEvent 169 93 0 0 0 0 0\n"
"MouseMoveEvent 174 91 0 0 0 0 0\n"
"RenderEvent 174 91 0 0 0 0 0\n"
"MouseMoveEvent 179 90 0 0 0 0 0\n"
"RenderEvent 179 90 0 0 0 0 0\n"
"MouseMoveEvent 183 88 0 0 0 0 0\n"
"RenderEvent 183 88 0 0 0 0 0\n"
"MouseMoveEvent 186 88 0 0 0 0 0\n"
"RenderEvent 186 88 0 0 0 0 0\n"
"MouseMoveEvent 188 87 0 0 0 0 0\n"
"RenderEvent 188 87 0 0 0 0 0\n"
"MouseMoveEvent 189 87 0 0 0 0 0\n"
"RenderEvent 189 87 0 0 0 0 0\n"
"LeftButtonReleaseEvent 189 87 0 0 0 0 0\n"
"RenderEvent 189 87 0 0 0 0 0\n"
"MouseMoveEvent 190 86 0 0 0 0 0\n"
"RenderEvent 190 86 0 0 0 0 0\n"
"MouseMoveEvent 190 85 0 0 0 0 0\n"
"RenderEvent 190 85 0 0 0 0 0\n"
"MouseMoveEvent 188 83 0 0 0 0 0\n"
"RenderEvent 188 83 0 0 0 0 0\n"
"MouseMoveEvent 182 79 0 0 0 0 0\n"
"RenderEvent 182 79 0 0 0 0 0\n"
"MouseMoveEvent 172 76 0 0 0 0 0\n"
"RenderEvent 172 76 0 0 0 0 0\n"
"MouseMoveEvent 161 74 0 0 0 0 0\n"
"RenderEvent 161 74 0 0 0 0 0\n"
"MouseMoveEvent 146 73 0 0 0 0 0\n"
"RenderEvent 146 73 0 0 0 0 0\n"
"MouseMoveEvent 129 73 0 0 0 0 0\n"
"RenderEvent 129 73 0 0 0 0 0\n"
"MouseMoveEvent 112 73 0 0 0 0 0\n"
"RenderEvent 112 73 0 0 0 0 0\n"
"MouseMoveEvent 98 73 0 0 0 0 0\n"
"RenderEvent 98 73 0 0 0 0 0\n"
"MouseMoveEvent 83 73 0 0 0 0 0\n"
"RenderEvent 83 73 0 0 0 0 0\n"
"MouseMoveEvent 70 73 0 0 0 0 0\n"
"RenderEvent 70 73 0 0 0 0 0\n"
"MouseMoveEvent 56 73 0 0 0 0 0\n"
"RenderEvent 56 73 0 0 0 0 0\n"
"MouseMoveEvent 50 73 0 0 0 0 0\n"
"RenderEvent 50 73 0 0 0 0 0\n"
"MouseMoveEvent 47 73 0 0 0 0 0\n"
"RenderEvent 47 73 0 0 0 0 0\n"
"MouseMoveEvent 45 73 0 0 0 0 0\n"
"RenderEvent 45 73 0 0 0 0 0\n"
"MouseMoveEvent 44 73 0 0 0 0 0\n"
"RenderEvent 44 73 0 0 0 0 0\n"
"MouseMoveEvent 43 73 0 0 0 0 0\n"
"RenderEvent 43 73 0 0 0 0 0\n"
"MouseMoveEvent 42 73 0 0 0 0 0\n"
"RenderEvent 42 73 0 0 0 0 0\n"
"MouseMoveEvent 41 74 0 0 0 0 0\n"
"RenderEvent 41 74 0 0 0 0 0\n"
"MouseMoveEvent 40 74 0 0 0 0 0\n"
"RenderEvent 40 74 0 0 0 0 0\n"
"MouseMoveEvent 39 74 0 0 0 0 0\n"
"RenderEvent 39 74 0 0 0 0 0\n"
"MouseMoveEvent 38 75 0 0 0 0 0\n"
"RenderEvent 38 75 0 0 0 0 0\n"
"MouseMoveEvent 37 75 0 0 0 0 0\n"
"RenderEvent 37 75 0 0 0 0 0\n"
"MouseMoveEvent 36 75 0 0 0 0 0\n"
"RenderEvent 36 75 0 0 0 0 0\n"
"MouseMoveEvent 35 75 0 0 0 0 0\n"
"RenderEvent 35 75 0 0 0 0 0\n"
"MouseMoveEvent 34 76 0 0 0 0 0\n"
"RenderEvent 34 76 0 0 0 0 0\n"
"MouseMoveEvent 33 77 0 0 0 0 0\n"
"RenderEvent 33 77 0 0 0 0 0\n"
"MouseMoveEvent 32 78 0 0 0 0 0\n"
"RenderEvent 32 78 0 0 0 0 0\n"
"MouseMoveEvent 31 79 0 0 0 0 0\n"
"RenderEvent 31 79 0 0 0 0 0\n"
"MouseMoveEvent 31 80 0 0 0 0 0\n"
"RenderEvent 31 80 0 0 0 0 0\n"
"MouseMoveEvent 31 82 0 0 0 0 0\n"
"RenderEvent 31 82 0 0 0 0 0\n"
"MouseMoveEvent 30 84 0 0 0 0 0\n"
"RenderEvent 30 84 0 0 0 0 0\n"
"MouseMoveEvent 29 85 0 0 0 0 0\n"
"RenderEvent 29 85 0 0 0 0 0\n"
"MouseMoveEvent 29 86 0 0 0 0 0\n"
"RenderEvent 29 86 0 0 0 0 0\n"
"MouseMoveEvent 28 87 0 0 0 0 0\n"
"RenderEvent 28 87 0 0 0 0 0\n"
"MouseMoveEvent 26 91 0 0 0 0 0\n"
"RenderEvent 26 91 0 0 0 0 0\n"
"MouseMoveEvent 24 94 0 0 0 0 0\n"
"RenderEvent 24 94 0 0 0 0 0\n"
"MouseMoveEvent 22 97 0 0 0 0 0\n"
"RenderEvent 22 97 0 0 0 0 0\n"
"MouseMoveEvent 21 99 0 0 0 0 0\n"
"RenderEvent 21 99 0 0 0 0 0\n"
"MouseMoveEvent 20 100 0 0 0 0 0\n"
"RenderEvent 20 100 0 0 0 0 0\n"
"MouseMoveEvent 20 101 0 0 0 0 0\n"
"RenderEvent 20 101 0 0 0 0 0\n"
"MouseMoveEvent 19 102 0 0 0 0 0\n"
"RenderEvent 19 102 0 0 0 0 0\n"
"MouseMoveEvent 18 104 0 0 0 0 0\n"
"RenderEvent 18 104 0 0 0 0 0\n"
"MouseMoveEvent 17 107 0 0 0 0 0\n"
"RenderEvent 17 107 0 0 0 0 0\n"
"MouseMoveEvent 17 108 0 0 0 0 0\n"
"RenderEvent 17 108 0 0 0 0 0\n"
"MouseMoveEvent 17 109 0 0 0 0 0\n"
"RenderEvent 17 109 0 0 0 0 0\n"
"MouseMoveEvent 17 110 0 0 0 0 0\n"
"RenderEvent 17 110 0 0 0 0 0\n"
"MouseMoveEvent 17 111 0 0 0 0 0\n"
"RenderEvent 17 111 0 0 0 0 0\n"
"MouseMoveEvent 17 112 0 0 0 0 0\n"
"RenderEvent 17 112 0 0 0 0 0\n"
"MouseMoveEvent 17 113 0 0 0 0 0\n"
"RenderEvent 17 113 0 0 0 0 0\n"
"MouseMoveEvent 17 114 0 0 0 0 0\n"
"RenderEvent 17 114 0 0 0 0 0\n"
"MouseMoveEvent 17 116 0 0 0 0 0\n"
"RenderEvent 17 116 0 0 0 0 0\n"
"MouseMoveEvent 17 119 0 0 0 0 0\n"
"RenderEvent 17 119 0 0 0 0 0\n"
"MouseMoveEvent 17 122 0 0 0 0 0\n"
"RenderEvent 17 122 0 0 0 0 0\n"
"MouseMoveEvent 18 125 0 0 0 0 0\n"
"RenderEvent 18 125 0 0 0 0 0\n"
"MouseMoveEvent 19 127 0 0 0 0 0\n"
"RenderEvent 19 127 0 0 0 0 0\n"
"MouseMoveEvent 19 128 0 0 0 0 0\n"
"RenderEvent 19 128 0 0 0 0 0\n"
"MouseMoveEvent 20 129 0 0 0 0 0\n"
"RenderEvent 20 129 0 0 0 0 0\n"
"MouseMoveEvent 20 130 0 0 0 0 0\n"
"RenderEvent 20 130 0 0 0 0 0\n"
"MouseMoveEvent 20 132 0 0 0 0 0\n"
"RenderEvent 20 132 0 0 0 0 0\n"
"MouseMoveEvent 21 133 0 0 0 0 0\n"
"RenderEvent 21 133 0 0 0 0 0\n"
"MouseMoveEvent 22 135 0 0 0 0 0\n"
"RenderEvent 22 135 0 0 0 0 0\n"
"MouseMoveEvent 23 136 0 0 0 0 0\n"
"RenderEvent 23 136 0 0 0 0 0\n"
"MouseMoveEvent 24 139 0 0 0 0 0\n"
"RenderEvent 24 139 0 0 0 0 0\n"
"MouseMoveEvent 25 142 0 0 0 0 0\n"
"RenderEvent 25 142 0 0 0 0 0\n"
"MouseMoveEvent 26 144 0 0 0 0 0\n"
"RenderEvent 26 144 0 0 0 0 0\n"
"MouseMoveEvent 26 145 0 0 0 0 0\n"
"RenderEvent 26 145 0 0 0 0 0\n"
"MouseMoveEvent 27 146 0 0 0 0 0\n"
"RenderEvent 27 146 0 0 0 0 0\n"
"MouseMoveEvent 27 147 0 0 0 0 0\n"
"RenderEvent 27 147 0 0 0 0 0\n"
"MouseMoveEvent 27 149 0 0 0 0 0\n"
"RenderEvent 27 149 0 0 0 0 0\n"
"MouseMoveEvent 28 151 0 0 0 0 0\n"
"RenderEvent 28 151 0 0 0 0 0\n"
"MouseMoveEvent 28 152 0 0 0 0 0\n"
"RenderEvent 28 152 0 0 0 0 0\n"
"MouseMoveEvent 29 153 0 0 0 0 0\n"
"RenderEvent 29 153 0 0 0 0 0\n"
"MouseMoveEvent 29 154 0 0 0 0 0\n"
"RenderEvent 29 154 0 0 0 0 0\n"
"MouseMoveEvent 29 155 0 0 0 0 0\n"
"RenderEvent 29 155 0 0 0 0 0\n"
"MouseMoveEvent 29 156 0 0 0 0 0\n"
"RenderEvent 29 156 0 0 0 0 0\n"
"MouseMoveEvent 30 158 0 0 0 0 0\n"
"RenderEvent 30 158 0 0 0 0 0\n"
"MouseMoveEvent 31 160 0 0 0 0 0\n"
"RenderEvent 31 160 0 0 0 0 0\n"
"MouseMoveEvent 33 164 0 0 0 0 0\n"
"RenderEvent 33 164 0 0 0 0 0\n"
"MouseMoveEvent 34 166 0 0 0 0 0\n"
"RenderEvent 34 166 0 0 0 0 0\n"
"MouseMoveEvent 36 168 0 0 0 0 0\n"
"RenderEvent 36 168 0 0 0 0 0\n"
"MouseMoveEvent 39 172 0 0 0 0 0\n"
"RenderEvent 39 172 0 0 0 0 0\n"
"MouseMoveEvent 42 175 0 0 0 0 0\n"
"RenderEvent 42 175 0 0 0 0 0\n"
"MouseMoveEvent 47 178 0 0 0 0 0\n"
"RenderEvent 47 178 0 0 0 0 0\n"
"MouseMoveEvent 52 181 0 0 0 0 0\n"
"RenderEvent 52 181 0 0 0 0 0\n"
"MouseMoveEvent 59 184 0 0 0 0 0\n"
"RenderEvent 59 184 0 0 0 0 0\n"
"MouseMoveEvent 67 186 0 0 0 0 0\n"
"RenderEvent 67 186 0 0 0 0 0\n"
"MouseMoveEvent 82 187 0 0 0 0 0\n"
"RenderEvent 82 187 0 0 0 0 0\n"
"MouseMoveEvent 93 189 0 0 0 0 0\n"
"RenderEvent 93 189 0 0 0 0 0\n"
"MouseMoveEvent 103 189 0 0 0 0 0\n"
"RenderEvent 103 189 0 0 0 0 0\n"
"MouseMoveEvent 113 190 0 0 0 0 0\n"
"RenderEvent 113 190 0 0 0 0 0\n"
"MouseMoveEvent 121 191 0 0 0 0 0\n"
"RenderEvent 121 191 0 0 0 0 0\n"
"MouseMoveEvent 130 192 0 0 0 0 0\n"
"RenderEvent 130 192 0 0 0 0 0\n"
"MouseMoveEvent 136 193 0 0 0 0 0\n"
"RenderEvent 136 193 0 0 0 0 0\n"
"MouseMoveEvent 141 194 0 0 0 0 0\n"
"RenderEvent 141 194 0 0 0 0 0\n"
"MouseMoveEvent 144 194 0 0 0 0 0\n"
"RenderEvent 144 194 0 0 0 0 0\n"
"MouseMoveEvent 145 195 0 0 0 0 0\n"
"RenderEvent 145 195 0 0 0 0 0\n"
"MouseMoveEvent 146 195 0 0 0 0 0\n"
"RenderEvent 146 195 0 0 0 0 0\n"
"MouseMoveEvent 149 195 0 0 0 0 0\n"
"RenderEvent 149 195 0 0 0 0 0\n"
"MouseMoveEvent 154 196 0 0 0 0 0\n"
"RenderEvent 154 196 0 0 0 0 0\n"
"MouseMoveEvent 155 196 0 0 0 0 0\n"
"RenderEvent 155 196 0 0 0 0 0\n"
"MouseMoveEvent 156 196 0 0 0 0 0\n"
"RenderEvent 156 196 0 0 0 0 0\n"
"MouseMoveEvent 157 196 0 0 0 0 0\n"
"RenderEvent 157 196 0 0 0 0 0\n"
"MouseMoveEvent 158 195 0 0 0 0 0\n"
"RenderEvent 158 195 0 0 0 0 0\n"
"MouseMoveEvent 160 194 0 0 0 0 0\n"
"RenderEvent 160 194 0 0 0 0 0\n"
"MouseMoveEvent 164 193 0 0 0 0 0\n"
"RenderEvent 164 193 0 0 0 0 0\n"
"MouseMoveEvent 168 192 0 0 0 0 0\n"
"RenderEvent 168 192 0 0 0 0 0\n"
"MouseMoveEvent 173 190 0 0 0 0 0\n"
"RenderEvent 173 190 0 0 0 0 0\n"
"MouseMoveEvent 177 189 0 0 0 0 0\n"
"RenderEvent 177 189 0 0 0 0 0\n"
"MouseMoveEvent 182 187 0 0 0 0 0\n"
"RenderEvent 182 187 0 0 0 0 0\n"
"MouseMoveEvent 187 184 0 0 0 0 0\n"
"RenderEvent 187 184 0 0 0 0 0\n"
"MouseMoveEvent 196 175 0 0 0 0 0\n"
"RenderEvent 196 175 0 0 0 0 0\n"
"MouseMoveEvent 202 170 0 0 0 0 0\n"
"RenderEvent 202 170 0 0 0 0 0\n"
"MouseMoveEvent 207 164 0 0 0 0 0\n"
"RenderEvent 207 164 0 0 0 0 0\n"
"MouseMoveEvent 211 159 0 0 0 0 0\n"
"RenderEvent 211 159 0 0 0 0 0\n"
"MouseMoveEvent 215 153 0 0 0 0 0\n"
"RenderEvent 215 153 0 0 0 0 0\n"
"MouseMoveEvent 219 148 0 0 0 0 0\n"
"RenderEvent 219 148 0 0 0 0 0\n"
"MouseMoveEvent 222 143 0 0 0 0 0\n"
"RenderEvent 222 143 0 0 0 0 0\n"
"MouseMoveEvent 224 140 0 0 0 0 0\n"
"RenderEvent 224 140 0 0 0 0 0\n"
"MouseMoveEvent 226 136 0 0 0 0 0\n"
"RenderEvent 226 136 0 0 0 0 0\n"
"MouseMoveEvent 228 133 0 0 0 0 0\n"
"RenderEvent 228 133 0 0 0 0 0\n"
"MouseMoveEvent 228 132 0 0 0 0 0\n"
"RenderEvent 228 132 0 0 0 0 0\n"
"MouseMoveEvent 229 129 0 0 0 0 0\n"
"RenderEvent 229 129 0 0 0 0 0\n"
"MouseMoveEvent 234 123 0 0 0 0 0\n"
"RenderEvent 234 123 0 0 0 0 0\n"
"MouseMoveEvent 237 118 0 0 0 0 0\n"
"RenderEvent 237 118 0 0 0 0 0\n"
"MouseMoveEvent 244 112 0 0 0 0 0\n"
"RenderEvent 244 112 0 0 0 0 0\n"
"MouseMoveEvent 251 106 0 0 0 0 0\n"
"RenderEvent 251 106 0 0 0 0 0\n"
"MouseMoveEvent 266 96 0 0 0 0 0\n"
"RenderEvent 266 96 0 0 0 0 0\n"
"MouseMoveEvent 288 85 0 0 0 0 0\n"
"RenderEvent 288 85 0 0 0 0 0\n"
"LeaveEvent 300 80 0 0 0 0 0\n"
"ExitEvent 300 80 0 0 0 0 0\n"
;

// This callback is responsible for setting the seed label.
class vtkSeedCallback2 : public vtkCommand
{
public:
  static vtkSeedCallback2 *New()
    { return new vtkSeedCallback2; }
  virtual void Execute(vtkObject*, unsigned long eid, void*)
    {
      if ( eid == vtkCommand::CursorChangedEvent )
        {
        std::cout << "cursor changed\n";
        }
      else
        {
        std::cout << "point placed\n";
        }
    }
};


// The actual test function
int TestSeedWidget2( int argc, char *argv[] )
{
  // Create the RenderWindow, Renderer and both Actors
  //
  vtkSmartPointer<vtkRenderer> ren1 =
    vtkSmartPointer<vtkRenderer>::New();
  vtkSmartPointer<vtkRenderWindow> renWin =
    vtkSmartPointer<vtkRenderWindow>::New();
  renWin->AddRenderer(ren1);

  vtkSmartPointer<vtkRenderWindowInteractor> iren =
    vtkSmartPointer<vtkRenderWindowInteractor>::New();
  iren->SetRenderWindow(renWin);

  // Create a test pipeline
  char* fname = vtkTestUtilities::ExpandDataFileName(argc, argv, "Data/headsq/quarter");

  // Start by creatin a black/white lookup table.
  vtkSmartPointer<vtkLookupTable> bwLut =
    vtkSmartPointer<vtkLookupTable>::New();
    bwLut->SetTableRange (0, 2000);
    bwLut->SetSaturationRange (0, 0);
    bwLut->SetHueRange (0, 0);
    bwLut->SetValueRange (0, 1);
    bwLut->Build(); //effective built
  vtkSmartPointer<vtkVolume16Reader> v16 =
    vtkSmartPointer<vtkVolume16Reader>::New();
    v16->SetDataDimensions(64,64);
    v16->SetDataByteOrderToLittleEndian();
    v16->SetFilePrefix(fname);
    v16->SetImageRange(1, 93);
    v16->SetDataSpacing (3.2, 3.2, 1.5);
  delete[] fname;
  vtkSmartPointer<vtkImageMapToColors> sagittalColors =
    vtkSmartPointer<vtkImageMapToColors>::New();
    sagittalColors->SetInputConnection(v16->GetOutputPort());
    sagittalColors->SetLookupTable(bwLut);
  vtkSmartPointer<vtkImageActor> sagittal =
    vtkSmartPointer<vtkImageActor>::New();
    sagittal->GetMapper()->SetInputConnection(sagittalColors->GetOutputPort());
    sagittal->SetDisplayExtent(32,32, 0,63, 0,92);
    sagittal->RotateY(90);
    sagittal->RotateX(90);

  // Create the widget and its representation
  vtkSmartPointer<vtkPointHandleRepresentation2D> handle =
    vtkSmartPointer<vtkPointHandleRepresentation2D>::New();
  handle->GetProperty()->SetColor(1,0,0);
  vtkSmartPointer<vtkSeedRepresentation> rep =
    vtkSmartPointer<vtkSeedRepresentation>::New();
  rep->SetHandleRepresentation(handle);

  vtkSmartPointer<vtkSeedWidget> widget =
    vtkSmartPointer<vtkSeedWidget>::New();
  widget->SetInteractor(iren);
  widget->SetRepresentation(rep);

  vtkSmartPointer<vtkSeedCallback2> mcbk =
    vtkSmartPointer<vtkSeedCallback2>::New();
  widget->AddObserver(vtkCommand::PlacePointEvent,mcbk);
  widget->AddObserver(vtkCommand::CursorChangedEvent,mcbk);

  // Add the actors to the renderer, set the background and size
  //
  ren1->AddActor(sagittal);
  ren1->ResetCamera();
  ren1->SetBackground(0.1, 0.2, 0.4);
  renWin->SetSize(300, 300);

  // render the image
  //
  iren->Initialize();
  renWin->Render();
  widget->On();

  return vtkTesting::InteractorEventLoop(
    argc, argv, iren, TestSeedWidget2Log );
}
