/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.reflect.Array;

class HashUtil {
    static final int SEED = 23;
    private static final int ODD_PRIME_NUMBER = 37;

    HashUtil() {
    }

    static int hash(int n2, boolean bl) {
        return HashUtil.firstTerm(n2) + (bl ? 1 : 0);
    }

    static int hash(int n2, char c2) {
        return HashUtil.firstTerm(n2) + c2;
    }

    static int hash(int n2, int n3) {
        return HashUtil.firstTerm(n2) + n3;
    }

    static int hash(int n2, long l2) {
        return HashUtil.firstTerm(n2) + (int)(l2 ^ l2 >>> 32);
    }

    static int hash(int n2, float f2) {
        return HashUtil.hash(n2, Float.floatToIntBits(f2));
    }

    static int hash(int n2, double d2) {
        return HashUtil.hash(n2, Double.doubleToLongBits(d2));
    }

    static int hash(int n2, Object object) {
        int n3 = n2;
        if (object == null) {
            n3 = HashUtil.hash(n3, 0);
        } else if (!object.getClass().isArray()) {
            n3 = HashUtil.hash(n3, object.hashCode());
        } else {
            int n4 = Array.getLength(object);
            for (int i2 = 0; i2 < n4; ++i2) {
                Object object2 = Array.get(object, i2);
                n3 = HashUtil.hash(n3, object2);
            }
        }
        return n3;
    }

    private static int firstTerm(int n2) {
        return 37 * n2;
    }
}

