/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.managed.TransactionContext;
import org.apache.commons.dbcp2.managed.TransactionContextListener;
import org.apache.commons.dbcp2.managed.TransactionRegistry;
import org.apache.commons.pool2.ObjectPool;

public class ManagedConnection<C extends Connection>
extends DelegatingConnection<C> {
    private final ObjectPool<C> pool;
    private final TransactionRegistry transactionRegistry;
    private final boolean accessToUnderlyingConnectionAllowed;
    private TransactionContext transactionContext;
    private boolean isSharedConnection;

    public ManagedConnection(ObjectPool<C> pool, TransactionRegistry transactionRegistry, boolean accessToUnderlyingConnectionAllowed) throws SQLException {
        super(null);
        this.pool = pool;
        this.transactionRegistry = transactionRegistry;
        this.accessToUnderlyingConnectionAllowed = accessToUnderlyingConnectionAllowed;
        this.updateTransactionStatus();
    }

    @Override
    protected void checkOpen() throws SQLException {
        super.checkOpen();
        this.updateTransactionStatus();
    }

    private void updateTransactionStatus() throws SQLException {
        if (this.transactionContext != null) {
            if (this.transactionContext.isActive()) {
                if (this.transactionContext != this.transactionRegistry.getActiveTransactionContext()) {
                    throw new SQLException("Connection can not be used while enlisted in another transaction");
                }
                return;
            }
            this.transactionComplete();
        }
        this.transactionContext = this.transactionRegistry.getActiveTransactionContext();
        if (this.transactionContext != null && this.transactionContext.getSharedConnection() != null) {
            Object connection = this.getDelegateInternal();
            this.setDelegate(null);
            if (connection != null) {
                try {
                    this.pool.returnObject(connection);
                }
                catch (Exception ignored) {
                    try {
                        this.pool.invalidateObject(connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.transactionContext.addTransactionContextListener(new CompletionListener());
            Connection shared = this.transactionContext.getSharedConnection();
            this.setDelegate(shared);
            this.isSharedConnection = true;
        } else {
            Object connection = this.getDelegateInternal();
            if (connection == null) {
                try {
                    connection = (Connection)this.pool.borrowObject();
                    this.setDelegate(connection);
                }
                catch (Exception e2) {
                    throw new SQLException("Unable to acquire a new connection from the pool", e2);
                }
            }
            if (this.transactionContext != null) {
                this.transactionContext.addTransactionContextListener(new CompletionListener());
                try {
                    this.transactionContext.setSharedConnection((Connection)connection);
                }
                catch (SQLException e3) {
                    this.transactionContext = null;
                    try {
                        this.pool.invalidateObject(connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e3;
                }
            }
        }
        this.clearCachedState();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosedInternal()) {
            try {
                if (this.transactionContext == null) {
                    super.close();
                }
            }
            finally {
                this.setClosedInternal(true);
            }
        }
    }

    protected void transactionComplete() {
        this.transactionContext = null;
        if (this.isSharedConnection) {
            this.setDelegate(null);
            this.isSharedConnection = false;
        }
        Object delegate = this.getDelegateInternal();
        if (this.isClosedInternal() && delegate != null) {
            try {
                this.setDelegate(null);
                if (!delegate.isClosed()) {
                    delegate.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Auto-commit can not be set while enrolled in a transaction");
        }
        super.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Commit can not be set while enrolled in a transaction");
        }
        super.commit();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Commit can not be set while enrolled in a transaction");
        }
        super.rollback();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Read-only can not be set while enrolled in a transaction");
        }
        super.setReadOnly(readOnly);
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public C getDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return this.getDelegateInternal();
        }
        return null;
    }

    @Override
    public Connection getInnermostDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return super.getInnermostDelegateInternal();
        }
        return null;
    }

    protected class CompletionListener
    implements TransactionContextListener {
        protected CompletionListener() {
        }

        @Override
        public void afterCompletion(TransactionContext completedContext, boolean commited) {
            if (completedContext == ManagedConnection.this.transactionContext) {
                ManagedConnection.this.transactionComplete();
            }
        }
    }
}

