/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BaseCluster;
import com.mongodb.ChangeEvent;
import com.mongodb.ChangeListener;
import com.mongodb.ClusterConnectionMode;
import com.mongodb.ClusterDescription;
import com.mongodb.ClusterListener;
import com.mongodb.ClusterSettings;
import com.mongodb.ClusterType;
import com.mongodb.ClusterableServer;
import com.mongodb.ClusterableServerFactory;
import com.mongodb.Loggers;
import com.mongodb.ServerAddress;
import com.mongodb.ServerDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;
import org.bson.util.Assertions;

final class SingleServerCluster
extends BaseCluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final ClusterableServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleServerCluster(String clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, ClusterListener clusterListener) {
        super(clusterId, settings, serverFactory, clusterListener);
        Assertions.isTrue("one server in a direct cluster", settings.getHosts().size() == 1);
        Assertions.isTrue("connection mode is single", settings.getMode() == ClusterConnectionMode.Single);
        LOGGER.info(String.format("Cluster created with settings %s", settings.getShortDescription()));
        SingleServerCluster singleServerCluster = this;
        synchronized (singleServerCluster) {
            this.server = this.createServer(settings.getHosts().get(0), new ChangeListener<ServerDescription>(){

                @Override
                public void stateChanged(ChangeEvent<ServerDescription> event) {
                    ServerDescription descriptionToPublish = event.getNewValue();
                    if (event.getNewValue().isOk()) {
                        if (SingleServerCluster.this.getSettings().getRequiredClusterType() != ClusterType.Unknown && SingleServerCluster.this.getSettings().getRequiredClusterType() != event.getNewValue().getClusterType()) {
                            descriptionToPublish = null;
                        } else if (SingleServerCluster.this.getSettings().getRequiredClusterType() == ClusterType.ReplicaSet && SingleServerCluster.this.getSettings().getRequiredReplicaSetName() != null && !SingleServerCluster.this.getSettings().getRequiredReplicaSetName().equals(event.getNewValue().getSetName())) {
                            descriptionToPublish = null;
                        }
                    }
                    SingleServerCluster.this.publishDescription(descriptionToPublish);
                }
            });
            this.publishDescription(this.server.getDescription());
        }
    }

    protected void connect() {
        this.server.connect();
    }

    private void publishDescription(ServerDescription serverDescription) {
        ClusterType clusterType = this.getSettings().getRequiredClusterType();
        if (clusterType == ClusterType.Unknown && serverDescription != null) {
            clusterType = serverDescription.getClusterType();
        }
        ClusterDescription description = new ClusterDescription(ClusterConnectionMode.Single, clusterType, serverDescription == null ? Collections.emptyList() : Arrays.asList(serverDescription));
        this.updateDescription(description);
        this.fireChangeEvent();
    }

    protected ClusterableServer getServer(ServerAddress serverAddress) {
        Assertions.isTrue("open", !this.isClosed());
        return this.server;
    }

    public void close() {
        if (!this.isClosed()) {
            this.server.close();
            super.close();
        }
    }
}

