static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (window_title, _(\"Window title\"), \"window_title\")         \n"
"    description (_(\"Title to be given to output window\"))                   \n"
"property_string (icon_title, _(\"Icon title\"), \"icon_title\")               \n"
"    description (_(\"Icon to be used for output window\"))                    \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE sdl-display.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <SDL.h>                                                              \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"  SDL_Surface *screen;                                                        \n"
"  gint         width;                                                         \n"
"  gint         height;                                                        \n"
"} SDLState;                                                                   \n"
"                                                                              \n"
"static void                                                                   \n"
"init_sdl (void)                                                               \n"
"{                                                                             \n"
"  static int inited = 0;                                                      \n"
"                                                                              \n"
"  if (!inited)                                                                \n"
"    {                                                                         \n"
"      inited = 1;                                                             \n"
"                                                                              \n"
"      if (SDL_Init (SDL_INIT_VIDEO) < 0)                                      \n"
"        {                                                                     \n"
"          fprintf (stderr, \"Unable to init SDL: %s\\n\", SDL_GetError ());   \n"
"          return;                                                             \n"
"        }                                                                     \n"
"      atexit (SDL_Quit);                                                      \n"
"      SDL_EnableUNICODE (1);                                                  \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean idle (gpointer data)                                          \n"
"{                                                                             \n"
"  SDL_Event event;                                                            \n"
"  while (SDL_PollEvent  (&event))                                             \n"
"    {                                                                         \n"
"      switch (event.type)                                                     \n"
"        {                                                                     \n"
"          case SDL_QUIT:                                                      \n"
"            exit (0);                                                         \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static guint handle = 0;                                                      \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  SDLState     *state = NULL;                                                 \n"
"                                                                              \n"
"  if(!o->user_data)                                                           \n"
"      o->user_data = g_new0 (SDLState, 1);                                    \n"
"  state = o->user_data;                                                       \n"
"                                                                              \n"
"  init_sdl ();                                                                \n"
"                                                                              \n"
"  if (!handle)                                                                \n"
"    handle = g_timeout_add (500, idle, NULL);                                 \n"
"                                                                              \n"
"  if (!state->screen ||                                                       \n"
"       state->width  != result->width ||                                      \n"
"       state->height != result->height)                                       \n"
"    {                                                                         \n"
"      state->screen = SDL_SetVideoMode (result->width, result->height, 32, SDL_SWSURFACE);\n"
"      if (!state->screen)                                                     \n"
"        {                                                                     \n"
"          fprintf (stderr, \"Unable to set SDL mode: %s\\n\",                 \n"
"                   SDL_GetError ());                                          \n"
"          return -1;                                                          \n"
"        }                                                                     \n"
"                                                                              \n"
"      state->width  = result->width ;                                         \n"
"      state->height = result->height;                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  /*                                                                          \n"
"   * There seems to be a valid faster path to the SDL desired display format  \n"
"   * in B'G'R'A, perhaps babl should have been able to figure this out ito?   \n"
"   *                                                                          \n"
"   */                                                                         \n"
"  gegl_buffer_get (input,                                                     \n"
"       NULL,                                                                  \n"
"       1.0,                                                                   \n"
"       babl_format_new (babl_model (\"R'G'B'A\"),                             \n"
"                        babl_type (\"u8\"),                                   \n"
"                        babl_component (\"B'\"),                              \n"
"                        babl_component (\"G'\"),                              \n"
"                        babl_component (\"R'\"),                              \n"
"                        babl_component (\"A\"),                               \n"
"                        NULL),                                                \n"
"       state->screen->pixels, GEGL_AUTO_ROWSTRIDE,                            \n"
"       GEGL_ABYSS_NONE);                                                      \n"
"                                                                              \n"
"  SDL_UpdateRect (state->screen, 0, 0, 0, 0);                                 \n"
"  SDL_WM_SetCaption (o->window_title, o->icon_title);                         \n"
"                                                                              \n"
"  state->width = result->width ;                                              \n"
"  state->height = result->height;                                             \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass           *object_class;                                       \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  sink_class->process = process;                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:sdl-display\",                                   \n"
"    \"title\",        _(\"SDL Display\"),                                     \n"
"    \"categories\",   \"display\",                                            \n"
"    \"description\",                                                          \n"
"        _(\"Displays the input buffer in an SDL window (restricted to one\"   \n"
"          \" display op/process, due to SDL implementation issues).\"),       \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
