/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggframecurrentinstance.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "ishell.h"

#include "iggextensionwindow.h"
#include "iggmainwindow.h"
#include "iggwidgetkeyselectionbox.h"


namespace iggFrameCurrentInstance_Private
{
	//
	//  Special widgets that update their parents on execution
	//
	class InstanceSpinBox : public iggWidgetKeySpinBox
	{

	public:

		InstanceSpinBox(int min, int max, const iString &title, int offset, const iObjectKey &key, iggFrameCurrentInstance *parent, int index, const iObjectKey *indkey) : iggWidgetKeySpinBox(min,max,title,offset,key,parent,index,indkey)
		{
			mRealParent = parent;
		}

	protected:

		virtual void OnInt1Body(int v)
		{
			iggWidgetKeySpinBox::OnInt1Body(v);
			mRealParent->OnCurrentInstanceChanged();
		}

		iggFrameCurrentInstance *mRealParent;
	};
	
	class InstanceComboBox : public iggWidgetKeyComboBox
	{

	public:

		InstanceComboBox(const iString &title, int offset, const iObjectKey &key, iggFrameCurrentInstance *parent, int index, const iObjectKey *indkey) : iggWidgetKeyComboBox(title,offset,key,parent,index,indkey)
		{
			mRealParent = parent;
		}

	protected:

		virtual void OnInt1Body(int v)
		{
			iggWidgetKeyComboBox::OnInt1Body(v);
			mRealParent->OnCurrentInstanceChanged();
		}

		iggFrameCurrentInstance *mRealParent;
	};
};


using namespace iggFrameCurrentInstance_Private;


iggFrameCurrentInstance::iggFrameCurrentInstance(bool withnone, const iString &title, const iString &item, const iObjectKey &key, const iObjectKey &maxkey, iggFrame *parent, bool spinbox, int index, const iObjectKey *indkey) : iggFrame(parent,1), mItemText(item), mKey(key), mMaxKey(maxkey)
{
	mIsSpinBox = spinbox;
	mWithNone = withnone;
	
	if(mMaxKey.Argument()!=iObjectKey::_OffsetInt || mMaxKey.Dimension()!=1 || mMaxKey.UnprefixedFullName().Find("Max")==-1)
	{
		IERROR_FATAL("Widget iggFrameCurrentInstance is congifured incorrectly.");
	}

	if(mIsSpinBox)
	{
		int off = 1;
		if(mWithNone) off--;
		iggWidgetKeySpinBox *b = new InstanceSpinBox(off,off,title,1,mKey,this,index,indkey);
		if(mWithNone) b->SetFirstEntryText("None");
		mBox = b;
	}
	else
	{
		iggWidgetKeyComboBox *b = new InstanceComboBox(title,1,mKey,this,index,indkey);
		if(mWithNone) b->InsertItem("None");
		mBox = b;
	}
	this->AddLine(mBox);
}


void iggFrameCurrentInstance::OnCurrentInstanceChanged()
{
	this->GetMainWindow()->UpdateAll();
}


void iggFrameCurrentInstance::UpdateChildren()
{
	int n, max;
	
	if(this->GetShell()->GetControlModule()->QueryValue(mMaxKey,max))
	{
		n = 1 + max;
		if(mWithNone) n++;
		if(mBox->Count() != n)
		{
			//
			//  Update the selection box
			//
			if(mIsSpinBox)
			{
				iggWidgetKeySpinBox *b = iDynamicCast<iggWidgetKeySpinBox,iggWidgetKeySelectionBox>(INFO,mBox);
				if(mWithNone) b->SetRange(0,1+max); else b->SetRange(1,1+max);
			}
			else
			{
				int i;

				iggWidgetKeyComboBox *b = iDynamicCast<iggWidgetKeyComboBox,iggWidgetKeySelectionBox>(INFO,mBox);
				b->Clear();
				if(mWithNone) b->InsertItem("None");
				for(i=0; i<=max; i++) b->InsertItem((iString(mItemText)+"#"+iString::FromNumber(i+1)).ToCharPointer());
			}
		}
		iggFrame::UpdateChildren();
	}
	else IERROR_LOW("iggFrameCurrentInstance::UpdateChildren() failed.");
}

#endif
