/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2007-2015 Broad Institute
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.broad.igv.feature;


public class Cytoband implements IGVNamedFeature {
    String chromosome;
    String name;
    int end;
    int start;
    char type; // p, n, or c
    short stain;


    public Cytoband(String chromosome) {
        this.chromosome = chromosome;
        this.name = "";
    }

    public Cytoband(String chromosome, int start,int end, String name, String gieStain) {
        this.chromosome = chromosome;
        this.end = end;
        this.start = start;
        this.name = name;
        if (gieStain.equals("acen")) {
            setType('c');
        } else {
            setType(gieStain.charAt(1));
            if (type == 'p') {
                String stainString = gieStain.substring(4).trim();
                short stain = stainString.length() == 0 ? 100 : Short.parseShort(stainString);
                setStain(stain);
            }
        }
    }

    public void trim() {

        // @todo -- trim arrays
    }

    @Override
    public String getContig() {
        return chromosome;
    }

    public String getChr() {
        return chromosome;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getEnd() {
        return end;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return start;
    }

    public void setType(char type) {
        this.type = type;
    }

    public char getType() {
        return type;
    }

    public void setStain(short stain) {
        this.stain = stain;
    }

    public short getStain() {
        return stain;
    }


}

