#!/usr/bin/env python

#
#ShutdownScreenlet Copyright (C) 2007 Helder Fraga
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
import screenlets
from screenlets.options import FloatOption, BoolOption, StringOption, FontOption, ColorOption, IntOption
import cairo
import pango
import gobject
from datetime import datetime
import os
import gtk
#use gettext for translation
import gettext

_ = screenlets.utils.get_translator(__file__)

def tdoc(obj):
	obj.__doc__ = _(obj.__doc__)
	return obj

@tdoc
class ShutdownScreenlet(screenlets.Screenlet):
	"""A Screenlet that opens gnome shutdown dialog and can also shut down your pc at a time you specify , for that you must first give root access to the "shutdown" command , by typing  "sudo chmod u+s /sbin/shutdown" in the console" or "su chmod u+s /sbin/shutdown" , if you dont it wont work"""
	
	# default meta-info for Screenlets
	__name__ = 'ShutdownScreenlet'
	__version__ = '0.3.1+++'
	__author__ = 'Helder Fraga aka Whise (c) 2007'
	__desc__ = __doc__
	
	style = True
	shut = ''
	do_it = False
	enable_shut = False
	icontheme = gtk.icon_theme_get_default()
	def __init__(self, **keyword_args):
		screenlets.Screenlet.__init__(self, width=100, height=100, **keyword_args) 
		self.update()
		# update the clock once a second
		self.__timeout = gobject.timeout_add(60000, self.update)
		self.theme_name = "default"
		self.add_default_menuitems()
		self.add_options_group(_('Options'), _('Options'))
		self.add_option(BoolOption(_('Options'), 'enable_shut', self.enable_shut, 
			_('Enable schedule shutdown'), _('Enable schedule shutdown')))
		self.add_option(StringOption(_('Options'), 'shut', self.shut,_('ShutDown time'), _('Select shutdown time , ex: 12:43'),),realtime=False)
		self.add_option(BoolOption(_('Options'), 'style', self.style, 
			_('Use gtk style'), _('Use gtk icon')))		
	def __setattr__(self, name, value):
		# call Screenlet.__setattr__ in baseclass (ESSENTIAL!!!!)
		screenlets.Screenlet.__setattr__(self, name, value)
		
		if name == 'ta' or name == 'style':
			self.redraw_canvas()
		
	def on_mouse_down(self, event):

		event.x /= (self.scale/2)
		event.y /= (self.scale/2)
		
		if event.button == 1:
			os.system('gnome-session-save --kill &')
		
	def update (self):
		ta = str(datetime.now())
		ta = ta[ta.find(" ")+1:]
		ta = ta[:ta.find('.') ].strip()
		tb = ta[:ta.find(':') ].strip()
		ta = ta[:ta.find(":")+3:]	
		
		self.redraw_canvas()
		if ta == self.shut:
			if self.enable_shut == True:
				os.system('shutdown -h now')
		return True # keep running this event	

			
	

	def on_draw(self, ctx):

		if self.theme:
			ctx.set_operator(cairo.OPERATOR_OVER)
			ctx.scale(self.scale, self.scale)
			if self.style == True:	
				theme1 = gtk.icon_theme_get_default()
			
				close = self.icontheme.load_icon ("gnome-session-halt",100,0)


		
				ctx.set_source_pixbuf(close, 0, 0)
				ctx.paint()
			else:
				self.theme.render(ctx,'back')
			

			
	def on_draw_shape(self,ctx):
	
		if self.theme:
			self.on_draw(ctx)

if __name__ == "__main__":
	import screenlets.session
	screenlets.session.create_session(ShutdownScreenlet)
