/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jetbrains.uast.java

import com.intellij.psi.PsiPolyadicExpression
import org.jetbrains.uast.UElement
import org.jetbrains.uast.UExpression
import org.jetbrains.uast.UPolyadicExpression
import org.jetbrains.uast.UastBinaryOperator


class JavaUPolyadicExpression(
  override val psi: PsiPolyadicExpression,
  givenParent: UElement?
) : JavaAbstractUExpression(givenParent), UPolyadicExpression {

  override val operands: List<UExpression> = object : AbstractList<UExpression>() {
    override val size: Int get() = psi.operands.size

    override fun get(index: Int): UExpression = JavaConverter.convertOrEmpty(psi.operands[index], this@JavaUPolyadicExpression)
  }

  override val operator: UastBinaryOperator by lz { psi.operationTokenType.getOperatorType() }
}