/*
 *  filter.h - Filtering mechanism
 *  
 *  (c) 1999-2001 Robert Cheramy <robert@cheramy.net>
 *  (c) 1999      Andres Krapf <dae@via.ecp.fr>
 *  (c) 2001      Loc Tortay & IN2P3 Computing Center <tortay@cc.in2p3.fr>
 *
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FILTER_H
#define FILTER_H

#include "config.h"

/* Log no address */
#define IPFM_LOG_NONE 0x0000
/* Log packets coming from "this" address */
#define IPFM_LOG_FROM 0x0001
/* Log going to "this" address */
#define IPFM_LOG_TO   0x0002
/* Log both addresses */
#define IPFM_LOG_BOTH 0x0003

struct ipfm_host {
  u_int32_t ip;
  u_int32_t mask;
};

struct ipfm_filter {
  struct ipfm_filter *next;

  /* Log in table ? NONE, FROM, TO, BOTH */
  int tlog;
  /* IP Match for _t_able log */
  struct ipfm_host thost;

  /* What to do with the _o_ther IP of the header */
  /* Do log ? 1 (TRUE) => LOG; 0 (FALSE) => IGNORE */
  int olog;
  /* IP Domain to log */
  struct ipfm_host ohost;
};

struct AllLogsType {
  struct ipfm_filter *Filter;
  struct ipfm_data *Data;

  char *LogFile;
  int DataSize;
  int Sort;
  int (*SortFunc)(const void *, const void *);
  int ReverseLookup;
  int Append;

  unsigned long int NextDump;
  unsigned long int DumpInterval;
  unsigned long int ClearCounter;
  unsigned long int ClearInterval;

  struct AllLogsType *Next;
};

void dofilter(struct ip *p_packet);

#endif
