#if !defined (__DECORATOR_HPP)
#define __DECORATOR_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif
  

namespace corelinux
{

   /**
   Decorators can attach additional responsibilities to an object 
   dynamically which provide a more flexible alternative to subclassing 
   for extending functionality.
   */

   template <class Implementation>
      class Decorator : public CoreLinuxObject
      {
      public:

         //
         // Constructors
         //
   
                              /** 
                              Default Constructor requires a Implementation
                              @param Implementation instance
                              */
   
                              Decorator( Implementation aImplementation )
                                 :
                                 CoreLinuxObject(),
                                 theImplementation(aImplementation)
                              {
                                 ;  // do nothing
                              }
   
                              /** 
                              Copy Constructor copies theImplementation.
                              @param Decorator const reference
                              */
   
                              Decorator( const Decorator &aDecorator ) 
                                 :
                                 CoreLinuxObject(),
                                 theImplementation
                                    ( 
                                       aDecorator.getImplementation() 
                                    )
                              {
                                 ; // do nothing
                              }
   
                              /// Virtual Destructor  
   
         virtual              ~Decorator( void )
         {
            ;  // do nothing
         }
   
         //
         // Operator overloads
         //
                  /**
                  Assignment operator overload. This may throw
                  Exception if there is a problem cloning theImplementation.
                  @param  Decorator const reference
                  @return Decorator reference to self
                  @exception Exception - implementation defined
                  */
               
                  Decorator &  operator=( const Decorator & aDecorator ) 
                     throw(Exception)
                  {
                     this->setImplementation
                        (  aDecorator.getImplementation() );

                     return (*this);
                  }
   
                  /**
                  Equality operator overload
                  @param Decorator const reference
                  @return true if equal, false otherwise
                  */
   
                  bool     operator==( const Decorator & aDecorator ) const
                  {
                     return 
                        (
                           this == &aDecorator && 
                           (
                              this->getImplementation() == 
                                 aDecorator.getImplementation() 
                           )
                        );
                  }
   
         //
         // Accessors
         //
   
                  /**
                  Gets current theImplementation
                  @return Implementation instance
                  */
   
         virtual  Implementation getImplementation( void ) const
                  {
                     return theImplementation;
                  }

         //
         // Mutators
         //

                  /**
                  Sets current theImplementation to aImplementation
                  @param Implementation - implementation instance
                  @exception Exception - derivation defined
                  */
         virtual  void  setImplementation( Implementation aImplementation )
                     throw(Exception)
                  {
                     theImplementation = aImplementation;
                  }

      protected:

         //
         // Constructors
         //
   
                              /** Default Constructor
                              Because a Decorator requires a implementation
                              to work, you can not construct one without it.
                              @param void
                              @exception NEVER_GET_HERE
                              */
                        
                              Decorator( void ) 
                                 throw (Assertion)
                                 :
                                 CoreLinuxObject()
                              {
                                 NEVER_GET_HERE;
                              }
   
   
      protected:
   
                  /// Storage for theImplementation object
   
                  Implementation   theImplementation;
   
   
      };

}
          
#endif   // if !defined(__DECORATOR_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/




