---MH---------------------------------------------------------------------------
-- Das Urheberrecht dieses Dokumentes verbleibt jederzeit der Siemens Schweiz AG.
-- Ohne deren schriftliche Einwilligung darf es nicht vervielfaeltigt oder dritten
-- Personen, auch nicht in abgeaenderter Form, ganz oder teilweise mitgeteilt,
-- zugaenglich oder nutzbar gemacht werden. Es ist Fabrikations- und
-- Geschaeftsgeheimnis im Sinne von OR 192 und StGB 273.
-- 
-- Filename    : ilss_hex_dump.ads
-- Version     : \main\3
-- 
-- Location    : \ILTIS\Cell\ilss\src\
-- Creation    : 10-Aug-99 17:43  GAU
-- Description : Memory-Bereich als Hex-Dump ausgeben.
-- 
-- \main branch:
--    3  09-Feb-09 06:11  chakuhm0  CMS-History durch ClearCase-History ersetzt
--    2  22-Jun-05 15:00  GAU       FR#2901: um weitere Darstellungsmoeglichkeiten erweitert.
--    1  10-Aug-99 17:43  GAU       Memory-Bereich als Hex-Dump ausgeben.
---END--------------------------------------------------------------------------

with System;

--         ******************************
--         *
-- SPEC    *    ILSS_Hex_Dump
--         *
--         ******************************
generic

   with procedure Put_Line(S : in STRING);
   --!
   --! Purpose
   --!   Zeile ausgeben
   --!

procedure ILSS_Hex_Dump (Start_Address  : in System.ADDRESS;
                         Length         : in NATURAL;
                         Address_Offset : in INTEGER := 0;
                         Align_Mod_16   : in BOOLEAN := TRUE);
--!
--! Purpose
--!   Memory-Bereich (Ab Adresse 'Start_Address' mit Laenge 'Length') als
--!   Hex-Dump ausgeben.
--!
--! Initialisation Exceptions
--!   none
--!
--! Notes
--!   Die dargestellte Adresse beginnt dabei bei 'Address_Offset'.
--!   Wenn 'Start_Address' mit Unchecked_Conversion in INTEGER umgewandelt und
--!   als 'Address_Offset' uebergeben wird, so wird die absolute Adresse
--!   dargestellt.
--!   Wenn 'Align_Mod_16' gesetzt ist, werden die Bytes so dargestellt, dass
--!   die Bytes an durch 16 teilbaren Adressen (bezueglich 'Address_Offset')
--!   immer ganz links stehen.
--!
