/*
 * @(#)IInputStreamGenerator.java
 *
 * Copyright (C) 2001,,2003 2002 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.io.v1;

import java.io.InputStream;
import java.io.IOException;



/**
 * A type of class which can generate a new InputStream based on just a
 * partial name.  Useful if a resource is loaded from a specific location
 * (classpath resource, file system, URL, etc), and it references other
 * resources which must be loaded relative to it.
 * <P>
 * The generators should be first created using the original full resource
 * name.  Then, each stream generated is relative to that first resource
 * location.  If the first resource location is requested, then it should
 * be considered absolute (not relative to itself).
 *
 * @author   Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since    0.9.1d Alpha (sometime in 2001)
 * @version  $Date: 2003/05/19 20:31:47 $
 */
public interface IInputStreamGenerator
{
    public String getFullName( String relativeName );
    
    public InputStream createInputStream( String relativeName )
            throws IOException;
}
