## Copyright 2009 Laurent Bovet <laurent.bovet@windmaster.ch>
##                Jordi Puigsegur <jordi.puigsegur@gmail.com>
##
##  This file is part of wfrog
##
##  wfrog is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import StringIO

class Element(object):
    
    def __init__(self):
        self.__dict__['children'] = []        
    
    def create_child(self, name):
        child = Element()
        self._add(name, child)
        return child
    
    def __setattr__(self, name, value):
        self._add(name, value)

    def _add(self, name, value):
        if not self.children.__contains__(name):
            self.children.append(name)
        self.__dict__[name] = value

    def __str__(self):
        # Trivial XML serialization. If the WESTEP protocol is extended, 
        # consider using real XML construction.
        result = StringIO.StringIO()
        if self.__dict__.keys().__contains__('_type'):
            result.write('<' + self._type + '>')
        for child in self.children:
            if not child == '_type':
                result.write('<' + child + '>' + str(self.__dict__[child]) + '</' + child + '>')
        if self.__dict__.keys().__contains__('_type'):
            result.write('</' + self._type + '>')

        return result.getvalue()
            
class Event(Element):
    '''
    Class for events generated by the station implementations.
    '''
    
    def __init__(self, type):
        Element.__init__(self)
        self._type = type

    
    
