/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import rene.dialogs.DirFieldListener;
import rene.gui.ButtonAction;
import rene.gui.CloseDialog;
import rene.gui.CloseFrame;
import rene.gui.Global;
import rene.gui.HistoryTextField;
import rene.gui.HistoryTextFieldChoice;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.lister.Lister;
import rene.lister.ListerMouseEvent;
import rene.util.FileList;
import rene.util.FileName;
import rene.util.MyVector;

public class MyFileDialog
extends CloseDialog
implements ItemListener,
FilenameFilter,
MouseListener {
    Lister Dirs;
    Lister Files;
    HistoryTextField DirField;
    HistoryTextField FileField;
    HistoryTextField PatternField;
    HistoryTextFieldChoice DirHistory;
    HistoryTextFieldChoice FileHistory;
    TextField Chosen;
    String CurrentDir = ".";
    boolean Aborted = true;
    String DirAppend = "";
    String PatternAppend = "";
    String FileAppend = "";
    Button Home;
    Frame F;
    FileDialog FD;
    boolean HomeShiftControl = false;
    MyVector Undo = new MyVector();

    public MyFileDialog(Frame frame, String string, String string2, boolean bl, boolean bl2) {
        super(frame, string, true);
        this.F = frame;
        this.setLayout(new BorderLayout());
        this.Chosen = new TextFieldAction(this, "");
        this.add("North", new Panel3D(this.Chosen));
        this.Chosen.setEditable(false);
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(1, 2, 5, 0));
        this.Dirs = new Lister();
        if (Global.NormalFont != null) {
            this.Dirs.setFont(Global.NormalFont);
        }
        this.Dirs.addActionListener(this);
        this.Dirs.setMode(false, false, false, false);
        myPanel.add(this.Dirs);
        this.Files = new Lister();
        if (Global.NormalFont != null) {
            this.Files.setFont(Global.NormalFont);
        }
        this.Files.addActionListener(this);
        this.Files.setMode(false, false, true, false);
        myPanel.add(this.Files);
        this.add("Center", new Panel3D(myPanel));
        MyPanel myPanel2 = new MyPanel();
        myPanel2.setLayout(new BorderLayout());
        MyPanel myPanel3 = new MyPanel();
        myPanel3.setLayout(new BorderLayout());
        MyPanel myPanel4 = new MyPanel();
        myPanel4.setLayout(new GridLayout(0, 1));
        MyPanel myPanel5 = new MyPanel();
        myPanel5.setLayout(new BorderLayout());
        this.DirField = new HistoryTextField(this, "Dir", 32){

            public boolean filterHistory(String string) {
                if (string.length() < 2) {
                    return true;
                }
                return string.charAt(1) != ':' || !Character.isUpperCase(string.charAt(0));
            }
        };
        myPanel5.add("North", this.linePanel(new MyLabel(Global.name("myfiledialog.dir")), this.DirField));
        this.DirField.setText(".");
        this.DirHistory = new HistoryTextFieldChoice(this.DirField);
        myPanel5.add("South", this.linePanel(new MyLabel(Global.name("myfiledialog.olddirs", "")), this.DirHistory));
        myPanel4.add(new Panel3D(myPanel5));
        MyPanel myPanel6 = new MyPanel();
        myPanel6.setLayout(new BorderLayout());
        this.FileField = new HistoryTextField(this, "File");
        myPanel6.add("North", this.linePanel(new MyLabel(Global.name("myfiledialog.file")), this.FileField));
        this.FileHistory = new HistoryTextFieldChoice(this.FileField);
        myPanel6.add("South", this.linePanel(new MyLabel(Global.name("myfiledialog.oldfiles", "")), this.FileHistory));
        myPanel4.add(new Panel3D(myPanel6));
        myPanel3.add("Center", myPanel4);
        this.PatternField = new HistoryTextField(this, "Pattern");
        myPanel3.add("South", new Panel3D(this.linePanel(new MyLabel(Global.name("myfiledialog.pattern")), this.PatternField)));
        this.PatternField.setText("*");
        myPanel2.add("Center", myPanel3);
        MyPanel myPanel7 = new MyPanel();
        myPanel7.setLayout(new FlowLayout(2));
        this.Home = new ButtonAction(this, Global.name("myfiledialog.home", "Home"), "Home");
        myPanel7.add(this.Home);
        myPanel7.add(new ButtonAction(this, Global.name("myfiledialog.mkdir", "Create Directory"), "Create"));
        myPanel7.add(new ButtonAction(this, Global.name("myfiledialog.back", "Back"), "Back"));
        myPanel7.add(new MyLabel(""));
        myPanel7.add(new ButtonAction(this, string2, "Action"));
        myPanel7.add(new ButtonAction(this, Global.name("abort"), "Close"));
        if (bl2) {
            this.addHelp(myPanel7, "filedialog");
        }
        myPanel2.add("South", myPanel7);
        this.add("South", new Panel3D(myPanel2));
        this.pack();
        this.setSize("myfiledialog");
        this.addKeyListener(this);
        this.DirField.addKeyListener(this);
        this.DirField.setTrigger(true);
        this.FileHistory.setDoActionListener(new DirFieldListener(this));
        this.PatternField.addKeyListener(this);
        this.PatternField.setTrigger(true);
        this.FileField.addKeyListener(this);
        this.FileField.setTrigger(true);
        this.Home.addMouseListener(this);
    }

    Panel linePanel(Component component, Component component2) {
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(1, 0));
        myPanel.add(component);
        myPanel.add(component2);
        return myPanel;
    }

    public MyFileDialog(Frame frame, String string, String string2, boolean bl) {
        this(frame, string, string2, bl, false);
    }

    public MyFileDialog(Frame frame, String string, boolean bl) {
        super(frame, "", true);
        this.FD = new FileDialog(frame, string, bl ? 1 : 0);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.HomeShiftControl = mouseEvent.isShiftDown() && mouseEvent.isControlDown();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void doAction(String string) {
        if (string.equals("Dir") || string.equals("Pattern")) {
            if (this.updateDir()) {
                this.updateFiles();
            }
            this.PatternField.remember(this.PatternField.getText());
        } else if (string.equals("File") || string.equals("Action")) {
            if (this.FileField.getText().equals("")) {
                return;
            }
            this.leave();
        } else if (string.equals("Home")) {
            String string2;
            if (this.HomeShiftControl) {
                string2 = Global.getParameter("myfiledialog.homdir", "");
                if (string2.equals("")) {
                    Global.setParameter("myfiledialog.homdir", this.DirField.getText());
                } else {
                    Global.setParameter("myfiledialog.homdir", "");
                }
            }
            try {
                string2 = Global.getParameter("myfiledialog.homdir", "");
                if (string2.equals("")) {
                    String string3 = System.getProperty("user.home");
                    String string4 = Global.name("myfiledialog.windowshome", "");
                    String string5 = Global.name("myfiledialog.homedir", "");
                    String string6 = System.getProperty("file.separator");
                    if (new File(string3 + string6 + string4 + string6 + string5).exists()) {
                        this.DirField.setText(string3 + string6 + string4 + string6 + string5);
                    } else if (new File(string3 + string6 + string4).exists()) {
                        this.DirField.setText(string3 + string6 + string4);
                    } else {
                        this.DirField.setText(string3);
                    }
                } else {
                    this.DirField.setText(string2);
                }
                this.updateDir();
                this.updateFiles();
            }
            catch (Exception exception) {}
        } else if (string.equals("Create")) {
            try {
                File file = new File(this.DirField.getText());
                if (!file.exists()) {
                    file.mkdir();
                }
                this.updateDir();
                this.updateFiles();
            }
            catch (Exception exception) {}
        } else if (string.equals("Back")) {
            String string7 = this.getUndo();
            if (!string7.equals("")) {
                this.DirField.setText(string7);
                this.updateDir();
                this.updateFiles();
            }
        } else {
            super.doAction(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.Dirs) {
            object = this.Dirs.getSelectedItem();
            if (object == null) {
                return;
            }
            if (((String)object).equals("..")) {
                this.dirup();
            } else {
                this.dirdown((String)object);
            }
        }
        if (actionEvent.getSource() == this.Files) {
            if (actionEvent instanceof ListerMouseEvent) {
                object = (ListerMouseEvent)actionEvent;
                if (((ListerMouseEvent)object).clickCount() >= 2) {
                    this.leave();
                } else {
                    String string = this.Files.getSelectedItem();
                    if (string != null) {
                        this.FileField.setText(string);
                    }
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void setFile(String string) {
        this.DirField.setText(FileName.path(string));
        this.FileField.setText(FileName.filename(string));
        this.update(false);
    }

    public void dirup() {
        this.DirField.setText(FileName.path(this.CurrentDir));
        if (this.DirField.getText().equals("")) {
            this.DirField.setText("" + File.separatorChar);
        }
        if (this.updateDir()) {
            this.updateFiles();
        }
    }

    public void dirdown(String string) {
        this.DirField.setText(this.CurrentDir + File.separatorChar + string);
        if (this.updateDir()) {
            this.updateFiles();
        }
    }

    void leave() {
        if (this.FD != null) {
            return;
        }
        if (!this.FileField.getText().equals("")) {
            this.Aborted = false;
        }
        if (!this.Aborted) {
            this.noteSize("myfiledialog");
            this.DirField.remember(this.DirField.getText());
            this.DirField.saveHistory("myfiledialog.dir.history" + this.DirAppend);
            this.PatternField.saveHistory("myfiledialog.pattern.history" + this.PatternAppend);
            this.FileField.remember(this.getFilePath());
            this.FileField.saveHistory("myfiledialog.file.history" + this.FileAppend);
        }
        this.doclose();
    }

    public boolean updateDir() {
        if (this.FD != null) {
            return true;
        }
        File file = new File(this.DirField.getText() + File.separatorChar);
        if (!file.isDirectory()) {
            return false;
        }
        try {
            String string = FileName.canonical(file.getCanonicalPath());
            this.addUndo(string);
            this.DirField.setText(string);
            this.Chosen.setText(FileName.chop(16, this.DirField.getText() + File.separatorChar + this.PatternField.getText(), 48));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void addUndo(String string) {
        if (this.Undo.size() > 0 && ((String)this.Undo.elementAt(this.Undo.size() - 1)).equals(string)) {
            return;
        }
        this.Undo.addElement(string);
    }

    public String getUndo() {
        if (this.Undo.size() < 2) {
            return "";
        }
        String string = (String)this.Undo.elementAt(this.Undo.size() - 2);
        this.Undo.truncate(this.Undo.size() - 1);
        return string;
    }

    public void updateFiles() {
        if (this.FD != null) {
            return;
        }
        File file = new File(this.DirField.getText());
        if (!file.isDirectory()) {
            return;
        }
        this.CurrentDir = this.DirField.getText();
        if (this.PatternField.getText().equals("")) {
            this.PatternField.setText("*");
        }
        try {
            File file2;
            this.Files.clear();
            this.Dirs.clear();
            FileList fileList = new FileList(this.DirField.getText(), this.PatternField.getText(), false);
            fileList.setCase(Global.getParameter("filedialog.usecaps", false));
            fileList.search();
            fileList.sort();
            Enumeration enumeration = fileList.files();
            while (enumeration.hasMoreElements()) {
                file2 = (File)enumeration.nextElement();
                this.Files.addElement(FileName.filename(file2.getCanonicalPath()));
            }
            this.Dirs.addElement("..");
            enumeration = fileList.dirs();
            while (enumeration.hasMoreElements()) {
                file2 = (File)enumeration.nextElement();
                this.Dirs.addElement(FileName.filename(file2.getCanonicalPath()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Dirs.updateDisplay();
        this.Files.updateDisplay();
        this.Files.requestFocus();
    }

    public void setDirectory(String string) {
        if (this.FD != null) {
            this.FD.setDirectory(string);
        } else {
            this.DirField.setText(string);
        }
    }

    public void setPattern(String string) {
        if (this.FD != null) {
            this.FD.setFilenameFilter(this);
            String string2 = string.replace(' ', ';');
            this.FD.setFile(string2);
        } else {
            this.PatternField.setText(string);
        }
    }

    public void setFilePath(String string) {
        if (this.FD != null) {
            this.FD.setFile(string);
            return;
        }
        String string2 = FileName.path(string);
        if (!string2.equals("")) {
            this.DirField.setText(string2);
            this.FileField.setText(FileName.filename(string));
        } else {
            this.FileField.setText(string);
        }
    }

    public boolean isAborted() {
        if (this.FD != null) {
            return this.FD.getFile() == null || this.FD.getFile().equals("");
        }
        return this.Aborted;
    }

    public String getFilePath() {
        if (this.FD != null) {
            if (this.FD.getFile() != null) {
                return this.FD.getDirectory() + this.FD.getFile();
            }
            return "";
        }
        String string = this.FileField.getText();
        if (!FileName.path(string).equals("")) {
            return string;
        }
        return this.CurrentDir + File.separatorChar + this.FileField.getText();
    }

    public void update(boolean bl) {
        if (this.FD != null) {
            return;
        }
        this.loadHistories(bl);
        this.setFilePath(this.FileField.getText());
        if (this.updateDir()) {
            this.updateFiles();
        }
        this.Aborted = true;
    }

    public void update() {
        this.update(true);
    }

    public void setVisible(boolean bl) {
        if (this.FD != null) {
            this.FD.setVisible(bl);
        } else {
            super.setVisible(bl);
        }
    }

    public void center(Frame frame) {
        if (this.FD != null) {
            CloseDialog.center(frame, this.FD);
        } else {
            super.center(frame);
        }
    }

    public static void main(String[] stringArray) {
        CloseFrame closeFrame = new CloseFrame(){

            public void doclose() {
                System.exit(0);
            }
        };
        closeFrame.setSize(500, 500);
        closeFrame.setLocation(400, 400);
        closeFrame.setVisible(true);
        MyFileDialog myFileDialog = new MyFileDialog((Frame)closeFrame, "Title", "Save", false);
        myFileDialog.center(closeFrame);
        myFileDialog.update();
        myFileDialog.setVisible(true);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.FileField.requestFocus();
    }

    public boolean accept(File file, String string) {
        return true;
    }

    public void loadHistories(boolean bl) {
        if (this.FD != null) {
            return;
        }
        this.DirField.loadHistory("myfiledialog.dir.history" + this.DirAppend);
        this.DirHistory.update();
        if (bl) {
            this.setDirectory(this.DirHistory.getRecent());
        }
        if (this.updateDir()) {
            this.updateFiles();
        }
        this.PatternField.loadHistory("myfiledialog.pattern.history" + this.PatternAppend);
        this.FileField.loadHistory("myfiledialog.file.history" + this.FileAppend);
        this.FileHistory.update();
    }

    public void loadHistories() {
        this.loadHistories(true);
    }

    public void loadHistories(String string, String string2, String string3) {
        this.setAppend(string, string2, string3);
        this.loadHistories();
    }

    public void setAppend(String string, String string2, String string3) {
        if (this.FD != null) {
            return;
        }
        this.DirAppend = !string.equals("") ? "." + string : ".default";
        this.PatternAppend = !string2.equals("") ? "." + string2 : ".default";
        this.FileAppend = !string3.equals("") ? "." + string3 : ".default";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }
}

