/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.Zirkel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;

class DoubleExpression
extends BasicExpression {
    double X;

    public DoubleExpression(double d2) {
        this.X = d2;
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        double d2 = 0.0;
        double d3 = 1.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (expressionText.next() == '+') {
            expressionText.advance();
        } else if (expressionText.next() == '-') {
            bl3 = true;
            expressionText.advance();
        }
        while (true) {
            char c2;
            if ((c2 = expressionText.next()) >= '0' && c2 <= '9') {
                d2 = d2 * 10.0 + (double)(c2 - 48);
                if (bl) {
                    d3 /= 10.0;
                }
                expressionText.advance();
                bl2 = true;
                continue;
            }
            if (c2 != '.') break;
            if (bl) {
                throw new ConstructionException(Zirkel.name("exception.dot"));
            }
            bl = true;
            expressionText.advance();
        }
        if (!bl2) {
            throw new ConstructionException(Zirkel.name("exception.nodigit"));
        }
        if (bl3) {
            d2 = -d2;
        }
        return new DoubleExpression(d3 * d2);
    }

    public double getValue() throws ConstructionException {
        return this.X;
    }

    public String toString() {
        String string = "" + this.X;
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public void translate() {
    }

    public boolean isNumber() {
        return true;
    }
}

