/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

final class Circle3D {
    Graphics3D g3d;
    int xCenter;
    int yCenter;
    int zCenter;
    int sizeCorrection;

    Circle3D(Graphics3D graphics3D) {
        this.g3d = graphics3D;
    }

    void plotCircleCenteredClipped(int n, int n2, int n3, int n4) {
        if (this.g3d.isClippedXY(n4, n, n2)) {
            return;
        }
        int n5 = n4 / 2;
        this.sizeCorrection = 1 - (n4 & 1);
        this.xCenter = n;
        this.yCenter = n2;
        this.zCenter = n3;
        int n6 = n5;
        int n7 = 1 - 2 * n5;
        int n8 = 1;
        int n9 = 0;
        for (int i = 0; n6 >= i; ++i) {
            this.plot8CircleCenteredClipped(n6, i);
            if (2 * (n9 += (n8 += 2)) + n7 <= 0) continue;
            --n6;
            n9 += n7;
            n7 += 2;
        }
    }

    void plotCircleCenteredUnclipped(int n, int n2, int n3, int n4) {
        int n5 = n4 / 2;
        this.sizeCorrection = 1 - (n4 & 1);
        this.xCenter = n;
        this.yCenter = n2;
        this.zCenter = n3;
        int n6 = n5;
        int n7 = 1 - 2 * n5;
        int n8 = 1;
        int n9 = 0;
        for (int i = 0; n6 >= i; ++i) {
            this.plot8CircleCenteredUnclipped(n6, i);
            if (2 * (n9 += (n8 += 2)) + n7 <= 0) continue;
            --n6;
            n9 += n7;
            n7 += 2;
        }
    }

    private void plot8CircleCenteredClipped(int n, int n2) {
        this.g3d.plotPixelClipped(this.xCenter + n - this.sizeCorrection, this.yCenter + n2 - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter + n - this.sizeCorrection, this.yCenter - n2, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter - n, this.yCenter + n2 - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter - n, this.yCenter - n2, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter + n2 - this.sizeCorrection, this.yCenter + n - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter + n2 - this.sizeCorrection, this.yCenter - n, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter - n2, this.yCenter + n - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter - n2, this.yCenter - n, this.zCenter);
    }

    private void plot8CircleCenteredUnclipped(int n, int n2) {
        this.g3d.plotPixelUnclipped(this.xCenter + n - this.sizeCorrection, this.yCenter + n2 - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter + n - this.sizeCorrection, this.yCenter - n2, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter - n, this.yCenter + n2 - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter - n, this.yCenter - n2, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter + n2 - this.sizeCorrection, this.yCenter + n - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter + n2 - this.sizeCorrection, this.yCenter - n, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter - n2, this.yCenter + n - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter - n2, this.yCenter - n, this.zCenter);
    }

    private void plot8FilledCircleCenteredClipped(int n, int n2) {
        this.g3d.plotPixelsClipped(2 * n + 1 - this.sizeCorrection, this.xCenter - n, this.yCenter + n2 - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelsClipped(2 * n + 1 - this.sizeCorrection, this.xCenter - n, this.yCenter - n2, this.zCenter);
        this.g3d.plotPixelsClipped(2 * n2 + 1 - this.sizeCorrection, this.xCenter - n2, this.yCenter + n - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelsClipped(2 * n2 + 1 - this.sizeCorrection, this.xCenter - n2, this.yCenter - n, this.zCenter);
    }

    private void plot8FilledCircleCenteredUnclipped(int n, int n2) {
        this.g3d.plotPixelsUnclipped(2 * n + 1 - this.sizeCorrection, this.xCenter - n, this.yCenter + n2 - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelsUnclipped(2 * n + 1 - this.sizeCorrection, this.xCenter - n, this.yCenter - n2, this.zCenter);
        this.g3d.plotPixelsUnclipped(2 * n2 + 1 - this.sizeCorrection, this.xCenter - n2, this.yCenter + n - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelsUnclipped(2 * n2 + 1 - this.sizeCorrection, this.xCenter - n2, this.yCenter - n, this.zCenter);
    }

    void plotFilledCircleCenteredClipped(int n, int n2, int n3, int n4) {
        int n5 = n4 / 2;
        this.sizeCorrection = 1 - (n4 & 1);
        this.xCenter = n;
        this.yCenter = n2;
        this.zCenter = n3;
        int n6 = n5;
        int n7 = 1 - 2 * n5;
        int n8 = 1;
        int n9 = 0;
        for (int i = 0; n6 >= i; ++i) {
            this.plot8FilledCircleCenteredClipped(n6, i);
            if (2 * (n9 += (n8 += 2)) + n7 <= 0) continue;
            --n6;
            n9 += n7;
            n7 += 2;
        }
    }

    void plotFilledCircleCenteredUnclipped(int n, int n2, int n3, int n4) {
        int n5 = n4 / 2;
        this.xCenter = n;
        this.yCenter = n2;
        this.zCenter = n3;
        int n6 = n5;
        int n7 = 1 - 2 * n5;
        int n8 = 1;
        int n9 = 0;
        for (int i = 0; n6 >= i; ++i) {
            this.plot8FilledCircleCenteredUnclipped(n6, i);
            if (2 * (n9 += (n8 += 2)) + n7 <= 0) continue;
            --n6;
            n9 += n7;
            n7 += 2;
        }
    }
}

