#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.util.simple_logger import Logger
from winswitch.util.vash_util import generate_image
from winswitch.util.common import load_binary_file
from winswitch.util.main_loop import test_loop, loop_exit
logger=Logger("vash_util_test", log_colour=Logger.CYAN)

def test_generate_image():
	s = "hello"
	filename = "test.png"
	def image_done(*args):
		data = load_binary_file(filename)
		if not data:
			logger.serror("generate_image(%s) failed!" % s)
		else:
			logger.slog("generate_image(%s)=%s bytes" % (s, len(data)))
		loop_exit()

	def err(*args):
		logger.serror(None, *args)
		loop_exit()

	generate_image(s, filename, image_done, err)


def main():
	test_loop(test_generate_image)

if __name__ == "__main__":
	main()
