//
//

#ifndef DBUS_DBusWorkrave_HH
#define DBUS_DBusWorkrave_HH

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "DBusBinding-gio.hh"



#include "Core.hh"

using namespace workrave;
using namespace std;

class org_workrave_CoreInterface
{
public:
  virtual ~org_workrave_CoreInterface() {}

  static org_workrave_CoreInterface *instance(const DBus *dbus);

  virtual void MicrobreakChanged(const string &path,        std::string progress  ) = 0;
  virtual void RestbreakChanged(const string &path,        std::string progress  ) = 0;
  virtual void DailylimitChanged(const string &path,        std::string progress  ) = 0;
};



#if defined(HAVE_TESTS)

#include "Test.hh"

using namespace workrave;
using namespace std;

class org_workrave_DebugInterface
{
public:
  virtual ~org_workrave_DebugInterface() {}

  static org_workrave_DebugInterface *instance(const DBus *dbus);

};

#endif // defined(HAVE_TESTS)



#include "IConfigurator.hh"

using namespace workrave;
using namespace std;

class org_workrave_ConfigInterface
{
public:
  virtual ~org_workrave_ConfigInterface() {}

  static org_workrave_ConfigInterface *instance(const DBus *dbus);

};



#endif // DBUS_DBusWorkrave_HH
