#include "wvtest.h"
#include "wvunixdgsocket.h"
#include "wvhex.h"


WVTEST_MAIN("embarrassingly simple unixdgsockets test")
{
    int fd;
    WvString testfile = "/tmp/wvunixdgtestXXXXXX";
    if ((fd = mkstemp(testfile.edit())) == (-1))
        return;
    close(fd);

    WvUnixDGListener in(testfile);
    WvUnixDGConn out(testfile);
    
    WVPASS(out.iswritable());
    WvString t("test");
    out.write(t);
    WVPASS(in.isreadable());

    WvDynBuf b;
    unsigned int len = in.read(b, t.len());
    WVPASS(len == t.len());
    WVPASS(t == b.getstr(t.len()));
}

WVTEST_MAIN("fire random binary data through unixdgsocket")
{

    // autofoward works in 1024 byte long chunks so use a stupidly long string
    // of sample data to be extra sure.
    WvString tstdata =
        "87abfa498c441b081a0ee95c786d0add68dfd1e5453d92a3f8f32767e3cb"
        "1907817b5c35b306e6e5876b31a35e46719d7eba83e3dab8740135b57a7b"
        "1ac68bb8277902803e43ca6c3b98b21c1747a4da9032985bac9398506f78"
        "c586f8e434a50b3640b51d956a33a6fb0308c3defc500c67342bd93ea6da"
        "95a134a310ee343fff46cbfc72341829ba4d9a0c0c239df711a96c2ba3f2"
        "33b0b727786fa5c24f35214fc96cc23b6ed4b88578324e97745575824199"
        "8ae655d8f207e138643b2c846afcabd865fad8a1d97a1d4f44969ac4a863"
        "c29cf752104d52e6837c2f066ba987ec52d5c8292d5a80540d8100c844ac"
        "371a21b3f8072397a876e3a31d78706382a7cf78cefb97ba676cf3fea222"
        "b44fba80dd9bd58fd68da933cfcbc21c542914f17d8d995c65517aa99a07"
        "37a1c2b95a6d6d8bef080e13367a9193ab63c3ba4c3831df5ec75b45366f"
        "c7c3fcced401b5d1513495bae1f73d8e2760860518e0d6d60d1629d55abc"
        "946c6040650b846af72fdc70280fc1c86a452a8dbbe283d153c2b3f5dd45"
        "b5ae91d1047151314159ebc6b7b1dc4499b8b9558ac723ded8a1286f06eb"
        "f9f5b9ab3db6867d6086af51a1438761c4015982f993cc87c47b5230b8cc"
        "1caf13f86349f8a7ada39648942ed4f43f08f6b491471990567742295ec8"
        "c3961495ce7c4dbbf06f4da86561f742154fdebfe75bda99b027ffc4e1c9"
        "47d9fb5fe37f96a8b7263ab7a3058b8223bfa43d4724b138f30c01407d86"
        "c29845c5408208756133afb5711ae573249315f5812979d2e6e96e8d081d"
        "4e886da36ce0e6287ce9f2439a24acb3c7a9874fa5bf1783a1545de9fe53"
        "476cd14f0497e3e5a28b3e1fa0c547596553625f514cbd19a7e725769cdf"
        "e4a553719729efd37e164f188d5c24b4fff37f68351e54a5bfc8d783839c"
        "43f34b40552ec5fdcd233027b18129e6e0977cd32ab1044a9a5214d49c90"
        "08b0a2966502f14fbc14c53b9d58bb4b20d7e3ec41dd30e74d1d46eb8fb5"
        "f2d9afa721bed40910529a50d6215263851b8c15ec97d3f49cf5c231f04e"
        "7a9691d7f5257e101f89672994358b9c4fc3126a79df964d60aa30e45245"
        "919c08d6144e447fc80bac951e8051051845f3ad99cf890ad866496e692e"
        "b34d3c021729323fed3664ce2d66827682dbc4abe01d9973ba499862945a"
        "a0185bd5481908cf09a440cda8df9f80ddd24a0ebf899c4926b7bafdd05e"
        "8cf36f91605223411f32478cea6b1a4cce317a46a66dd5e5b499e747c332"
        "2788fe8bfed7d225973dbed6b98039fe16e51f1c2aecc538227bb2526dba"
        "f0cd9976a750e943bd0ccf8d63cc5baf1bcae9489e0baa92e3a1cd2ce817"
        "3688808303812d888c4be2fc994d619b267cbca6e8fe9d243600fa5ebd1c"
        "323f10088a4f78320571b6c0716846db26e1c28b6a16cb7dfcf9a243bca4"
        "d493acdd02784409ce6c4622ce605a831d57cd8fcc1ca27dfd646d8cfdba"
        "1474e355b43166ad9d3baaa5110c9e627640df40cc6e85581e58c133babc"
        "1bd6d28413d3e1095d2d481e405c8bf75fbb02fb4733ec2d93d348250fe5"
        "7e764a5e4fe8439b49effa0a6ecb05332e15696b5bb984bc04d1a2683712"
        "ce8bed95bd59c23aeb25d5ea51e0e471c7c8af4f9c7d7ebe14a9e3aead6e"
        "924a38eddfa8668bb706e173f7c833058edbe585be8b653f323c138aed73"
        "64b6ce9c7b24a65a657287c52dd20d03ef147335bd5b800bbce74157e6db"
        "e1cf4fdff7daa084bcc9e1b2b7fd9d85572644869909cefe28656b8a1fc3"
        "98c072260624e3c3c25cb4574b498055ba02da7ea3166d4f1e52ba46ba65"
        "155dd4e89a217ae0494090bf9fd7085effc67a997009f3a3480442277f66"
        "cc10d03f8988a5d656ac0ea63d2b112ceee0a2ac8af1f4708aa81b1d09bd"
        "55bbbaf1b2caf26ad2bc1f8b53cd22adf10536f3e94dfe30eba856e2a0fb"
        "6069d7bf90df338acd42868e2a4bc6406c7e0630f83ddfd13bdac07f2d36"
        "f82064d8b7fac17086257ef4efe926d94fced9af43dcd03d08bf3b6fccef"
        "20073ee54f2c9604b2bcf7f8027f8290826456d17166c3817fc143d122d9"
        "81fc22754f3289eae12473083b8ab33c0abe70ffd2b8b68f749cfdcaf2e8"
        "c5ef8fc9cb21ae8e7ed40b84c2d88ddbda381747250e7712a7c5390f702a"
        "e82a822149c6c343db7d48a5fe46a0af08c523239fa9ea57d6e1a897bf70"
        "e35ac84cb5590e97b4005609a51339fd8c98081eb925d17063ad85475ce1"
        "515d46d5dd3a914417694305d877a520fd9551f33109a79cde26b8fdc3e3"
        "2b64fe32ffd0284777d36fc312fb495b96a05a744c81b5c74de379f7e73b"
        "da6a5ec69226747be0e030563385ad216daeb71a9244c4e69783b6e242bc"
        "266ffc89a8e73a54f7d3ac8b400f91842dafaab93d46330bfeab8cac328b"
        "07cbe2ffd0c9bae070b3c065c06e14cbeb9efcdaf4718f189999b89ff20d"
        "ba46dd3987edde47c122dffa01f6c164c388acb98c1ef6bf2f7874f729f0"
        "4e38a43a54d9533536364fc1b620436a858aae56b1890006d402d223184e"
        "9c9798a4ff29bc3473bd27ecb8a91b9a108fd17ddce1c51550f6cb5e9a83"
        "0c3a4e0ae4e2aee8933017e2c679eaf614a48ab4f5310980d2926e4457d0"
        "ab15bfe7e9a88038be1b803bf74d42235b2b908b4ebacabb71716e676124"
        "5299e6d201e9029862418a96aadd8ca1e5706383d44c21428fc4a392b23f"
        "91439f88764b51f020a6a7aa1370b888e1521cbe0f0e8a0ad0c03c7945b0"
        "3c0e0731cff586cd24b8cbb9f0c778e7e338fe224bd35b7edd2632826f4f"
        "b78a9e80780ee7618308a4d6d557372b9e6e0c551aa3b9276dd085346330"
        "8a9c3e3f8b686d32997a5cc1c6d842b11704322295d9548460f9f1111b3a"
        "209095fcc47f97c371c2d52edb98b88d37bc6cf5fa16f0f04a69f08cdda6"
        "0360b38bc7316764b9574dc2429910aa8c9426f624c07cca9e813f1cddee"
        "0ec1334b8aa89a6644e37e05f223e216d28bd195e87be478eab294c58b50"
        "991072a7b8559255c03bb1815920058d750577c39a9eff7ffa124a6925a3"
        "eba11637eafc5e41e2083d73523bac0e213961f5c90d1603f65752a1bbe2"
        "c4429e778245ceb2f215488a6ec7fae9d2244a5582eb1e7f99363d3193ec"
        "fd738aca11679dff1cb998d964bd11aaaba049cf3e8275fa45f8a9962124"
        "a352d0d1d0b38269715a4879d42269bc83c523cd28b964916c858aa998f5"
        "679c176b1776861977d91e1914b241bdcc72971e8491c4408c2dedfc0aad"
        "99f29d0deaec8cc4d22c861db52731b47479c3bb48b8dad15eed7aacaf7b"
        "a90edb6ac31ee4fadd065f0f02de1a5d74e80278affb89cb66c0a1e0e2e5"
        "bc5744e129593b8aa92956f5a79ee98b81e95605b13bcdc4bfc8e7a0b2a0"
        "b4f47351b23628f42d41ba7b3689fad660181cf5a54e634ae4001818b324"
        "088e66b21da1109c27ebc1d15b64c330e8c8ee5669b8b5dcf0a072a927b2"
        "0f969a62d4feabe0e7139c8da57a327f88503462f45d57afccad4c8aa92f"
        "3a29ab58afdf03e8a226ab46bd0a20587a70544f8c4dcc82fbd29413809d"
        "4fbb04c7b10e8f7010e065750fb9fdbd42dcb077b09af5cff6b55ef48a11"
        "15eb9ab3fad2d6b8d3c42929db40b2ff5431c95295dbb3cc658f0aae81c8"
        "dedaf354a9c1256576334f887c4405b2e2a16d24523c7310d1d6e1883165"
        "b5cb92948b86676e06967c6f337925d579e62a92a863478fd2c41248a7ec"
        "cf76013402a4c5643effb7675be4b1005512617cab15f67c67e0b925ce35"
        "d57239a72a0fd24476eb326a05126e1753ed0c2dca1f128aff76e508def0"
        "c206e0d20bc337accee8bdfde7c435cd3b3164afc5f4051ebb48f86794ea"
        "a171269f55d524611bd76e0d0c4f21214779a621ade3c0b66d5112731fbc"
        "0a74a8bf4568504fab6bb1d47bd85c76d09dec0f4f63b0cd040b5c981728"
        "c49292bc5cb4537185a99f0aeaedf87138ddf72ad621d7d18229a5603d14"
        "ede2d602951c98dd996d7ed87bc636ad477f6327f30d184cba7e05b04069"
        "dd8069516a23202b628b5f67aa662b8b040673c0a97507ee24185c1fceed"
        "0ac77f097bb6f87f555885c054df13ca3e5d172257bd2505e32aed5098f9"
        "b841f722832f0ea8bb53a2b805d93c4e6a7adb6f9b7e1258bfd139026548"
        "c3ae867b82d569fa8da6b9968ba36c0038c27f488073c09d062fadf78f23"
        "755281911f60a6714d4d9bcaed08c03b6001772cf4c8cb678ea82f81364d"
        "eb6c790e58a4b40b795103118bd541108a3fe04c829391afd0570025e0de"
        "d2d5024669028fc99b7860a10f3177c3650091ee198f84c8a911115dda8f"
        "8a2282cbd7e78399fb9744ff06d585a2486805790629aca772e8ee30107e"
        "396be551c4625fffd64436c88f70e25685baf5a1459ebeb69405216662ef"
        "53524fe633a2ef43172c6ca66d9a8dfcf37aed42ce232ff08bb62984fb8c"
        "a94cbdc8518a4df96e127f4335338143df9bdbea4e8422a9cd3fb1637f38"
        "db37edf26d891b8b00ed99c8bb74ed95105616154df117d0df6f71ae1b32"
        "9f8c0871a559478160845143d710bbdf12e489cfa694bcc4e0719890415c"
        "9ad1cab875179aaeede6a6fc3b8eed3e2da7f025110d80667a5c00a5025a"
        "058a4932f5395cca1317d4ae496c59facaf914a30667363146efbb6ec5f5"
        "8fbceb958d0f717b206c8a54609e8e3b8b5f242bc6b0b18f7cdbfb055d40"
        "c0198e49d35abf2a2a63ce573236b3b85125830b175498be2ab02e8de4ed"
        "833e872e8f35c124601e8c90abbfb5cf0521d2e2ffd326e4b58d30a57a00"
        "33e7a6e43066060b63ae0f43a0fc486ea332c5015789a67c629943872059"
        "bdd571851ce15dcc8cc28bd251147a129e72c3973203251504601f272b1b"
        "486667b2629861d89771680f0ffd4e27e4961ce84db93568f8b3bb6aa702"
        "e29a6d0ea6eebdf2b347786d83689003a87418f555f9b06452f3d9e37138"
        "c9ee0033917154b9e667e065339d9d82375e57601aea5e113b6971c3b7ef"
        "33a8e42af5c6462e4034e2c8647b628f7fd29ae0e8683338da92a1cf2e1a"
        "0e7e2f594921d9ca419ed0749d3d357dc7aab8bd0393c8c72f0b3f541bd8"
        "783b6cbb98e6444c217297e810cef4da9063f1892dae8ea1be5b36169439"
        "b0803f74030e6635a5cc98ac5bd3a94c940417c86b5335496508d35f53b7"
        "9b723d4d073092bc7f086c24343f30efcabe0bd915bea8ec35b2856eb72e"
        "805c38405902e0d271983b79bc8c964c13a89f6262d47aa9339132d97556"
        "c9508922ac9eb7651021240485ac0fd07f907b412e14fa81a5cb5b449376"
        "110e12857aa4f2f7b7ac30b422dcd7a8e6d7ddf5e4a2b99dd6b0a51c5257"
        "7874db37e14222b52a97753b75ae807ed4bb16b8e03348d2d7558c8c8f59"
        "3e78ccdd813ea7886ee926e2f853c23a5bd4af50055cec7317da2f76afca"
        "c0c68a6835f63b88a7971234d4ff0b4285d57a207074bd41991d0f8707cd"
        "eaa990860c540bad47cda6845c4615dc3ea2f8d9a923efcd214699b2d445"
        "d7b18081dbaf6bc3be759ae35084e36dc857e0481342f4cd18205655008e"
        "8f8cd404c476bc47c90d79818098e7a520369162f01efbcee636b8e3af83"
        "a786fd2bfafcffe0579662fb02d38b25a064677c37aa7f967a9ee2848f33"
        "a055dccdb05e16ecb6b2e75e171e1462746df8070faed5355d6c7393383d"
        "50f8abb3b1e4b975071131d3196456ebba5d69364d02fac56830f63b13a2"
        "d2f1ebed21590fc912e382f2f7d9843e56750e16f7e56564dfed027da35a"
        "eb31bfd729ab0ee11a511b2a0acb132f1c93d3480984d82c8d2eb9720abe"
        "a9ec68f92256685dbdc2b6728b488dda6252c04c2484a13ee06c16d8e8c5"
        "2cad0aa03a2e762a4451c543edd834f5a9f88c546ec2aed8d724396fe356"
        "4efe7301e31693f7059e4607a3bb8c7891351d47583048f73bc48f1a8b2a"
        "8211aca0d551389cab77781dd63409f0bbf03e4f8476c8079faa484f1d75"
        "e4270fbd93db0f4033b11483b84ddcc4a409b0a2aff4286b8f92311e21a1"
        "032fdc156febd943a9e7aacffc2e96cb0d26b6b7ac0bf77322913675b08d"
        "5e5de79da8dbb13ec4977339e42cc4ab6cafb0028b8406c3a9e4b867a04c"
        "4ccdd7e7accbc9ecfd9dc82ea11dcfb98bc0457eecd03aed3b8d54662bb4"
        "e2d5dee57c4b136447117511ff5375ecc777e4a02e893ccb1ccbaaa7c895"
        "848174e2335502de2e851986bebfc3c8dc73568aedd8854b11164b3d3fe7"
        "311ac19fe76e28402031b50e127ae015c7c9ee01eca7c8e67988febc7ab9"
        "7631086ed26d333737670db36b8f80ef139e751162ff3e19ed1f97b14ce6"
        "2d25c7dfad31850de5036df38f8f0f5132e3f1b2dad4da9f7a98174b531c"
        "c7e383a4b9bbf927e0e014111ee439dcd0453766fff1686de14992afd0cb"
        "1cb31686e5ded202119d85e6cf0f59f5accd00852eda2cdb5a19533a6d61"
        "75aa97d3d651feca7d5d271c624d5939b3e1107a7c469481354b7f50334f"
        "6ef6a1776900433f9d02c810c34bb0f9b5ef6629a03eb2c0006d78ac5e4f"
        "f304ab50f8fb6e3cce70359a225f17afb890cf2b275fc8788596991b14d7"
        "3cb297e17b3a28b440f57cc3c0c0a12468027b20770a1a87a1c1fb85a31c"
        "112260a8db240b7910873e4bcb0a604c94f0d55448382b99485b140c4549"
        "cac20a123ce4c967ac9c0c37547360277f9d3b16b6d99b9bd46e03aa6ab9"
        "cef2835b9ff1c84d13080009e74f17551673469a5b3faf5884556ed8a055"
        "f10a2ff7172f4e0860487cbdc6423b7d2cbcf6a118fbbc027ceb80a91e1b"
        "fa438cd9150f600d719a180e429f482f45f2b43fe303541b2c8d3d73eb58"
        "b59e1486a00b7769ba7ab427e911b7739abeb21d082491bbc61cba993ac5"
        "1ffc24b87f22c2ceb635c38111ee82098b99b931025945b33196d185f472"
        "8b6f7a6e8f8809c4fa9ba1bff917204749ceaa8907aa9f82ebda057c012d"
        "42f1e993a7bce23470abb65292a85b9d0b3e96b38d0116c8d2ce73805ba2"
        "cf63cb1fdf2117838e50c8ea2f3a991c3fefe57b893c3f0d02b87ececcbd"
        "a8151c1fad655a6832d2637fe3d3b7af21b19c07a8b3c03d87d37f8e360e"
        "2ffe2b7bcb627bf928e4e13721bfe13bfb53d73973dd2e7fcbf878251209"
        "f1c69295f3ef3cf918339d976a30631d3f46382455fc1be936bc8cfd4298"
        "f9ae5ebd052a6fd8e02c497fcf7bd106a45f63b23c20a3ed1eb4fb9bba18"
        "907a84d1ffbe64a93b4c09841e5cecafe7027c20";

    int tstlen = tstdata.len() / 2;
    unsigned char outbuf[tstlen];
    
    unhexify(outbuf, tstdata);

    int fd;
    WvString testfile = "/tmp/wvunixdgtestXXXXXX";
    if ((fd = mkstemp(testfile.edit())) == (-1))
        return;
    close(fd);

    WvUnixDGListener in(testfile);
    WvUnixDGConn out(testfile);

    WVPASS(out.iswritable());
    out.write(outbuf, tstlen);

    // Is there something to read now?
    WVPASS(in.isreadable());

    WvDynBuf b;
    int len = in.read(b, tstlen);
    WVPASS(len == tstlen);
   
    // walk through the buffers to make sure input matches output.
    const unsigned char* inbuf = b.get(tstlen);
    bool success = true;
    for (int i = 0; i < tstlen; i++) 
    {
        if (inbuf[i] != outbuf[i]) {
            success = false;
            break;
        }
    }

    WVPASS(success);
}

